/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.DiscoveryStatus;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessLog;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessParticipant;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessParticipantAttributes;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisher;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisherAttributes;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessSubscriber;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessSubscriberAttributes;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

class IntraProcessDomainImpl {
    private final Executor threadPool = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "IntraProcessDomainImpl-thread-" + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });
    private final ReentrantLock domainLock = new ReentrantLock();
    private final List<IntraProcessParticipant> participants = new ArrayList<IntraProcessParticipant>();
    private final HashMap<String, List<IntraProcessSubscriber>> subscribers = new HashMap();
    private final HashMap<String, List<IntraProcessPublisher>> publishers = new HashMap();
    private LogLevel logLevel;

    public IntraProcessDomainImpl(int domainID, LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    private void matchParticipants(Consumer<IntraProcessParticipant> exec) {
        for (IntraProcessParticipant participant : this.participants) {
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying matched participant " + participant);
            }
            this.threadPool.execute(() -> exec.accept(participant));
        }
    }

    private void matchSubscribers(IntraProcessPublisherAttributes publisherToMatch, Consumer<IntraProcessSubscriber> exec) {
        List<IntraProcessSubscriber> topicSubscribers = this.subscribers.get(publisherToMatch.getTopic().getTopicName());
        if (topicSubscribers != null) {
            for (IntraProcessSubscriber subscriber : topicSubscribers) {
                if (!subscriber.getAttributes().publisherMatches(publisherToMatch)) continue;
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Notifying matched subscriber " + subscriber);
                }
                this.threadPool.execute(() -> exec.accept(subscriber));
            }
        }
    }

    private void matchPublishers(IntraProcessSubscriberAttributes subscriberToMatch, Consumer<IntraProcessPublisher> exec) {
        List<IntraProcessPublisher> topicPublishers = this.publishers.get(subscriberToMatch.getTopic().getTopicName());
        if (topicPublishers != null) {
            for (IntraProcessPublisher publisher : topicPublishers) {
                if (!subscriberToMatch.publisherMatches(publisher.getAttributes())) continue;
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Notifying matched publisher " + publisher);
                }
                this.threadPool.execute(() -> exec.accept(publisher));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntraProcessParticipant createParticipant(IntraProcessParticipantAttributes attributes, ParticipantListener listener) {
        this.domainLock.lock();
        try {
            IntraProcessParticipant participant = new IntraProcessParticipant(this, attributes, listener);
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Adding participant " + participant);
            }
            this.matchParticipants(participantToNotify -> participantToNotify.notifyParticipantListener(participant, DiscoveryStatus.DISCOVERED_RTPSPARTICIPANT));
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying self of existing participants");
            }
            this.matchParticipants(participantOnline -> participant.notifyParticipantListener((IntraProcessParticipant)participantOnline, DiscoveryStatus.DISCOVERED_RTPSPARTICIPANT));
            this.participants.add(participant);
            IntraProcessParticipant intraProcessParticipant = participant;
            return intraProcessParticipant;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeParticipant(IntraProcessParticipant participant) {
        this.domainLock.lock();
        try {
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Removing participant " + participant);
            }
            if (this.participants.remove(participant)) {
                for (IntraProcessSubscriber subscriber : participant.getSubscribers()) {
                    this.removeSubscriber(subscriber);
                }
                for (IntraProcessPublisher publisher : participant.getPublishers()) {
                    this.removePublisher(publisher);
                }
                participant.destroy();
                this.matchParticipants(participantToNotify -> participantToNotify.notifyParticipantListener(participant, DiscoveryStatus.REMOVED_RTPSPARTICIPANT));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscriber createSubscriber(IntraProcessParticipant participant, IntraProcessSubscriberAttributes attr, SubscriberListener listener) throws IOException {
        this.domainLock.lock();
        try {
            IntraProcessSubscriber subscriber = participant.createSubscriber(this, attr, listener);
            String topicName = attr.getTopic().getTopicName();
            List<IntraProcessSubscriber> topicSubscribers = this.subscribers.get(topicName);
            if (topicSubscribers == null) {
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Creating new subscriber list for topic " + topicName);
                }
                topicSubscribers = new ArrayList<IntraProcessSubscriber>();
                this.subscribers.put(topicName, topicSubscribers);
            }
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Adding subscriber " + subscriber);
            }
            topicSubscribers.add(subscriber);
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying subscribers discovery listeners");
            }
            this.matchParticipants(participantToNotify -> participantToNotify.notifySubscriberDiscoveryListener(subscriber));
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying publisher listeners");
            }
            this.matchPublishers(subscriber.getAttributes(), publisher -> publisher.notifyPublisherListener(subscriber, MatchingInfo.MatchingStatus.MATCHED_MATCHING));
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying self listener of existing publishers");
            }
            this.matchPublishers(subscriber.getAttributes(), publisher -> subscriber.notifySubscriberListener(publisher, MatchingInfo.MatchingStatus.MATCHED_MATCHING));
            IntraProcessSubscriber intraProcessSubscriber = subscriber;
            return intraProcessSubscriber;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeSubscriber(IntraProcessSubscriber subscriber) {
        this.domainLock.lock();
        try {
            String topicName = subscriber.getAttributes().getTopic().getTopicName();
            List<IntraProcessSubscriber> topicSubscribers = this.subscribers.get(topicName);
            if (topicSubscribers == null) {
                if (this.logLevel == LogLevel.WARNING) {
                    IntraProcessLog.warn(this, "Subscriber is not part of this domain");
                }
                boolean bl = false;
                return bl;
            }
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Removing subscriber " + subscriber);
            }
            if (topicSubscribers.remove(subscriber)) {
                subscriber.getParticipant().unregister(subscriber);
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Notifying publisher listeners");
                }
            } else {
                if (this.logLevel == LogLevel.WARNING) {
                    IntraProcessLog.warn(this, "No subscriber matched in this domain");
                }
                boolean bl = false;
                return bl;
            }
            this.matchPublishers(subscriber.getAttributes(), publisher -> publisher.notifyPublisherListener(subscriber, MatchingInfo.MatchingStatus.REMOVED_MATCHING));
            subscriber.destroy();
            boolean bl = true;
            return bl;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntraProcessPublisher createPublisher(IntraProcessParticipant participant, IntraProcessPublisherAttributes attr, PublisherListener listener) throws IOException {
        this.domainLock.lock();
        try {
            IntraProcessPublisher publisher = participant.createPublisher(this, attr, listener);
            String topicName = attr.getTopic().getTopicName();
            List<IntraProcessPublisher> topicPublishers = this.publishers.get(topicName);
            if (topicPublishers == null) {
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Creating new publisher list for topic " + topicName);
                }
                topicPublishers = new ArrayList<IntraProcessPublisher>();
                this.publishers.put(topicName, topicPublishers);
            }
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Adding publisher " + publisher);
            }
            topicPublishers.add(publisher);
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying publisher discovery listeners");
            }
            this.matchParticipants(participantToNotify -> participantToNotify.notifyPublisherDiscoveryListener(publisher));
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notifying subscriber listeners");
            }
            this.matchSubscribers(publisher.getAttributes(), subscriber -> subscriber.notifySubscriberListener(publisher, MatchingInfo.MatchingStatus.MATCHED_MATCHING));
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Notify self listener of existing subscribers");
            }
            this.matchSubscribers(publisher.getAttributes(), subscriber -> publisher.notifyPublisherListener((IntraProcessSubscriber)subscriber, MatchingInfo.MatchingStatus.MATCHED_MATCHING));
            IntraProcessPublisher intraProcessPublisher = publisher;
            return intraProcessPublisher;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removePublisher(IntraProcessPublisher publisher) {
        this.domainLock.lock();
        try {
            String topicName = publisher.getAttributes().getTopic().getTopicName();
            List<IntraProcessPublisher> topicSubscribers = this.publishers.get(topicName);
            if (topicSubscribers == null) {
                if (this.logLevel == LogLevel.WARNING) {
                    IntraProcessLog.warn(this, "No publisher matched in domain");
                }
                boolean bl = false;
                return bl;
            }
            if (this.logLevel == LogLevel.INFO) {
                IntraProcessLog.info(this, "Removing publisher " + topicName);
            }
            if (topicSubscribers.remove(publisher)) {
                publisher.getParticipant().unregister(publisher);
                if (this.logLevel == LogLevel.INFO) {
                    IntraProcessLog.info(this, "Notifying subscriber listeners");
                }
            } else {
                if (this.logLevel == LogLevel.WARNING) {
                    IntraProcessLog.warn(this, "No subscriber matched in domain");
                }
                boolean bl = false;
                return bl;
            }
            this.matchSubscribers(publisher.getAttributes(), subscriber -> subscriber.notifySubscriberListener(publisher, MatchingInfo.MatchingStatus.REMOVED_MATCHING));
            publisher.destroy();
            boolean bl = true;
            return bl;
        }
        finally {
            this.domainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void write(IntraProcessPublisherAttributes attr, TopicDataType<T> type, T data, SampleInfo info) throws IOException {
        this.domainLock.lock();
        try {
            List<IntraProcessSubscriber> topicSubscribers = this.subscribers.get(attr.getTopic().getTopicName());
            if (topicSubscribers != null) {
                for (IntraProcessSubscriber subscriber : topicSubscribers) {
                    Object newData;
                    if (!subscriber.getAttributes().publisherMatches(attr)) continue;
                    if (this.logLevel == LogLevel.INFO) {
                        // empty if block
                    }
                    if (!(newData = type.createData()).getClass().isAssignableFrom(data.getClass())) {
                        throw new IOException("Expected message of type " + newData.getClass().getName() + "; got " + data.getClass().getName());
                    }
                    type.copy(data, newData);
                    SampleInfo newInfo = new SampleInfo();
                    newInfo.set(info);
                    this.threadPool.execute(() -> subscriber.putNextData(newData, newInfo));
                }
            }
        }
        finally {
            this.domainLock.unlock();
        }
    }
}

