/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.matrixlib;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOpsWrapper;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class NativeCommonOps {
    private static final NativeCommonOpsWrapper nativeCommonOpsWrapper = NativeCommonOps.loadNativeOps();

    static NativeCommonOpsWrapper loadNativeOps() {
        try {
            NativeLibraryLoader.loadLibrary((String)"", (String)"NativeCommonOps");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("See IHMC Matrix Tools README.");
            throw e;
        }
        return new NativeCommonOpsWrapper();
    }

    public static void ensureNativeOpsIsLoaded() {
    }

    public static void mult(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.getNumCols() != b.getNumRows()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        c.reshape(a.getNumRows(), b.getNumCols());
        nativeCommonOpsWrapper.mult(c.data, a.data, b.data, a.getNumRows(), a.getNumCols(), b.getNumCols());
    }

    public static void multQuad(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.getNumRows() != b.getNumCols() || b.getNumCols() != b.getNumRows()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        c.reshape(a.getNumCols(), a.getNumCols());
        nativeCommonOpsWrapper.multQuad(c.data, a.data, b.data, a.getNumRows(), a.getNumCols());
    }

    public static void invert(DMatrix1Row a, DMatrix1Row inv) {
        if (a == inv) {
            throw new IllegalArgumentException("Can not invert in place. The result matrix needs to be different from the matrix to invert.");
        }
        if (a.getNumRows() != a.getNumCols()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        inv.reshape(a.getNumRows(), a.getNumCols());
        nativeCommonOpsWrapper.invert(inv.data, a.data, a.getNumRows());
    }

    public static void solve(DMatrix1Row a, DMatrix1Row b, DMatrix1Row x) {
        if (a.getNumRows() != b.getNumRows() || b.getNumCols() != 1 || a.getNumCols() != a.getNumRows()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        x.reshape(a.getNumCols(), 1);
        nativeCommonOpsWrapper.solve(x.data, a.data, b.data, a.getNumRows());
    }

    public static boolean solveCheck(DMatrix1Row a, DMatrix1Row b, DMatrix1Row x) {
        if (a.getNumRows() != b.getNumRows() || b.getNumCols() != 1 || a.getNumCols() != a.getNumRows()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        x.reshape(a.getNumCols(), 1);
        if (nativeCommonOpsWrapper.solveCheck(x.data, a.data, b.data, a.getNumRows())) {
            return true;
        }
        CommonOps_DDRM.fill((DMatrixD1)x, (double)Double.NaN);
        return false;
    }

    public static void solveRobust(DMatrix1Row a, DMatrix1Row b, DMatrix1Row x) {
        if (a.getNumRows() != b.getNumRows() || b.getNumCols() != 1) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        x.reshape(a.getNumCols(), 1);
        nativeCommonOpsWrapper.solveRobust(x.data, a.data, b.data, a.getNumRows(), a.getNumCols());
    }

    public static void solveDamped(DMatrix1Row a, DMatrix1Row b, double alpha, DMatrix1Row x) {
        if (a.getNumRows() != b.getNumRows() || b.getNumCols() != 1) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        x.reshape(a.getNumCols(), 1);
        nativeCommonOpsWrapper.solveDamped(x.data, a.data, b.data, a.getNumRows(), a.getNumCols(), alpha);
    }

    public static void projectOnNullspace(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, double alpha) {
        if (a == c) {
            throw new IllegalArgumentException("Can not project in place. The result matrix needs to be different from the matrix to project.");
        }
        if (a.getNumCols() != b.getNumCols()) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
        c.reshape(a.getNumRows(), a.getNumCols());
        nativeCommonOpsWrapper.projectOnNullspace(c.data, a.data, b.data, a.getNumRows(), a.getNumCols(), b.getNumRows(), alpha);
    }
}

