/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.matrixlib;

import java.util.Arrays;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix1Row;

public class DiagonalMatrixTools {
    public static void invertDiagonalMatrix(DMatrix1Row matrixToInvert, DMatrix1Row invertedMatrixToPack) {
        if (matrixToInvert.numRows != matrixToInvert.numCols) {
            throw new MatrixDimensionException("Diagonal matrix to invert is not square. Number of rows in matrix: " + matrixToInvert.getNumRows() + ", number of cols in matrix: " + matrixToInvert.getNumCols() + ".");
        }
        if (invertedMatrixToPack.numRows != matrixToInvert.numRows && invertedMatrixToPack.numCols != matrixToInvert.numCols) {
            throw new MatrixDimensionException("Matrix destination is the wrong size. Number of rows in matrix: " + matrixToInvert.getNumRows() + ", number of cols in matrix: " + matrixToInvert.getNumCols() + ".");
        }
        if (matrixToInvert == invertedMatrixToPack) {
            throw new IllegalArgumentException("Matrices should not be the same. Use {@link DiagonalMatrixTools.invertDiagonalMatrix(DMatrix1Row)} instead.");
        }
        int size = matrixToInvert.getNumRows();
        Arrays.fill(invertedMatrixToPack.data, 0, invertedMatrixToPack.getNumElements(), 0.0);
        for (int index = 0; index < size; ++index) {
            invertedMatrixToPack.unsafe_set(index, index, 1.0 / matrixToInvert.unsafe_get(index, index));
        }
    }

    public static void invertDiagonalMatrix(DMatrix1Row matrixToInvertAndPack) {
        if (matrixToInvertAndPack.numRows != matrixToInvertAndPack.numCols) {
            throw new MatrixDimensionException("Diagonal matrix to invert is not square. Number of rows in matrix: " + matrixToInvertAndPack.getNumRows() + ", number of cols in matrix: " + matrixToInvertAndPack.getNumCols() + ".");
        }
        int size = matrixToInvertAndPack.getNumRows();
        for (int index = 0; index < size; ++index) {
            matrixToInvertAndPack.unsafe_set(index, index, 1.0 / matrixToInvertAndPack.unsafe_get(index, index));
        }
    }

    public static void preMult(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols > 1) {
            DiagonalMatrixTools.preMult_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.preMult_vector(a, b, c);
        }
    }

    private static void preMult_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int row = 0; row < Math.min(a.numRows, a.numCols); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(row, col, a.unsafe_get(row, row) * b.unsafe_get(row, col));
            }
        }
    }

    private static void preMult_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        for (int row = 0; row < Math.min(a.numRows, b.numRows); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(row, col, a.data[row] * b.unsafe_get(row, col));
            }
        }
    }

    public static void preMultAddBlock(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows + startRow > c.numRows || b.numCols + startCol > c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols > 1) {
            DiagonalMatrixTools.preMultAddBlock_matrix(a, b, c, startRow, startCol);
        } else {
            DiagonalMatrixTools.preMultAddBlock_vector(a, b, c, startRow, startCol);
        }
    }

    private static void preMultAddBlock_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int row = 0; row < Math.min(a.numRows, a.numCols); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(startRow + row, startCol + col, c.unsafe_get(startRow + row, startCol + col) + a.unsafe_get(row, row) * b.unsafe_get(row, col));
            }
        }
    }

    private static void preMultAddBlock_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        for (int row = 0; row < Math.min(a.numRows, b.numRows); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(startRow + row, startCol + col, c.unsafe_get(startRow + row, startCol + col) + a.data[row] * b.unsafe_get(row, col));
            }
        }
    }

    public static void preMultAddBlock(double d, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows + startRow > c.numRows || b.numCols + startCol > c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols > 1) {
            DiagonalMatrixTools.preMultAddBlock_matrix(d, a, b, c, startRow, startCol);
        } else {
            DiagonalMatrixTools.preMultAddBlock_vector(d, a, b, c, startRow, startCol);
        }
    }

    private static void preMultAddBlock_matrix(double d, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int row = 0; row < Math.min(a.numRows, a.numCols); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(startRow + row, startCol + col, c.unsafe_get(startRow + row, startCol + col) + d * a.unsafe_get(row, row) * b.unsafe_get(row, col));
            }
        }
    }

    private static void preMultAddBlock_vector(double d, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int startRow, int startCol) {
        for (int row = 0; row < Math.min(a.numRows, b.numRows); ++row) {
            for (int col = 0; col < b.numCols; ++col) {
                c.unsafe_set(startRow + row, startCol + col, c.unsafe_get(startRow + row, startCol + col) + d * a.data[row] * b.unsafe_get(row, col));
            }
        }
    }

    public static void postMult(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != c.numRows) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.postMult_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.postMult_vector(a, b, c);
        }
    }

    private static void postMult_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        for (int row = 0; row < a.numRows; ++row) {
            for (int col = 0; col < Math.min(b.numRows, b.numCols); ++col) {
                c.unsafe_set(row, col, b.unsafe_get(col, col) * a.unsafe_get(row, col));
            }
        }
    }

    private static void postMult_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        for (int row = 0; row < a.numRows; ++row) {
            for (int col = 0; col < Math.min(b.numRows, c.numCols); ++col) {
                c.unsafe_set(row, col, b.data[col] * a.unsafe_get(row, col));
            }
        }
    }

    public static void postMultTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.postMultTransA_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.postMultTransA_vector(a, b, c);
        }
    }

    private static void postMultTransA_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int index = 0;
        int bIndex = 0;
        int maxValue = Math.min(b.numRows, b.numCols);
        for (int i = 0; i < maxValue; ++i) {
            int index2 = i;
            int end = index + a.numCols;
            while (index < end) {
                c.data[index2] = b.data[bIndex] * a.data[index++];
                index2 += c.numCols;
            }
            bIndex += b.numCols + 1;
        }
    }

    private static void postMultTransA_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols != c.numRows) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int index = 0;
        int bIndex = 0;
        int maxValue = Math.min(c.numCols, b.numRows);
        for (int i = 0; i < maxValue; ++i) {
            int index2 = i;
            int end = index + a.numCols;
            while (index < end) {
                c.data[index2] = b.data[bIndex] * a.data[index++];
                index2 += c.numCols;
            }
            ++bIndex;
        }
    }

    public static void multInner(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.multInner_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.multInner_vector(a, b, c);
        }
    }

    private static void multInner_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = i; j < a.numCols; ++j) {
                int indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                int indexA = i;
                int indexB = j;
                int indexC = 0;
                double sum = 0.0;
                int end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    indexC += b.numCols + 1;
                }
                c.data[indexC1] = c.data[indexC2] = sum;
            }
        }
    }

    private static void multInner_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = i; j < a.numCols; ++j) {
                int indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                int indexA = i;
                int indexB = j;
                int indexC = 0;
                double sum = 0.0;
                int end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    ++indexC;
                }
                c.data[indexC1] = c.data[indexC2] = sum;
            }
        }
    }

    public static void multAddInner(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.multAddInner_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.multAddInner_vector(a, b, c);
        }
    }

    private static void multAddInner_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            int j = i;
            int indexC1 = i * c.numCols + j;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + a.numRows * a.numCols;
            while (indexA < end) {
                sum += a.data[indexA] * a.data[indexA] * b.data[indexC];
                indexA += a.numCols;
                indexC += b.numCols + 1;
            }
            int n = indexC1;
            c.data[n] = c.data[n] + sum;
            ++j;
            while (j < a.numCols) {
                indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    indexC += b.numCols + 1;
                }
                int n2 = indexC1;
                c.data[n2] = c.data[n2] + sum;
                int n3 = indexC2;
                c.data[n3] = c.data[n3] + sum;
                ++j;
            }
        }
    }

    private static void multAddInner_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        for (int i = 0; i < a.numCols; ++i) {
            int j = i;
            int indexC1 = i * c.numCols + j;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + a.numRows * a.numCols;
            while (indexA < end) {
                sum += a.data[indexA] * a.data[indexA] * b.data[indexC];
                indexA += a.numCols;
                ++indexC;
            }
            int n = indexC1;
            c.data[n] = c.data[n] + sum;
            ++j;
            while (j < a.numCols) {
                indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    ++indexC;
                }
                int n2 = indexC1;
                c.data[n2] = c.data[n2] + sum;
                int n3 = indexC2;
                c.data[n3] = c.data[n3] + sum;
                ++j;
            }
        }
    }

    public static void multAddBlockInner(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int cRowStart, int cColStart) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols + cRowStart > c.numRows || a.numCols + cColStart > c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.multAddBlockInner_matrix(a, b, c, cRowStart, cColStart);
        } else {
            DiagonalMatrixTools.multAddBlockInner_vector(a, b, c, cRowStart, cColStart);
        }
    }

    private static void multAddBlockInner_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int cRowStart, int cColStart) {
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            int indexC1;
            int j = i;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + a.numRows * a.numCols;
            while (indexA < end) {
                sum += a.data[indexA] * a.data[indexA] * b.data[indexC];
                indexA += a.numCols;
                indexC += b.numCols + 1;
            }
            int n = indexC1 = (i + cRowStart) * c.numCols + j + cColStart;
            c.data[n] = c.data[n] + sum;
            ++j;
            while (j < a.numCols) {
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    indexC += b.numCols + 1;
                }
                indexC1 = (i + cRowStart) * c.numCols + j + cColStart;
                int indexC2 = (j + cRowStart) * c.numCols + i + cColStart;
                int n2 = indexC1;
                c.data[n2] = c.data[n2] + sum;
                int n3 = indexC2;
                c.data[n3] = c.data[n3] + sum;
                ++j;
            }
        }
    }

    private static void multAddBlockInner_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, int cRowStart, int cColStart) {
        for (int i = 0; i < a.numCols; ++i) {
            int indexC1;
            int j = i;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + a.numRows * a.numCols;
            while (indexA < end) {
                sum += a.data[indexA] * a.data[indexA] * b.data[indexC];
                indexA += a.numCols;
                ++indexC;
            }
            int n = indexC1 = (i + cRowStart) * c.numCols + j + cColStart;
            c.data[n] = c.data[n] + sum;
            ++j;
            while (j < a.numCols) {
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    indexA += a.numCols;
                    indexB += a.numCols;
                    ++indexC;
                }
                indexC1 = (i + cRowStart) * c.numCols + j + cColStart;
                int indexC2 = (j + cRowStart) * c.numCols + i + cColStart;
                int n2 = indexC1;
                c.data[n2] = c.data[n2] + sum;
                int n3 = indexC2;
                c.data[n3] = c.data[n3] + sum;
                ++j;
            }
        }
    }

    public static void multAddInner(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (b == c || c == d) {
            throw new IllegalArgumentException("Neither 'b' or 'c' can be the same matrix as 'd'");
        }
        if (b.numRows != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        if (b.numCols != d.numRows || b.numCols != d.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (c.numCols > 1) {
            DiagonalMatrixTools.multAddInner_matrix(a, b, c, d);
        } else {
            DiagonalMatrixTools.multAddInner_vector(a, b, c, d);
        }
    }

    private static void multAddInner_matrix(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (b.numRows != c.numCols) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < b.numCols; ++i) {
            int j = i;
            int indexC1 = i * d.numCols + j;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + b.numRows * b.numCols;
            while (indexA < end) {
                sum += b.data[indexA] * b.data[indexA] * c.data[indexC];
                indexA += b.numCols;
                indexC += c.numCols + 1;
            }
            int n = indexC1;
            d.data[n] = d.data[n] + a * sum;
            ++j;
            while (j < b.numCols) {
                indexC1 = i * d.numCols + j;
                int indexC2 = j * d.numCols + i;
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + b.numRows * b.numCols;
                while (indexA < end) {
                    sum += b.data[indexA] * b.data[indexB] * c.data[indexC];
                    indexA += b.numCols;
                    indexB += b.numCols;
                    indexC += c.numCols + 1;
                }
                int n2 = indexC1;
                d.data[n2] = d.data[n2] + a * sum;
                int n3 = indexC2;
                d.data[n3] = d.data[n3] + a * sum;
                ++j;
            }
        }
    }

    private static void multAddInner_vector(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        for (int i = 0; i < b.numCols; ++i) {
            int j = i;
            int indexC1 = i * d.numCols + j;
            int indexA = i;
            int indexC = 0;
            double sum = 0.0;
            int end = indexA + b.numRows * b.numCols;
            while (indexA < end) {
                sum += b.data[indexA] * b.data[indexA] * c.data[indexC];
                indexA += b.numCols;
                ++indexC;
            }
            int n = indexC1;
            d.data[n] = d.data[n] + a * sum;
            ++j;
            while (j < b.numCols) {
                indexC1 = i * d.numCols + j;
                int indexC2 = j * d.numCols + i;
                indexA = i;
                int indexB = j;
                indexC = 0;
                sum = 0.0;
                end = indexA + b.numRows * b.numCols;
                while (indexA < end) {
                    sum += b.data[indexA] * b.data[indexB] * c.data[indexC];
                    indexA += b.numCols;
                    indexB += b.numCols;
                    ++indexC;
                }
                int n2 = indexC1;
                d.data[n2] = d.data[n2] + a * sum;
                int n3 = indexC2;
                d.data[n3] = d.data[n3] + a * sum;
                ++j;
            }
        }
    }

    public static void multOuter(DMatrix1Row a, double b, DMatrix1Row c) {
        if (a == c) {
            throw new IllegalArgumentException("'a' cannot be the same matrix as 'c'");
        }
        if (a.numRows != c.numRows || a.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        for (int i = 0; i < a.numRows; ++i) {
            int indexC1;
            int indexC2 = indexC1 = i * c.numCols + i;
            int j = i;
            while (j < a.numRows) {
                int indexA = i * a.numCols;
                int indexB = j * a.numCols;
                double sum = 0.0;
                int end = indexA + a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b;
                    ++indexA;
                    ++indexB;
                }
                int n = indexC1++;
                double d = sum;
                c.data[n] = d;
                c.data[indexC2] = d;
                ++j;
                indexC2 += c.numCols;
            }
        }
    }

    public static void multOuter(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || a.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.multOuter_matrix(a, b, c);
        } else {
            DiagonalMatrixTools.multOuter_vector(a, b, c);
        }
    }

    private static void multOuter_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numRows; ++i) {
            int indexC1;
            int indexC2 = indexC1 = i * c.numCols + i;
            int j = i;
            while (j < a.numRows) {
                int indexA = i * a.numCols;
                int indexB = j * a.numCols;
                int indexC = 0;
                double sum = 0.0;
                int end = indexA + a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    ++indexA;
                    ++indexB;
                    indexC += b.numCols + 1;
                }
                int n = indexC1++;
                double d = sum;
                c.data[n] = d;
                c.data[indexC2] = d;
                ++j;
                indexC2 += c.numCols;
            }
        }
    }

    private static void multOuter_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        for (int i = 0; i < a.numRows; ++i) {
            int indexC1;
            int indexC2 = indexC1 = i * c.numCols + i;
            int j = i;
            while (j < a.numRows) {
                int indexA = i * a.numCols;
                int indexB = j * a.numCols;
                int indexC = 0;
                double sum = 0.0;
                int end = indexA + a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB] * b.data[indexC];
                    ++indexA;
                    ++indexB;
                    ++indexC;
                }
                int n = indexC1++;
                double d = sum;
                c.data[n] = d;
                c.data[indexC2] = d;
                ++j;
                indexC2 += c.numCols;
            }
        }
    }

    public static void multInner(DMatrix1Row a, double b, DMatrix1Row c) {
        if (a == c) {
            throw new IllegalArgumentException("'a' cannot be the same matrix as 'c'");
        }
        if (a.numCols != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = i; j < a.numCols; ++j) {
                int indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                int indexA = i;
                int indexB = j;
                double sum = 0.0;
                int end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB];
                    indexA += a.numCols;
                    indexB += a.numCols;
                }
                c.data[indexC1] = c.data[indexC2] = b * sum;
            }
        }
    }

    public static void innerDiagonalMult(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a == c || b == c || c == d) {
            throw new IllegalArgumentException("Neither 'a', 'b', or 'c' can be the same matrix as 'd'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != d.numRows || c.numCols != d.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.innerDiagonalMult_matrix(a, b, c, d);
        } else {
            DiagonalMatrixTools.innerDiagonalMult_vector(a, b, c, d);
        }
    }

    private static void innerDiagonalMult_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (b.numCols != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        int aIndexStart = 0;
        int dIndex = 0;
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexC = j;
                int indexB = 0;
                int end = indexA + c.numRows;
                while (indexA < end) {
                    total += a.data[indexA++] * c.data[indexC] * b.data[indexB];
                    indexC += c.numCols;
                    indexB += b.numCols + 1;
                }
                d.data[dIndex++] = total;
            }
            aIndexStart += a.numCols;
        }
    }

    private static void innerDiagonalMult_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a.numCols != c.numRows) {
            throw new MatrixDimensionException("The 'a' and 'c' matrices do not have compatible dimensions");
        }
        int aIndexStart = 0;
        int dIndex = 0;
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexC = j;
                int indexB = 0;
                int end = indexA + c.numRows;
                while (indexA < end) {
                    total += a.data[indexA++] * c.data[indexC] * b.data[indexB];
                    indexC += c.numCols;
                    ++indexB;
                }
                d.data[dIndex++] = total;
            }
            aIndexStart += a.numCols;
        }
    }

    public static void innerDiagonalMultTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a == c || b == c || c == d) {
            throw new IllegalArgumentException("Neither 'a', 'b', or 'c' can be the same matrix as 'd'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != d.numRows || c.numCols != d.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.innerDiagonalMultTransA_matrix(a, b, c, d);
        } else {
            DiagonalMatrixTools.innerDiagonalMultTransA_vector(a, b, c, d);
        }
    }

    private static void innerDiagonalMultTransA_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (b.numCols != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        int dIndex = 0;
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    indexB += b.numCols + 1;
                }
                d.data[dIndex++] = total;
            }
        }
    }

    private static void innerDiagonalMultTransA_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a.numRows != c.numRows) {
            throw new MatrixDimensionException("The 'a' and 'c' matrices do not have compatible dimensions");
        }
        int dIndex = 0;
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    ++indexB;
                }
                d.data[dIndex++] = total;
            }
        }
    }

    public static void innerDiagonalMultAddTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a == c || b == c || c == d) {
            throw new IllegalArgumentException("Neither 'a', 'b', or 'c' can be the same matrix as 'd'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != d.numRows || c.numCols != d.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.innerDiagonalMultAddTransA_matrix(a, b, c, d);
        } else {
            DiagonalMatrixTools.innerDiagonalMultAddTransA_vector(a, b, c, d);
        }
    }

    private static void innerDiagonalMultAddTransA_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (b.numCols != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        int dIndex = 0;
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    indexB += b.numCols + 1;
                }
                int n = dIndex++;
                d.data[n] = d.data[n] + total;
            }
        }
    }

    private static void innerDiagonalMultAddTransA_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d) {
        if (a.numRows != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        int dIndex = 0;
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    ++indexB;
                }
                int n = dIndex++;
                d.data[n] = d.data[n] + total;
            }
        }
    }

    public static void innerDiagonalMultAddBlockTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, int rowStart, int colStart) {
        if (a == c || b == c || c == d) {
            throw new IllegalArgumentException("Neither 'a', 'b', or 'c' can be the same matrix as 'd'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols + rowStart > d.numRows || c.numCols + colStart > d.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (b.numCols > 1) {
            DiagonalMatrixTools.innerDiagonalMultAddBlockTransA_matrix(a, b, c, d, rowStart, colStart);
        } else {
            DiagonalMatrixTools.innerDiagonalMultAddBlockTransA_vector(a, b, c, d, rowStart, colStart);
        }
    }

    private static void innerDiagonalMultAddBlockTransA_matrix(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, int rowStart, int colStart) {
        if (b.numCols != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int dIndex;
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    indexB += b.numCols + 1;
                }
                int n = dIndex = (i + rowStart) * d.numCols + j + colStart;
                d.data[n] = d.data[n] + total;
            }
        }
    }

    private static void innerDiagonalMultAddBlockTransA_vector(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, int rowStart, int colStart) {
        if (a.numRows != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < a.numCols; ++i) {
            for (int j = 0; j < c.numCols; ++j) {
                int dIndex;
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + c.numRows * c.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += c.numCols) {
                    total += a.data[indexA] * c.data[indexC] * b.data[indexB];
                    indexA += a.numCols;
                    ++indexB;
                }
                int n = dIndex = (i + rowStart) * d.numCols + j + colStart;
                d.data[n] = d.data[n] + total;
            }
        }
    }

    public static void innerDiagonalMultAddBlockTransA(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, DMatrix1Row e, int rowStart, int colStart) {
        if (b == d || c == d || d == e) {
            throw new IllegalArgumentException("Neither 'b', 'c', or 'd' can be the same matrix as 'e'");
        }
        if (b.numRows != c.numRows) {
            throw new MatrixDimensionException("The 'b' and 'c' matrices do not have compatible dimensions");
        }
        if (b.numCols + rowStart > e.numRows || d.numCols + colStart > e.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (c.numCols > 1) {
            DiagonalMatrixTools.innerDiagonalMultAddBlockTransA_matrix(a, b, c, d, e, rowStart, colStart);
        } else {
            DiagonalMatrixTools.innerDiagonalMultAddBlockTransA_vector(a, b, c, d, e, rowStart, colStart);
        }
    }

    private static void innerDiagonalMultAddBlockTransA_matrix(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, DMatrix1Row e, int rowStart, int colStart) {
        if (c.numCols != d.numRows) {
            throw new MatrixDimensionException("The 'c' and 'd' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < b.numCols; ++i) {
            for (int j = 0; j < d.numCols; ++j) {
                int dIndex;
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + d.numRows * d.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += d.numCols) {
                    total += b.data[indexA] * d.data[indexC] * c.data[indexB];
                    indexA += b.numCols;
                    indexB += c.numCols + 1;
                }
                int n = dIndex = (i + rowStart) * e.numCols + j + colStart;
                e.data[n] = e.data[n] + a * total;
            }
        }
    }

    private static void innerDiagonalMultAddBlockTransA_vector(double a, DMatrix1Row b, DMatrix1Row c, DMatrix1Row d, DMatrix1Row e, int rowStart, int colStart) {
        if (b.numRows != d.numRows) {
            throw new MatrixDimensionException("The 'c' and 'd' matrices do not have compatible dimensions");
        }
        for (int i = 0; i < b.numCols; ++i) {
            for (int j = 0; j < d.numCols; ++j) {
                int dIndex;
                int indexC;
                int indexA = i;
                int indexB = 0;
                int end = indexC + d.numRows * d.numCols;
                double total = 0.0;
                for (indexC = j; indexC < end; indexC += d.numCols) {
                    total += b.data[indexA] * d.data[indexC] * c.data[indexB];
                    indexA += b.numCols;
                    ++indexB;
                }
                int n = dIndex = (i + rowStart) * e.numCols + j + colStart;
                e.data[n] = e.data[n] + a * total;
            }
        }
    }
}

