/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.matrixlib;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.MatrixDimensionException;
import org.ejml.data.Matrix;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import us.ihmc.matrixlib.NativeMatrix;

public class NativeMatrixTools {
    public static void extractRows(NativeMatrix source, int[] srcRows, int srcRowsLength, NativeMatrix dest, int destStartRow) {
        for (int i = 0; i < srcRowsLength; ++i) {
            int srcRow = srcRows[i];
            dest.insert(source, srcRow, srcRow + 1, 0, source.getNumCols(), destStartRow, 0);
            ++destStartRow;
        }
    }

    public static void extractRows(NativeMatrix source, int[] srcRows, NativeMatrix dest, int destStartRow) {
        NativeMatrixTools.extractRows(source, srcRows, srcRows.length, dest, destStartRow);
    }

    public static void extractColumns(NativeMatrix source, int[] srcColumns, int srcColumnsLength, NativeMatrix dest, int destStartColumn) {
        for (int i = 0; i < srcColumnsLength; ++i) {
            int srcColumn = srcColumns[i];
            dest.insert(source, 0, source.getNumRows(), srcColumn, srcColumn + 1, 0, destStartColumn);
            ++destStartColumn;
        }
    }

    public static void extractColumns(NativeMatrix source, int[] srcColumns, NativeMatrix dest, int destStartColumn) {
        NativeMatrixTools.extractColumns(source, srcColumns, srcColumns.length, dest, destStartColumn);
    }

    public static void extract(NativeMatrix src, int[] indexes, int length, NativeMatrix dst) {
        if (!MatrixFeatures_DDRM.isVector((Matrix)dst)) {
            throw new MatrixDimensionException("Dst must be a vector");
        }
        if (length != dst.getNumElements()) {
            throw new MatrixDimensionException("Unexpected number of elements in dst vector");
        }
        for (int i = 0; i < length; ++i) {
            dst.setElement(i, 0, src, indexes[i], 0);
        }
    }

    public static void extractColumns(NativeMatrix src, TIntArrayList srcColumns, NativeMatrix dst, int[] dstColumns) {
        int cols = src.getNumCols();
        int rows = src.getNumRows();
        if (dstColumns.length > cols) {
            throw new MatrixDimensionException("dstColumns must have the less than the number of cols in src.");
        }
        if (dst.getNumRows() < rows) {
            throw new MatrixDimensionException("dst must have at least as many rows as src.");
        }
        if (srcColumns.size() != dstColumns.length) {
            throw new MatrixDimensionException("src columns should be the same size as dst columns");
        }
        for (int i = 0; i < dstColumns.length; ++i) {
            dst.insert(src, 0, rows, srcColumns.get(i), srcColumns.get(i) + 1, 0, dstColumns[i]);
        }
    }
}

