/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.matrixlib;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.MatrixIO;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.jni.NativeMatrixImpl;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class NativeMatrix
implements ReshapeMatrix,
DMatrix {
    private static final long serialVersionUID = -6143897236850269840L;
    final NativeMatrixImpl impl;

    public NativeMatrix(int rows, int cols) {
        this.impl = new NativeMatrixImpl(rows, cols);
        this.zero();
    }

    public NativeMatrix(DMatrixRMaj matrix) {
        this(matrix.getNumRows(), matrix.getNumCols());
        this.set(matrix);
    }

    public NativeMatrix(NativeMatrix matrix) {
        this(matrix.getNumRows(), matrix.getNumCols());
        this.set(matrix);
    }

    public void reshape(int rows, int cols) {
        this.impl.resize(rows, cols);
    }

    public void growRows(int rowsToGrow) {
        this.impl.growRows(rowsToGrow);
    }

    public void scale(double alpha, DMatrixRMaj matrix) {
        this.set(matrix);
        this.scale(alpha);
    }

    public void scale(double alpha, NativeMatrix matrix) {
        if (!this.impl.scale(alpha, matrix.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void scaleColumn(int column, double alpha) {
        this.scaleBlock(0, column, this.getNumRows(), 1, alpha);
    }

    public void scaleBlock(int startRow, int startCol, int numberOfRows, int numberOfCols, double alpha) {
        if (!this.impl.scaleBlock(startRow, startCol, numberOfRows, numberOfCols, alpha)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void set(DMatrixRMaj matrix) {
        if (!this.impl.set(matrix.data, matrix.numRows, matrix.numCols)) {
            throw new IllegalArgumentException("Cannot set matrix.");
        }
    }

    public void set(NativeMatrix matrix) {
        if (!this.impl.set(matrix.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void get(DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(this.getNumRows(), this.getNumCols());
        if (!this.impl.get(matrixToPack.data, matrixToPack.numRows, matrixToPack.numCols)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void add(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.add(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void add(NativeMatrix a, double scale, NativeMatrix b) {
        if (!this.impl.add(a.impl, scale, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void add(double scale1, NativeMatrix a, double scale2, NativeMatrix b) {
        if (!this.impl.add(scale1, a.impl, scale2, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void add(int row, int col, double value) {
        if (!this.impl.add(row, col, value)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void addEquals(NativeMatrix b) {
        if (!this.impl.addEquals(b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void addEquals(double scale, NativeMatrix b) {
        if (!this.impl.addEquals(scale, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void subtract(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.subtract(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void mult(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.mult(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void mult(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.mult(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAdd(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAdd(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAdd(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAdd(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddTransA(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAddTransA(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddTransA(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAddTransA(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddTransB(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAddTransB(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddTransB(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAddTransB(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddBlock(NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multAddBlock(a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddBlock(double scale, NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multAddBlock(scale, a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddBlockTransA(NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multAddBlockTransA(a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddBlockTransA(double scale, NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multAddBlockTransA(scale, a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void addBlock(NativeMatrix a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns, double scale) {
        if (!this.impl.addBlock(a.impl, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns, scale)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void addBlock(NativeMatrix a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns) {
        if (!this.impl.addBlock(a.impl, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void subtractBlock(NativeMatrix a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns) {
        if (!this.impl.subtractBlock(a.impl, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multTransB(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multTransB(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multTransB(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multTransB(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multTransA(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multTransA(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multTransA(double scale, NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multTransA(scale, a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multQuad(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multQuad(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddQuad(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.multAddQuad(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multQuadBlock(NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multQuadBlock(a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void multAddQuadBlock(NativeMatrix a, NativeMatrix b, int rowStart, int colStart) {
        if (!this.impl.multAddQuadBlock(a.impl, b.impl, rowStart, colStart)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void invert(NativeMatrix a) {
        if (a == this) {
            throw new IllegalArgumentException("Can not invert in place. The result matrix needs to be different from the matrix to invert.");
        }
        if (!this.impl.invert(a.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void transpose(NativeMatrix a) {
        if (a == this) {
            throw new IllegalArgumentException("Can not transpose in place. The result matrix needs to be different from the matrix to transpose.");
        }
        if (!this.impl.transpose(a.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void solve(NativeMatrix a, NativeMatrix b) {
        if (!this.impl.solve(a.impl, b.impl)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public boolean solveCheck(NativeMatrix a, NativeMatrix b) {
        return this.impl.solveCheck(a.impl, b.impl);
    }

    public void insert(Matrix3DReadOnly src, int startRow, int startCol) {
        if (!this.impl.insert(startRow, startCol, src.getM00(), src.getM01(), src.getM02(), src.getM10(), src.getM11(), src.getM12(), src.getM20(), src.getM21(), src.getM22())) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insertScaled(Matrix3DReadOnly src, int startRow, int startCol, double scale) {
        if (!this.impl.insert(startRow, startCol, scale * src.getM00(), scale * src.getM01(), scale * src.getM02(), scale * src.getM10(), scale * src.getM11(), scale * src.getM12(), scale * src.getM20(), scale * src.getM21(), scale * src.getM22())) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insertTupleRow(int startRow, int startCol, double x, double y, double z) {
        if (!this.impl.insertTupleRow(startRow, startCol, x, y, z)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insertTupleRow(Tuple3DReadOnly tuple, int startRow, int startCol) {
        this.insertTupleRow(startRow, startCol, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public void insert(NativeMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0) {
        if (!this.impl.insert(src.impl, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insert(NativeMatrix src, int dstY0, int dstX0) {
        this.insert(src, 0, src.getNumRows(), 0, src.getNumCols(), dstY0, dstX0);
    }

    public void insertScaled(NativeMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0, double scale) {
        if (!this.impl.insertScaled(src.impl, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0, scale)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insertScaled(NativeMatrix src, int dstY0, int dstX0, double scale) {
        this.insertScaled(src, 0, src.getNumRows(), 0, src.getNumCols(), dstY0, dstX0, scale);
    }

    public void insert(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0) {
        if (!this.impl.insert(src.data, src.numRows, src.numCols, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insert(DMatrixRMaj src, int dstY0, int dstX0) {
        this.insert(src, 0, src.getNumRows(), 0, src.getNumCols(), dstY0, dstX0);
    }

    public void insertScaled(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0, double scale) {
        if (!this.impl.insertScaled(src.data, src.numRows, src.numCols, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0, scale)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions.");
        }
    }

    public void insertScaled(DMatrixRMaj src, int dstY0, int dstX0, double scale) {
        this.insertScaled(src, 0, src.getNumRows(), 0, src.getNumCols(), dstY0, dstX0, scale);
    }

    public void extract(int srcY0, int srcY1, int srcX0, int srcX1, DMatrixRMaj dst, int dstY0, int dstX0) {
        if (!this.impl.extract(srcY0, srcY1, srcX0, srcX1, dst.data, dst.numRows, dst.numCols, dstY0, dstX0)) {
            throw new IllegalArgumentException("Incompatible Matrix Dimensions");
        }
    }

    public void extract(DMatrixRMaj dst, int dstY0, int dstX0) {
        this.extract(0, this.getNumRows(), 0, this.getNumCols(), dst, dstY0, dstX0);
    }

    public double get(int row, int col) {
        double value;
        if (row < 0 || col < 0) {
            this.throwIndexOutOfBoundsException(row, col);
        }
        if (Double.isNaN(value = this.impl.get(row, col)) && (row >= this.getNumRows() || col >= this.getNumCols())) {
            this.throwIndexOutOfBoundsException(row, col);
        }
        return value;
    }

    private void throwIndexOutOfBoundsException(int row, int col) {
        throw new IllegalArgumentException("Index out of bounds. Requested (" + row + ", " + col + "). Dimension (" + this.getNumRows() + ", " + this.getNumCols() + ").");
    }

    public void set(int row, int col, double value) {
        if (!this.impl.set(row, col, value)) {
            this.throwIndexOutOfBoundsException(row, col);
        }
    }

    public void removeRow(int row) {
        if (!this.impl.removeRow(row)) {
            throw new IllegalArgumentException("Row out of bounds.");
        }
    }

    public void removeColumn(int col) {
        if (!this.impl.removeColumn(col)) {
            throw new IllegalArgumentException("Col out of bounds.");
        }
    }

    public void zero() {
        this.impl.zero();
    }

    public boolean containsNaN() {
        return this.impl.containsNaN();
    }

    public int getNumRows() {
        return this.impl.rows();
    }

    public int getNumCols() {
        return this.impl.cols();
    }

    public double min() {
        return this.impl.min();
    }

    public double max() {
        return this.impl.max();
    }

    public double sum() {
        return this.impl.sum();
    }

    public double prod() {
        return this.impl.prod();
    }

    public int getNumElements() {
        return this.impl.size();
    }

    public void scale(double scale) {
        this.impl.scale(scale);
    }

    public void addDiagonal(double value) {
        if (!this.impl.addDiagonal(value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void addDiagonal(int startRow, int startCol, int rows, int cols, double value) {
        if (!this.impl.addDiagonal(startRow, startCol, rows, cols, value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void addDiagonal(int startRow, int startCol, int size, double value) {
        if (!this.impl.addDiagonal(startRow, startCol, size, value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void fillDiagonal(double value) {
        if (!this.impl.fillDiagonal(value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void fillDiagonal(int startRow, int startCol, int rows, int cols, double value) {
        if (!this.impl.fillDiagonal(startRow, startCol, rows, cols, value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void fillDiagonal(int startRow, int startCol, int size, double value) {
        if (!this.impl.fillDiagonal(startRow, startCol, size, value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public void fill(double value) {
        if (!this.impl.fill(value)) {
            throw new RuntimeException("Invalid matrix dimensions.");
        }
    }

    public void fillBlock(int startRow, int startCol, int numberOfRows, int numberOfCols, double value) {
        if (!this.impl.fillBlock(startRow, startCol, numberOfRows, numberOfCols, value)) {
            throw new RuntimeException("Invalid matrix dimensions");
        }
    }

    public boolean isApprox(NativeMatrix other, double precision) {
        return this.impl.isAprrox(other.impl, precision);
    }

    public void zeroRow(int rowToZero) {
        if (!this.impl.zeroRow(rowToZero)) {
            throw new RuntimeException("Invalid matrix dimensions.");
        }
    }

    public void zeroColumn(int colToZero) {
        if (!this.impl.zeroCol(colToZero)) {
            throw new RuntimeException("Invalid matrix dimensions.");
        }
    }

    public void setElement(int dstRow, int dstCol, NativeMatrix src, int srcRow, int srcCol) {
        if (!this.impl.setElement(dstRow, dstCol, src.impl, srcRow, srcCol)) {
            throw new RuntimeException("Invalid matrix dimensions.");
        }
    }

    public void zeroBlock(int srcY0, int srcY1, int srcX0, int srcX1) {
        if (!this.impl.zeroBlock(srcY0, srcY1, srcX0, srcX1)) {
            throw new RuntimeException("Invalid matrix dimensions.");
        }
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixIO.print((PrintStream)new PrintStream(stream), (DMatrix)this);
        return stream.toString();
    }

    public void print() {
        MatrixIO.printFancy((PrintStream)System.out, (DMatrix)this, (int)11);
    }

    public void print(String format) {
        MatrixIO.print((PrintStream)System.out, (DMatrix)this, (String)format);
    }

    public NativeMatrix copy() {
        return new NativeMatrix(this);
    }

    public NativeMatrix createLike() {
        return new NativeMatrix(this.getNumRows(), this.getNumCols());
    }

    public NativeMatrix create(int numRows, int numCols) {
        return new NativeMatrix(numRows, numCols);
    }

    public void set(Matrix original) {
        if (original instanceof NativeMatrix) {
            this.set((NativeMatrix)original);
        } else if (original instanceof DMatrixRMaj) {
            this.set((DMatrixRMaj)original);
        } else {
            if (original == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException("Unsupported matrix type: " + original.getClass().getSimpleName());
        }
    }

    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }

    public double unsafe_get(int row, int col) {
        return this.impl.get(row, col);
    }

    public void unsafe_set(int row, int col, double value) {
        this.set(row, col, value);
    }

    static {
        NativeLibraryLoader.loadLibrary((String)"", (String)"NativeCommonOps");
    }
}

