/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.wrenchDistribution;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.FrictionConeRotationCalculator;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PlaneContactStateToWrenchMatrixHelper {
    private static final double distanceThresholdBetweenTwoContactPoint = 0.005;
    private static final double minFootholdSizeForCoPObjectives = 0.001;
    public static final boolean useOldCoPObjectiveFormulation = true;
    private final int maxNumberOfContactPoints;
    private final int numberOfBasisVectorsPerContactPoint;
    private final double basisVectorAngleIncrement;
    private final int rhoSize;
    private final DMatrixRMaj rhoMatrix;
    private final DMatrixRMaj wrenchJacobianInCoMFrame;
    private final DMatrixRMaj wrenchJacobianInPlaneFrame;
    private final DMatrixRMaj fzRow = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj singleCopRow = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj copRegularizationJacobian;
    private final DMatrixRMaj copRegularizationObjective;
    private final DMatrixRMaj copRateRegularizationJacobian;
    private final DMatrixRMaj copRateRegularizationObjective;
    private final DMatrixRMaj rhoMaxMatrix;
    private final DMatrixRMaj rhoWeightMatrix;
    private final DMatrixRMaj rhoRateWeightMatrix;
    private final DMatrixRMaj copRegularizationWeightMatrix = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj copRateRegularizationWeightMatrix = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj activeRhoMatrix;
    private final YoPlaneContactState yoPlaneContactState;
    private final YoBoolean hasReset;
    private final YoBoolean resetRequested;
    private final FrameVector3D contactNormalVector = new FrameVector3D();
    private final ReferenceFrame centerOfMassFrame;
    private final PoseReferenceFrame planeFrame;
    private final YoFramePoint2D desiredCoP;
    private final YoFramePoint2D previousCoP;
    private final YoBoolean deactivateRhoWhenNotInContact;
    private final YoBoolean[] rhoEnabled;
    private final FramePoint3D[] basisVectorsOrigin;
    private final FrameVector3D[] basisVectors;
    private final YoDouble[] maxContactForces;
    private final YoDouble[] rhoWeights;
    private final RotationMatrix normalContactVectorRotationMatrix = new RotationMatrix();
    private final FramePoint2D contactPoint2d = new FramePoint2D();
    private final FrictionConeRotationCalculator coneRotationCalculator;
    private final FrameVector3D forceFromRho = new FrameVector3D();
    private final Wrench wrenchFromRho = new Wrench();
    private final DMatrixRMaj totalWrenchMatrix = new DMatrixRMaj(6, 1);
    private final SpatialForce unitSpatialForceVector = new SpatialForce();

    public PlaneContactStateToWrenchMatrixHelper(ContactablePlaneBody contactablePlaneBody, ReferenceFrame centerOfMassFrame, int maxNumberOfContactPoints, int numberOfBasisVectorsPerContactPoint, FrictionConeRotationCalculator coneRotationCalculator, YoRegistry parentRegistry) {
        int i;
        List contactPoints2d = contactablePlaneBody.getContactPoints2d();
        if (contactPoints2d.size() > maxNumberOfContactPoints) {
            throw new RuntimeException("Unexpected number of contact points: " + contactPoints2d.size());
        }
        this.centerOfMassFrame = centerOfMassFrame;
        this.maxNumberOfContactPoints = maxNumberOfContactPoints;
        this.numberOfBasisVectorsPerContactPoint = numberOfBasisVectorsPerContactPoint;
        this.coneRotationCalculator = coneRotationCalculator;
        this.rhoSize = maxNumberOfContactPoints * numberOfBasisVectorsPerContactPoint;
        this.basisVectorAngleIncrement = Math.PI * 2 / (double)numberOfBasisVectorsPerContactPoint;
        this.rhoMatrix = new DMatrixRMaj(this.rhoSize, 1);
        this.wrenchJacobianInCoMFrame = new DMatrixRMaj(6, this.rhoSize);
        this.copRegularizationJacobian = new DMatrixRMaj(2, this.rhoSize);
        this.copRegularizationObjective = new DMatrixRMaj(2, 1);
        this.copRegularizationObjective.zero();
        this.copRateRegularizationJacobian = new DMatrixRMaj(2, this.rhoSize);
        this.copRateRegularizationObjective = new DMatrixRMaj(2, 1);
        this.copRateRegularizationObjective.zero();
        this.wrenchJacobianInPlaneFrame = new DMatrixRMaj(6, this.rhoSize);
        this.rhoMaxMatrix = new DMatrixRMaj(this.rhoSize, 1);
        this.rhoWeightMatrix = new DMatrixRMaj(this.rhoSize, this.rhoSize);
        this.rhoRateWeightMatrix = new DMatrixRMaj(this.rhoSize, this.rhoSize);
        this.activeRhoMatrix = new DMatrixRMaj(this.rhoSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.activeRhoMatrix, (double)1.0);
        CommonOps_DDRM.fill((DMatrixD1)this.rhoMaxMatrix, (double)Double.POSITIVE_INFINITY);
        String bodyName = contactablePlaneBody.getName();
        String namePrefix = bodyName + "WrenchMatrixHelper";
        YoRegistry registry = new YoRegistry(namePrefix);
        RigidBodyBasics rigidBody = contactablePlaneBody.getRigidBody();
        this.planeFrame = new PoseReferenceFrame(namePrefix + "ContactFrame", (ReferenceFrame)rigidBody.getBodyFixedFrame());
        this.planeFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)contactablePlaneBody.getSoleFrame().getTransformToDesiredFrame((ReferenceFrame)rigidBody.getBodyFixedFrame()));
        this.yoPlaneContactState = new YoPlaneContactState(namePrefix, rigidBody, (ReferenceFrame)this.planeFrame, contactPoints2d, 0.0, registry);
        this.yoPlaneContactState.clear();
        this.yoPlaneContactState.computeSupportPolygon();
        this.hasReset = new YoBoolean(namePrefix + "HasReset", registry);
        this.resetRequested = new YoBoolean(namePrefix + "ResetRequested", registry);
        this.deactivateRhoWhenNotInContact = new YoBoolean(namePrefix + "DeactivateRhoWhenNotInContact", registry);
        this.rhoWeights = new YoDouble[contactPoints2d.size()];
        this.maxContactForces = new YoDouble[contactPoints2d.size()];
        for (i = 0; i < contactPoints2d.size(); ++i) {
            YoDouble rhoWeight = new YoDouble(namePrefix + "RhoWeight" + i, registry);
            YoDouble maxContactForce = new YoDouble(namePrefix + "MaxContactForce" + i, registry);
            maxContactForce.set(Double.POSITIVE_INFINITY);
            this.rhoWeights[i] = rhoWeight;
            this.maxContactForces[i] = maxContactForce;
        }
        this.rhoEnabled = new YoBoolean[this.rhoSize];
        this.basisVectors = new FrameVector3D[this.rhoSize];
        this.basisVectorsOrigin = new FramePoint3D[this.rhoSize];
        for (i = 0; i < this.rhoSize; ++i) {
            this.rhoEnabled[i] = new YoBoolean("Rho" + i + "Enabled", registry);
            this.basisVectors[i] = new FrameVector3D(centerOfMassFrame);
            this.basisVectorsOrigin[i] = new FramePoint3D(centerOfMassFrame);
        }
        this.previousCoP = new YoFramePoint2D(namePrefix + "PreviousCoP", (ReferenceFrame)this.planeFrame, registry);
        this.desiredCoP = new YoFramePoint2D(namePrefix + "DesiredCoP", (ReferenceFrame)this.planeFrame, registry);
        this.fzRow.reshape(1, this.rhoSize);
        this.singleCopRow.reshape(1, this.rhoSize);
        parentRegistry.addChild(registry);
    }

    public void setDeactivateRhoWhenNotInContact(boolean deactivateRhoWhenNotInContact) {
        this.deactivateRhoWhenNotInContact.set(deactivateRhoWhenNotInContact);
    }

    public void setPlaneContactStateCommand(PlaneContactStateCommand command) {
        boolean liftedOff;
        RigidBodyTransform contactFramePose = command.getContactFramePoseInBodyFixedFrame();
        if (!contactFramePose.containsNaN()) {
            this.planeFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)contactFramePose);
        }
        int previousNumberOfContacts = this.yoPlaneContactState.getNumberOfContactPointsInContact();
        this.yoPlaneContactState.updateFromPlaneContactStateCommand(command);
        this.yoPlaneContactState.computeSupportPolygon();
        int newNumberOfContacts = this.yoPlaneContactState.getNumberOfContactPointsInContact();
        boolean touchedDown = previousNumberOfContacts == 0 && newNumberOfContacts > 0;
        boolean bl = liftedOff = previousNumberOfContacts > 0 && newNumberOfContacts == 0;
        if (this.yoPlaneContactState.pollContactHasChangedNotification()) {
            this.resetRequested.set(touchedDown || liftedOff);
        }
        for (int i = 0; i < command.getNumberOfContactPoints(); ++i) {
            this.rhoWeights[i].set(command.getRhoWeight(i));
            if (!command.hasMaxContactPointNormalForce()) continue;
            this.maxContactForces[i].set(command.getMaxContactPointNormalForce(i));
        }
    }

    public void computeMatrices(double defaultRhoWeight, double rhoRateWeight, Vector2DReadOnly copRegularizationWeight, Vector2DReadOnly copRateRegularizationWeight) {
        int numberOfContactPointsInContact = this.yoPlaneContactState.getNumberOfContactPointsInContact();
        if (numberOfContactPointsInContact > this.maxNumberOfContactPoints) {
            throw new RuntimeException("Unhandled number of contact points: " + numberOfContactPointsInContact);
        }
        this.computeNormalContactVectorRotation(this.normalContactVectorRotationMatrix);
        List<YoContactPoint> contactPoints = this.yoPlaneContactState.getContactPoints();
        int rhoIndex = 0;
        for (int contactPointIndex = 0; contactPointIndex < this.yoPlaneContactState.getTotalNumberOfContactPoints(); ++contactPointIndex) {
            YoContactPoint contactPoint = contactPoints.get(contactPointIndex);
            boolean inContact = contactPoint.isInContact();
            double angleOffset = this.coneRotationCalculator.computeConeRotation(this.yoPlaneContactState, contactPointIndex);
            if (inContact) {
                int matches = 0;
                for (int j = contactPointIndex + 1; j < contactPoints.size(); ++j) {
                    YoContactPoint candidateForMatch = contactPoints.get(j);
                    this.contactPoint2d.setIncludingFrame((FrameTuple3DReadOnly)candidateForMatch);
                    if (!candidateForMatch.isInContact() || !contactPoint.epsilonEquals(this.contactPoint2d, 0.005)) continue;
                    ++matches;
                }
                if (matches > 1) {
                    inContact = false;
                } else if (matches == 1) {
                    angleOffset += this.basisVectorAngleIncrement / 2.0;
                }
            }
            for (int basisVectorIndex = 0; basisVectorIndex < this.numberOfBasisVectorsPerContactPoint; ++basisVectorIndex) {
                FramePoint3D basisVectorOrigin = this.basisVectorsOrigin[rhoIndex];
                FrameVector3D basisVector = this.basisVectors[rhoIndex];
                this.rhoEnabled[rhoIndex].set(inContact);
                if (inContact) {
                    basisVectorOrigin.setIncludingFrame((FrameTuple3DReadOnly)contactPoint);
                    this.computeBasisVector(basisVectorIndex, angleOffset, this.normalContactVectorRotationMatrix, basisVector);
                    double rhoWeight = this.rhoWeights[contactPointIndex].getDoubleValue();
                    if (Double.isNaN(rhoWeight)) {
                        rhoWeight = defaultRhoWeight;
                    }
                    this.rhoWeightMatrix.set(rhoIndex, rhoIndex, rhoWeight * (double)this.maxNumberOfContactPoints / (double)numberOfContactPointsInContact);
                    if (this.resetRequested.getBooleanValue()) {
                        this.rhoRateWeightMatrix.set(rhoIndex, rhoIndex, 0.0);
                    } else {
                        this.rhoRateWeightMatrix.set(rhoIndex, rhoIndex, rhoRateWeight);
                    }
                    this.activeRhoMatrix.set(rhoIndex, 0, 1.0);
                } else {
                    this.clear(rhoIndex);
                    if (this.deactivateRhoWhenNotInContact.getBooleanValue()) {
                        this.activeRhoMatrix.set(rhoIndex, 0, 0.0);
                    }
                }
                this.rhoMaxMatrix.set(rhoIndex, 0, this.maxContactForces[contactPointIndex].getDoubleValue() / (double)this.numberOfBasisVectorsPerContactPoint);
                ++rhoIndex;
            }
        }
        this.computeWrenchJacobianInFrame(this.centerOfMassFrame, this.wrenchJacobianInCoMFrame);
        this.computeWrenchJacobianInFrame((ReferenceFrame)this.planeFrame, this.wrenchJacobianInPlaneFrame);
        this.computeCopObjectiveJacobian(this.copRegularizationJacobian, (FramePoint2DReadOnly)this.desiredCoP);
        this.computeCopObjectiveJacobian(this.copRateRegularizationJacobian, (FramePoint2DReadOnly)this.previousCoP);
        if (this.desiredCoP.containsNaN()) {
            this.copRegularizationObjective.zero();
        } else {
            this.desiredCoP.get((DMatrix)this.copRegularizationObjective);
        }
        if (this.previousCoP.containsNaN()) {
            this.copRateRegularizationObjective.zero();
        } else {
            this.previousCoP.get((DMatrix)this.copRateRegularizationObjective);
        }
        if (this.yoPlaneContactState.inContact() && !this.resetRequested.getBooleanValue() && this.canHandleCoPCommand()) {
            this.copRegularizationWeightMatrix.set(0, 0, copRegularizationWeight.getX());
            this.copRegularizationWeightMatrix.set(1, 1, copRegularizationWeight.getY());
            this.copRateRegularizationWeightMatrix.set(0, 0, copRateRegularizationWeight.getX());
            this.copRateRegularizationWeightMatrix.set(1, 1, copRateRegularizationWeight.getY());
        } else {
            this.copRegularizationWeightMatrix.zero();
            this.copRateRegularizationWeightMatrix.zero();
        }
        this.hasReset.set(this.resetRequested.getBooleanValue());
        this.resetRequested.set(false);
        while (rhoIndex < this.rhoSize) {
            this.clear(rhoIndex);
            ++rhoIndex;
        }
    }

    public void computeCopObjectiveJacobian(DMatrixRMaj jacobianToPack, FramePoint2DReadOnly desiredCoP) {
        if (desiredCoP.containsNaN()) {
            jacobianToPack.reshape(2, this.rhoSize);
            jacobianToPack.zero();
            return;
        }
        if (this.wrenchFromRho.getLinearPart().lengthSquared() < 0.1) {
            jacobianToPack.reshape(2, this.rhoSize);
            jacobianToPack.zero();
            return;
        }
        this.forceFromRho.setIncludingFrame((FrameTuple3DReadOnly)this.wrenchFromRho.getLinearPart());
        this.forceFromRho.changeFrame((ReferenceFrame)this.planeFrame);
        if (this.forceFromRho.getZ() < 0.1) {
            jacobianToPack.reshape(2, this.rhoSize);
            jacobianToPack.zero();
            return;
        }
        double fzInverse = 1.0 / this.forceFromRho.getZ();
        int tauYIndex = 1;
        MatrixTools.setMatrixBlock((DMatrix)jacobianToPack, (int)0, (int)0, (DMatrix)this.wrenchJacobianInPlaneFrame, (int)tauYIndex, (int)0, (int)1, (int)this.rhoSize, (double)(-fzInverse));
        int tauXIndex = 0;
        MatrixTools.setMatrixBlock((DMatrix)jacobianToPack, (int)1, (int)0, (DMatrix)this.wrenchJacobianInPlaneFrame, (int)tauXIndex, (int)0, (int)1, (int)this.rhoSize, (double)fzInverse);
    }

    private void clear(int rhoIndex) {
        FramePoint3D basisVectorOrigin = this.basisVectorsOrigin[rhoIndex];
        FrameVector3D basisVector = this.basisVectors[rhoIndex];
        basisVectorOrigin.setToZero(this.centerOfMassFrame);
        basisVector.setToZero(this.centerOfMassFrame);
        this.rhoMaxMatrix.set(rhoIndex, 0, Double.POSITIVE_INFINITY);
        this.rhoWeightMatrix.set(rhoIndex, rhoIndex, 1.0);
        this.rhoRateWeightMatrix.set(rhoIndex, rhoIndex, 0.0);
    }

    public void computeWrenchFromRho(int startIndex, DMatrixRMaj allRobotRho) {
        CommonOps_DDRM.extract((DMatrix)allRobotRho, (int)startIndex, (int)(startIndex + this.rhoSize), (int)0, (int)1, (DMatrix)this.rhoMatrix, (int)0, (int)0);
        MovingReferenceFrame bodyFixedFrame = this.getRigidBody().getBodyFixedFrame();
        if (this.yoPlaneContactState.inContact()) {
            CommonOps_DDRM.mult((DMatrix1Row)this.wrenchJacobianInPlaneFrame, (DMatrix1Row)this.rhoMatrix, (DMatrix1Row)this.totalWrenchMatrix);
            this.wrenchFromRho.setIncludingFrame((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)this.planeFrame, (DMatrix)this.totalWrenchMatrix);
            this.previousCoP.setX(-this.wrenchFromRho.getAngularPartY() / this.wrenchFromRho.getLinearPartZ());
            this.previousCoP.setY(this.wrenchFromRho.getAngularPartX() / this.wrenchFromRho.getLinearPartZ());
        } else {
            this.wrenchFromRho.setToZero((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)this.planeFrame);
            this.previousCoP.setToZero();
        }
    }

    public WrenchReadOnly getWrench() {
        return this.wrenchFromRho;
    }

    public void computeWrenchJacobianInFrame(ReferenceFrame frame, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(6, this.rhoSize);
        for (int rhoIndex = 0; rhoIndex < this.rhoSize; ++rhoIndex) {
            if (this.rhoEnabled[rhoIndex].getValue()) {
                FramePoint3D basisVectorOrigin = this.basisVectorsOrigin[rhoIndex];
                FrameVector3D basisVector = this.basisVectors[rhoIndex];
                basisVectorOrigin.changeFrame(frame);
                basisVector.changeFrame(frame);
                this.unitSpatialForceVector.setIncludingFrame(null, (FrameVector3DReadOnly)basisVector, (FramePoint3DReadOnly)basisVectorOrigin);
                this.unitSpatialForceVector.get(0, rhoIndex, (DMatrix)matrixToPack);
                continue;
            }
            MatrixTools.zeroColumn((int)rhoIndex, (DMatrix1Row)matrixToPack);
        }
    }

    private void computeNormalContactVectorRotation(RotationMatrix normalContactVectorRotationMatrixToPack) {
        this.yoPlaneContactState.getContactNormalFrameVector(this.contactNormalVector);
        this.contactNormalVector.changeFrame((ReferenceFrame)this.planeFrame);
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.contactNormalVector, (Orientation3DBasics)normalContactVectorRotationMatrixToPack);
    }

    private void computeBasisVector(int basisVectorIndex, double rotationOffset, RotationMatrix normalContactVectorRotationMatrix, FrameVector3D basisVectorToPack) {
        double angle = rotationOffset + (double)basisVectorIndex * this.basisVectorAngleIncrement;
        double mu = this.yoPlaneContactState.getCoefficientOfFriction();
        basisVectorToPack.setIncludingFrame((ReferenceFrame)this.planeFrame, Math.cos(angle) * mu, Math.sin(angle) * mu, 1.0);
        normalContactVectorRotationMatrix.transform((Tuple3DBasics)basisVectorToPack);
        basisVectorToPack.normalize();
    }

    public RigidBodyBasics getRigidBody() {
        return this.yoPlaneContactState.getRigidBody();
    }

    public int getRhoSize() {
        return this.rhoSize;
    }

    public DMatrixRMaj getLastRho() {
        return this.rhoMatrix;
    }

    public DMatrixRMaj getRhoJacobian() {
        return this.wrenchJacobianInCoMFrame;
    }

    public DMatrixRMaj getActiveRhoMatrix() {
        return this.activeRhoMatrix;
    }

    public DMatrixRMaj getRhoMax() {
        return this.rhoMaxMatrix;
    }

    public DMatrixRMaj getRhoWeight() {
        return this.rhoWeightMatrix;
    }

    public DMatrixRMaj getRhoRateWeight() {
        return this.rhoRateWeightMatrix;
    }

    public Wrench getWrenchFromRho() {
        return this.wrenchFromRho;
    }

    public DMatrixRMaj getCoPRegularizationJacobian() {
        return this.copRegularizationJacobian;
    }

    public DMatrixRMaj getCoPRegularizationObjective() {
        return this.copRegularizationObjective;
    }

    public DMatrixRMaj getCoPRateRegularizationJacobian() {
        return this.copRateRegularizationJacobian;
    }

    public DMatrixRMaj getCoPRateRegularizationObjective() {
        return this.copRateRegularizationObjective;
    }

    public DMatrixRMaj getCoPRegularizationWeight() {
        return this.copRegularizationWeightMatrix;
    }

    public DMatrixRMaj getCoPRateRegularizationWeight() {
        return this.copRateRegularizationWeightMatrix;
    }

    public FramePoint3D[] getBasisVectorsOrigin() {
        return this.basisVectorsOrigin;
    }

    public FrameVector3D[] getBasisVectors() {
        return this.basisVectors;
    }

    public boolean hasReset() {
        return this.hasReset.getBooleanValue();
    }

    public DMatrixRMaj getWrenchJacobianMatrix() {
        return this.wrenchJacobianInPlaneFrame;
    }

    public ReferenceFrame getPlaneFrame() {
        return this.planeFrame;
    }

    public boolean canHandleCoPCommand() {
        return this.yoPlaneContactState.getFootholdArea() > 0.001;
    }
}

