/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.wrenchDistribution;

import us.ihmc.commonWalkingControlModules.wrenchDistribution.FrictionConeRotationCalculator;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class InteriorAngleConeRotationCalculator
implements FrictionConeRotationCalculator {
    private final double offset;
    private final Point2D point2d = new Point2D();
    private final LineSegment2D edge1 = new LineSegment2D();
    private final LineSegment2D edge2 = new LineSegment2D();
    private final Vector2D edgeDirection1 = new Vector2D();
    private final Vector2D edgeDirection2 = new Vector2D();
    private final LineSegment2D edge = new LineSegment2D();
    private final Vector2D edgeDirection = new Vector2D();
    private final Vector2D xAxis = new Vector2D();

    public InteriorAngleConeRotationCalculator(double offset) {
        this.offset = offset;
    }

    @Override
    public double computeConeRotation(ConvexPolygon2DReadOnly supportPolygonInPlaneFrame, Point3DReadOnly contactPoint) {
        this.point2d.set((Tuple3DReadOnly)contactPoint);
        int vertexIndex = supportPolygonInPlaneFrame.getClosestVertexIndex((Point2DReadOnly)this.point2d);
        double angleOfEdge = this.getAngleOfEdgeAfterPoint(supportPolygonInPlaneFrame, vertexIndex);
        double interiorAngle = this.getInteriorAngle(supportPolygonInPlaneFrame, vertexIndex);
        return angleOfEdge - 0.5 * interiorAngle + this.offset;
    }

    public double getInteriorAngle(ConvexPolygon2DReadOnly supportPolygon, int vertexIndex) {
        supportPolygon.getEdge(supportPolygon.getPreviousVertexIndex(vertexIndex), (LineSegment2DBasics)this.edge1);
        supportPolygon.getEdge(vertexIndex, (LineSegment2DBasics)this.edge2);
        this.edgeDirection1.sub((Tuple2DReadOnly)this.edge1.getSecondEndpoint(), (Tuple2DReadOnly)this.edge1.getFirstEndpoint());
        this.edgeDirection2.sub((Tuple2DReadOnly)this.edge2.getSecondEndpoint(), (Tuple2DReadOnly)this.edge2.getFirstEndpoint());
        double angle = this.edgeDirection2.angle((Vector2DReadOnly)this.edgeDirection1);
        double dotProduct = this.edgeDirection2.dot((Vector2DReadOnly)this.edgeDirection1);
        if (dotProduct > 0.0) {
            angle = Math.PI - angle;
        }
        return angle;
    }

    public double getAngleOfEdgeAfterPoint(ConvexPolygon2DReadOnly supportPolygon, int vertexIndex) {
        supportPolygon.getEdge(vertexIndex, (LineSegment2DBasics)this.edge);
        this.edgeDirection.sub((Tuple2DReadOnly)this.edge.getSecondEndpoint(), (Tuple2DReadOnly)this.edge.getFirstEndpoint());
        this.xAxis.set(1.0, 0.0);
        return this.xAxis.angle((Vector2DReadOnly)this.edgeDirection);
    }
}

