/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.visualizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactableBody;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WrenchVisualizer {
    private static final double FORCE_VECTOR_SCALE = 0.0015;
    private static final double TORQUE_VECTOR_SCALE = 0.0015;
    private YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Map<RigidBodyBasics, YoFrameVector3D> forces = new LinkedHashMap<RigidBodyBasics, YoFrameVector3D>();
    private final Map<RigidBodyBasics, YoFrameVector3D> torques = new LinkedHashMap<RigidBodyBasics, YoFrameVector3D>();
    private final Map<RigidBodyBasics, YoFramePoint3D> pointsOfApplication = new LinkedHashMap<RigidBodyBasics, YoFramePoint3D>();
    private final Map<RigidBodyBasics, YoGraphicVector> forceVisualizers = new LinkedHashMap<RigidBodyBasics, YoGraphicVector>();
    private final Map<RigidBodyBasics, YoGraphicVector> torqueVisualizers = new LinkedHashMap<RigidBodyBasics, YoGraphicVector>();
    private final Wrench tempWrench = new Wrench();
    private final FrameVector3D tempVector = new FrameVector3D();
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final ArrayList<RigidBodyBasics> rigidBodies = new ArrayList();

    public static WrenchVisualizer createWrenchVisualizerWithContactableBodies(String name, List<? extends ContactableBody> contactableBodies, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        return new WrenchVisualizer(name, WrenchVisualizer.extractRigidBodyList(contactableBodies), vizScaling, yoGraphicsListRegistry, parentRegistry);
    }

    public WrenchVisualizer(String name, List<RigidBodyBasics> rigidBodies, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(name, rigidBodies, vizScaling, yoGraphicsListRegistry, parentRegistry, YoAppearance.OrangeRed(), YoAppearance.CornflowerBlue());
    }

    public WrenchVisualizer(String name, List<RigidBodyBasics> rigidBodies, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry, AppearanceDefinition forceAppearance, AppearanceDefinition torqueAppearance) {
        YoGraphicsList yoGraphicsList = new YoGraphicsList(name);
        this.rigidBodies.addAll(rigidBodies);
        for (RigidBodyBasics rigidBody : rigidBodies) {
            String prefix = name + rigidBody.getName();
            YoFrameVector3D force = new YoFrameVector3D(prefix + "Force", ReferenceFrame.getWorldFrame(), this.registry);
            this.forces.put(rigidBody, force);
            YoFrameVector3D torque = new YoFrameVector3D(prefix + "Torque", ReferenceFrame.getWorldFrame(), this.registry);
            this.torques.put(rigidBody, torque);
            YoFramePoint3D pointOfApplication = new YoFramePoint3D(prefix + "PointOfApplication", ReferenceFrame.getWorldFrame(), this.registry);
            this.pointsOfApplication.put(rigidBody, pointOfApplication);
            YoGraphicVector forceVisualizer = new YoGraphicVector(prefix + "ForceViz", pointOfApplication, force, 0.0015 * vizScaling, forceAppearance, true);
            this.forceVisualizers.put(rigidBody, forceVisualizer);
            yoGraphicsList.add((YoGraphic)forceVisualizer);
            YoGraphicVector torqueVisualizer = new YoGraphicVector(prefix + "TorqueViz", pointOfApplication, torque, 0.0015 * vizScaling, torqueAppearance, true);
            this.torqueVisualizers.put(rigidBody, torqueVisualizer);
            yoGraphicsList.add((YoGraphic)torqueVisualizer);
        }
        yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
        parentRegistry.addChild(this.registry);
    }

    public void visualize(Map<RigidBodyBasics, ? extends WrenchReadOnly> wrenches) {
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.rigidBodies.get(i);
            WrenchReadOnly wrench = wrenches.get(rigidBody);
            if (wrench != null) {
                this.tempWrench.setIncludingFrame(wrench);
                this.tempWrench.changeFrame(this.tempWrench.getBodyFrame());
                YoFrameVector3D force = this.forces.get(rigidBody);
                this.tempVector.setToZero(this.tempWrench.getReferenceFrame());
                this.tempVector.set((FrameTuple3DReadOnly)this.tempWrench.getLinearPart());
                this.tempVector.changeFrame(ReferenceFrame.getWorldFrame());
                force.set((FrameTuple3DReadOnly)this.tempVector);
                YoFrameVector3D torque = this.torques.get(rigidBody);
                this.tempVector.setToZero(this.tempWrench.getReferenceFrame());
                this.tempVector.set((FrameTuple3DReadOnly)this.tempWrench.getAngularPart());
                this.tempVector.changeFrame(ReferenceFrame.getWorldFrame());
                torque.set((FrameTuple3DReadOnly)this.tempVector);
                YoFramePoint3D pointOfApplication = this.pointsOfApplication.get(rigidBody);
                this.tempPoint.setToZero(wrench.getBodyFrame());
                this.tempPoint.changeFrame(ReferenceFrame.getWorldFrame());
                pointOfApplication.set((FrameTuple3DReadOnly)this.tempPoint);
                continue;
            }
            this.forces.get(rigidBody).set(Double.NaN, Double.NaN, Double.NaN);
            this.torques.get(rigidBody).set(Double.NaN, Double.NaN, Double.NaN);
            this.pointsOfApplication.get(rigidBody).set(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    private static List<RigidBodyBasics> extractRigidBodyList(List<? extends ContactableBody> contactableBodies) {
        ArrayList<RigidBodyBasics> ret = new ArrayList<RigidBodyBasics>(contactableBodies.size());
        for (int i = 0; i < contactableBodies.size(); ++i) {
            ret.add(contactableBodies.get(i).getRigidBody());
        }
        return ret;
    }
}

