/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.visualizer;

import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.robotics.screwTheory.MomentumCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MomentumVisualizer
implements Updatable {
    private final CenterOfMassCalculator comCalculator;
    private final MomentumCalculator momentumCalculator;
    private final YoFramePoint3D centerOfMass;
    private final YoFrameVector3D linearMomentum;
    private final Momentum momentum = new Momentum(ReferenceFrame.getWorldFrame());
    private final FrameVector3D frameVector = new FrameVector3D();

    public MomentumVisualizer(String name, OneDoFJointBasics rootJoint, YoRegistry registry, YoGraphicsListRegistry graphicsRegistry) {
        this(name, registry, graphicsRegistry, rootJoint.getSuccessor());
    }

    public MomentumVisualizer(String name, YoRegistry registry, YoGraphicsListRegistry graphicsRegistry, RigidBodyBasics rootBody) {
        this.comCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, ReferenceFrame.getWorldFrame());
        this.momentumCalculator = new MomentumCalculator(rootBody);
        this.centerOfMass = new YoFramePoint3D(name + "CoM", ReferenceFrame.getWorldFrame(), registry);
        this.linearMomentum = new YoFrameVector3D(name + "Momentum", ReferenceFrame.getWorldFrame(), registry);
        YoGraphicPosition yoCoMGraphics = new YoGraphicPosition(name + "CoM", this.centerOfMass, 0.05, YoAppearance.Brown());
        YoGraphicVector yoMomentumGraphics = new YoGraphicVector(name + "Momentum", this.centerOfMass, this.linearMomentum, 0.05, YoAppearance.Brown());
        graphicsRegistry.registerYoGraphic(name, (YoGraphic)yoCoMGraphics);
        graphicsRegistry.registerYoGraphic(name, (YoGraphic)yoMomentumGraphics);
    }

    @Override
    public void update(double time) {
        this.comCalculator.reset();
        this.centerOfMass.set((FrameTuple3DReadOnly)this.comCalculator.getCenterOfMass());
        this.momentumCalculator.computeAndPack(this.momentum);
        this.frameVector.set((FrameTuple3DReadOnly)this.momentum.getLinearPart());
        this.linearMomentum.set((FrameTuple3DReadOnly)this.frameVector);
    }
}

