/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.visualizer;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoRegistry;

public class InverseDynamicsMechanismReferenceFrameVisualizer
implements RobotController {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final List<YoGraphicReferenceFrame> yoGraphicReferenceFrames = new ArrayList<YoGraphicReferenceFrame>();

    public InverseDynamicsMechanismReferenceFrameVisualizer(RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry, double length, FrameToDisplay frameToDisplay, YoRegistry parentRegistry) {
        this(rootBody, yoGraphicsListRegistry, length, frameToDisplay);
        parentRegistry.addChild(this.registry);
    }

    public InverseDynamicsMechanismReferenceFrameVisualizer(RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry, double length) {
        this(rootBody, yoGraphicsListRegistry, length, FrameToDisplay.BODY_FIXED_FRAME);
    }

    public InverseDynamicsMechanismReferenceFrameVisualizer(RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry, double length, FrameToDisplay frameToDisplay) {
        YoGraphicsList yoGraphicsList = new YoGraphicsList(this.name);
        ArrayList jointStack = new ArrayList(rootBody.getChildrenJoints());
        while (!jointStack.isEmpty()) {
            MovingReferenceFrame referenceFrame;
            JointBasics joint = (JointBasics)jointStack.get(0);
            switch (frameToDisplay) {
                case BODY_FIXED_FRAME: {
                    referenceFrame = joint.getSuccessor().getBodyFixedFrame();
                    break;
                }
                case AFTER_JOINT_FRAME: {
                    referenceFrame = joint.getFrameAfterJoint();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid frame to display: " + (Object)((Object)frameToDisplay));
                }
            }
            YoGraphicReferenceFrame yoGraphicReferenceFrame = new YoGraphicReferenceFrame((ReferenceFrame)referenceFrame, this.registry, false, length);
            yoGraphicsList.add((YoGraphic)yoGraphicReferenceFrame);
            this.yoGraphicReferenceFrames.add(yoGraphicReferenceFrame);
            List childrenJoints = joint.getSuccessor().getChildrenJoints();
            jointStack.addAll(childrenJoints);
            jointStack.remove(joint);
        }
        yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
    }

    public void initialize() {
        this.doControl();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getName();
    }

    public void doControl() {
        for (int i = 0; i < this.yoGraphicReferenceFrames.size(); ++i) {
            this.yoGraphicReferenceFrames.get(i).update();
        }
    }

    public static enum FrameToDisplay {
        BODY_FIXED_FRAME,
        AFTER_JOINT_FRAME;

    }
}

