/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.visualizer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controlModules.CenterOfPressureResolver;
import us.ihmc.commonWalkingControlModules.momentumBasedController.GeometricJacobianHolder;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.contactable.ContactableBody;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.functionApproximation.DampedLeastSquaresSolver;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ExternalWrenchJointTorqueBasedEstimatorVisualizer {
    private static final double FORCE_VECTOR_SCALE = 0.0015;
    private static final double TORQUE_VECTOR_SCALE = 0.0015;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DampedLeastSquaresSolver pseudoInverseSolver = new DampedLeastSquaresSolver(0, 0.005);
    private final DMatrixRMaj jacobianInverseMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jointChainTorquesVector = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj wrenchVector = new DMatrixRMaj(6, 1);
    private final Wrench estimatedWrench = new Wrench();
    private final String name;
    private final RigidBodyBasics rootBody;
    private final List<RigidBodyCalculator> calculators = new ArrayList<RigidBodyCalculator>();
    private final CenterOfPressureResolver centerOfPressureResolver = new CenterOfPressureResolver();

    public static ExternalWrenchJointTorqueBasedEstimatorVisualizer createWrenchVisualizerWithContactableBodies(String name, RigidBodyBasics rootBody, List<? extends ContactablePlaneBody> contactableBodies, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        return new ExternalWrenchJointTorqueBasedEstimatorVisualizer(name, null, rootBody, contactableBodies.stream().map(ContactableBody::getRigidBody).collect(Collectors.toList()), contactableBodies.stream().map(ContactablePlaneBody::getSoleFrame).collect(Collectors.toList()), vizScaling, yoGraphicsListRegistry, parentRegistry);
    }

    public ExternalWrenchJointTorqueBasedEstimatorVisualizer(String name, GeometricJacobianHolder jacobianHolder, RigidBodyBasics rootBody, List<RigidBodyBasics> rigidBodies, List<ReferenceFrame> soleFrames, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(name, jacobianHolder, rootBody, rigidBodies, soleFrames, vizScaling, yoGraphicsListRegistry, parentRegistry, YoAppearance.AliceBlue(), YoAppearance.YellowGreen(), YoAppearance.DarkViolet(), YoGraphicPosition.GraphicType.CROSS);
    }

    public ExternalWrenchJointTorqueBasedEstimatorVisualizer(String name, GeometricJacobianHolder jacobianHolder, RigidBodyBasics rootBody, List<RigidBodyBasics> rigidBodies, List<ReferenceFrame> soleFrames, double vizScaling, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry, AppearanceDefinition forceAppearance, AppearanceDefinition torqueAppearance, AppearanceDefinition copAppearance, YoGraphicPosition.GraphicType copGraphicType) {
        this.name = name;
        this.rootBody = rootBody;
        for (int i = 0; i < rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = rigidBodies.get(i);
            ReferenceFrame soleFrame = soleFrames == null ? null : soleFrames.get(i);
            this.calculators.add(new RigidBodyCalculator(rigidBody, soleFrame, jacobianHolder, vizScaling, forceAppearance, torqueAppearance, copAppearance, copGraphicType, yoGraphicsListRegistry));
        }
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        for (int i = 0; i < this.calculators.size(); ++i) {
            this.calculators.get(i).update();
        }
    }

    private class RigidBodyCalculator {
        private final OneDoFJointBasics[] joints;
        private final RigidBodyBasics rigidBody;
        private final GeometricJacobian jacobian;
        private final YoFrameVector3D force;
        private final YoFrameVector3D torque;
        private final YoFramePoint3D pointOfApplication;
        private final YoGraphicVector forceVisualizer;
        private final YoGraphicVector torqueVisualizer;
        private final YoFramePoint2D cop2D;
        private final YoFramePoint3D cop3D;

        public RigidBodyCalculator(RigidBodyBasics rigidBody, ReferenceFrame soleFrame, GeometricJacobianHolder jacobianHolder, double vizScaling, AppearanceDefinition forceAppearance, AppearanceDefinition torqueAppearance, AppearanceDefinition copAppearance, YoGraphicPosition.GraphicType copGraphicType, YoGraphicsListRegistry yoGraphicsListRegistry) {
            this.rigidBody = rigidBody;
            this.joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.rootBody, (RigidBodyBasics)rigidBody);
            this.jacobian = jacobianHolder != null ? jacobianHolder.getJacobian(jacobianHolder.getOrCreateGeometricJacobian((JointBasics[])this.joints, (ReferenceFrame)rigidBody.getBodyFixedFrame())) : new GeometricJacobian((JointBasics[])this.joints, (ReferenceFrame)rigidBody.getBodyFixedFrame());
            String prefix = ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.name + rigidBody.getName();
            this.force = new YoFrameVector3D(prefix + "Force", ReferenceFrame.getWorldFrame(), ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.registry);
            this.torque = new YoFrameVector3D(prefix + "Torque", ReferenceFrame.getWorldFrame(), ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.registry);
            this.pointOfApplication = new YoFramePoint3D(prefix + "PointOfApplication", ReferenceFrame.getWorldFrame(), ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.registry);
            this.forceVisualizer = new YoGraphicVector(prefix + "ForceViz", this.pointOfApplication, this.force, 0.0015 * vizScaling, forceAppearance, true);
            this.torqueVisualizer = new YoGraphicVector(prefix + "TorqueViz", this.pointOfApplication, this.torque, 0.0015 * vizScaling, torqueAppearance, true);
            yoGraphicsListRegistry.registerYoGraphic(ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.name, (YoGraphic)this.forceVisualizer);
            yoGraphicsListRegistry.registerYoGraphic(ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.name, (YoGraphic)this.torqueVisualizer);
            if (soleFrame != null) {
                this.cop2D = new YoFramePoint2D(prefix + "CoPInSole", "", soleFrame, ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.registry);
                this.cop3D = new YoFramePoint3D(prefix + "CoPInWorld", "", ReferenceFrame.getWorldFrame(), ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.registry);
                YoGraphicPosition copYoGraphic = new YoGraphicPosition(prefix + "CoP", this.cop3D, 0.008, copAppearance, copGraphicType);
                YoArtifactPosition copArtifact = copYoGraphic.createArtifact();
                yoGraphicsListRegistry.registerArtifact(ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.name, (Artifact)copArtifact);
            } else {
                this.cop2D = null;
                this.cop3D = null;
            }
        }

        public void update() {
            this.jacobian.compute();
            DMatrixRMaj jacobianMatrix = this.jacobian.getJacobianMatrix();
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jointChainTorquesVector.reshape(this.jacobian.getNumberOfColumns(), 1);
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jacobianInverseMatrix.reshape(this.jacobian.getNumberOfColumns(), 6);
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.pseudoInverseSolver.setA(jacobianMatrix);
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.pseudoInverseSolver.invert(ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jacobianInverseMatrix);
            for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
                ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jointChainTorquesVector.set(jointIndex, 0, this.joints[jointIndex].getTau());
            }
            CommonOps_DDRM.multTransA((DMatrix1Row)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jacobianInverseMatrix, (DMatrix1Row)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.jointChainTorquesVector, (DMatrix1Row)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.wrenchVector);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.wrenchVector);
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.estimatedWrench.setToZero((ReferenceFrame)this.rigidBody.getBodyFixedFrame(), this.jacobian.getJacobianFrame());
            ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.estimatedWrench.set((DMatrix)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.wrenchVector);
            this.torque.setMatchingFrame((FrameTuple3DReadOnly)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.estimatedWrench.getAngularPart());
            this.force.setMatchingFrame((FrameTuple3DReadOnly)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.estimatedWrench.getLinearPart());
            this.pointOfApplication.setFromReferenceFrame((ReferenceFrame)this.rigidBody.getBodyFixedFrame());
            if (this.cop2D != null) {
                ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.centerOfPressureResolver.resolveCenterOfPressureAndNormalTorque((FixedFramePoint2DBasics)this.cop2D, (SpatialForceReadOnly)ExternalWrenchJointTorqueBasedEstimatorVisualizer.this.estimatedWrench, this.cop2D.getReferenceFrame());
                this.cop3D.setMatchingFrame((FrameTuple2DReadOnly)this.cop2D, 0.0);
            }
        }
    }
}

