/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.virtualModelControl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualWrenchCommand;
import us.ihmc.commonWalkingControlModules.virtualModelControl.VirtualModelControlDataHandler;
import us.ihmc.commonWalkingControlModules.virtualModelControl.VirtualModelControlSolution;
import us.ihmc.commonWalkingControlModules.visualizer.WrenchVisualizer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.registry.YoRegistry;

public class VirtualModelController {
    private static final boolean USE_SUPER_JACOBIAN = true;
    private static final boolean DISPLAY_GRAVITY_WRENCHES = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final GeometricJacobianCalculator geometricJacobianCalculator = new GeometricJacobianCalculator();
    private final RigidBodyBasics defaultRootBody;
    private final Map<JointBasics, MutableDouble> jointTorques = new HashMap<JointBasics, MutableDouble>();
    private final VirtualModelControlDataHandler vmcDataHandler = new VirtualModelControlDataHandler();
    private final DMatrixRMaj fullJTMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj fullObjectiveWrench = new DMatrixRMaj(0, 0, true, new double[0]);
    private final DMatrixRMaj fullEffortMatrix = new DMatrixRMaj(1, 1);
    private final PoseReferenceFrame controlFrame = new PoseReferenceFrame("controlFrame", ReferenceFrame.getWorldFrame());
    private final Wrench tempWrench = new Wrench();
    private final DMatrixRMaj tempSelectionMatrix = new DMatrixRMaj(6, 6);
    private final WrenchVisualizer gravityWrenchVisualizer;
    private final Map<RigidBodyBasics, Wrench> gravityWrenchMap = new HashMap<RigidBodyBasics, Wrench>();
    private final ReferenceFrame centerOfMassFrame;
    private List<RigidBodyBasics> allBodies = new ArrayList<RigidBodyBasics>();
    private final DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tmpWrench = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tmpJMatrix = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tmpJTMatrix = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj matrixToCopy = new DMatrixRMaj(1, 1);

    public VirtualModelController(RigidBodyBasics defaultRootBody, ReferenceFrame centerOfMassFrame, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.defaultRootBody = defaultRootBody;
        this.centerOfMassFrame = centerOfMassFrame;
        for (JointBasics joint : defaultRootBody.childrenSubtreeIterable()) {
            this.jointTorques.put(joint, new MutableDouble());
        }
        this.gravityWrenchVisualizer = null;
        parentRegistry.addChild(this.registry);
    }

    public void registerControlledBody(RigidBodyBasics controlledBody) {
        this.registerControlledBody(controlledBody, this.defaultRootBody);
    }

    public void registerControlledBody(RigidBodyBasics controlledBody, RigidBodyBasics baseOfControl) {
        OneDoFJointBasics[] joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)baseOfControl, (RigidBodyBasics)controlledBody);
        if (joints.length > 1) {
            if (MultiBodySystemTools.isAncestor((RigidBodyReadOnly)joints[1].getPredecessor(), (RigidBodyReadOnly)joints[0].getPredecessor())) {
                this.registerControlledBody(controlledBody, joints);
            } else {
                int size = joints.length;
                OneDoFJointBasics[] newJoints = new OneDoFJointBasics[size];
                for (int i = 0; i < size; ++i) {
                    newJoints[i] = joints[size - i - 1];
                }
                this.registerControlledBody(controlledBody, newJoints);
            }
        } else {
            this.registerControlledBody(controlledBody, joints);
        }
    }

    public void registerControlledBody(RigidBodyBasics controlledBody, OneDoFJointBasics[] jointsToUse) {
        this.vmcDataHandler.addBodyForControl(controlledBody);
        this.vmcDataHandler.addJointsForControl(controlledBody, jointsToUse);
    }

    public void submitControlledBodyVirtualWrench(RigidBodyBasics controlledBody, Wrench wrench) {
        this.submitControlledBodyVirtualWrench(controlledBody, wrench, CommonOps_DDRM.identity((int)6, (int)6));
    }

    public void submitControlledBodyVirtualWrench(VirtualWrenchCommand virtualWrenchCommand) {
        virtualWrenchCommand.getDesiredWrench(this.controlFrame, this.tempWrench);
        virtualWrenchCommand.getSelectionMatrix(this.centerOfMassFrame, this.tempSelectionMatrix);
        this.submitControlledBodyVirtualWrench(virtualWrenchCommand.getEndEffector(), this.tempWrench, this.tempSelectionMatrix);
    }

    public void submitControlledBodyVirtualWrench(RigidBodyBasics controlledBody, Wrench wrench, DMatrixRMaj selectionMatrix) {
        this.vmcDataHandler.addDesiredWrench(controlledBody, wrench);
        this.vmcDataHandler.addDesiredSelectionMatrix(controlledBody, selectionMatrix);
    }

    public void reset() {
        this.vmcDataHandler.reset();
    }

    public void clear() {
        this.vmcDataHandler.clear();
    }

    public void compute(VirtualModelControlSolution virtualModelControlSolutionToPack) {
        this.matrixToCopy.reshape(0, 0);
        this.fullJTMatrix.reshape(0, 0);
        this.fullObjectiveWrench.reshape(0, 0);
        this.fullEffortMatrix.reshape(this.vmcDataHandler.numberOfControlledJoints, 1);
        this.matrixToCopy.zero();
        this.fullJTMatrix.zero();
        this.fullObjectiveWrench.zero();
        this.fullEffortMatrix.zero();
        for (RigidBodyBasics controlledBody : this.vmcDataHandler.getControlledBodies()) {
            if (this.vmcDataHandler.hasWrench(controlledBody) && this.vmcDataHandler.hasSelectionMatrix(controlledBody)) {
                int n = this.vmcDataHandler.numberOfChains(controlledBody);
                if (n <= 0) continue;
                Wrench wrench = this.vmcDataHandler.getDesiredWrench(controlledBody);
                DMatrixRMaj selectionMatrix = this.vmcDataHandler.getDesiredSelectionMatrix(controlledBody);
                int taskSize = selectionMatrix.getNumRows();
                wrench.changeFrame((ReferenceFrame)this.defaultRootBody.getBodyFixedFrame());
                wrench.setBodyFrame((ReferenceFrame)controlledBody.getBodyFixedFrame());
                this.tmpWrench.reshape(taskSize, 1);
                wrench.get((DMatrix)this.wrenchMatrix);
                CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.wrenchMatrix, (DMatrix1Row)this.tmpWrench);
                wrench.changeFrame(ReferenceFrame.getWorldFrame());
                int previousSize = this.fullObjectiveWrench.getNumRows();
                int newSize = previousSize + taskSize;
                this.fullObjectiveWrench.reshape(newSize, 1, true);
                CommonOps_DDRM.extract((DMatrix)this.tmpWrench, (int)0, (int)taskSize, (int)0, (int)1, (DMatrix)this.fullObjectiveWrench, (int)previousSize, (int)0);
                for (int chainID = 0; chainID < n; ++chainID) {
                    this.geometricJacobianCalculator.clear();
                    this.geometricJacobianCalculator.setKinematicChain((JointReadOnly[])this.vmcDataHandler.getJointsForControl(controlledBody, chainID));
                    this.geometricJacobianCalculator.setJacobianFrame((ReferenceFrame)this.defaultRootBody.getBodyFixedFrame());
                    this.geometricJacobianCalculator.reset();
                    int numberOfJoints = this.vmcDataHandler.jointsInChain(controlledBody, chainID);
                    this.tmpJMatrix.reshape(taskSize, numberOfJoints);
                    this.tmpJTMatrix.reshape(numberOfJoints, taskSize);
                    CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.geometricJacobianCalculator.getJacobianMatrix(), (DMatrix1Row)this.tmpJMatrix);
                    CommonOps_DDRM.transpose((DMatrixRMaj)this.tmpJMatrix, (DMatrixRMaj)this.tmpJTMatrix);
                    this.matrixToCopy.set((DMatrixD1)this.fullJTMatrix);
                    this.fullJTMatrix.reshape(this.vmcDataHandler.numberOfControlledJoints, newSize);
                    this.fullJTMatrix.zero();
                    CommonOps_DDRM.extract((DMatrix)this.matrixToCopy, (int)0, (int)this.matrixToCopy.getNumRows(), (int)0, (int)this.matrixToCopy.getNumCols(), (DMatrix)this.fullJTMatrix, (int)0, (int)0);
                    for (int jointID = 0; jointID < numberOfJoints; ++jointID) {
                        CommonOps_DDRM.extract((DMatrix)this.tmpJTMatrix, (int)jointID, (int)(jointID + 1), (int)0, (int)taskSize, (DMatrix)this.fullJTMatrix, (int)this.vmcDataHandler.indexOfInTree(controlledBody, chainID, jointID), (int)previousSize);
                    }
                }
                continue;
            }
            LogTools.warn((String)("Do not have a wrench or selection matrix for body " + controlledBody.getName() + ", skipping this body."));
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.fullJTMatrix, (DMatrix1Row)this.fullObjectiveWrench, (DMatrix1Row)this.fullEffortMatrix);
        int index = 0;
        for (JointBasics jointBasics : this.vmcDataHandler.getControlledJoints()) {
            this.jointTorques.get(jointBasics).setValue(this.fullEffortMatrix.get(index));
            ++index;
        }
        virtualModelControlSolutionToPack.setJointTorques(this.fullEffortMatrix);
    }
}

