/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.trajectories.TwoWaypointSwingGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.math.YoCounter;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class SwingOverPlanarRegionsTrajectoryExpander {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final double[] swingWaypointProportions;
    private final YoGraphicsListRegistry graphicsListRegistry;
    private final TwoWaypointSwingGenerator twoWaypointSwingGenerator;
    private final ConvexPolygon2D footPolygonShape;
    private final FrameConvexPolygon2D swingStartPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D swingEndPolygon = new FrameConvexPolygon2D();
    private final YoBoolean doInitialFastApproximation;
    private final YoInteger numberOfCheckpoints;
    private final YoCounter numberOfTriesCounter;
    private final YoDouble minimumClearance;
    private final YoDouble fastApproximationLessClearance;
    private final YoDouble minimumAdjustmentIncrementDistance;
    private final YoDouble maximumAdjustmentIncrementDistance;
    private final YoDouble adjustmentIncrementDistanceGain;
    private final YoDouble maximumAdjustmentDistance;
    private final YoDouble minimumHeightAboveFloorForCollision;
    private final YoEnum<SwingOverPlanarRegionsCollisionType> mostSevereCollisionType;
    private final YoEnum<SwingOverPlanarRegionsStatus> status;
    private final YoBoolean collisionIsOnRising;
    private final YoDouble heightAboveFloorPlane;
    private final YoDouble heightAboveEndFoot;
    private final YoBoolean wereWaypointsAdjusted;
    private final YoFramePoint3D trajectoryPosition;
    private final PoseReferenceFrame solePoseReferenceFrame = new PoseReferenceFrame("desiredPositionFrame", worldFrame);
    private final PoseReferenceFrame startOfSwingReferenceFrame = new PoseReferenceFrame("startOfSwingFrame", worldFrame);
    private final PoseReferenceFrame endOfSwingReferenceFrame = new PoseReferenceFrame("endOfSwingFrame", worldFrame);
    private final ZUpFrame endOfSwingZUpFrame = new ZUpFrame(ReferenceFrame.getWorldFrame(), (ReferenceFrame)this.endOfSwingReferenceFrame, "endOfSwingZUpFrame");
    private final ZUpFrame startOfSwingZUpFrame = new ZUpFrame(ReferenceFrame.getWorldFrame(), (ReferenceFrame)this.startOfSwingReferenceFrame, "startOfSwingZUpFrame");
    private static final int numberOfTrajectorySegmentsToCalculateLength = 10;
    private final YoDouble initialTrajectoryLength;
    private final YoDouble expandedTrajectoryLength;
    private final RecyclingArrayList<FramePoint3D> originalWaypoints;
    private final RecyclingArrayList<FramePoint3D> adjustedWaypoints;
    private final double minimumSwingHeight;
    private final double maximumSwingHeight;
    private final double footLengthOffset;
    private double heelLength;
    private double toeLength;
    private final double footLength;
    private final double footWidth;
    private final double footHeight;
    private final Box3D collisionBox;
    private final Map<SwingOverPlanarRegionsCollisionType, FramePoint3D> closestPolygonPointMap;
    private final FramePoint3D midGroundPoint;
    private final FrameVector3D waypointAdjustment;
    private final Plane3D swingTrajectoryPlane;
    private final Plane3D swingFloorPlane;
    private final AxisAngle axisAngle;
    private final RigidBodyTransform rigidBodyTransform;
    private final Vector3D tempPlaneNormal = new Vector3D();
    private final FrameVector3D initialVelocity;
    private final FrameVector3D touchdownVelocity;
    private final FramePoint3D swingStartPosition;
    private final FramePoint3D swingEndPosition;
    private final FramePoint3D stanceFootPosition;
    private final FramePoint3D collisionRelativeToStart;
    private final FramePoint3D stepRelativeToStart;
    private final FramePose3D swingStartPose = new FramePose3D();
    private final FramePose3D swingEndPose = new FramePose3D();
    private Optional<Runnable> visualizer;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final RigidBodyTransform transformToStart = new RigidBodyTransform();
    private final RigidBodyTransform transformFromStart = new RigidBodyTransform();
    private final RigidBodyTransform transformToEnd = new RigidBodyTransform();
    private final RigidBodyTransform transformFromEnd = new RigidBodyTransform();

    public SwingOverPlanarRegionsTrajectoryExpander(WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        String namePrefix = "trajectoryExpander";
        this.graphicsListRegistry = graphicsListRegistry;
        SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
        this.twoWaypointSwingGenerator = new TwoWaypointSwingGenerator(namePrefix, steppingParameters.getMinSwingHeightFromStanceFoot(), steppingParameters.getMaxSwingHeightFromStanceFoot(), steppingParameters.getDefaultSwingHeightFromStanceFoot(), steppingParameters.getCustomWaypointAngleThreshold(), this.registry, graphicsListRegistry);
        this.minimumSwingHeight = steppingParameters.getMinSwingHeightFromStanceFoot();
        this.maximumSwingHeight = steppingParameters.getMaxSwingHeightFromStanceFoot();
        this.toeLength = steppingParameters.getFootForwardOffset();
        this.heelLength = steppingParameters.getFootBackwardOffset();
        this.footLengthOffset = 0.5 * (this.heelLength - this.toeLength);
        double scaleUp = steppingParameters.getActualFootLength() / steppingParameters.getFootLength();
        this.toeLength *= scaleUp;
        this.heelLength *= scaleUp;
        this.footLength = steppingParameters.getActualFootLength();
        this.footWidth = steppingParameters.getActualFootWidth();
        this.footHeight = 0.05;
        this.collisionBox = new Box3D();
        this.swingWaypointProportions = walkingControllerParameters.getSwingTrajectoryParameters().getSwingWaypointProportions();
        this.footPolygonShape = new ConvexPolygon2D();
        this.footPolygonShape.addVertex(steppingParameters.getFootForwardOffset(), 0.5 * steppingParameters.getToeWidth());
        this.footPolygonShape.addVertex(steppingParameters.getFootForwardOffset(), -0.5 * steppingParameters.getToeWidth());
        this.footPolygonShape.addVertex(-steppingParameters.getFootBackwardOffset(), 0.5 * steppingParameters.getFootWidth());
        this.footPolygonShape.addVertex(-steppingParameters.getFootBackwardOffset(), -0.5 * steppingParameters.getFootWidth());
        this.footPolygonShape.update();
        this.doInitialFastApproximation = new YoBoolean(namePrefix + "DoInitialFastApproximation", this.registry);
        this.numberOfCheckpoints = new YoInteger(namePrefix + "NumberOfCheckpoints", this.registry);
        this.numberOfTriesCounter = new YoCounter(namePrefix + "NumberOfTriesCounter", this.registry);
        this.minimumClearance = new YoDouble(namePrefix + "MinimumClearance", this.registry);
        this.fastApproximationLessClearance = new YoDouble(namePrefix + "FastApproximationLessClearance", this.registry);
        this.minimumHeightAboveFloorForCollision = new YoDouble(namePrefix + "MinimumHeightAboveFloorForCollision", this.registry);
        this.minimumAdjustmentIncrementDistance = new YoDouble(namePrefix + "MinimumAdjustmentIncrementDistance", this.registry);
        this.maximumAdjustmentIncrementDistance = new YoDouble(namePrefix + "MaximumAdjustmentIncrementDistance", this.registry);
        this.adjustmentIncrementDistanceGain = new YoDouble(namePrefix + "AdjustmentIncrementDistanceGain", this.registry);
        this.maximumAdjustmentDistance = new YoDouble(namePrefix + "MaximumAdjustmentDistance", this.registry);
        this.wereWaypointsAdjusted = new YoBoolean(namePrefix + "WereWaypointsAdjusted", this.registry);
        this.status = new YoEnum(namePrefix + "Status", this.registry, SwingOverPlanarRegionsStatus.class);
        this.mostSevereCollisionType = new YoEnum(namePrefix + "CollisionType", this.registry, SwingOverPlanarRegionsCollisionType.class);
        this.collisionIsOnRising = new YoBoolean(namePrefix + "CollisionIsOnRising", this.registry);
        this.heightAboveFloorPlane = new YoDouble(namePrefix + "HeightAboveFloorPlane", this.registry);
        this.heightAboveEndFoot = new YoDouble(namePrefix + "HeightAboveEndFoot", this.registry);
        this.initialTrajectoryLength = new YoDouble(namePrefix + "InitialTrajectoryLength", this.registry);
        this.expandedTrajectoryLength = new YoDouble(namePrefix + "ExpandedTrajectoryLength", this.registry);
        this.trajectoryPosition = new YoFramePoint3D(namePrefix + "TrajectoryPosition", worldFrame, this.registry);
        this.originalWaypoints = new RecyclingArrayList(2, FramePoint3D.class);
        this.originalWaypoints.add();
        this.originalWaypoints.add();
        this.adjustedWaypoints = new RecyclingArrayList(2, FramePoint3D.class);
        this.adjustedWaypoints.add();
        this.adjustedWaypoints.add();
        this.closestPolygonPointMap = new HashMap<SwingOverPlanarRegionsCollisionType, FramePoint3D>();
        for (SwingOverPlanarRegionsCollisionType swingOverPlanarRegionsTrajectoryCollisionType : SwingOverPlanarRegionsCollisionType.values()) {
            this.closestPolygonPointMap.put(swingOverPlanarRegionsTrajectoryCollisionType, new FramePoint3D());
        }
        this.midGroundPoint = new FramePoint3D();
        this.waypointAdjustment = new FrameVector3D();
        this.swingTrajectoryPlane = new Plane3D();
        this.swingFloorPlane = new Plane3D();
        this.axisAngle = new AxisAngle();
        this.rigidBodyTransform = new RigidBodyTransform();
        this.initialVelocity = new FrameVector3D();
        this.touchdownVelocity = new FrameVector3D();
        this.touchdownVelocity.setZ(walkingControllerParameters.getSwingTrajectoryParameters().getDesiredTouchdownVelocity());
        this.swingStartPosition = new FramePoint3D();
        this.swingEndPosition = new FramePoint3D();
        this.stanceFootPosition = new FramePoint3D();
        this.collisionRelativeToStart = new FramePoint3D();
        this.stepRelativeToStart = new FramePoint3D();
        this.visualizer = Optional.empty();
        this.doInitialFastApproximation.set(true);
        this.fastApproximationLessClearance.set(0.05);
        this.minimumHeightAboveFloorForCollision.set(0.02);
        this.numberOfCheckpoints.set(100);
        this.numberOfTriesCounter.setMaxCount(50);
        this.minimumClearance.set(0.04);
        this.minimumAdjustmentIncrementDistance.set(0.03);
        this.maximumAdjustmentIncrementDistance.set(0.15);
        this.adjustmentIncrementDistanceGain.set(0.95);
        this.maximumAdjustmentDistance.set(this.maximumSwingHeight - this.minimumSwingHeight);
        parentRegistry.addChild(this.registry);
    }

    public void setDoInitialFastApproximation(boolean doInitialFastApproximation) {
        this.doInitialFastApproximation.set(doInitialFastApproximation);
    }

    public void setFastApproximationLessClearance(double fastApproximationLessClearance) {
        this.fastApproximationLessClearance.set(fastApproximationLessClearance);
    }

    public void setNumberOfCheckpoints(int numberOfCheckpoints) {
        this.numberOfCheckpoints.set(numberOfCheckpoints);
    }

    public void setMaximumNumberOfTries(int maximumNumberOfTries) {
        this.numberOfTriesCounter.setMaxCount(maximumNumberOfTries);
    }

    public void setMinimumSwingFootClearance(double minimumSwingFootClearance) {
        this.minimumClearance.set(minimumSwingFootClearance);
    }

    public void setMinimumAdjustmentIncrementDistance(double minimumAdjustmentIncrementDistance) {
        this.minimumAdjustmentIncrementDistance.set(minimumAdjustmentIncrementDistance);
    }

    public void setMaximumAdjustmentIncrementDistance(double maximumAdjustmentIncrementDistance) {
        this.maximumAdjustmentIncrementDistance.set(maximumAdjustmentIncrementDistance);
    }

    public void setAdjustmentIncrementDistanceGain(double adjustmentIncrementDistanceGain) {
        this.adjustmentIncrementDistanceGain.set(adjustmentIncrementDistanceGain);
    }

    public void setMaximumAdjustmentDistance(double maximumAdjustmentDistance) {
        this.maximumAdjustmentDistance.set(maximumAdjustmentDistance);
    }

    public void setMinimumHeightAboveFloorForCollision(double heightAboveFloorForCollision) {
        this.minimumHeightAboveFloorForCollision.set(heightAboveFloorForCollision);
    }

    public double expandTrajectoryOverPlanarRegions(FramePose3DReadOnly stanceFootPose, FramePose3DReadOnly swingStartPose, FramePose3DReadOnly swingEndPose, PlanarRegionsList planarRegionsList) {
        this.swingStartPose.set(swingStartPose);
        this.swingEndPose.set(swingEndPose);
        this.stanceFootPosition.setMatchingFrame((FrameTuple3DReadOnly)stanceFootPose.getPosition());
        this.twoWaypointSwingGenerator.setStanceFootPosition((FramePoint3DReadOnly)this.stanceFootPosition);
        this.swingStartPosition.setMatchingFrame((FrameTuple3DReadOnly)swingStartPose.getPosition());
        this.twoWaypointSwingGenerator.setInitialConditions((FramePoint3DReadOnly)this.swingStartPosition, (FrameVector3DReadOnly)this.initialVelocity);
        this.swingEndPosition.setMatchingFrame((FrameTuple3DReadOnly)swingEndPose.getPosition());
        this.twoWaypointSwingGenerator.setFinalConditions((FramePoint3DReadOnly)this.swingEndPosition, (FrameVector3DReadOnly)this.touchdownVelocity);
        this.twoWaypointSwingGenerator.setStepTime(1.0);
        swingStartPose.get((RigidBodyTransformBasics)this.transformToStart);
        swingEndPose.get((RigidBodyTransformBasics)this.transformToEnd);
        this.transformToStart.inverseTransform((RigidBodyTransformBasics)this.transformFromStart);
        this.transformToEnd.inverseTransform((RigidBodyTransformBasics)this.transformFromEnd);
        this.initializeSwingWaypoints();
        this.adjustSwingEndIfCoincidentWithSwingStart();
        this.startOfSwingReferenceFrame.setPoseAndUpdate(swingStartPose);
        this.endOfSwingReferenceFrame.setPoseAndUpdate(swingEndPose);
        this.startOfSwingZUpFrame.update();
        this.endOfSwingZUpFrame.update();
        this.stepRelativeToStart.setIncludingFrame((FrameTuple3DReadOnly)this.swingEndPosition);
        this.stepRelativeToStart.changeFrame((ReferenceFrame)this.startOfSwingReferenceFrame);
        this.swingStartPolygon.setIncludingFrame((ReferenceFrame)this.startOfSwingReferenceFrame, (Vertex2DSupplier)this.footPolygonShape);
        this.swingEndPolygon.setIncludingFrame((ReferenceFrame)this.endOfSwingReferenceFrame, (Vertex2DSupplier)this.footPolygonShape);
        this.swingStartPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        this.swingEndPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        this.midGroundPoint.interpolate((FrameTuple3DReadOnly)this.swingStartPosition, (FrameTuple3DReadOnly)this.swingEndPosition, 0.5);
        this.swingTrajectoryPlane.set((Point3DReadOnly)this.swingStartPosition, (Point3DReadOnly)this.adjustedWaypoints.get(0), (Point3DReadOnly)this.swingEndPosition);
        this.axisAngle.set((Vector3DReadOnly)this.swingTrajectoryPlane.getNormal(), 1.5707963267948966);
        this.rigidBodyTransform.getRotation().set((Orientation3DReadOnly)this.axisAngle);
        this.tempPlaneNormal.sub((Tuple3DReadOnly)this.swingStartPosition, (Tuple3DReadOnly)this.swingEndPosition);
        this.rigidBodyTransform.transform((Vector3DBasics)this.tempPlaneNormal);
        this.tempPlaneNormal.normalize();
        this.swingFloorPlane.set((Point3DReadOnly)this.swingStartPosition, (Vector3DReadOnly)this.tempPlaneNormal);
        this.wereWaypointsAdjusted.set(false);
        double filterDistance = this.maximumSwingHeight + Math.max(this.heelLength, this.toeLength) + 2.0 * this.minimumClearance.getDoubleValue();
        List filteredRegions = PlanarRegionTools.filterPlanarRegionsWithBoundingCapsule((Point3DReadOnly)this.swingStartPosition, (Point3DReadOnly)this.swingEndPosition, (double)filterDistance, (List)planarRegionsList.getPlanarRegionsAsList());
        this.status.set((Enum)SwingOverPlanarRegionsStatus.SEARCHING_FOR_SOLUTION);
        this.numberOfTriesCounter.resetCount();
        while (this.doInitialFastApproximation.getBooleanValue() && ((SwingOverPlanarRegionsStatus)this.status.getEnumValue()).equals((Object)SwingOverPlanarRegionsStatus.SEARCHING_FOR_SOLUTION) && !this.numberOfTriesCounter.maxCountReached()) {
            for (SwingOverPlanarRegionsCollisionType swingOverPlanarRegionsTrajectoryCollisionType : SwingOverPlanarRegionsCollisionType.values()) {
                this.closestPolygonPointMap.get((Object)swingOverPlanarRegionsTrajectoryCollisionType).setIncludingFrame(worldFrame, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            this.mostSevereCollisionType.set((Enum)SwingOverPlanarRegionsCollisionType.NO_INTERSECTION);
            this.status.set((Enum)this.checkAndAdjustForCollisions(filteredRegions, this::getFractionAlongLineForCollision));
            this.updateVisualizer();
            this.numberOfTriesCounter.countOne();
        }
        this.twoWaypointSwingGenerator.setTrajectoryType(TrajectoryType.CUSTOM, this.adjustedWaypoints);
        this.twoWaypointSwingGenerator.initialize();
        this.calculateTrajectoryLength(this.initialTrajectoryLength);
        this.status.set((Enum)SwingOverPlanarRegionsStatus.SEARCHING_FOR_SOLUTION);
        while (((SwingOverPlanarRegionsStatus)this.status.getEnumValue()).equals((Object)SwingOverPlanarRegionsStatus.SEARCHING_FOR_SOLUTION) && !this.numberOfTriesCounter.maxCountReached()) {
            for (SwingOverPlanarRegionsCollisionType swingOverPlanarRegionsTrajectoryCollisionType : SwingOverPlanarRegionsCollisionType.values()) {
                this.closestPolygonPointMap.get((Object)swingOverPlanarRegionsTrajectoryCollisionType).setIncludingFrame(worldFrame, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            this.mostSevereCollisionType.set((Enum)SwingOverPlanarRegionsCollisionType.NO_INTERSECTION);
            this.status.set((Enum)this.checkAndAdjustForCollisions(filteredRegions, this::getFractionThroughTrajectoryForCollision));
            if (!((SwingOverPlanarRegionsStatus)this.status.getEnumValue()).equals((Object)SwingOverPlanarRegionsStatus.FAILURE_HIT_MAX_ADJUSTMENT_DISTANCE)) {
                this.twoWaypointSwingGenerator.setTrajectoryType(TrajectoryType.CUSTOM, this.adjustedWaypoints);
                this.twoWaypointSwingGenerator.initialize();
            }
            this.updateVisualizer();
            this.numberOfTriesCounter.countOne();
        }
        this.calculateTrajectoryLength(this.expandedTrajectoryLength);
        return this.twoWaypointSwingGenerator.computeAndGetMaxSpeed();
    }

    private void adjustSwingEndIfCoincidentWithSwingStart() {
        if (this.swingStartPosition.distance((FramePoint3DReadOnly)this.swingEndPosition) < 1.0E-8) {
            this.swingEndPosition.add(1.0E-4, 1.0E-4, 1.0E-4);
        }
    }

    private void initializeSwingWaypoints() {
        FramePoint3DBasics firstBaseWaypoint = (FramePoint3DBasics)this.originalWaypoints.get(0);
        FramePoint3DBasics secondBaseWaypoint = (FramePoint3DBasics)this.originalWaypoints.get(1);
        firstBaseWaypoint.interpolate((FrameTuple3DReadOnly)this.swingStartPosition, (FrameTuple3DReadOnly)this.swingEndPosition, this.swingWaypointProportions[0]);
        secondBaseWaypoint.interpolate((FrameTuple3DReadOnly)this.swingStartPosition, (FrameTuple3DReadOnly)this.swingEndPosition, this.swingWaypointProportions[1]);
        double firstWaypointHeight = Math.max(this.swingStartPosition.getZ(), firstBaseWaypoint.getZ()) + this.minimumSwingHeight;
        double secondWaypointHeight = Math.max(this.swingEndPosition.getZ(), secondBaseWaypoint.getZ()) + this.minimumSwingHeight;
        firstBaseWaypoint.setZ(firstWaypointHeight);
        secondBaseWaypoint.setZ(secondWaypointHeight);
        ((FramePoint3D)this.adjustedWaypoints.get(0)).set((FrameTuple3DReadOnly)firstBaseWaypoint);
        ((FramePoint3D)this.adjustedWaypoints.get(1)).set((FrameTuple3DReadOnly)secondBaseWaypoint);
    }

    private SwingOverPlanarRegionsStatus checkAndAdjustForCollisions(List<PlanarRegion> planarRegionsList, FractionThroughTrajectoryForCollision collisionChecker) {
        double maxAdjustmentDistanceSquared = MathTools.square((double)this.maximumAdjustmentDistance.getDoubleValue());
        FramePoint3DBasics originalFirstWaypoint = (FramePoint3DBasics)this.originalWaypoints.get(0);
        FramePoint3DBasics originalSecondWaypoint = (FramePoint3DBasics)this.originalWaypoints.get(1);
        FramePoint3DBasics adjustedFirstWaypoint = (FramePoint3DBasics)this.adjustedWaypoints.get(0);
        FramePoint3DBasics adjustedSecondWaypoint = (FramePoint3DBasics)this.adjustedWaypoints.get(1);
        Point3D pointOnTrajectory = new Point3D();
        Point3D collisionInFoot = new Point3D();
        Point3D nearestCollisionInWorld = new Point3D();
        double fractionForCollision = collisionChecker.getFractionThroughTrajectoryForCollision(planarRegionsList, (Point3DBasics)pointOnTrajectory, (Point3DBasics)collisionInFoot, (Point3DBasics)nearestCollisionInWorld);
        if (fractionForCollision >= 0.0) {
            double adjustmentDistance;
            this.wereWaypointsAdjusted.set(true);
            this.computeWaypointAdjustmentDirection(fractionForCollision);
            double distanceToCollisionFromTrajectory = pointOnTrajectory.distance((Point3DReadOnly)nearestCollisionInWorld);
            if (MathTools.epsilonEquals((double)distanceToCollisionFromTrajectory, (double)0.0, (double)0.001)) {
                adjustmentDistance = this.minimumAdjustmentIncrementDistance.getDoubleValue();
            } else {
                adjustmentDistance = collisionInFoot.distance((Point3DReadOnly)nearestCollisionInWorld);
                adjustmentDistance = MathTools.clamp((double)(this.adjustmentIncrementDistanceGain.getDoubleValue() * adjustmentDistance), (double)this.minimumAdjustmentIncrementDistance.getDoubleValue(), (double)this.maximumAdjustmentIncrementDistance.getDoubleValue());
            }
            this.waypointAdjustment.scale(adjustmentDistance);
            adjustedFirstWaypoint.scaleAdd(1.0 - fractionForCollision, (FrameTuple3DReadOnly)this.waypointAdjustment, (FrameTuple3DReadOnly)adjustedFirstWaypoint);
            adjustedSecondWaypoint.scaleAdd(fractionForCollision, (FrameTuple3DReadOnly)this.waypointAdjustment, (FrameTuple3DReadOnly)adjustedSecondWaypoint);
            if (adjustedFirstWaypoint.distanceSquared((FramePoint3DReadOnly)originalFirstWaypoint) > maxAdjustmentDistanceSquared || adjustedSecondWaypoint.distanceSquared((FramePoint3DReadOnly)originalSecondWaypoint) > maxAdjustmentDistanceSquared) {
                return SwingOverPlanarRegionsStatus.FAILURE_HIT_MAX_ADJUSTMENT_DISTANCE;
            }
            return SwingOverPlanarRegionsStatus.SEARCHING_FOR_SOLUTION;
        }
        return SwingOverPlanarRegionsStatus.SOLUTION_FOUND;
    }

    private double getFractionAlongLineForCollision(List<PlanarRegion> planarRegions, Point3DBasics collisionOnSegmentToPack, Point3DBasics collisionInFootToPack, Point3DBasics collisionOnRegionToPack) {
        double firstSegmentLength = this.swingStartPosition.distance((FramePoint3DReadOnly)this.adjustedWaypoints.get(0));
        double secondSegmentLength = ((FramePoint3D)this.adjustedWaypoints.get(0)).distance((FramePoint3DReadOnly)this.adjustedWaypoints.get(1));
        double thirdSegmentLength = ((FramePoint3D)this.adjustedWaypoints.get(1)).distance((FramePoint3DReadOnly)this.swingEndPosition);
        double totalLength = firstSegmentLength + secondSegmentLength + thirdSegmentLength;
        RotationMatrix startRotation = new RotationMatrix();
        RotationMatrix endRotation = new RotationMatrix();
        this.startOfSwingReferenceFrame.getOrientation(startRotation);
        this.endOfSwingReferenceFrame.getOrientation(endRotation);
        this.collisionBox.getOrientation().interpolate((RotationMatrixReadOnly)startRotation, (RotationMatrixReadOnly)endRotation, 0.5);
        double fractionThroughSegmentForCollision = this.checkLineSegmentForCollision((Point3DReadOnly)this.swingStartPosition, (Point3DReadOnly)this.adjustedWaypoints.get(0), planarRegions, collisionOnSegmentToPack, collisionInFootToPack, collisionOnRegionToPack, true);
        if (fractionThroughSegmentForCollision >= 0.0) {
            return fractionThroughSegmentForCollision * firstSegmentLength / totalLength;
        }
        fractionThroughSegmentForCollision = this.checkLineSegmentForCollision((Point3DReadOnly)this.adjustedWaypoints.get(0), (Point3DReadOnly)this.adjustedWaypoints.get(1), planarRegions, collisionOnSegmentToPack, collisionInFootToPack, collisionOnRegionToPack, false);
        if (fractionThroughSegmentForCollision >= 0.0) {
            return (fractionThroughSegmentForCollision * secondSegmentLength + firstSegmentLength) / totalLength;
        }
        fractionThroughSegmentForCollision = this.checkLineSegmentForCollision((Point3DReadOnly)this.adjustedWaypoints.get(1), (Point3DReadOnly)this.swingEndPosition, planarRegions, collisionOnSegmentToPack, collisionInFootToPack, collisionOnRegionToPack, false);
        if (fractionThroughSegmentForCollision >= 0.0) {
            return (fractionThroughSegmentForCollision * thirdSegmentLength + secondSegmentLength + firstSegmentLength) / totalLength;
        }
        return -1.0;
    }

    private double checkLineSegmentForCollision(Point3DReadOnly firstEndpoint, Point3DReadOnly secondEndpoint, List<PlanarRegion> planarRegions, Point3DBasics collisionOnSegmentToPack, Point3DBasics collisionInFootToPack, Point3DBasics collisionOnRegionToPack, boolean collisionIsOnRising) {
        this.collisionBox.getSize().set(this.footLength, this.footWidth, this.footHeight);
        for (PlanarRegion planarRegion : planarRegions) {
            Point3D startInLocal = new Point3D((Tuple3DReadOnly)firstEndpoint);
            Point3D endInLocal = new Point3D((Tuple3DReadOnly)secondEndpoint);
            planarRegion.transformFromWorldToLocal((Transformable)startInLocal);
            planarRegion.transformFromWorldToLocal((Transformable)endInLocal);
            Point3D closestPointOnSegment = new Point3D();
            PlanarRegionTools.getDistanceFromLineSegment3DToPlanarRegion((Point3DReadOnly)startInLocal, (Point3DReadOnly)endInLocal, (PlanarRegion)planarRegion, (Point3DBasics)closestPointOnSegment, (Point3DBasics)collisionOnRegionToPack);
            planarRegion.transformFromLocalToWorld((Transformable)collisionOnRegionToPack);
            planarRegion.getTransformToWorld().transform((Point3DReadOnly)closestPointOnSegment, collisionOnSegmentToPack);
            this.trajectoryPosition.set((Tuple3DReadOnly)collisionOnSegmentToPack);
            this.collisionBox.getPosition().set((Tuple3DReadOnly)this.trajectoryPosition);
            this.collisionBox.getPosition().addX(this.footLengthOffset);
            this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.NO_INTERSECTION, (Point3DReadOnly)collisionOnRegionToPack);
            if (!this.checkValidityOfCollisionPoint(collisionInFootToPack, (Point3DReadOnly)collisionOnRegionToPack, (Box3DReadOnly)this.collisionBox, this.minimumClearance.getDoubleValue(), collisionIsOnRising)) continue;
            return closestPointOnSegment.distance((Point3DReadOnly)startInLocal) / endInLocal.distance((Point3DReadOnly)startInLocal);
        }
        collisionOnSegmentToPack.setToNaN();
        collisionOnRegionToPack.setToNaN();
        return -1.0;
    }

    private double getFractionThroughTrajectoryForCollision(List<PlanarRegion> planarRegions, Point3DBasics pointOnTrajectoryToPack, Point3DBasics closestPointInFootToPack, Point3DBasics closestPointOnRegionToPack) {
        this.twoWaypointSwingGenerator.setTrajectoryType(TrajectoryType.CUSTOM, this.adjustedWaypoints);
        this.twoWaypointSwingGenerator.initialize();
        ((FramePoint3D)this.adjustedWaypoints.get(0)).set((FrameTuple3DReadOnly)this.twoWaypointSwingGenerator.getWaypoint(0));
        ((FramePoint3D)this.adjustedWaypoints.get(1)).set((FrameTuple3DReadOnly)this.twoWaypointSwingGenerator.getWaypoint(1));
        double stepAmount = 1.0 / (double)this.numberOfCheckpoints.getIntegerValue();
        boolean collisionIsOnRising = true;
        this.collisionBox.getSize().set(this.footLength, this.footWidth, this.footHeight);
        RotationMatrix startRotation = new RotationMatrix();
        RotationMatrix endRotation = new RotationMatrix();
        this.startOfSwingReferenceFrame.getOrientation(startRotation);
        this.endOfSwingReferenceFrame.getOrientation(endRotation);
        for (double fraction = 0.0; fraction <= 1.0; fraction += stepAmount) {
            this.twoWaypointSwingGenerator.compute(fraction);
            this.trajectoryPosition.setMatchingFrame((FrameTuple3DReadOnly)this.twoWaypointSwingGenerator.getPosition());
            this.solePoseReferenceFrame.setPositionAndUpdate((FramePoint3DReadOnly)this.trajectoryPosition);
            pointOnTrajectoryToPack.set((Tuple3DReadOnly)this.trajectoryPosition);
            this.collisionBox.getOrientation().interpolate((RotationMatrixReadOnly)startRotation, (RotationMatrixReadOnly)endRotation, fraction);
            this.collisionBox.getPosition().set((Tuple3DReadOnly)this.trajectoryPosition);
            this.collisionBox.getPosition().addX(this.footLengthOffset);
            this.twoWaypointSwingGenerator.getWaypointTime(0);
            if (collisionIsOnRising && fraction > this.twoWaypointSwingGenerator.getWaypointTime(0)) {
                collisionIsOnRising = false;
            }
            for (PlanarRegion planarRegion : planarRegions) {
                Point3D closestPointOnRegion = PlanarRegionTools.closestPointOnPlanarRegion((Point3DReadOnly)this.trajectoryPosition, (PlanarRegion)planarRegion);
                this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.NO_INTERSECTION, (Point3DReadOnly)closestPointOnRegion);
                if (closestPointOnRegion == null) continue;
                closestPointOnRegionToPack.set((Tuple3DReadOnly)closestPointOnRegion);
                if (!this.checkValidityOfCollisionPoint(closestPointInFootToPack, (Point3DReadOnly)closestPointOnRegionToPack, (Box3DReadOnly)this.collisionBox, this.minimumClearance.getDoubleValue(), collisionIsOnRising)) continue;
                return fraction;
            }
            this.updateVisualizer();
        }
        pointOnTrajectoryToPack.setToNaN();
        closestPointOnRegionToPack.setToNaN();
        return -1.0;
    }

    private boolean checkValidityOfCollisionPoint(Point3DBasics closestPointInFootToPack, Point3DReadOnly closestPointOnRegion, Box3DReadOnly footCollisionBox, double minimumClearance, boolean collisionIsOnRising) {
        this.heightAboveEndFoot.setToNaN();
        this.collisionIsOnRising.set(collisionIsOnRising);
        footCollisionBox.orthogonalProjection(closestPointOnRegion, closestPointInFootToPack);
        if (footCollisionBox.distance(closestPointOnRegion) > minimumClearance) {
            return false;
        }
        this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.TOO_CLOSE_TO_IGNORE_PLANE, closestPointOnRegion);
        if (!this.checkIfCollidingWithFloorPlane(closestPointOnRegion)) {
            boolean isCollisionAboveFootholds;
            boolean bl = isCollisionAboveFootholds = this.isCollisionAboveStartFoot(closestPointOnRegion, collisionIsOnRising) || this.isCollisionAboveEndFoot(closestPointOnRegion);
            if (isCollisionAboveFootholds) {
                this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.COLLISION_ABOVE_FOOT, closestPointOnRegion);
            } else {
                boolean isCollisionInsideTheTrajectory;
                boolean bl2 = isCollisionInsideTheTrajectory = this.midGroundPoint.distanceSquared(closestPointOnRegion) < this.midGroundPoint.distanceSquared((FramePoint3DReadOnly)this.trajectoryPosition);
                if (isCollisionInsideTheTrajectory) {
                    this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.COLLISION_INSIDE_TRAJECTORY, closestPointOnRegion);
                    return true;
                }
                this.collisionRelativeToStart.setIncludingFrame(worldFrame, (Tuple3DReadOnly)closestPointOnRegion);
                this.collisionRelativeToStart.changeFrame((ReferenceFrame)this.startOfSwingReferenceFrame);
                double toePoint = this.toeLength;
                double heelPoint = this.stepRelativeToStart.getX() - this.heelLength;
                boolean collisionIsBetweenToeAndHeel = MathTools.intervalContains((double)this.collisionRelativeToStart.getX(), (double)Math.min(toePoint, heelPoint), (double)Math.max(toePoint, heelPoint));
                if (collisionIsBetweenToeAndHeel) {
                    this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.COLLISION_BETWEEN_FEET, closestPointOnRegion);
                    return true;
                }
                this.updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType.OUTSIDE_TRAJECTORY, closestPointOnRegion);
            }
        }
        return false;
    }

    private void updateClosestAndMostSevereIntersectionPoint(SwingOverPlanarRegionsCollisionType collisionType, Point3DReadOnly collision) {
        if (collisionType.ordinal() > ((SwingOverPlanarRegionsCollisionType)this.mostSevereCollisionType.getEnumValue()).ordinal()) {
            this.mostSevereCollisionType.set((Enum)collisionType);
        }
        if (collision != null && this.trajectoryPosition.distanceSquared(collision) < this.trajectoryPosition.distanceSquared((FramePoint3DReadOnly)this.closestPolygonPointMap.get((Object)collisionType))) {
            this.closestPolygonPointMap.get((Object)collisionType).set((Tuple3DReadOnly)collision);
        }
    }

    private boolean checkIfCollidingWithFloorPlane(Point3DReadOnly collisionPoint) {
        this.heightAboveFloorPlane.set(this.swingFloorPlane.signedDistance(collisionPoint));
        return this.heightAboveFloorPlane.getDoubleValue() < this.minimumHeightAboveFloorForCollision.getDoubleValue();
    }

    private boolean isCollisionAboveEndFoot(Point3DReadOnly collisionPoint) {
        if (!this.swingEndPolygon.isPointInside(collisionPoint.getX(), collisionPoint.getY())) {
            return false;
        }
        FramePoint3D collisionInEnd = new FramePoint3D(worldFrame, (Tuple3DReadOnly)collisionPoint);
        collisionInEnd.changeFrame((ReferenceFrame)this.endOfSwingZUpFrame);
        this.heightAboveEndFoot.set(collisionInEnd.getZ());
        return this.heightAboveEndFoot.getDoubleValue() < this.minimumHeightAboveFloorForCollision.getDoubleValue();
    }

    private boolean isCollisionAboveStartFoot(Point3DReadOnly collisionPoint, boolean collisionIsOnRising) {
        if (!this.swingStartPolygon.isPointInside(collisionPoint.getX(), collisionPoint.getY())) {
            return false;
        }
        FramePoint3D collisionInStart = new FramePoint3D(worldFrame, (Tuple3DReadOnly)collisionPoint);
        collisionInStart.changeFrame((ReferenceFrame)this.startOfSwingZUpFrame);
        return collisionIsOnRising && collisionInStart.getZ() < this.minimumHeightAboveFloorForCollision.getDoubleValue() + this.minimumClearance.getDoubleValue();
    }

    private void computeWaypointAdjustmentDirection(double fraction) {
        this.axisAngle.set((Vector3DReadOnly)this.swingTrajectoryPlane.getNormal(), Math.PI * fraction);
        this.rigidBodyTransform.getRotation().set((Orientation3DReadOnly)this.axisAngle);
        this.waypointAdjustment.sub((FrameTuple3DReadOnly)this.swingStartPosition, (FrameTuple3DReadOnly)this.swingEndPosition);
        this.waypointAdjustment.normalize();
        this.rigidBodyTransform.transform((Vector3DBasics)this.waypointAdjustment);
    }

    private void calculateTrajectoryLength(YoDouble trajectoryLengthToSet) {
        FramePoint3D position0 = new FramePoint3D();
        FramePoint3D position1 = new FramePoint3D();
        this.twoWaypointSwingGenerator.compute(0.0);
        position0.setIncludingFrame((FrameTuple3DReadOnly)this.twoWaypointSwingGenerator.getPosition());
        double distance = 0.0;
        for (int i = 0; i < 10; ++i) {
            double t = (double)(i + 1) / 10.0;
            this.twoWaypointSwingGenerator.compute(t);
            position1.setIncludingFrame((FrameTuple3DReadOnly)this.twoWaypointSwingGenerator.getPosition());
            distance += position0.distance((FramePoint3DReadOnly)position1);
            position0.set(position1);
        }
        trajectoryLengthToSet.set(distance);
    }

    public List<FramePoint3D> getExpandedWaypoints() {
        return this.adjustedWaypoints;
    }

    public boolean wereWaypointsAdjusted() {
        return this.wereWaypointsAdjusted.getBooleanValue();
    }

    public double getInitialTrajectoryLength() {
        return this.initialTrajectoryLength.getDoubleValue();
    }

    public double getExpandedTrajectoryLength() {
        return this.expandedTrajectoryLength.getDoubleValue();
    }

    public SwingOverPlanarRegionsStatus getStatus() {
        return (SwingOverPlanarRegionsStatus)this.status.getEnumValue();
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getGraphicsListRegistry() {
        return this.graphicsListRegistry;
    }

    public void updateVisualizer() {
        if (this.visualizer.isPresent()) {
            this.visualizer.get().run();
        }
    }

    public void attachVisualizer(Runnable visualizer) {
        this.visualizer = Optional.of(visualizer);
    }

    public PoseReferenceFrame getSolePoseReferenceFrame() {
        return this.solePoseReferenceFrame;
    }

    public Plane3DReadOnly getSwingFloorPlane() {
        return this.swingFloorPlane;
    }

    public FramePose3DReadOnly getStartPose() {
        return this.swingStartPose;
    }

    public FramePose3DReadOnly getEndPose() {
        return this.swingEndPose;
    }

    public FramePoint3D getClosestPolygonPoint(SwingOverPlanarRegionsCollisionType collisionType) {
        return this.closestPolygonPointMap.get((Object)collisionType);
    }

    public double getCollisionSphereRadius() {
        return Math.max(this.heelLength, this.toeLength);
    }

    public double getFootHeight() {
        return this.footHeight;
    }

    public double getToeLength() {
        return this.toeLength;
    }

    public double getHeelLength() {
        return this.heelLength;
    }

    public double getFootWidth() {
        return this.footWidth;
    }

    public double getMinimumClearance() {
        return this.minimumClearance.getDoubleValue();
    }

    public static enum SwingOverPlanarRegionsStatus {
        INITIALIZED,
        FAILURE_HIT_MAX_ADJUSTMENT_DISTANCE,
        SEARCHING_FOR_SOLUTION,
        SOLUTION_FOUND;

    }

    public static enum SwingOverPlanarRegionsCollisionType {
        NO_INTERSECTION,
        TOO_CLOSE_TO_IGNORE_PLANE,
        COLLISION_ABOVE_FOOT,
        OUTSIDE_TRAJECTORY,
        COLLISION_INSIDE_TRAJECTORY,
        COLLISION_BETWEEN_FEET;

    }

    @FunctionalInterface
    private static interface FractionThroughTrajectoryForCollision {
        public double getFractionThroughTrajectoryForCollision(List<PlanarRegion> var1, Point3DBasics var2, Point3DBasics var3, Point3DBasics var4);
    }
}

