/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePolynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoFramePolynomial3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SoftTouchdownPositionTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final FixedFramePolynomial3DBasics positionTouchdownTrajectory;
    private final YoDouble timeInitial;
    private final YoDouble timeFinal;
    private final YoDouble timeIntoTouchdown;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialVelocity = new FrameVector3D();
    private final FrameVector3D initialAcceleration = new FrameVector3D();

    public SoftTouchdownPositionTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.positionTouchdownTrajectory = new YoFramePolynomial3D(namePrefix + "Trajectory", 3, worldFrame, this.registry);
        this.timeInitial = new YoDouble(namePrefix + "TimeInitial", this.registry);
        this.timeFinal = new YoDouble(namePrefix + "TimeFinal", this.registry);
        this.timeIntoTouchdown = new YoDouble(namePrefix + "TimeIntoTouchdown", this.registry);
        this.timeFinal.set(Double.POSITIVE_INFINITY);
    }

    public void setLinearTrajectory(double initialTime, FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, FrameVector3DReadOnly initialAcceleration) {
        this.timeInitial.set(initialTime);
        this.initialPosition.setIncludingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialVelocity);
        this.initialAcceleration.setIncludingFrame((FrameTuple3DReadOnly)initialAcceleration);
        this.initialPosition.changeFrame(worldFrame);
        this.initialVelocity.changeFrame(worldFrame);
        this.initialAcceleration.changeFrame(worldFrame);
    }

    public void initialize() {
        double t0 = this.timeInitial.getDoubleValue();
        double tf = this.timeFinal.getDoubleValue();
        this.positionTouchdownTrajectory.setQuadraticUsingInitialAcceleration(t0, tf, (FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialVelocity, (FrameVector3DReadOnly)this.initialAcceleration);
    }

    public void compute(double time) {
        double clippedTime = MathTools.clamp((double)time, (double)this.timeInitial.getDoubleValue(), (double)this.timeFinal.getDoubleValue());
        this.timeIntoTouchdown.set(clippedTime - this.timeInitial.getDoubleValue());
        this.positionTouchdownTrajectory.compute(clippedTime);
    }

    public boolean isDone() {
        return false;
    }

    public FramePoint3DReadOnly getPosition() {
        return this.positionTouchdownTrajectory.getPosition();
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.positionTouchdownTrajectory.getVelocity();
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.positionTouchdownTrajectory.getAcceleration();
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
    }
}

