/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class PositionOptimizedTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    public static final int dimensions = 3;
    public final ReferenceFrame trajectoryFrame;
    private final String namePrefix;
    private final TrajectoryPointOptimizer optimizer;
    private final YoInteger maxIterations;
    private final RecyclingArrayList<TDoubleArrayList> coefficients;
    private final EnumMap<Axis3D, ArrayList<YoPolynomial>> trajectories = new EnumMap(Axis3D.class);
    private final double[] tempCoeffs = new double[4];
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialVelocity = new FrameVector3D();
    private final FramePoint3D finalPosition = new FramePoint3D();
    private final FrameVector3D finalVelocity = new FrameVector3D();
    private final FramePoint3D waypointPosition = new FramePoint3D();
    private final RecyclingArrayList<TDoubleArrayList> waypointPositions;
    private final TIntIntMap indexMap = new TIntIntHashMap(10, 0.5f, -1, -1);
    private final TDoubleArrayList waypointVelocity = new TDoubleArrayList(3);
    private final YoRegistry registry;
    private final YoBoolean isDone;
    private final YoBoolean optimizeInOneTick;
    private final YoBoolean hasConverged;
    private final YoInteger segments;
    private final YoInteger activeSegment;
    private final ArrayList<YoDouble> waypointTimes = new ArrayList();
    private final YoFramePoint3D desiredPosition;
    private final YoFrameVector3D desiredVelocity;
    private final YoFrameVector3D desiredAcceleration;
    private final YoGraphicPolynomial3D trajectoryViz;
    private final YoDouble maxSpeed;
    private final YoDouble maxSpeedTime;
    private final FrameVector3D tempVelocity = new FrameVector3D();
    private boolean visualize = true;

    public PositionOptimizedTrajectoryGenerator() {
        this("", null, ReferenceFrame.getWorldFrame());
    }

    public PositionOptimizedTrajectoryGenerator(int maxIterations, int maxWaypoints) {
        this(maxIterations, maxWaypoints, ReferenceFrame.getWorldFrame());
    }

    public PositionOptimizedTrajectoryGenerator(int maxIterations, int maxWaypoints, ReferenceFrame trajectoryFrame) {
        this("", null, null, maxIterations, maxWaypoints, trajectoryFrame);
    }

    public PositionOptimizedTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry, ReferenceFrame trajectoryFrame) {
        this(namePrefix, parentRegistry, null, 200, 200, trajectoryFrame);
    }

    public PositionOptimizedTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry, ReferenceFrame trajectoryFrame) {
        this(namePrefix, parentRegistry, graphicsListRegistry, 200, 200, trajectoryFrame);
    }

    public PositionOptimizedTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry, int maxIterations, int maxWaypoints) {
        this(namePrefix, parentRegistry, graphicsListRegistry, maxIterations, maxWaypoints, ReferenceFrame.getWorldFrame());
    }

    public PositionOptimizedTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry, int maxIterations, int maxWaypoints, ReferenceFrame trajectoryFrame) {
        this.namePrefix = namePrefix;
        this.trajectoryFrame = trajectoryFrame;
        this.coefficients = new RecyclingArrayList(0, () -> {
            TDoubleArrayList ret = new TDoubleArrayList(4);
            for (int i = 0; i < 4; ++i) {
                ret.add(0.0);
            }
            return ret;
        });
        this.waypointPositions = new RecyclingArrayList(0, () -> {
            TDoubleArrayList ret = new TDoubleArrayList(3);
            for (int i = 0; i < 3; ++i) {
                ret.add(0.0);
            }
            return ret;
        });
        this.registry = new YoRegistry(namePrefix + "Trajectory");
        this.optimizer = new TrajectoryPointOptimizer(namePrefix, 3, this.registry);
        this.maxIterations = new YoInteger(namePrefix + "MaxIterations", this.registry);
        this.maxIterations.set(maxIterations);
        this.isDone = new YoBoolean(namePrefix + "IsDone", this.registry);
        this.optimizeInOneTick = new YoBoolean(namePrefix + "OptimizeInOneTick", this.registry);
        this.hasConverged = new YoBoolean(namePrefix + "HasConverged", this.registry);
        this.segments = new YoInteger(namePrefix + "Segments", this.registry);
        this.activeSegment = new YoInteger(namePrefix + "ActiveSegment", this.registry);
        this.optimizeInOneTick.set(maxIterations >= 0);
        this.hasConverged.set(this.optimizeInOneTick.getBooleanValue());
        this.desiredPosition = new YoFramePoint3D(namePrefix + "DesiredPosition", trajectoryFrame, this.registry);
        this.desiredVelocity = new YoFrameVector3D(namePrefix + "DesiredVelocity", trajectoryFrame, this.registry);
        this.desiredAcceleration = new YoFrameVector3D(namePrefix + "DesiredAcceleration", trajectoryFrame, this.registry);
        for (Axis3D axis : Axis3D.values) {
            ArrayList segments = new ArrayList();
            this.trajectories.put(axis, segments);
        }
        while (this.waypointTimes.size() <= maxWaypoints) {
            this.extendBySegment(this.registry);
        }
        this.reset();
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
        if (graphicsListRegistry != null) {
            List yoPolynomial3Ds = YoPolynomial3D.createYoPolynomial3DList((List)this.trajectories.get(Axis3D.X), (List)this.trajectories.get(Axis3D.Y), (List)this.trajectories.get(Axis3D.Z));
            this.trajectoryViz = new YoGraphicPolynomial3D(namePrefix + "Trajectory", null, yoPolynomial3Ds, this.waypointTimes, 0.01, 25, 8, this.registry);
            graphicsListRegistry.registerYoGraphic(namePrefix + "Trajectory", (YoGraphic)this.trajectoryViz);
            this.trajectoryViz.setColorType(YoGraphicPolynomial3D.TrajectoryColorType.ACCELERATION_BASED);
        } else {
            this.trajectoryViz = null;
        }
        this.maxSpeed = new YoDouble("MaxVelocity", this.registry);
        this.maxSpeedTime = new YoDouble("MaxVelocityTime", this.registry);
    }

    private void extendBySegment(YoRegistry registry) {
        int size = this.waypointTimes.size() + 1;
        for (Axis3D axis : Axis3D.values) {
            this.trajectories.get(axis).add(new YoPolynomial(this.namePrefix + "Segment" + size + "Axis" + axis.ordinal(), 4, registry));
        }
        this.waypointTimes.add(new YoDouble(this.namePrefix + "WaypointTime" + size, registry));
        this.waypointPositions.add();
    }

    public void reset() {
        this.initialPosition.setToNaN(this.trajectoryFrame);
        this.initialVelocity.setToNaN(this.trajectoryFrame);
        this.finalPosition.setToNaN(this.trajectoryFrame);
        this.finalVelocity.setToNaN(this.trajectoryFrame);
        this.segments.set(1);
        this.waypointPositions.clear();
        this.optimizer.setWaypoints(this.waypointPositions);
        this.coefficients.clear();
        this.coefficients.add();
    }

    public void setEndpointConditions(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity) {
        this.initialPosition.setIncludingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialVelocity);
        this.initialPosition.changeFrame(this.trajectoryFrame);
        this.initialVelocity.changeFrame(this.trajectoryFrame);
        this.finalPosition.setIncludingFrame((FrameTuple3DReadOnly)finalPosition);
        this.finalVelocity.setIncludingFrame((FrameTuple3DReadOnly)finalVelocity);
        this.finalPosition.changeFrame(this.trajectoryFrame);
        this.finalVelocity.changeFrame(this.trajectoryFrame);
        for (Axis3D axis : Axis3D.values) {
            this.optimizer.setEndPoints(axis.ordinal(), this.initialPosition.getElement(axis), this.initialVelocity.getElement(axis), this.finalPosition.getElement(axis), this.finalVelocity.getElement(axis));
        }
    }

    public void setEndpointWeights(Tuple3DReadOnly initialPositionWeight, Tuple3DReadOnly initialVelocityWeight, Tuple3DReadOnly finalPositionWeight, Tuple3DReadOnly finalVelocityWeight) {
        for (Axis3D axis : Axis3D.values) {
            this.optimizer.setEndPointWeights(axis.ordinal(), initialPositionWeight == null ? Double.POSITIVE_INFINITY : initialPositionWeight.getElement(axis), initialVelocityWeight == null ? Double.POSITIVE_INFINITY : initialVelocityWeight.getElement(axis), finalPositionWeight == null ? Double.POSITIVE_INFINITY : finalPositionWeight.getElement(axis), finalVelocityWeight == null ? Double.POSITIVE_INFINITY : finalVelocityWeight.getElement(axis));
        }
    }

    public void setWaypoints(List<? extends FramePoint3DReadOnly> waypointPositions) {
        if (waypointPositions.size() > this.waypointTimes.size()) {
            throw new RuntimeException("Too many waypoints");
        }
        this.waypointPositions.clear();
        this.coefficients.clear();
        this.indexMap.clear();
        this.coefficients.add();
        int optimizerIndex = 0;
        for (int i = 0; i < waypointPositions.size(); ++i) {
            this.waypointPosition.setIncludingFrame((FrameTuple3DReadOnly)waypointPositions.get(i));
            this.waypointPosition.changeFrame(this.trajectoryFrame);
            if (i > 0 && this.waypointPosition.epsilonEquals((FrameTuple3DReadOnly)waypointPositions.get(i - 1), 1.0E-4)) {
                this.indexMap.put(i, --optimizerIndex);
                continue;
            }
            this.indexMap.put(i, optimizerIndex);
            ++optimizerIndex;
            TDoubleArrayList waypoint = (TDoubleArrayList)this.waypointPositions.add();
            for (Axis3D axis : Axis3D.values) {
                waypoint.set(axis.ordinal(), this.waypointPosition.getElement(axis.ordinal()));
            }
            this.coefficients.add();
        }
        this.optimizer.setWaypoints(this.waypointPositions);
        this.segments.set(this.coefficients.size());
    }

    public void initialize() {
        if (this.initialPosition.containsNaN()) {
            throw new RuntimeException("Does not have valid enpoint conditions. Did you call setEndpointConditions?");
        }
        if (this.optimizeInOneTick.getBooleanValue()) {
            this.optimizer.compute(this.maxIterations.getIntegerValue());
            this.hasConverged.set(true);
        } else {
            this.hasConverged.set(false);
            this.optimizer.compute(0);
        }
        this.updateVariablesFromOptimizer();
    }

    private void updateVariablesFromOptimizer() {
        int i;
        for (i = 0; i < this.segments.getIntegerValue() - 1; ++i) {
            this.waypointTimes.get(i).set(this.optimizer.getWaypointTime(i));
        }
        this.waypointTimes.get(this.segments.getIntegerValue() - 1).set(1.0);
        for (i = this.segments.getIntegerValue(); i < this.waypointTimes.size(); ++i) {
            this.waypointTimes.get(i).set(Double.NaN);
        }
        for (int dimension = 0; dimension < Axis3D.values.length; ++dimension) {
            this.optimizer.getPolynomialCoefficients(this.coefficients, dimension);
            Axis3D axis = Axis3D.values[dimension];
            for (int i2 = 0; i2 < this.segments.getIntegerValue(); ++i2) {
                ((TDoubleArrayList)this.coefficients.get(i2)).toArray(this.tempCoeffs);
                this.trajectories.get(axis).get(i2).setDirectlyReverse(this.tempCoeffs);
            }
        }
        this.isDone.set(false);
        if (this.visualize) {
            this.visualize();
        } else {
            this.hide();
        }
    }

    public void setShouldVisualize(boolean shouldVisualize) {
        this.visualize = shouldVisualize;
    }

    private void visualize() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.showGraphic();
    }

    private void hide() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.hideGraphic();
    }

    public boolean doOptimizationUpdate() {
        if (!this.hasConverged.getBooleanValue()) {
            this.hasConverged.set(this.optimizer.doFullTimeUpdate());
            this.updateVariablesFromOptimizer();
        }
        return !this.hasConverged();
    }

    public void compute(double time) {
        double waypointTime;
        this.doOptimizationUpdate();
        this.isDone.set(time > 1.0);
        if (time < 0.0) {
            this.desiredPosition.set((FrameTuple3DReadOnly)this.initialPosition);
            this.desiredVelocity.setToZero();
            this.desiredAcceleration.setToZero();
            return;
        }
        if (time > 1.0) {
            this.desiredPosition.set((FrameTuple3DReadOnly)this.finalPosition);
            this.desiredVelocity.setToZero();
            this.desiredAcceleration.setToZero();
            return;
        }
        time = MathTools.clamp((double)time, (double)0.0, (double)1.0);
        int activeSegment = 0;
        for (int i = 0; i < this.segments.getIntegerValue() - 1 && time > (waypointTime = this.waypointTimes.get(i).getDoubleValue()); ++i) {
            activeSegment = i + 1;
        }
        this.activeSegment.set(activeSegment);
        for (int dimension = 0; dimension < Axis3D.values.length; ++dimension) {
            Axis3D axis = Axis3D.values[dimension];
            YoPolynomial polynomial = this.trajectories.get(axis).get(activeSegment);
            polynomial.compute(time);
            this.desiredPosition.setElement(dimension, polynomial.getValue());
            this.desiredVelocity.setElement(dimension, polynomial.getVelocity());
            this.desiredAcceleration.setElement(dimension, polynomial.getAcceleration());
        }
    }

    public double getWaypointTime(int waypointIndex) {
        return this.optimizer.getWaypointTime(this.indexMap.get(waypointIndex));
    }

    public void getWaypointVelocity(int waypointIndex, FrameVector3D waypointVelocityToPack) {
        this.optimizer.getWaypointVelocity(this.waypointVelocity, this.indexMap.get(waypointIndex));
        waypointVelocityToPack.setToZero(this.trajectoryFrame);
        for (int d = 0; d < Axis3D.values.length; ++d) {
            waypointVelocityToPack.setElement(d, this.waypointVelocity.get(d));
        }
    }

    public void getInitialPosition(FrameVector3DBasics initialPositionToPack) {
        this.optimizer.getStartPosition(this.waypointVelocity);
        initialPositionToPack.setReferenceFrame(this.trajectoryFrame);
        for (Axis3D axis : Axis3D.values) {
            initialPositionToPack.setElement(axis, this.waypointVelocity.get(axis.ordinal()));
        }
    }

    public void getInitialVelocity(FrameVector3DBasics initialVelocityToPack) {
        this.optimizer.getStartVelocity(this.waypointVelocity);
        initialVelocityToPack.setReferenceFrame(this.trajectoryFrame);
        for (Axis3D axis : Axis3D.values) {
            initialVelocityToPack.setElement(axis, this.waypointVelocity.get(axis.ordinal()));
        }
    }

    public void getFinalPosition(FrameVector3DBasics finalPositionToPack) {
        this.optimizer.getTargetPosition(this.waypointVelocity);
        finalPositionToPack.setReferenceFrame(this.trajectoryFrame);
        for (Axis3D axis : Axis3D.values) {
            finalPositionToPack.setElement(axis, this.waypointVelocity.get(axis.ordinal()));
        }
    }

    public void getFinalVelocity(FrameVector3DBasics finalVelocityToPack) {
        this.optimizer.getTargetVelocity(this.waypointVelocity);
        finalVelocityToPack.setReferenceFrame(this.trajectoryFrame);
        for (Axis3D axis : Axis3D.values) {
            finalVelocityToPack.setElement(axis, this.waypointVelocity.get(axis.ordinal()));
        }
    }

    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    public FramePoint3DReadOnly getPosition() {
        return this.desiredPosition;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.desiredVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.desiredAcceleration;
    }

    public void informDone() {
        this.desiredPosition.setToZero();
        this.desiredVelocity.setToZero();
        this.desiredAcceleration.setToZero();
    }

    public void showVisualization() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.showGraphic();
    }

    public void hideVisualization() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.hideGraphic();
    }

    public boolean hasConverged() {
        return this.hasConverged.getBooleanValue();
    }

    public void computeMaxSpeed() {
        this.computeMaxSpeed(1.0E-5);
    }

    public void computeMaxSpeed(double timeIncrement) {
        this.maxSpeed.set(Double.NEGATIVE_INFINITY);
        this.maxSpeedTime.set(Double.NaN);
        for (double time = 0.0; time <= 1.0; time += timeIncrement) {
            this.compute(time);
            this.tempVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.getVelocity());
            double speed = this.tempVelocity.length();
            if (!(speed > this.maxSpeed.getDoubleValue())) continue;
            this.maxSpeed.set(speed);
            this.maxSpeedTime.set(time);
        }
    }

    public double getMaxSpeed() {
        return this.maxSpeed.getDoubleValue();
    }

    public double getMaxSpeedTime() {
        return this.maxSpeedTime.getDoubleValue();
    }
}

