/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.robotics.math.filters.WeightedAverageYoBoolean;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class WeightedAverageTouchdownDetectors
implements TouchdownDetector {
    private final ArrayList<TouchdownDetector> touchdownDetectors = new ArrayList();
    private final WeightedAverageYoBoolean hasTouchedDown;
    private final String prefix;

    public WeightedAverageTouchdownDetectors(PairList<DoubleProvider, TouchdownDetector> touchdownDetectors, String prefix, YoRegistry registry) {
        this.prefix = prefix;
        this.hasTouchedDown = new WeightedAverageYoBoolean(prefix + "_HasTouchedDown", registry);
        for (int i = 0; i < touchdownDetectors.size(); ++i) {
            TouchdownDetector touchdownDetector = (TouchdownDetector)((ImmutablePair)touchdownDetectors.get(i)).getRight();
            YoBoolean oneHasTouchedDown = new YoBoolean(prefix + touchdownDetector.getName() + "_HasTouchedDown", registry);
            this.hasTouchedDown.addBooleanToAverage((DoubleProvider)((ImmutablePair)touchdownDetectors.get(i)).getLeft(), (BooleanProvider)oneHasTouchedDown);
            this.touchdownDetectors.add(touchdownDetector);
        }
    }

    @Override
    public boolean hasTouchedDown() {
        return this.hasTouchedDown.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        for (int i = 0; i < this.touchdownDetectors.size(); ++i) {
            if (!this.touchdownDetectors.get(i).hasForSureTouchedDown()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        for (int i = 0; i < this.touchdownDetectors.size(); ++i) {
            this.touchdownDetectors.get(i).update();
        }
        this.hasTouchedDown.update();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.touchdownDetectors.size(); ++i) {
            this.touchdownDetectors.get(i).reset();
        }
    }

    @Override
    public String getName() {
        return this.prefix + "WeightedAverageTouchdownDetector";
    }
}

