/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FootVelocityBasedTouchDownDetection
implements TouchdownDetector {
    private final String name = "VelTchdwnDetect";
    private final YoRegistry registry;
    private final MovingReferenceFrame soleFrame;
    private final YoBoolean isInContact;
    private final DoubleProvider speedThreshold;
    private final DoubleProvider zVelocityThreshold;
    private final YoDouble measuredSpeed;
    private final YoFrameVector3D footVelocity;

    public FootVelocityBasedTouchDownDetection(String suffix, MovingReferenceFrame soleFrame, RobotQuadrant robotQuadrant, DoubleProvider speedThreshold, DoubleProvider zVelocityThreshold, YoRegistry parentRegistry) {
        this.soleFrame = soleFrame;
        this.speedThreshold = speedThreshold;
        this.zVelocityThreshold = zVelocityThreshold;
        String prefix = robotQuadrant.getShortName() + "VelTchdwnDetect";
        this.registry = new YoRegistry(prefix);
        this.isInContact = new YoBoolean(prefix + "IsInContact" + suffix, this.registry);
        this.footVelocity = new YoFrameVector3D(prefix + "FootVelocity" + suffix, ReferenceFrame.getWorldFrame(), this.registry);
        this.measuredSpeed = new YoDouble(prefix + "MeasuredSpeed" + suffix, this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public boolean hasTouchedDown() {
        return this.isInContact.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        return false;
    }

    @Override
    public void update() {
        this.footVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.soleFrame.getTwistOfFrame().getLinearPart());
        this.measuredSpeed.set(this.footVelocity.length());
        boolean totalSpeedLowEnough = this.measuredSpeed.getDoubleValue() < this.speedThreshold.getValue();
        boolean zVelocitySlowEnough = Math.abs(this.footVelocity.getZ()) < this.zVelocityThreshold.getValue();
        this.isInContact.set(totalSpeedLowEnough && zVelocitySlowEnough);
    }

    @Override
    public void reset() {
        this.measuredSpeed.set(0.0);
        this.footVelocity.setToZero();
        this.isInContact.set(false);
    }

    @Override
    public String getName() {
        return "VelTchdwnDetect";
    }
}

