/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ActuatorForceBasedTouchdownDetector
implements TouchdownDetector {
    private final int GLITCH_FLITER_WINDOW_SIZE = 10;
    private final YoBoolean touchdownDetected;
    private final YoBoolean touchdownForSureDetected;
    private final GlitchFilteredYoBoolean touchdownDetectedFiltered;
    private final GlitchFilteredYoBoolean touchdownForSureDetectedFiltered;
    private final ForceSensorDataReadOnly foreSensorData;
    private final YoDouble touchdownForceThreshold;
    private final YoDouble definitelyTouchdownForceThreshold;
    private final Wrench wrenchToPack = new Wrench();
    private final Vector3D vectorToPack = new Vector3D();

    public ActuatorForceBasedTouchdownDetector(String name, ForceSensorDataReadOnly forceSensorData, double touchdownForceThreshold, double defintielyTouchdownForceThreshold, YoRegistry registry) {
        this.foreSensorData = forceSensorData;
        this.touchdownForceThreshold = new YoDouble(name + "_touchdownForceThreshold", registry);
        this.definitelyTouchdownForceThreshold = new YoDouble(name + "_definitelyTouchdownForceThreshold", registry);
        this.touchdownForceThreshold.set(touchdownForceThreshold);
        this.definitelyTouchdownForceThreshold.set(defintielyTouchdownForceThreshold);
        this.touchdownDetected = new YoBoolean(name + "_touchdownDetected", registry);
        this.touchdownForSureDetected = new YoBoolean(name + "_touchdownForSureDetected", registry);
        this.touchdownDetectedFiltered = new GlitchFilteredYoBoolean(this.touchdownDetected.getName() + "Filtered", registry, this.touchdownDetected, 10);
        this.touchdownForSureDetectedFiltered = new GlitchFilteredYoBoolean(this.touchdownForSureDetected.getName() + "Filtered", registry, this.touchdownForSureDetected, 10);
    }

    @Override
    public boolean hasTouchedDown() {
        return this.touchdownDetectedFiltered.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        return this.touchdownForSureDetectedFiltered.getBooleanValue();
    }

    @Override
    public void update() {
        this.foreSensorData.getWrench(this.wrenchToPack);
        this.vectorToPack.set((Tuple3DReadOnly)this.wrenchToPack.getLinearPart());
        this.touchdownDetected.set(this.vectorToPack.length() > this.touchdownForceThreshold.getDoubleValue());
        this.touchdownForSureDetected.set(this.vectorToPack.length() > this.definitelyTouchdownForceThreshold.getDoubleValue());
        this.touchdownDetectedFiltered.update();
        this.touchdownForSureDetectedFiltered.update();
    }

    @Override
    public void reset() {
        this.touchdownDetected.set(false);
        this.touchdownForSureDetected.set(false);
        this.touchdownDetectedFiltered.set(false);
        this.touchdownForSureDetectedFiltered.set(false);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

