/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticReachability;

public class StepReachabilityLatticePoint {
    private final int xIndex;
    private final int yIndex;
    private final int zIndex;
    private final int yawIndex;
    private final int hashCode;

    public StepReachabilityLatticePoint(double x, double y, double z, double yaw, double xyzSpacing, int yawDivisions, double yawSpacing) {
        this((int)Math.round(x / xyzSpacing), (int)Math.round(y / xyzSpacing), (int)Math.round(z / xyzSpacing), Math.floorMod((int)Math.round(yaw / yawSpacing), yawDivisions));
    }

    public StepReachabilityLatticePoint(int xIndex, int yIndex, int zIndex, int yawIndex) {
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.zIndex = zIndex;
        this.yawIndex = yawIndex;
        this.hashCode = StepReachabilityLatticePoint.computeHashCode(this);
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public int getYawIndex() {
        return this.yawIndex;
    }

    private static int computeHashCode(StepReachabilityLatticePoint cell) {
        int result = 1;
        int prime = 31;
        result += prime * cell.xIndex;
        result += prime * cell.yIndex;
        result += prime * cell.zIndex;
        return result += prime * cell.yawIndex;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepReachabilityLatticePoint other = (StepReachabilityLatticePoint)obj;
        if (this.xIndex != other.xIndex) {
            return false;
        }
        if (this.yIndex != other.yIndex) {
            return false;
        }
        if (this.zIndex != other.zIndex) {
            return false;
        }
        return this.yawIndex == other.yawIndex;
    }

    public String toString() {
        return "(" + this.xIndex + ", " + this.yIndex + ", " + this.zIndex + ", " + this.yawIndex + ")";
    }
}

