/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticEquilibrium;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;

public class StaticEquilibriumSolverInput {
    public static final int maxContactPoints = 50;
    private static final double defaultGravityMagnitude = 9.80665;
    private static final double defaultCoefficientOfFriction = 0.8;
    private final List<FramePoint3D> contactPointPositions = new ArrayList<FramePoint3D>();
    private final List<FrameVector3D> surfaceNormals = new ArrayList<FrameVector3D>();
    private double gravityMagnitude = 9.80665;
    private double coefficientOfFriction = 0.8;

    public void clear() {
        this.contactPointPositions.clear();
        this.surfaceNormals.clear();
        this.gravityMagnitude = 9.80665;
        this.coefficientOfFriction = 0.8;
    }

    public void addContactPoint(FramePoint3D contactPointPosition, FrameVector3D surfaceNormal) {
        this.contactPointPositions.add(contactPointPosition);
        this.surfaceNormals.add(surfaceNormal);
    }

    public void setGravityMagnitude(double gravityMagnitude) {
        this.gravityMagnitude = gravityMagnitude;
    }

    public int getNumberOfContacts() {
        return this.contactPointPositions.size();
    }

    public void setCoefficientOfFriction(double coefficientOfFriction) {
        this.coefficientOfFriction = coefficientOfFriction;
    }

    public List<FramePoint3D> getContactPointPositions() {
        return this.contactPointPositions;
    }

    public List<FrameVector3D> getSurfaceNormals() {
        return this.surfaceNormals;
    }

    public double getGravityMagnitude() {
        return this.gravityMagnitude;
    }

    public double getCoefficientOfFriction() {
        return this.coefficientOfFriction;
    }
}

