/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticEquilibrium;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StaticEquilibriumSolverInput;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

class StaticEquilibriumContactPoint {
    private static final double basisVectorScale = 0.1;
    private static final double forceVectorScale = 0.1;
    private final int contactPointIndex;
    private final YoFrameVector3D[] polyhedraFrameBasisVectors = new YoFrameVector3D[4];
    private final YoFramePose3D surfacePose;
    private final YoFrameVector3D force;
    private final PoseReferenceFrame contactPointFrame;
    private final YoDouble[] rhoValues = new YoDouble[4];

    public StaticEquilibriumContactPoint(int contactPointIndex, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.contactPointIndex = contactPointIndex;
        this.contactPointFrame = new PoseReferenceFrame("cpFrame" + contactPointIndex, ReferenceFrame.getWorldFrame());
        this.surfacePose = new YoFramePose3D("cpPose" + contactPointIndex, ReferenceFrame.getWorldFrame(), registry);
        this.force = new YoFrameVector3D("cpForce" + contactPointIndex, ReferenceFrame.getWorldFrame(), registry);
        for (int i = 0; i < this.polyhedraFrameBasisVectors.length; ++i) {
            this.polyhedraFrameBasisVectors[i] = new YoFrameVector3D("beta" + contactPointIndex + "_" + i, ReferenceFrame.getWorldFrame(), registry);
            YoGraphicVector basisVector = new YoGraphicVector("betaGraphic" + contactPointIndex + "_" + i, this.surfacePose.getPosition(), this.polyhedraFrameBasisVectors[i], 0.1);
            graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)basisVector);
        }
        YoGraphicVector forceVector = new YoGraphicVector("forceGraphic" + contactPointIndex, this.surfacePose.getPosition(), this.force, 0.1, YoAppearance.Red());
        graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)forceVector);
        for (int i = 0; i < this.rhoValues.length; ++i) {
            this.rhoValues[i] = new YoDouble("rho_cp" + contactPointIndex + "_" + i, registry);
        }
    }

    public void initialize(StaticEquilibriumSolverInput input) {
        FramePoint3D contactPointPosition = input.getContactPointPositions().get(this.contactPointIndex);
        FrameVector3D surfaceNormal = input.getSurfaceNormals().get(this.contactPointIndex);
        contactPointPosition.changeFrame(ReferenceFrame.getWorldFrame());
        surfaceNormal.changeFrame(ReferenceFrame.getWorldFrame());
        this.surfacePose.getPosition().set((FrameTuple3DReadOnly)contactPointPosition);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)surfaceNormal, (Orientation3DBasics)this.surfacePose.getOrientation());
        this.contactPointFrame.setPoseAndUpdate((FramePose3DReadOnly)this.surfacePose);
        double angleFromNormal = Math.atan(input.getCoefficientOfFriction());
        for (int i = 0; i < this.polyhedraFrameBasisVectors.length; ++i) {
            Vector3D basisVector = new Vector3D();
            basisVector.set((Tuple3DReadOnly)Axis3D.Z);
            double angleToRotateAroundInXY = (double)i * Math.PI / 2.0;
            AxisAngle basisVectorRotation = new AxisAngle(Math.cos(angleToRotateAroundInXY), Math.sin(angleToRotateAroundInXY), 0.0, angleFromNormal);
            basisVectorRotation.transform((Tuple3DBasics)basisVector);
            FrameVector3D frameBasisVector = new FrameVector3D((ReferenceFrame)this.contactPointFrame, (Tuple3DReadOnly)basisVector);
            frameBasisVector.changeFrame(ReferenceFrame.getWorldFrame());
            this.polyhedraFrameBasisVectors[i].set((FrameTuple3DReadOnly)frameBasisVector);
        }
    }

    public YoFrameVector3D getBasisVector(int index) {
        return this.polyhedraFrameBasisVectors[index];
    }

    public void clear() {
        this.surfacePose.setToNaN();
        for (int i = 0; i < this.polyhedraFrameBasisVectors.length; ++i) {
            this.polyhedraFrameBasisVectors[i].setToNaN();
        }
    }

    public void setResolvedForce(DMatrixRMaj solution) {
        this.force.setToZero();
        for (int i = 0; i < 4; ++i) {
            Vector3D scaledBasisVector = new Vector3D((Tuple3DReadOnly)this.polyhedraFrameBasisVectors[i]);
            double rho = solution.get(4 * this.contactPointIndex + i);
            scaledBasisVector.scale(rho);
            this.force.add((Tuple3DReadOnly)scaledBasisVector);
            this.rhoValues[i].set(rho);
            if (!Double.isNaN(rho)) continue;
            this.force.setToNaN();
            return;
        }
    }
}

