/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors.footSwitch;

import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class SettableFootSwitch
implements FootSwitchInterface {
    YoBoolean hasFootHitGround;
    private final ContactablePlaneBody foot;
    private final double totalRobotWeight;
    private final YoFramePoint2D yoResolvedCoP;
    private final int totalNumberOfFeet;

    public SettableFootSwitch(ContactablePlaneBody foot, double totalRobotWeight, int totalNumberOfFeet, YoRegistry registry) {
        this.totalNumberOfFeet = totalNumberOfFeet;
        this.hasFootHitGround = new YoBoolean(foot.getName() + "_SettableFootSwitch", registry);
        this.totalRobotWeight = totalRobotWeight;
        this.foot = foot;
        this.hasFootHitGround.set(false);
        this.yoResolvedCoP = new YoFramePoint2D(foot.getName() + "ResolvedCoP", "", foot.getSoleFrame(), registry);
    }

    public boolean hasFootHitGround() {
        return this.hasFootHitGround.getBooleanValue();
    }

    public double computeFootLoadPercentage() {
        return Double.NaN;
    }

    public void computeAndPackCoP(FramePoint2D copToPack) {
        copToPack.setToNaN(this.getMeasurementFrame());
    }

    public void updateCoP() {
        this.yoResolvedCoP.setToZero();
    }

    public void computeAndPackFootWrench(Wrench footWrenchToPack) {
        footWrenchToPack.setToZero();
        if (this.hasFootHitGround()) {
            footWrenchToPack.setLinearPartZ(this.totalRobotWeight / (double)this.totalNumberOfFeet);
        }
    }

    public ReferenceFrame getMeasurementFrame() {
        return this.foot.getSoleFrame();
    }

    public void reset() {
        this.hasFootHitGround.set(false);
    }

    public boolean getForceMagnitudePastThreshhold() {
        return false;
    }

    public void setFootContactState(boolean hasFootHitGround) {
        this.hasFootHitGround.set(hasFootHitGround);
    }

    public void trustFootSwitchInSwing(boolean trustFootSwitch) {
    }

    public void trustFootSwitchInSupport(boolean trustFootSwitch) {
    }
}

