/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class StepConstraintPolygonTools {
    public static boolean isPointInsidePolygon(Vertex2DSupplier polygon, Point2DReadOnly queryPoint) {
        if (polygon.getNumberOfVertices() < 3) {
            return false;
        }
        int intersections = 0;
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = polygon.getVertex(i);
            Point2DReadOnly nextVertex = polygon.getVertex((i + 1) % polygon.getNumberOfVertices());
            double lineDirectionX = 1.0;
            double lineDirectionY = 0.0;
            boolean intersects = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((double)queryPoint.getX(), (double)queryPoint.getY(), (double)lineDirectionX, (double)lineDirectionY, (double)vertex.getX(), (double)vertex.getY(), (double)nextVertex.getX(), (double)nextVertex.getY(), null);
            if (!intersects) continue;
            ++intersections;
        }
        boolean oddNumberOfIntersections = intersections % 2 == 1;
        return oddNumberOfIntersections;
    }

    public static boolean arePolygonsIntersecting(ConvexPolygon2DReadOnly polygonA, ConvexPolygon2DReadOnly polygonB) {
        for (int i = 0; i < polygonA.getNumberOfVertices(); ++i) {
            Point2DReadOnly vA1 = polygonA.getVertex(i);
            Point2DReadOnly vA2 = polygonA.getNextVertex(i);
            if (polygonB.isPointInside(vA1)) {
                return true;
            }
            for (int j = 0; j < polygonB.getNumberOfVertices(); ++j) {
                double vB2y;
                double vB2x;
                double vB1y;
                double vB1x;
                double vA2y;
                double vA2x;
                double vA1y;
                Point2DReadOnly vB1 = polygonB.getVertex(j);
                Point2DReadOnly vB2 = polygonB.getNextVertex(j);
                if (polygonA.isPointInside(vB1)) {
                    return true;
                }
                double vA1x = vA1.getX();
                boolean intersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((double)vA1x, (double)(vA1y = vA1.getY()), (double)(vA2x = vA2.getX()), (double)(vA2y = vA2.getY()), (double)(vB1x = vB1.getX()), (double)(vB1y = vB1.getY()), (double)(vB2x = vB2.getX()), (double)(vB2y = vB2.getY()), null);
                if (!intersection) continue;
                return true;
            }
        }
        return false;
    }

    public static double distanceBetweenPolygons(ConvexPolygon2D polygonA, ConvexPolygon2D polygonB) {
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < polygonA.getNumberOfVertices(); ++i) {
            for (int j = 0; j < polygonB.getNumberOfVertices(); ++j) {
                double vA1x = polygonA.getVertex(i).getX();
                double vA1y = polygonA.getVertex(i).getY();
                double vA2x = polygonA.getNextVertex(i).getX();
                double vA2y = polygonA.getNextVertex(i).getY();
                double vB1x = polygonB.getVertex(j).getX();
                double vB1y = polygonB.getVertex(j).getY();
                double vB2x = polygonB.getNextVertex(j).getX();
                double vB2y = polygonB.getNextVertex(j).getY();
                double distance = EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((double)vA1x, (double)vA1y, (double)vA2x, (double)vA2y, (double)vB1x, (double)vB1y, (double)vB2x, (double)vB2y, null, null);
                minDistance = Math.min(minDistance, distance);
            }
        }
        return minDistance;
    }
}

