/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import java.util.List;
import us.ihmc.commonWalkingControlModules.polygonWiggling.StepConstraintPolygonTools;
import us.ihmc.commonWalkingControlModules.polygonWiggling.WiggleParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.robotics.EuclidCoreMissingTools;

public class FootPlacementConstraintCalculator {
    private final Point2D closestPerimeterPoint = new Point2D();
    private final Vector2D directionToClosestPoint = new Vector2D();

    void calculateFootAreaGradient(List<? extends Point2DReadOnly> polygonToWiggle, List<? extends Vector2DReadOnly> rotationVectors, Vertex2DSupplier concavePolygonToWiggleInto, WiggleParameters wiggleParameters, Tuple3DBasics gradientToPack) {
        gradientToPack.setToZero();
        for (int i = 0; i < polygonToWiggle.size(); ++i) {
            boolean pointDoesNotMeetConstraints;
            Point2DReadOnly vertex = polygonToWiggle.get(i);
            boolean pointIsInside = StepConstraintPolygonTools.isPointInsidePolygon(concavePolygonToWiggleInto, vertex);
            double distanceSquaredFromPerimeter = FootPlacementConstraintCalculator.distanceSquaredFromPerimeter(concavePolygonToWiggleInto, vertex, this.closestPerimeterPoint);
            double signedDistanceSquared = pointIsInside ? -distanceSquaredFromPerimeter : distanceSquaredFromPerimeter;
            double deltaOutside = -wiggleParameters.deltaInside;
            double signedDeltaOutsideSquared = Math.signum(deltaOutside) * MathTools.square((double)deltaOutside);
            boolean bl = pointDoesNotMeetConstraints = signedDistanceSquared > signedDeltaOutsideSquared;
            if (!pointDoesNotMeetConstraints) continue;
            this.directionToClosestPoint.sub((Tuple2DReadOnly)this.closestPerimeterPoint, (Tuple2DReadOnly)vertex);
            if (signedDistanceSquared < 0.0) {
                this.directionToClosestPoint.scale(-1.0);
            }
            double distanceSquaredFromConstraint = signedDistanceSquared - signedDeltaOutsideSquared;
            this.directionToClosestPoint.scale(Math.sqrt(distanceSquaredFromConstraint / this.directionToClosestPoint.lengthSquared()));
            gradientToPack.addX(this.directionToClosestPoint.getX());
            gradientToPack.addY(this.directionToClosestPoint.getY());
            gradientToPack.addZ(this.directionToClosestPoint.dot(rotationVectors.get(i)) / wiggleParameters.rotationWeight);
        }
    }

    public static double distanceSquaredFromPerimeter(Vertex2DSupplier polygon, Point2DReadOnly queryPoint, Point2D closestPointToPack) {
        double minimumDistanceSquared = Double.MAX_VALUE;
        Point2D tempPoint = new Point2D();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = polygon.getVertex(i);
            Point2DReadOnly nextVertex = polygon.getVertex((i + 1) % polygon.getNumberOfVertices());
            double distanceSquared = EuclidCoreMissingTools.distanceSquaredFromPoint2DToLineSegment2D((double)queryPoint.getX(), (double)queryPoint.getY(), (double)vertex.getX(), (double)vertex.getY(), (double)nextVertex.getX(), (double)nextVertex.getY(), (Point2D)tempPoint);
            if (!(distanceSquared < minimumDistanceSquared)) continue;
            minimumDistanceSquared = distanceSquared;
            if (closestPointToPack == null) continue;
            closestPointToPack.set(tempPoint);
        }
        return minimumDistanceSquared;
    }
}

