/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.orientationControl;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.tools.MPCAngleTools;
import us.ihmc.commonWalkingControlModules.orientationControl.AlgebraicVariationalFunction;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalCommonValues;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;

public class VariationalLQRController {
    private static final double defaultQR = 1100.0;
    private static final double defaultQw = 5.0;
    private static final double defaultR = 1.25;
    private final MPCAngleTools angleTools = new MPCAngleTools();
    private final VariationalCommonValues commonValues = new VariationalCommonValues();
    private final Vector3DBasics axisAngleError = new Vector3D();
    private final DMatrixRMaj wBd = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj desiredRotationMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj wB = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj RBerrorVector = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj wBerror = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj state = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj desiredTorque = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj feedbackTorque = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj deltaTau = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj inertia = new DMatrixRMaj(3, 3);
    private final AlgebraicVariationalFunction variationalFunction = new AlgebraicVariationalFunction();
    private final QuaternionBasics desiredRotation = new Quaternion();
    private final RotationMatrix tempRotation = new RotationMatrix();

    public VariationalLQRController() {
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.inertia);
        this.commonValues.setInertia(this.inertia);
        this.commonValues.computeCostMatrices(1100.0, 5.0, 1.25);
    }

    public void setInertia(SpatialInertiaReadOnly inertia) {
        inertia.getMomentOfInertia().get((DMatrix)this.inertia);
        this.commonValues.setInertia(this.inertia);
    }

    public void setDesired(QuaternionReadOnly desiredRotation, Vector3DReadOnly desiredAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentum) {
        this.desiredRotation.set(desiredRotation);
        desiredRotation.get((CommonMatrix3DBasics)this.tempRotation);
        this.tempRotation.get((DMatrix)this.desiredRotationMatrix);
        desiredAngularVelocityInBodyFrame.get((DMatrix)this.wBd);
        desiredNetAngularMomentum.get((DMatrix)this.desiredTorque);
        this.variationalFunction.setDesired(desiredRotation, desiredAngularVelocityInBodyFrame, desiredNetAngularMomentum, this.commonValues);
    }

    public void compute(QuaternionReadOnly currentRotation, Vector3DReadOnly currentAngularVelocityInBodyFrame) {
        currentAngularVelocityInBodyFrame.get((DMatrix)this.wB);
        this.angleTools.computeRotationError((Orientation3DReadOnly)this.desiredRotation, (Orientation3DReadOnly)currentRotation, this.axisAngleError);
        this.axisAngleError.get((DMatrix)this.RBerrorVector);
        CommonOps_DDRM.subtract((DMatrixD1)this.wB, (DMatrixD1)this.wBd, (DMatrixD1)this.wBerror);
        MatrixTools.setMatrixBlock((DMatrix)this.state, (int)0, (int)0, (DMatrix)this.RBerrorVector, (int)0, (int)0, (int)3, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.state, (int)3, (int)0, (DMatrix)this.wBerror, (int)0, (int)0, (int)3, (int)1, (double)1.0);
        CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.variationalFunction.getK(), (DMatrix1Row)this.state, (DMatrix1Row)this.deltaTau);
        CommonOps_DDRM.add((DMatrixD1)this.deltaTau, (DMatrixD1)this.desiredTorque, (DMatrixD1)this.feedbackTorque);
    }

    public void getDesiredTorque(Vector3DBasics tau) {
        tau.set((DMatrix)this.feedbackTorque);
    }
}

