/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.orientationControl;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.MatrixMissingTools;

public class VariationalDynamicsCalculator {
    private final DMatrixRMaj A21 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj A22 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj B2 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj identity = CommonOps_DDRM.identity((int)3);
    private final DMatrixRMaj A = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj B = new DMatrixRMaj(6, 3);
    private final DMatrixRMaj desiredTorque = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj skewDesiredTorque = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj RBd = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj desiredAngularVelocity = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj skewAngularVelocity = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj angularMomentum = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj skewAngularMomentum = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj coriolis = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj temp = new DMatrixRMaj(3, 3);
    private final RotationMatrix rotationMatrix = new RotationMatrix();

    public void compute(QuaternionReadOnly desiredRotation, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentum, DMatrixRMaj inertia, DMatrixRMaj inertiaInverse) {
        desiredRotation.get((CommonMatrix3DBasics)this.rotationMatrix);
        this.rotationMatrix.get((DMatrix)this.RBd);
        desiredBodyAngularVelocityInBodyFrame.get((DMatrix)this.desiredAngularVelocity);
        desiredNetAngularMomentum.get((DMatrix)this.desiredTorque);
        CommonOps_DDRM.multTransB((DMatrix1Row)inertiaInverse, (DMatrix1Row)this.RBd, (DMatrix1Row)this.B2);
        MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)desiredBodyAngularVelocityInBodyFrame, (DMatrixRMaj)this.skewAngularVelocity);
        MatrixMissingTools.toSkewSymmetricMatrix((DMatrix1Row)this.desiredTorque, (DMatrixRMaj)this.skewDesiredTorque);
        CommonOps_DDRM.mult((DMatrix1Row)this.B2, (DMatrix1Row)this.skewDesiredTorque, (DMatrix1Row)this.A21);
        CommonOps_DDRM.mult((DMatrix1Row)inertia, (DMatrix1Row)this.desiredAngularVelocity, (DMatrix1Row)this.angularMomentum);
        MatrixMissingTools.toSkewSymmetricMatrix((DMatrix1Row)this.angularMomentum, (DMatrixRMaj)this.skewAngularMomentum);
        CommonOps_DDRM.mult((DMatrix1Row)this.skewAngularVelocity, (DMatrix1Row)inertia, (DMatrix1Row)this.coriolis);
        CommonOps_DDRM.subtract((DMatrixD1)this.skewAngularMomentum, (DMatrixD1)this.coriolis, (DMatrixD1)this.temp);
        CommonOps_DDRM.mult((DMatrix1Row)inertiaInverse, (DMatrix1Row)this.temp, (DMatrix1Row)this.A22);
        this.assembleAMatrix();
        this.assembleBMatrix();
    }

    private void assembleAMatrix() {
        MatrixMissingTools.setMatrixBlock((DMatrix1Row)this.A, (int)0, (int)0, (DMatrix)this.skewAngularVelocity, (int)0, (int)0, (int)3, (int)3, (double)-1.0);
        MatrixMissingTools.setMatrixBlock((DMatrix1Row)this.A, (int)0, (int)3, (DMatrix)this.identity, (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixMissingTools.setMatrixBlock((DMatrix1Row)this.A, (int)3, (int)0, (DMatrix)this.A21, (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixMissingTools.setMatrixBlock((DMatrix1Row)this.A, (int)3, (int)3, (DMatrix)this.A22, (int)0, (int)0, (int)3, (int)3, (double)1.0);
    }

    private void assembleBMatrix() {
        MatrixMissingTools.setMatrixBlock((DMatrix1Row)this.B, (int)3, (int)0, (DMatrix)this.B2, (int)0, (int)0, (int)3, (int)3, (double)1.0);
    }

    public DMatrixRMaj getA() {
        return this.A;
    }

    public DMatrixRMaj getB() {
        return this.B;
    }
}

