/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.orientationControl;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalCommonValues;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalDynamicsCalculator;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalFunction;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.DefectCorrectionCARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.SignFunctionCARESolver;

public class AlgebraicVariationalFunction
implements VariationalFunction {
    private final DMatrixRMaj P = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj BTransposeP = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj K = new DMatrixRMaj(3, 6);
    private final VariationalDynamicsCalculator dynamicsCalculator = new VariationalDynamicsCalculator();
    private final CARESolver careSolver = new DefectCorrectionCARESolver((CARESolver)new SignFunctionCARESolver());

    public void setDesired(QuaternionReadOnly desiredRotation, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentum, VariationalCommonValues commonValues) {
        this.setDesired(desiredRotation, desiredBodyAngularVelocityInBodyFrame, desiredNetAngularMomentum, commonValues.getQ(), commonValues.getR(), commonValues.getRInverse(), commonValues.getInertia(), commonValues.getInertiaInverse());
    }

    public void setDesired(QuaternionReadOnly desiredRotation, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentum, DMatrixRMaj Q, DMatrixRMaj R, DMatrixRMaj RInverse, DMatrixRMaj inertia, DMatrixRMaj inertiaInverse) {
        this.dynamicsCalculator.compute(desiredRotation, desiredBodyAngularVelocityInBodyFrame, desiredNetAngularMomentum, inertia, inertiaInverse);
        this.careSolver.setMatrices(this.dynamicsCalculator.getA(), this.dynamicsCalculator.getB(), null, Q, R);
        this.P.set((DMatrixD1)this.careSolver.getP());
        CommonOps_DDRM.multTransA((DMatrix1Row)this.dynamicsCalculator.getB(), (DMatrix1Row)this.P, (DMatrix1Row)this.BTransposeP);
        CommonOps_DDRM.mult((DMatrix1Row)RInverse, (DMatrix1Row)this.BTransposeP, (DMatrix1Row)this.K);
    }

    public DMatrixRMaj getP() {
        return this.P;
    }

    public DMatrixRMaj getB() {
        return this.dynamicsCalculator.getB();
    }

    public DMatrixRMaj getK() {
        return this.K;
    }

    @Override
    public void compute(double timeInState, DMatrixRMaj PToPack, DMatrixRMaj KToPack) {
        PToPack.set((DMatrixD1)this.P);
        KToPack.set((DMatrixD1)this.K);
    }
}

