/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumControlCore;

import us.ihmc.commonWalkingControlModules.controlModules.YoSE3OffsetFrame;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.momentumControlCore.HeightController;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.controllers.PDController;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class PelvisHeightController
implements HeightController<PointFeedbackControlCommand> {
    private final MovingReferenceFrame pelvisFrame;
    private final ReferenceFrame baseFrame;
    private final YoDouble currentPelvisHeightInWorld;
    private final YoDouble desiredPelvisHeightInWorld;
    private final YoDouble desiredPelvisVelocityInWorld;
    private final YoDouble currentPelvisVelocityInWorld;
    private final YoDouble feedbackPelvisAcceleration;
    private final YoDouble feedForwardPelvisAcceleration;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final PDController linearMomentumZPDController;
    private final YoSE3OffsetFrame yoControlFrame;
    private final FramePoint3D controlPosition = new FramePoint3D();
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredLinearVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardLinearAcceleration = new FrameVector3D();
    private final FrameVector3D currentLinearVelocity = new FrameVector3D();
    private final Twist twist = new Twist();

    public PelvisHeightController(MovingReferenceFrame pelvisFrame, ReferenceFrame baseFrame, YoRegistry parentRegistry) {
        this.pelvisFrame = pelvisFrame;
        this.baseFrame = baseFrame;
        this.yoControlFrame = new YoSE3OffsetFrame("pelvisHeightBodyFixedControlFrame", (ReferenceFrame)pelvisFrame, this.registry);
        this.linearMomentumZPDController = new PDController("pelvisHeightControlState_linearMomentumZPDController", this.registry);
        this.currentPelvisHeightInWorld = new YoDouble("currentPelvisHeightInWorld", this.registry);
        this.desiredPelvisHeightInWorld = new YoDouble("desiredPelvisHeightInWorld", this.registry);
        this.desiredPelvisVelocityInWorld = new YoDouble("desiredPelvisVelocityInWorld", this.registry);
        this.currentPelvisVelocityInWorld = new YoDouble("currentPelvisVelocityInWorld", this.registry);
        this.feedbackPelvisAcceleration = new YoDouble("feedbackPelvisAcceleration", this.registry);
        this.feedForwardPelvisAcceleration = new YoDouble("feedForwardPelvisAcceleration", this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void compute(PointFeedbackControlCommand feedbackCommand) {
        this.controlPosition.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getBodyFixedPointToControl());
        this.controlPosition.changeFrame((ReferenceFrame)this.pelvisFrame);
        this.yoControlFrame.setOffsetToParentToTranslationOnly((FrameTuple3DReadOnly)this.controlPosition);
        this.yoControlFrame.getTwistRelativeToOther(this.baseFrame, (TwistBasics)this.twist);
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.twist.getLinearPart());
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getReferenceLinearAcceleration());
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getReferencePosition());
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getReferenceLinearVelocity());
        this.controlPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.currentLinearVelocity.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedForwardLinearAcceleration.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredLinearVelocity.changeFrame(ReferenceFrame.getWorldFrame());
        this.currentPelvisHeightInWorld.set(this.controlPosition.getZ());
        this.desiredPelvisHeightInWorld.set(this.desiredPosition.getZ());
        this.currentPelvisVelocityInWorld.set(this.currentLinearVelocity.getZ());
        this.desiredPelvisVelocityInWorld.set(this.desiredLinearVelocity.getZ());
        this.linearMomentumZPDController.setProportionalGain(feedbackCommand.getGains().getProportionalGains()[2]);
        this.linearMomentumZPDController.setDerivativeGain(feedbackCommand.getGains().getDerivativeGains()[2]);
        this.linearMomentumZPDController.setPositionDeadband(0.0);
        this.feedForwardPelvisAcceleration.set(this.feedForwardLinearAcceleration.getZ());
        this.feedbackPelvisAcceleration.set(this.linearMomentumZPDController.compute(this.currentPelvisHeightInWorld.getValue(), this.desiredPelvisHeightInWorld.getValue(), this.currentPelvisVelocityInWorld.getValue(), this.desiredPelvisVelocityInWorld.getValue()));
        this.feedbackPelvisAcceleration.add(this.feedForwardLinearAcceleration.getZ());
    }

    @Override
    public double getHeightAcceleration() {
        return this.feedbackPelvisAcceleration.getDoubleValue();
    }
}

