/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce;

import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce.GroundContactForceQPSolver;
import us.ihmc.commonWalkingControlModules.visualizer.BasisVectorVisualizer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchMatrixCalculator;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.frames.YoMatrix;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class GroundContactForceOptimizationControlModule {
    private static final boolean DEBUG = true;
    private static final boolean VISUALIZE_RHO_BASIS_VECTORS = false;
    private static final boolean SETUP_RHO_TASKS = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final WrenchMatrixCalculator wrenchMatrixCalculator;
    private final List<? extends ContactablePlaneBody> contactablePlaneBodies;
    private final YoDouble rhoMin = new YoDouble("rhoMinGCFOptimization", this.registry);
    private final BasisVectorVisualizer basisVectorVisualizer;
    private final GroundContactForceQPSolver qpSolver;
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("hasNotConvergedInPast", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("hasNotConvergedCounts", this.registry);
    private final YoFrameVector3D desiredLinearMomentumRate;
    private final YoFrameVector3D desiredAngularMomentumRate;
    private final MomentumRateCommand momentumRateCommand = new MomentumRateCommand();
    private final YoMatrix yoMomentumSelectionMatrix = new YoMatrix("VMCMomentumSelectionMatrix", 6, 6, this.registry);
    private final YoMatrix yoMomentumObjective = new YoMatrix("VMCMomentumObjectiveMatrix", 6, 1, this.registry);
    private final YoMatrix yoMomentumWeight = new YoMatrix("VMCMomentumWeightMatrix", 6, 6, this.registry);
    private final DMatrixRMaj momentumSelectionMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj momentumObjective = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj momentumJacobian = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj momentumWeight = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj zeroObjective = new DMatrixRMaj(0, 0);
    private Map<RigidBodyBasics, Wrench> solutionWrenches;
    private final DMatrixRMaj tempTaskWeight = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj tempTaskWeightSubspace = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj fullMomentumObjective = new DMatrixRMaj(6, 1);

    public GroundContactForceOptimizationControlModule(WrenchMatrixCalculator wrenchMatrixCalculator, List<? extends ContactablePlaneBody> contactablePlaneBodies, ControllerCoreOptimizationSettings optimizationSettings, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.wrenchMatrixCalculator = wrenchMatrixCalculator;
        this.contactablePlaneBodies = contactablePlaneBodies;
        int rhoSize = optimizationSettings.getRhoSize();
        this.basisVectorVisualizer = null;
        this.desiredLinearMomentumRate = new YoFrameVector3D("desiredLinearMomentumRateToQP", null, this.registry);
        this.desiredAngularMomentumRate = new YoFrameVector3D("desiredAngularMomentumRateToQP", null, this.registry);
        this.rhoMin.set(optimizationSettings.getRhoMin());
        ActiveSetQPSolverWithInactiveVariablesInterface activeSetQPSolver = optimizationSettings.getActiveSetQPSolver();
        this.qpSolver = new GroundContactForceQPSolver((ActiveSetQPSolver)activeSetQPSolver, rhoSize, this.registry);
        this.qpSolver.setMinRho(optimizationSettings.getRhoMin());
        this.zeroObjective.reshape(wrenchMatrixCalculator.getCopTaskSize(), 1);
        this.zeroObjective.zero();
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        this.qpSolver.reset();
    }

    public void compute(Map<RigidBodyBasics, Wrench> groundReactionWrenchesToPack) throws NoConvergenceException {
        this.qpSolver.setRhoRegularizationWeight(this.wrenchMatrixCalculator.getRhoWeightMatrix());
        this.qpSolver.addRegularization();
        this.setupRhoTasks();
        this.qpSolver.setMinRho(this.rhoMin.getDoubleValue());
        this.qpSolver.addMotionTask(this.momentumJacobian, this.momentumObjective, this.momentumWeight);
        NoConvergenceException noConvergenceException = null;
        try {
            this.qpSolver.solve();
        }
        catch (NoConvergenceException e) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                e.printStackTrace();
                LogTools.warn((String)("Only showing the stack trace of the first " + ((Object)((Object)e)).getClass().getSimpleName() + ". This may be happening more than once."));
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
            noConvergenceException = e;
        }
        DMatrixRMaj rhoSolution = this.qpSolver.getRhos();
        if (noConvergenceException != null) {
            throw noConvergenceException;
        }
        this.solutionWrenches = this.wrenchMatrixCalculator.computeWrenchesFromRho(rhoSolution);
        for (int i = 0; i < this.contactablePlaneBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.contactablePlaneBodies.get(i).getRigidBody();
            Wrench solutionWrench = this.solutionWrenches.get(rigidBody);
            if (groundReactionWrenchesToPack.containsKey(rigidBody)) {
                groundReactionWrenchesToPack.get(rigidBody).setIncludingFrame((WrenchReadOnly)solutionWrench);
                continue;
            }
            groundReactionWrenchesToPack.put(rigidBody, solutionWrench);
        }
    }

    private void setupRhoTasks() {
        DMatrixRMaj rhoPrevious = this.wrenchMatrixCalculator.getRhoPreviousMatrix();
        DMatrixRMaj rhoRateWeight = this.wrenchMatrixCalculator.getRhoRateWeightMatrix();
        this.qpSolver.addRhoTask(rhoPrevious, rhoRateWeight);
        DMatrixRMaj copRegularizationWeight = this.wrenchMatrixCalculator.getCoPRegularizationWeight();
        DMatrixRMaj copRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRegularizationJacobian();
        this.qpSolver.addRhoTask(copRegularizationJacobian, this.zeroObjective, copRegularizationWeight);
        DMatrixRMaj copRateRegularizationWeight = this.wrenchMatrixCalculator.getCoPRateRegularizationWeight();
        DMatrixRMaj copRateRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRateRegularizationJacobian();
        this.qpSolver.addRhoTask(copRateRegularizationJacobian, this.zeroObjective, copRateRegularizationWeight);
    }

    public void submitMomentumRateCommand(MomentumRateCommand command) {
        this.momentumRateCommand.set(command);
        this.momentumRateCommand.setWeights(command.getWeightMatrix());
    }

    public void submitPlaneContactStateCommand(PlaneContactStateCommand command) {
        this.wrenchMatrixCalculator.submitPlaneContactStateCommand(command);
    }

    public void submitMomentumSelectionMatrix(DMatrixRMaj momentumSelectionMatrix) {
        this.momentumSelectionMatrix.set((DMatrixD1)momentumSelectionMatrix);
        this.yoMomentumSelectionMatrix.set(momentumSelectionMatrix);
    }

    public void processMomentumRateCommand(DMatrixRMaj additionalWrench) {
        this.wrenchMatrixCalculator.computeMatrices();
        int taskSize = this.momentumSelectionMatrix.getNumRows();
        this.momentumObjective.reshape(taskSize, 1);
        this.momentumWeight.reshape(taskSize, taskSize);
        if (taskSize == 0) {
            return;
        }
        this.tempTaskWeight.reshape(6, 6);
        this.tempTaskWeightSubspace.reshape(taskSize, 6);
        this.momentumRateCommand.getWeightMatrix(this.tempTaskWeight);
        CommonOps_DDRM.mult((DMatrix1Row)this.momentumSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.momentumSelectionMatrix, (DMatrix1Row)this.momentumWeight);
        this.yoMomentumWeight.set(this.momentumWeight);
        DMatrixRMaj rhoJacobian = this.wrenchMatrixCalculator.getRhoJacobianMatrix();
        this.momentumJacobian.reshape(taskSize, rhoJacobian.numCols);
        CommonOps_DDRM.mult((DMatrix1Row)this.momentumSelectionMatrix, (DMatrix1Row)rhoJacobian, (DMatrix1Row)this.momentumJacobian);
        DMatrixRMaj momentumRate = this.momentumRateCommand.getMomentumRate();
        CommonOps_DDRM.subtract((DMatrixD1)momentumRate, (DMatrixD1)additionalWrench, (DMatrixD1)this.fullMomentumObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.momentumSelectionMatrix, (DMatrix1Row)this.fullMomentumObjective, (DMatrix1Row)this.momentumObjective);
        this.yoMomentumObjective.set(this.momentumObjective);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.momentumSelectionMatrix, (DMatrix1Row)this.momentumObjective, (DMatrix1Row)this.fullMomentumObjective);
        this.desiredLinearMomentumRate.set(this.fullMomentumObjective.get(3), this.fullMomentumObjective.get(4), this.fullMomentumObjective.get(5));
        this.desiredAngularMomentumRate.set(this.fullMomentumObjective.get(0), this.fullMomentumObjective.get(1), this.fullMomentumObjective.get(2));
    }

    public DMatrixRMaj getMomentumObjective() {
        return this.fullMomentumObjective;
    }
}

