/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.QuadProgSolver;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class FlatGroundContactForceOptimizer {
    private static final int maxContactPointsForViz = 30;
    private static final AppearanceDefinition transparentBlue = new YoAppearanceRGBColor(Color.BLUE, 0.8);
    private static final AppearanceDefinition transparentRed = new YoAppearanceRGBColor(Color.RED, 0.8);
    private YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble friction = new YoDouble("Friction", this.registry);
    private final YoInteger vectorsPerContact = new YoInteger("VectorsPerContact", this.registry);
    private final YoDouble regWeight = new YoDouble("RegWeight", this.registry);
    private final List<List<FrameVector3D>> forceVectors = new ArrayList<List<FrameVector3D>>();
    private final List<List<YoFrameVector3D>> yoGRFVectors = new ArrayList<List<YoFrameVector3D>>();
    private final List<YoFramePoint3D> yoContactPoints = new ArrayList<YoFramePoint3D>();
    private final YoFramePoint3D yoCenterOfMass;
    private final YoFrameVector3D yoForce;
    private final YoFrameVector3D yoAchievedForce;
    private final YoFrameVector3D yoTorque;
    private final YoFrameVector3D yoAchievedTorque;
    private final QuadProgSolver solver = new QuadProgSolver();
    private final DMatrixRMaj x = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Q = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj f = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Aeq = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj beq = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Ain = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj bin = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj objective = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj J = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj W = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj temp1 = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj temp2 = new DMatrixRMaj(1, 1);
    private final Vector3D offset = new Vector3D();
    private final Vector3D unitTorque = new Vector3D();
    private final Vector3D unitForce = new Vector3D();
    private final FrameVector3D contactForce = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final FrameVector3D resultForce = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final FrameVector3D resultTorque = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final Vector3D forceVector = new Vector3D();
    private final Vector3D torqueVector = new Vector3D();

    public FlatGroundContactForceOptimizer(double friction, int vectorsPerContact, double regWeight, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        this.friction.set(friction);
        this.vectorsPerContact.set(vectorsPerContact);
        this.regWeight.set(regWeight);
        if (graphicsListRegistry == null) {
            graphicsListRegistry = new YoGraphicsListRegistry();
        }
        for (int n = 0; n < 30; ++n) {
            YoFramePoint3D yoContactPoint = new YoFramePoint3D("ContactPointPosition" + n, ReferenceFrame.getWorldFrame(), this.registry);
            this.yoContactPoints.add(yoContactPoint);
            ArrayList<FrameVector3D> forceVectors = new ArrayList<FrameVector3D>();
            ArrayList<YoFrameVector3D> yoForceVectors = new ArrayList<YoFrameVector3D>();
            ArrayList<YoFrameVector3D> yoGRFVectors = new ArrayList<YoFrameVector3D>();
            for (int i = 0; i < vectorsPerContact; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)vectorsPerContact;
                double x = Math.sin(angle) * friction;
                double y = Math.cos(angle) * friction;
                FrameVector3D vector = new FrameVector3D(ReferenceFrame.getWorldFrame(), x, y, 1.0);
                vector.normalize();
                forceVectors.add(vector);
                YoFrameVector3D yoVector = new YoFrameVector3D("ForceVector" + i + "Contact" + n, ReferenceFrame.getWorldFrame(), this.registry);
                YoFrameVector3D yoGRFVector = new YoFrameVector3D("GRFVector" + i + "Contact" + n, ReferenceFrame.getWorldFrame(), this.registry);
                yoForceVectors.add(yoVector);
                yoGRFVectors.add(yoGRFVector);
                yoVector.set((FrameTuple3DReadOnly)vector);
                YoGraphicVector vectorViz = new YoGraphicVector("Force Vector " + i + " Contact " + n, yoContactPoint, yoVector, 0.2, YoAppearance.Aquamarine());
                graphicsListRegistry.registerYoGraphic("Friction Cone", (YoGraphic)vectorViz);
                YoGraphicVector grfViz = new YoGraphicVector("GRF Vector " + i + " Contact " + n, yoContactPoint, yoGRFVector, 1.0, transparentBlue);
                graphicsListRegistry.registerYoGraphic("GRF", (YoGraphic)grfViz);
            }
            this.yoGRFVectors.add(yoGRFVectors);
            this.forceVectors.add(forceVectors);
        }
        this.yoCenterOfMass = new YoFramePoint3D("CenterOfMass", ReferenceFrame.getWorldFrame(), this.registry);
        YoGraphicPosition comViz = new YoGraphicPosition("Center of Mass", this.yoCenterOfMass, 0.03, YoAppearance.Black());
        graphicsListRegistry.registerYoGraphic("Center of Mass", (YoGraphic)comViz);
        this.yoForce = new YoFrameVector3D("force", ReferenceFrame.getWorldFrame(), this.registry);
        YoGraphicVector forceViz = new YoGraphicVector("Desired Linear Momentum Rate", this.yoCenterOfMass, this.yoForce, 1.0, YoAppearance.Blue());
        graphicsListRegistry.registerYoGraphic("Desired Linear Momentum Rate", (YoGraphic)forceViz);
        this.yoAchievedForce = new YoFrameVector3D("achievedForce", ReferenceFrame.getWorldFrame(), this.registry);
        YoGraphicVector achievedForceViz = new YoGraphicVector("Achieved Linear Momentum Rate", this.yoCenterOfMass, this.yoAchievedForce, 1.0, transparentBlue);
        graphicsListRegistry.registerYoGraphic("Achieved Linear Momentum Rate", (YoGraphic)achievedForceViz);
        this.yoTorque = new YoFrameVector3D("torque", ReferenceFrame.getWorldFrame(), this.registry);
        YoGraphicVector torqueViz = new YoGraphicVector("Desired Angular Momentum Rate", this.yoCenterOfMass, this.yoTorque, 1.0, YoAppearance.Red());
        graphicsListRegistry.registerYoGraphic("Desired Angular Momentum Rate", (YoGraphic)torqueViz);
        this.yoAchievedTorque = new YoFrameVector3D("achievedTorque", ReferenceFrame.getWorldFrame(), this.registry);
        YoGraphicVector achievedTorqueViz = new YoGraphicVector("Achieved Angular Momentum Rate", this.yoCenterOfMass, this.yoAchievedTorque, 1.0, transparentRed);
        graphicsListRegistry.registerYoGraphic("Achieved Angular Momentum Rate", (YoGraphic)achievedTorqueViz);
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
        this.hide();
    }

    public List<Wrench> compute(List<List<FramePoint3D>> contactPlanes, List<ReferenceFrame> contactFrames, FramePoint3D centerOfMass, FrameVector3D force, FrameVector3D torque, WeightMatrix6D weights) {
        ArrayList<FramePoint3D> contactPoints = new ArrayList<FramePoint3D>();
        ArrayList<FrameVector3D> contactForces = new ArrayList<FrameVector3D>();
        contactPlanes.stream().forEachOrdered(points -> contactPoints.addAll((Collection<FramePoint3D>)points));
        if (!this.compute(contactPoints, centerOfMass, force, torque, weights, contactForces)) {
            return null;
        }
        ArrayList<Wrench> wrenches = new ArrayList<Wrench>();
        int indexOffset = 0;
        for (int planeIdx = 0; planeIdx < contactPlanes.size(); ++planeIdx) {
            this.resultForce.setToZero();
            this.resultTorque.setToZero();
            ReferenceFrame planeFrame = contactFrames.get(planeIdx);
            FramePoint3D planeCenter = new FramePoint3D(planeFrame);
            planeCenter.changeFrame(ReferenceFrame.getWorldFrame());
            int contactPointsInPlane = contactPlanes.get(planeIdx).size();
            for (int pointIdx = 0; pointIdx < contactPointsInPlane; ++pointIdx) {
                int index = pointIdx + indexOffset;
                FrameVector3D contactForce = (FrameVector3D)contactForces.get(index);
                this.offset.sub((Tuple3DReadOnly)planeCenter, (Tuple3DReadOnly)contactPoints.get(index));
                this.torqueVector.cross((Tuple3DReadOnly)this.forceVector, (Tuple3DReadOnly)this.offset);
                this.resultForce.add((FrameTuple3DReadOnly)contactForce);
                this.resultTorque.add((Tuple3DReadOnly)this.torqueVector);
            }
            indexOffset += contactPointsInPlane;
            Wrench wrench = new Wrench(planeFrame, ReferenceFrame.getWorldFrame(), (Vector3DReadOnly)this.resultTorque, (Vector3DReadOnly)this.resultForce);
            wrenches.add(wrench);
        }
        return wrenches;
    }

    public boolean compute(List<FramePoint3D> contactPoints, FramePoint3D centerOfMass, FrameVector3D force, FrameVector3D torque, WeightMatrix6D weights) {
        return this.compute(contactPoints, centerOfMass, force, torque, weights, null);
    }

    public boolean compute(List<FramePoint3D> contactPoints, FramePoint3D centerOfMass, FrameVector3D force, FrameVector3D torque, WeightMatrix6D weights, List<FrameVector3D> contactForcesToPack) {
        int vectorIdx;
        int contactIdx;
        for (int contactIdx2 = 0; contactIdx2 < contactPoints.size(); ++contactIdx2) {
            this.yoContactPoints.get(contactIdx2).set((FrameTuple3DReadOnly)contactPoints.get(contactIdx2));
        }
        this.yoCenterOfMass.set((FrameTuple3DReadOnly)centerOfMass);
        this.yoForce.set((FrameTuple3DReadOnly)force);
        this.yoTorque.set((FrameTuple3DReadOnly)torque);
        int vectorsPerPoint = this.vectorsPerContact.getIntegerValue();
        int size = vectorsPerPoint * contactPoints.size();
        this.x.reshape(size, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.x, (double)0.0);
        this.Ain.reshape(size, size);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Ain);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.Ain);
        this.bin.reshape(size, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.bin, (double)0.0);
        this.Aeq.reshape(0, size);
        this.beq.reshape(0, size);
        this.Q.reshape(size, size);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Q);
        CommonOps_DDRM.scale((double)this.regWeight.getDoubleValue(), (DMatrixD1)this.Q);
        weights.getFullWeightMatrixInFrame(ReferenceFrame.getWorldFrame(), this.W);
        this.J.reshape(6, size);
        for (contactIdx = 0; contactIdx < contactPoints.size(); ++contactIdx) {
            this.offset.sub((Tuple3DReadOnly)centerOfMass, (Tuple3DReadOnly)contactPoints.get(contactIdx));
            for (vectorIdx = 0; vectorIdx < vectorsPerPoint; ++vectorIdx) {
                this.unitForce.set((Tuple3DReadOnly)this.forceVectors.get(contactIdx).get(vectorIdx));
                this.unitTorque.cross((Tuple3DReadOnly)this.unitForce, (Tuple3DReadOnly)this.offset);
                this.J.set(0, contactIdx * vectorsPerPoint + vectorIdx, this.unitTorque.getX());
                this.J.set(1, contactIdx * vectorsPerPoint + vectorIdx, this.unitTorque.getY());
                this.J.set(2, contactIdx * vectorsPerPoint + vectorIdx, this.unitTorque.getZ());
                this.J.set(3, contactIdx * vectorsPerPoint + vectorIdx, this.unitForce.getX());
                this.J.set(4, contactIdx * vectorsPerPoint + vectorIdx, this.unitForce.getY());
                this.J.set(5, contactIdx * vectorsPerPoint + vectorIdx, this.unitForce.getZ());
            }
        }
        this.objective.reshape(6, 1);
        this.objective.set(0, torque.getX());
        this.objective.set(1, torque.getY());
        this.objective.set(2, torque.getZ());
        this.objective.set(3, force.getX());
        this.objective.set(4, force.getY());
        this.objective.set(5, force.getZ());
        this.temp1.reshape(size, 6);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.J, (DMatrix1Row)this.W, (DMatrix1Row)this.temp1);
        this.temp2.reshape(size, size);
        CommonOps_DDRM.mult((DMatrix1Row)this.temp1, (DMatrix1Row)this.J, (DMatrix1Row)this.temp2);
        CommonOps_DDRM.add((DMatrixD1)this.Q, (DMatrixD1)this.temp2, (DMatrixD1)this.Q);
        this.f.reshape(size, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.f, (double)0.0);
        CommonOps_DDRM.mult((DMatrix1Row)this.temp1, (DMatrix1Row)this.objective, (DMatrix1Row)this.f);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.f);
        try {
            this.solver.solve(this.Q, this.f, this.Aeq, this.beq, this.Ain, this.bin, this.x, false);
        }
        catch (NoConvergenceException e) {
            this.hide();
            return false;
        }
        this.resultForce.setToZero();
        this.resultTorque.setToZero();
        if (contactForcesToPack != null) {
            contactForcesToPack.clear();
        }
        for (contactIdx = 0; contactIdx < contactPoints.size(); ++contactIdx) {
            this.contactForce.setToZero();
            for (vectorIdx = 0; vectorIdx < vectorsPerPoint; ++vectorIdx) {
                this.forceVector.set((Tuple3DReadOnly)this.forceVectors.get(contactIdx).get(vectorIdx));
                this.forceVector.scale(this.x.get(contactIdx * vectorsPerPoint + vectorIdx));
                this.yoGRFVectors.get(contactIdx).get(vectorIdx).set((Tuple3DReadOnly)this.forceVector);
                this.offset.sub((Tuple3DReadOnly)centerOfMass, (Tuple3DReadOnly)contactPoints.get(contactIdx));
                this.torqueVector.cross((Tuple3DReadOnly)this.forceVector, (Tuple3DReadOnly)this.offset);
                this.contactForce.add((Tuple3DReadOnly)this.forceVector);
                this.resultForce.add((Tuple3DReadOnly)this.forceVector);
                this.resultTorque.add((Tuple3DReadOnly)this.torqueVector);
            }
            if (contactForcesToPack == null) continue;
            contactForcesToPack.add(new FrameVector3D((FrameTuple3DReadOnly)this.contactForce));
        }
        this.yoAchievedForce.set((FrameTuple3DReadOnly)this.resultForce);
        this.yoAchievedTorque.set((FrameTuple3DReadOnly)this.resultTorque);
        return true;
    }

    public void getAchievedMomentumRate(FrameVector3D angularMomentumRateToPack, FrameVector3D linearMomentumRateToPack) {
        angularMomentumRateToPack.set((FrameTuple3DReadOnly)this.yoAchievedTorque);
        linearMomentumRateToPack.set((FrameTuple3DReadOnly)this.yoAchievedForce);
    }

    private void hide() {
        this.yoContactPoints.stream().forEach(point -> point.setToNaN());
    }
}

