/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.matrixlib.NativeMatrix;

public class NativeQPInputTypeA {
    private static final int initialTaskSize = 6;
    private int numberOfVariables;
    public final NativeMatrix taskJacobian = new NativeMatrix(0, 0);
    public final NativeMatrix taskObjective = new NativeMatrix(0, 0);
    public final NativeMatrix taskWeightMatrix = new NativeMatrix(0, 0);
    private boolean useWeightScalar = false;
    private double taskWeightScalar;
    private ConstraintType constraintType = ConstraintType.OBJECTIVE;

    public NativeQPInputTypeA(int numberOfVariables) {
        this.numberOfVariables = numberOfVariables;
        this.reshape(6);
    }

    public void setNumberOfVariables(int numberOfVariables) {
        this.numberOfVariables = numberOfVariables;
    }

    public void reshape(int taskSize) {
        this.taskJacobian.reshape(taskSize, this.numberOfVariables);
        this.taskObjective.reshape(taskSize, 1);
        this.taskWeightMatrix.reshape(taskSize, taskSize);
    }

    public void setTaskJacobian(DMatrix taskJacobian) {
        this.taskJacobian.set((Matrix)taskJacobian);
    }

    public NativeMatrix getTaskJacobian() {
        return this.taskJacobian;
    }

    public void setTaskObjective(DMatrix taskObjective) {
        this.taskObjective.set((Matrix)taskObjective);
    }

    public NativeMatrix getTaskObjective() {
        return this.taskObjective;
    }

    public void setTaskWeightMatrix(DMatrix taskWeightMatrix) {
        this.taskWeightMatrix.set((Matrix)taskWeightMatrix);
    }

    public NativeMatrix getTaskWeightMatrix() {
        return this.taskWeightMatrix;
    }

    public void setUseWeightScalar(boolean useWeightScalar) {
        this.useWeightScalar = useWeightScalar;
    }

    public void setWeight(double weight) {
        this.taskWeightScalar = weight;
    }

    public double getWeightScalar() {
        return this.taskWeightScalar;
    }

    public double getTaskWeightScalar() {
        return this.taskWeightScalar;
    }

    public boolean useWeightScalar() {
        return this.useWeightScalar;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName();
        ret = ret + "Jacobian:\n" + this.taskJacobian;
        ret = ret + "Objective:\n" + this.taskObjective;
        ret = this.constraintType != ConstraintType.OBJECTIVE ? ret + this.constraintType.toString() : (this.useWeightScalar ? ret + "Weight: " + this.taskWeightScalar : ret + "Weight:\n" + this.taskWeightMatrix);
        return ret;
    }
}

