/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import java.util.List;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.LinearMomentumRateCostCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.inverseKinematics.JointPrivilegedConfigurationHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeB;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPVariableSubstitution;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.matrixlib.NativeNullspaceProjector;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.algorithms.CentroidalMomentumRateCalculator;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.MomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class MotionQPInputCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble nullspaceProjectionAlpha;
    private final YoDouble secondaryTaskJointsWeight = new YoDouble("secondaryTaskJointsWeight", this.registry);
    private final PoseReferenceFrame controlFrame = new PoseReferenceFrame("controlFrame", worldFrame);
    private final GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
    private final OneDoFJointBasics[] oneDoFJoints;
    private final CentroidalMomentumCalculator centroidalMomentumCalculator;
    private final CentroidalMomentumRateCalculator centroidalMomentumRateCalculator;
    private final JointPrivilegedConfigurationHandler privilegedConfigurationHandler;
    private final DMatrixRMaj tempPrimaryTaskJacobian = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj tempTaskJacobian = new DMatrixRMaj(6, 12);
    private final NativeMatrix tempTaskJacobianNative = new NativeMatrix(6, 12);
    private final NativeMatrix tempTaskVelocityJacobianNative = new NativeMatrix(6, 12);
    private final NativeMatrix projectedTaskJacobian = new NativeMatrix(6, 12);
    private final DMatrixRMaj tempTaskObjective = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempTaskWeight = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj tempTaskWeightSubspace = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj lineConstraintSelection = new DMatrixRMaj(1, 2);
    private final DMatrixRMaj lineConstraintJacobian = new DMatrixRMaj(1, 12);
    private final DMatrixRMaj tempSelectionMatrix = new DMatrixRMaj(6, 6);
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final FrameVector3D linearMomentum = new FrameVector3D();
    private final ReferenceFrame centerOfMassFrame;
    private final JointIndexHandler jointIndexHandler;
    private final DMatrixRMaj allTaskJacobian;
    private final NativeMatrix allTaskJacobianNative;
    private final int numberOfDoFs;
    private final NativeNullspaceProjector accelerationNativeNullspaceProjector;
    private final NativeNullspaceProjector velocityNativeNullspaceProjector;
    private final SpatialForce momentumRate = new SpatialForce();
    private final Momentum momentum = new Momentum();

    public MotionQPInputCalculator(ReferenceFrame centerOfMassFrame, CentroidalMomentumRateCalculator centroidalMomentumRateCalculator, JointIndexHandler jointIndexHandler, JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters, YoRegistry parentRegistry) {
        this(centerOfMassFrame, null, centroidalMomentumRateCalculator, jointIndexHandler, jointPrivilegedConfigurationParameters, parentRegistry);
    }

    public MotionQPInputCalculator(ReferenceFrame centerOfMassFrame, CentroidalMomentumCalculator centroidalMomentumCalculator, JointIndexHandler jointIndexHandler, JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters, YoRegistry parentRegistry) {
        this(centerOfMassFrame, centroidalMomentumCalculator, null, jointIndexHandler, jointPrivilegedConfigurationParameters, parentRegistry);
    }

    private MotionQPInputCalculator(ReferenceFrame centerOfMassFrame, CentroidalMomentumCalculator centroidalMomentumCalculator, CentroidalMomentumRateCalculator centroidalMomentumRateCalculator, JointIndexHandler jointIndexHandler, JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters, YoRegistry parentRegistry) {
        this.centerOfMassFrame = centerOfMassFrame;
        this.jointIndexHandler = jointIndexHandler;
        this.centroidalMomentumCalculator = centroidalMomentumCalculator;
        this.centroidalMomentumRateCalculator = centroidalMomentumRateCalculator;
        this.oneDoFJoints = jointIndexHandler.getIndexedOneDoFJoints();
        this.numberOfDoFs = jointIndexHandler.getNumberOfDoFs();
        if (jointPrivilegedConfigurationParameters != null) {
            this.privilegedConfigurationHandler = new JointPrivilegedConfigurationHandler(this.oneDoFJoints, jointPrivilegedConfigurationParameters, this.registry);
            this.nullspaceProjectionAlpha = new YoDouble("nullspaceProjectionAlpha", this.registry);
            this.nullspaceProjectionAlpha.set(jointPrivilegedConfigurationParameters.getNullspaceProjectionAlpha());
        } else {
            this.privilegedConfigurationHandler = null;
            this.nullspaceProjectionAlpha = null;
        }
        this.allTaskJacobian = new DMatrixRMaj(this.numberOfDoFs, this.numberOfDoFs);
        this.allTaskJacobianNative = new NativeMatrix(this.numberOfDoFs, this.numberOfDoFs);
        this.secondaryTaskJointsWeight.set(1.0);
        this.accelerationNativeNullspaceProjector = new NativeNullspaceProjector(this.numberOfDoFs);
        this.velocityNativeNullspaceProjector = new NativeNullspaceProjector(this.numberOfDoFs);
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        if (this.centroidalMomentumRateCalculator != null) {
            this.centroidalMomentumRateCalculator.reset();
        } else {
            this.centroidalMomentumCalculator.reset();
        }
        this.allTaskJacobian.reshape(0, this.numberOfDoFs);
    }

    public void updatePrivilegedConfiguration(PrivilegedConfigurationCommand command) {
        if (this.privilegedConfigurationHandler == null) {
            throw new NullPointerException("JointPrivilegedConfigurationParameters have to be set to enable this feature.");
        }
        this.privilegedConfigurationHandler.submitPrivilegedConfigurationCommand(command);
    }

    public void submitPrivilegedAccelerations(PrivilegedJointSpaceCommand command) {
        if (this.privilegedConfigurationHandler == null) {
            throw new NullPointerException("JointPrivilegedConfigurationParameters have to be set to enable this feature.");
        }
        this.privilegedConfigurationHandler.submitPrivilegedAccelerations(command);
    }

    public void submitPrivilegedVelocities(PrivilegedJointSpaceCommand command) {
        if (this.privilegedConfigurationHandler == null) {
            throw new NullPointerException("JointPrivilegedConfigurationParameters have to be set to enable this feature.");
        }
        this.privilegedConfigurationHandler.submitPrivilegedVelocities(command);
    }

    public boolean computePrivilegedJointAccelerations(QPInputTypeA qpInputToPack) {
        if (this.privilegedConfigurationHandler == null || !this.privilegedConfigurationHandler.isEnabled()) {
            return false;
        }
        this.privilegedConfigurationHandler.computePrivilegedJointAccelerations();
        qpInputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        qpInputToPack.setUseWeightScalar(false);
        int taskSize = 0;
        DMatrixRMaj selectionMatrix = this.privilegedConfigurationHandler.getSelectionMatrix();
        int robotTaskSize = selectionMatrix.getNumRows();
        if (robotTaskSize > 0) {
            OneDoFJointBasics[] joints = this.privilegedConfigurationHandler.getJoints();
            this.tempTaskJacobianNative.reshape(robotTaskSize, this.numberOfDoFs);
            boolean success = this.jointIndexHandler.compactBlockToFullBlock((JointReadOnly[])joints, selectionMatrix, this.tempTaskJacobianNative);
            if (success) {
                qpInputToPack.reshape(robotTaskSize);
                this.allTaskJacobianNative.set(this.allTaskJacobian);
                this.accelerationNativeNullspaceProjector.project(this.tempTaskJacobianNative, this.allTaskJacobianNative, this.projectedTaskJacobian, this.nullspaceProjectionAlpha.getValue());
                this.projectedTaskJacobian.extract(qpInputToPack.taskJacobian, taskSize, 0);
                CommonOps_DDRM.insert((DMatrix)this.privilegedConfigurationHandler.getPrivilegedJointAccelerations(), (DMatrix)qpInputToPack.taskObjective, (int)taskSize, (int)0);
                CommonOps_DDRM.insert((DMatrix)this.privilegedConfigurationHandler.getWeights(), (DMatrix)qpInputToPack.taskWeightMatrix, (int)taskSize, (int)taskSize);
            }
        }
        return robotTaskSize > 0;
    }

    public boolean computePrivilegedJointVelocities(QPInputTypeA qpInputToPack) {
        if (this.privilegedConfigurationHandler == null || !this.privilegedConfigurationHandler.isEnabled()) {
            return false;
        }
        this.privilegedConfigurationHandler.computePrivilegedJointVelocities();
        qpInputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        qpInputToPack.setUseWeightScalar(false);
        DMatrixRMaj selectionMatrix = this.privilegedConfigurationHandler.getSelectionMatrix();
        int taskSize = selectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setTaskObjective(this.privilegedConfigurationHandler.getPrivilegedJointVelocities());
        qpInputToPack.setTaskWeightMatrix(this.privilegedConfigurationHandler.getWeights());
        OneDoFJointBasics[] joints = this.privilegedConfigurationHandler.getJoints();
        boolean success = this.jointIndexHandler.compactBlockToFullBlock((JointReadOnly[])joints, selectionMatrix, qpInputToPack.taskJacobian);
        if (!success) {
            return false;
        }
        this.tempTaskVelocityJacobianNative.set(qpInputToPack.taskJacobian);
        this.allTaskJacobianNative.set(this.allTaskJacobian);
        this.velocityNativeNullspaceProjector.project(this.tempTaskVelocityJacobianNative, this.allTaskJacobianNative, this.projectedTaskJacobian, this.nullspaceProjectionAlpha.getValue());
        this.projectedTaskJacobian.get(qpInputToPack.taskJacobian);
        return true;
    }

    public void convertKinematicLoopFunction(KinematicLoopFunction function, QPVariableSubstitution qpVariableSubstitutionToPack) {
        int i;
        DMatrixRMaj loopJacobian = function.getLoopJacobian();
        DMatrixRMaj loopConvectiveTerm = function.getLoopConvectiveTerm();
        List loopJoints = function.getLoopJoints();
        int[] actuatedJointIndices = function.getActuatedJointIndices();
        if (loopJacobian.getNumRows() != loopConvectiveTerm.getNumRows()) {
            throw new IllegalArgumentException("Inconsistent dimensions: number of rows in Jacobian: " + loopJacobian.getNumRows() + ", number of joints: " + loopJoints.size());
        }
        if (loopJacobian.getNumRows() != loopConvectiveTerm.getNumRows()) {
            throw new MatrixDimensionException("Inconsistent dimensions: loopJacobian.numRows=" + loopJacobian.getNumRows() + ", loopConvectiveTerm.numRows=" + loopConvectiveTerm.getNumRows());
        }
        if (actuatedJointIndices.length != loopJacobian.getNumCols()) {
            throw new IllegalArgumentException("Inconsistent dimensions: number of actuated joints: " + actuatedJointIndices.length + ", number of columns in Jacobian: " + loopJacobian.getNumCols());
        }
        qpVariableSubstitutionToPack.reshape(loopJoints.size(), loopJacobian.getNumRows());
        qpVariableSubstitutionToPack.transformation.set((DMatrixD1)loopJacobian);
        qpVariableSubstitutionToPack.bias.set((DMatrixD1)loopConvectiveTerm);
        for (i = 0; i < loopJoints.size(); ++i) {
            qpVariableSubstitutionToPack.variableIndices[i] = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)loopJoints.get(i));
        }
        for (i = 0; i < actuatedJointIndices.length; ++i) {
            qpVariableSubstitutionToPack.activeIndices.add(actuatedJointIndices[i]);
        }
    }

    public boolean convertSpatialAccelerationCommand(SpatialAccelerationCommand commandToConvert, QPInputTypeA qpInputToPack) {
        commandToConvert.getControlFrame(this.controlFrame);
        commandToConvert.getSelectionMatrix((ReferenceFrame)this.controlFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setConstraintType(commandToConvert.isHardConstraint() ? ConstraintType.EQUALITY : ConstraintType.OBJECTIVE);
        if (!commandToConvert.isHardConstraint()) {
            qpInputToPack.setUseWeightScalar(false);
            this.tempTaskWeight.reshape(6, 6);
            this.tempTaskWeightSubspace.reshape(taskSize, 6);
            commandToConvert.getWeightMatrix((ReferenceFrame)this.controlFrame, this.tempTaskWeight);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
            CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.taskWeightMatrix);
        }
        RigidBodyBasics base = commandToConvert.getBase();
        RigidBodyBasics endEffector = commandToConvert.getEndEffector();
        this.jacobianCalculator.clear();
        this.jacobianCalculator.setKinematicChain((RigidBodyReadOnly)base, (RigidBodyReadOnly)endEffector);
        this.jacobianCalculator.setJacobianFrame((ReferenceFrame)this.controlFrame);
        this.jacobianCalculator.reset();
        commandToConvert.getDesiredSpatialAcceleration(this.tempTaskObjective);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempTaskObjective, (DMatrixD1)this.jacobianCalculator.getConvectiveTermMatrix());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)qpInputToPack.taskObjective);
        this.tempTaskJacobian.reshape(taskSize, this.jacobianCalculator.getNumberOfDegreesOfFreedom());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.jacobianCalculator.getJacobianMatrix(), (DMatrix1Row)this.tempTaskJacobian);
        RigidBodyBasics primaryBase = commandToConvert.getPrimaryBase();
        List jointsUsedInTask = this.jacobianCalculator.getJointsFromBaseToEndEffector();
        this.jointIndexHandler.compactBlockToFullBlockIgnoreUnindexedJoints(jointsUsedInTask, this.tempTaskJacobian, qpInputToPack.taskJacobian);
        if (primaryBase == null) {
            this.recordTaskJacobian(qpInputToPack.taskJacobian);
        } else {
            this.tempPrimaryTaskJacobian.set((DMatrixD1)qpInputToPack.taskJacobian);
            boolean isJointUpstreamOfPrimaryBase = false;
            for (int i = jointsUsedInTask.size() - 1; i >= 0; --i) {
                int[] jointIndices;
                JointReadOnly joint = (JointReadOnly)jointsUsedInTask.get(i);
                if (joint.getSuccessor() == primaryBase) {
                    isJointUpstreamOfPrimaryBase = true;
                }
                if (!isJointUpstreamOfPrimaryBase) continue;
                for (int dofIndex : jointIndices = this.jointIndexHandler.getJointIndices(joint)) {
                    double scaleFactor = this.secondaryTaskJointsWeight.getDoubleValue();
                    if (commandToConvert.scaleSecondaryTaskJointWeight()) {
                        scaleFactor = commandToConvert.getSecondaryTaskJointWeightScale();
                    }
                    MatrixTools.scaleColumn((double)scaleFactor, (int)dofIndex, (DMatrix1Row)qpInputToPack.taskJacobian);
                    MatrixTools.zeroColumn((int)dofIndex, (DMatrix1Row)this.tempPrimaryTaskJacobian);
                }
            }
            this.recordTaskJacobian(this.tempPrimaryTaskJacobian);
        }
        return true;
    }

    public boolean convertSpatialVelocityCommand(SpatialVelocityCommand commandToConvert, QPInputTypeA qpInputToPack) {
        commandToConvert.getControlFrame(this.controlFrame);
        commandToConvert.getSelectionMatrix((ReferenceFrame)this.controlFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        ConstraintType constraintType = commandToConvert.getConstraintType();
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setConstraintType(constraintType);
        if (constraintType == ConstraintType.OBJECTIVE) {
            qpInputToPack.setUseWeightScalar(false);
            this.tempTaskWeight.reshape(6, 6);
            this.tempTaskWeightSubspace.reshape(taskSize, 6);
            commandToConvert.getWeightMatrix((ReferenceFrame)this.controlFrame, this.tempTaskWeight);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
            CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.taskWeightMatrix);
        }
        RigidBodyBasics base = commandToConvert.getBase();
        RigidBodyBasics endEffector = commandToConvert.getEndEffector();
        this.jacobianCalculator.clear();
        this.jacobianCalculator.setKinematicChain((RigidBodyReadOnly)base, (RigidBodyReadOnly)endEffector);
        this.jacobianCalculator.setJacobianFrame((ReferenceFrame)this.controlFrame);
        this.jacobianCalculator.reset();
        commandToConvert.getDesiredSpatialVelocity(this.tempTaskObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)qpInputToPack.taskObjective);
        this.tempTaskJacobian.reshape(taskSize, this.jacobianCalculator.getNumberOfDegreesOfFreedom());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.jacobianCalculator.getJacobianMatrix(), (DMatrix1Row)this.tempTaskJacobian);
        RigidBodyBasics primaryBase = commandToConvert.getPrimaryBase();
        List jointsUsedInTask = this.jacobianCalculator.getJointsFromBaseToEndEffector();
        this.jointIndexHandler.compactBlockToFullBlockIgnoreUnindexedJoints(jointsUsedInTask, this.tempTaskJacobian, qpInputToPack.taskJacobian);
        if (constraintType == ConstraintType.OBJECTIVE) {
            if (primaryBase == null) {
                this.recordTaskJacobian(qpInputToPack.taskJacobian);
            } else {
                this.tempPrimaryTaskJacobian.set((DMatrixD1)qpInputToPack.taskJacobian);
                boolean isJointUpstreamOfPrimaryBase = false;
                for (int i = jointsUsedInTask.size() - 1; i >= 0; --i) {
                    int[] jointIndices;
                    JointReadOnly joint = (JointReadOnly)jointsUsedInTask.get(i);
                    if (joint.getSuccessor() == primaryBase) {
                        isJointUpstreamOfPrimaryBase = true;
                    }
                    if (!isJointUpstreamOfPrimaryBase) continue;
                    for (int dofIndex : jointIndices = this.jointIndexHandler.getJointIndices(joint)) {
                        double scaleFactor = this.secondaryTaskJointsWeight.getDoubleValue();
                        if (commandToConvert.scaleSecondaryTaskJointWeight()) {
                            scaleFactor = commandToConvert.getSecondaryTaskJointWeightScale();
                        }
                        MatrixTools.scaleColumn((double)scaleFactor, (int)dofIndex, (DMatrix1Row)qpInputToPack.taskJacobian);
                        MatrixTools.zeroColumn((int)dofIndex, (DMatrix1Row)this.tempPrimaryTaskJacobian);
                    }
                }
                this.recordTaskJacobian(this.tempPrimaryTaskJacobian);
            }
        }
        return true;
    }

    public boolean convertMomentumRateCommand(MomentumRateCommand commandToConvert, QPInputTypeA qpInputToPack) {
        commandToConvert.getSelectionMatrix(this.centerOfMassFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setUseWeightScalar(false);
        qpInputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        this.tempTaskWeight.reshape(6, 6);
        this.tempTaskWeightSubspace.reshape(taskSize, 6);
        commandToConvert.getWeightMatrix(this.tempTaskWeight);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.taskWeightMatrix);
        DMatrixRMaj centroidalMomentumMatrix = this.getCentroidalMomentumMatrix();
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)centroidalMomentumMatrix, (DMatrix1Row)qpInputToPack.taskJacobian);
        commandToConvert.getMomentumRate(this.angularMomentum, this.linearMomentum);
        this.angularMomentum.changeFrame(this.centerOfMassFrame);
        this.linearMomentum.changeFrame(this.centerOfMassFrame);
        this.angularMomentum.get(0, (DMatrix)this.tempTaskObjective);
        this.linearMomentum.get(3, (DMatrix)this.tempTaskObjective);
        DMatrixRMaj convectiveTerm = this.centroidalMomentumRateCalculator.getBiasSpatialForceMatrix();
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempTaskObjective, (DMatrixD1)convectiveTerm);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)qpInputToPack.taskObjective);
        this.recordTaskJacobian(qpInputToPack.taskJacobian);
        return true;
    }

    public boolean convertLinearMomentumRateCostCommand(LinearMomentumRateCostCommand commandToConvert, QPInputTypeB qpInputToPack) {
        this.tempSelectionMatrix.zero();
        commandToConvert.getSelectionMatrix(this.centerOfMassFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setUseWeightScalar(false);
        this.tempTaskWeight.reshape(6, 6);
        this.tempTaskWeightSubspace.reshape(taskSize, 3);
        commandToConvert.getWeightMatrix(this.tempTaskWeight);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.taskWeightMatrix);
        this.tempTaskWeight.set((DMatrixD1)commandToConvert.getMomentumRateHessian());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.directCostHessian);
        DMatrixRMaj centroidalMomentumMatrix = this.getCentroidalMomentumMatrix();
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)centroidalMomentumMatrix, (DMatrix1Row)qpInputToPack.taskJacobian);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)commandToConvert.getMomentumRateGradient(), (DMatrix1Row)qpInputToPack.directCostGradient);
        DMatrixRMaj convectiveTerm = this.getCentroidalMomentumConvectiveTerm();
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)convectiveTerm, (DMatrix1Row)qpInputToPack.taskConvectiveTerm);
        this.recordTaskJacobian(qpInputToPack.taskJacobian);
        return true;
    }

    public boolean convertMomentumCommand(MomentumCommand commandToConvert, QPInputTypeA qpInputToPack) {
        commandToConvert.getSelectionMatrix(this.centerOfMassFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        ConstraintType constraintType = ConstraintType.OBJECTIVE;
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setConstraintType(constraintType);
        if (constraintType == ConstraintType.OBJECTIVE) {
            qpInputToPack.setUseWeightScalar(false);
            this.tempTaskWeight.reshape(6, 6);
            this.tempTaskWeightSubspace.reshape(taskSize, 6);
            commandToConvert.getWeightMatrix(this.tempTaskWeight);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
            CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)qpInputToPack.taskWeightMatrix);
        }
        DMatrixRMaj centroidalMomentumMatrix = this.getCentroidalMomentumMatrix();
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)centroidalMomentumMatrix, (DMatrix1Row)qpInputToPack.taskJacobian);
        commandToConvert.getMomentumRate((FrameVector3DBasics)this.angularMomentum, (FrameVector3DBasics)this.linearMomentum);
        this.angularMomentum.changeFrame(this.centerOfMassFrame);
        this.linearMomentum.changeFrame(this.centerOfMassFrame);
        this.angularMomentum.get(0, (DMatrix)this.tempTaskObjective);
        this.linearMomentum.get(3, (DMatrix)this.tempTaskObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)qpInputToPack.taskObjective);
        this.recordTaskJacobian(qpInputToPack.taskJacobian);
        return true;
    }

    public boolean convertLinearMomentumConvexConstraint2DCommand(LinearMomentumConvexConstraint2DCommand command, QPInputTypeA qpInputToPack) {
        List<Vector2D> vertices = command.getLinearMomentumConstraintVertices();
        if (vertices.isEmpty()) {
            return false;
        }
        this.tempSelectionMatrix.reshape(2, 6);
        this.tempSelectionMatrix.zero();
        this.tempSelectionMatrix.set(0, 3, 1.0);
        this.tempSelectionMatrix.set(1, 4, 1.0);
        this.tempTaskJacobian.reshape(2, this.numberOfDoFs);
        DMatrixRMaj centroidalMomentumMatrix = this.getCentroidalMomentumMatrix();
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)centroidalMomentumMatrix, (DMatrix1Row)this.tempTaskJacobian);
        if (vertices.size() < 2) {
            return false;
        }
        if (vertices.size() == 2) {
            qpInputToPack.reshape(1);
            qpInputToPack.setConstraintType(ConstraintType.LEQ_INEQUALITY);
            this.setupLineConstraint(0, (Tuple2DReadOnly)vertices.get(0), (Tuple2DReadOnly)vertices.get(1), this.tempTaskJacobian, qpInputToPack);
        } else {
            qpInputToPack.reshape(vertices.size());
            qpInputToPack.setConstraintType(ConstraintType.LEQ_INEQUALITY);
            Vector2D v0 = vertices.get(vertices.size() - 1);
            for (int i = 0; i < vertices.size(); ++i) {
                Vector2D v1 = vertices.get(i);
                this.setupLineConstraint(i, (Tuple2DReadOnly)v0, (Tuple2DReadOnly)v1, this.tempTaskJacobian, qpInputToPack);
                v0 = v1;
            }
        }
        return true;
    }

    private void setupLineConstraint(int constraintIndex, Tuple2DReadOnly firstPointOnLine, Tuple2DReadOnly secondPointOnLine, DMatrixRMaj centroidalMomemtumMatrixLinearXY, QPInputTypeA qpInputToPack) {
        double directionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double directionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        double norm = Math.sqrt(EuclidCoreTools.normSquared((double)directionX, (double)directionY));
        this.lineConstraintSelection.set(0, -(directionY /= norm));
        this.lineConstraintSelection.set(1, directionX /= norm);
        this.lineConstraintJacobian.reshape(1, this.numberOfDoFs);
        CommonOps_DDRM.mult((DMatrix1Row)this.lineConstraintSelection, (DMatrix1Row)centroidalMomemtumMatrixLinearXY, (DMatrix1Row)this.lineConstraintJacobian);
        CommonOps_DDRM.insert((DMatrix)this.lineConstraintJacobian, (DMatrix)qpInputToPack.taskJacobian, (int)constraintIndex, (int)0);
        qpInputToPack.taskObjective.set(constraintIndex, directionX * firstPointOnLine.getY() - directionY * firstPointOnLine.getX());
    }

    public boolean convertJointspaceAccelerationCommand(JointspaceAccelerationCommand commandToConvert, QPInputTypeA qpInputToPack) {
        int taskSize = MultiBodySystemTools.computeDegreesOfFreedom(commandToConvert.getJoints());
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setConstraintType(commandToConvert.isHardConstraint() ? ConstraintType.EQUALITY : ConstraintType.OBJECTIVE);
        qpInputToPack.taskJacobian.zero();
        qpInputToPack.taskWeightMatrix.zero();
        qpInputToPack.setUseWeightScalar(false);
        int row = 0;
        for (int jointIndex = 0; jointIndex < commandToConvert.getNumberOfJoints(); ++jointIndex) {
            JointBasics joint = commandToConvert.getJoint(jointIndex);
            double weight = commandToConvert.getWeight(jointIndex);
            int[] columns = this.jointIndexHandler.getJointIndices((JointReadOnly)joint);
            if (columns == null) {
                return false;
            }
            CommonOps_DDRM.insert((DMatrix)commandToConvert.getDesiredAcceleration(jointIndex), (DMatrix)qpInputToPack.taskObjective, (int)row, (int)0);
            for (int column : columns) {
                qpInputToPack.taskJacobian.set(row, column, 1.0);
                qpInputToPack.taskWeightMatrix.set(row, row, weight);
                ++row;
            }
        }
        this.recordTaskJacobian(qpInputToPack.taskJacobian);
        return true;
    }

    public boolean convertJointspaceVelocityCommand(JointspaceVelocityCommand commandToConvert, QPInputTypeA qpInputToPack) {
        int taskSize = MultiBodySystemTools.computeDegreesOfFreedom(commandToConvert.getJoints());
        if (taskSize == 0) {
            return false;
        }
        qpInputToPack.reshape(taskSize);
        qpInputToPack.setConstraintType(commandToConvert.isHardConstraint() ? ConstraintType.EQUALITY : ConstraintType.OBJECTIVE);
        qpInputToPack.taskJacobian.zero();
        qpInputToPack.taskWeightMatrix.zero();
        qpInputToPack.setUseWeightScalar(false);
        int row = 0;
        for (int jointIndex = 0; jointIndex < commandToConvert.getNumberOfJoints(); ++jointIndex) {
            JointBasics joint = commandToConvert.getJoint(jointIndex);
            double weight = commandToConvert.getWeight(jointIndex);
            int[] columns = this.jointIndexHandler.getJointIndices((JointReadOnly)joint);
            if (columns == null) {
                return false;
            }
            CommonOps_DDRM.insert((DMatrix)commandToConvert.getDesiredVelocity(jointIndex), (DMatrix)qpInputToPack.taskObjective, (int)row, (int)0);
            for (int column : columns) {
                qpInputToPack.taskJacobian.set(row, column, 1.0);
                qpInputToPack.taskWeightMatrix.set(row, row, weight);
                ++row;
            }
        }
        this.recordTaskJacobian(qpInputToPack.taskJacobian);
        return true;
    }

    private void recordTaskJacobian(DMatrixRMaj taskJacobian) {
        int taskSize = taskJacobian.getNumRows();
        this.allTaskJacobian.reshape(this.allTaskJacobian.getNumRows() + taskSize, this.numberOfDoFs, true);
        CommonOps_DDRM.insert((DMatrix)taskJacobian, (DMatrix)this.allTaskJacobian, (int)(this.allTaskJacobian.getNumRows() - taskSize), (int)0);
    }

    public DMatrixRMaj getCentroidalMomentumMatrix() {
        if (this.centroidalMomentumCalculator != null) {
            return this.centroidalMomentumCalculator.getCentroidalMomentumMatrix();
        }
        return this.centroidalMomentumRateCalculator.getCentroidalMomentumMatrix();
    }

    public DMatrixRMaj getCentroidalMomentumConvectiveTerm() {
        return this.centroidalMomentumRateCalculator.getBiasSpatialForceMatrix();
    }

    public SpatialForceReadOnly computeCentroidalMomentumRateFromSolution(DMatrixRMaj jointAccelerations) {
        this.centroidalMomentumRateCalculator.getMomentumRate((DMatrix1Row)jointAccelerations, (SpatialForceBasics)this.momentumRate);
        return this.momentumRate;
    }

    public MomentumReadOnly computeCentroidalMomentumFromSolution(DMatrixRMaj jointVelocities) {
        if (this.centroidalMomentumCalculator != null) {
            this.centroidalMomentumCalculator.getMomentum((DMatrix1Row)jointVelocities, (MomentumBasics)this.momentum);
        } else {
            this.centroidalMomentumRateCalculator.getMomentum((DMatrix1Row)jointVelocities, (MomentumBasics)this.momentum);
        }
        return this.momentum;
    }
}

