/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointVelocityIntegratorResetMode;
import us.ihmc.commons.MathTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class JointAccelerationIntegrationCalculator {
    public static final double DEFAULT_POSITION_BREAK_FREQUENCY = 0.016;
    public static final double DEFAULT_VELOCITY_BREAK_FREQUENCY = 2.04;
    public static final double DEFAULT_MAX_POSITION_ERROR = 0.2;
    public static final double DEFAULT_MAX_VELOCITY_ERROR = 2.0;
    public static final double DEFAULT_VELOCITY_REFERENCE_ALPHA = 0.0;
    public static final JointVelocityIntegratorResetMode DEFAULT_VELOCITY_RESET_MODE = JointVelocityIntegratorResetMode.CURRENT_VELOCITY;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<OneDoFJointBasics> jointsToComputeDesiredPositionFor = new ArrayList<OneDoFJointBasics>();
    private final TDoubleArrayList jointSpecificPositionBreakFrequency = new TDoubleArrayList();
    private final TDoubleArrayList jointSpecificVelocityBreakFrequency = new TDoubleArrayList();
    private final TDoubleArrayList jointSpecificMaxPositionError = new TDoubleArrayList();
    private final TDoubleArrayList jointSpecificMaxVelocityError = new TDoubleArrayList();
    private final TDoubleArrayList jointSpecificVelocityReferenceAlpha = new TDoubleArrayList();
    private final List<JointVelocityIntegratorResetMode> jointSpecificVelocityResetMode = new ArrayList<JointVelocityIntegratorResetMode>();
    private final YoDouble defaultPositionBreakFrequency = new YoDouble("defaultPositionBreakFrequencyIntegration", this.registry);
    private final YoDouble defaultVelocityBreakFrequency = new YoDouble("defaultVelocityBreakFrequencyIntegration", this.registry);
    private final YoDouble defaultIntegrationMaxVelocityError = new YoDouble("defaultIntegrationMaxVelocityError", this.registry);
    private final YoDouble defaultIntegrationMaxPositionError = new YoDouble("defaultIntegrationMaxPositionError", this.registry);
    private final YoDouble defaultVelocityReferenceAlpha = new YoDouble("defaultVelocityReferenceAlpha", this.registry);
    private final YoEnum<JointVelocityIntegratorResetMode> defaultVelocityResetMode = new YoEnum("defaultVelocityResetMode", this.registry, JointVelocityIntegratorResetMode.class);
    private final double controlDT;

    public JointAccelerationIntegrationCalculator(double controlDT, YoRegistry parentRegistry) {
        this.controlDT = controlDT;
        this.defaultPositionBreakFrequency.set(0.016);
        this.defaultVelocityBreakFrequency.set(2.04);
        this.defaultIntegrationMaxPositionError.set(0.2);
        this.defaultIntegrationMaxVelocityError.set(2.0);
        this.defaultVelocityReferenceAlpha.set(0.0);
        this.defaultVelocityResetMode.set((Enum)DEFAULT_VELOCITY_RESET_MODE);
        parentRegistry.addChild(this.registry);
    }

    public void submitJointAccelerationIntegrationCommand(JointAccelerationIntegrationCommand command) {
        for (int commandJointIndex = 0; commandJointIndex < command.getNumberOfJointsToComputeDesiredPositionFor(); ++commandJointIndex) {
            OneDoFJointBasics jointToComputeDesierdPositionFor = command.getJointToComputeDesiredPositionFor(commandJointIndex);
            int localJointIndex = this.jointsToComputeDesiredPositionFor.indexOf(jointToComputeDesierdPositionFor);
            JointAccelerationIntegrationParametersReadOnly jointParameters = command.getJointParameters(commandJointIndex);
            double newPositionBreakFrequency = jointParameters.getPositionBreakFrequency();
            if (Double.isNaN(newPositionBreakFrequency) || newPositionBreakFrequency < 0.0) {
                newPositionBreakFrequency = this.defaultPositionBreakFrequency.getDoubleValue();
            }
            newPositionBreakFrequency = Math.max(0.0, newPositionBreakFrequency);
            double newVelocityBreakFrequency = jointParameters.getVelocityBreakFrequency();
            if (Double.isNaN(newVelocityBreakFrequency) || newVelocityBreakFrequency < 0.0) {
                newVelocityBreakFrequency = this.defaultVelocityBreakFrequency.getDoubleValue();
            }
            newVelocityBreakFrequency = Math.max(0.0, newVelocityBreakFrequency);
            double newMaxPositionError = jointParameters.getMaxPositionError();
            if (Double.isNaN(newMaxPositionError) || newMaxPositionError < 0.0) {
                newMaxPositionError = this.defaultIntegrationMaxPositionError.getDoubleValue();
            }
            newMaxPositionError = Math.max(0.0, newMaxPositionError);
            double newMaxVelocityError = jointParameters.getMaxVelocityError();
            if (Double.isNaN(newMaxVelocityError) || newMaxVelocityError < 0.0) {
                newMaxVelocityError = this.defaultIntegrationMaxVelocityError.getDoubleValue();
            }
            newMaxVelocityError = Math.max(0.0, newMaxVelocityError);
            double newVelocityReferenceAlpha = jointParameters.getVelocityReferenceAlpha();
            if (Double.isNaN(newVelocityReferenceAlpha) || newVelocityReferenceAlpha < 0.0) {
                newVelocityReferenceAlpha = this.defaultVelocityReferenceAlpha.getDoubleValue();
            }
            newVelocityReferenceAlpha = MathTools.clamp((double)newVelocityReferenceAlpha, (double)0.0, (double)1.0);
            JointVelocityIntegratorResetMode newVelocityResetMode = jointParameters.getVelocityResetMode();
            if (newVelocityResetMode == null) {
                newVelocityResetMode = (JointVelocityIntegratorResetMode)this.defaultVelocityResetMode.getValue();
            }
            if (localJointIndex < 0) {
                this.jointsToComputeDesiredPositionFor.add(jointToComputeDesierdPositionFor);
                this.jointSpecificPositionBreakFrequency.add(newPositionBreakFrequency);
                this.jointSpecificVelocityBreakFrequency.add(newVelocityBreakFrequency);
                this.jointSpecificMaxPositionError.add(newMaxPositionError);
                this.jointSpecificMaxVelocityError.add(newMaxVelocityError);
                this.jointSpecificVelocityReferenceAlpha.add(newVelocityReferenceAlpha);
                this.jointSpecificVelocityResetMode.add(newVelocityResetMode);
                continue;
            }
            this.jointSpecificPositionBreakFrequency.set(localJointIndex, newPositionBreakFrequency);
            this.jointSpecificVelocityBreakFrequency.set(localJointIndex, newVelocityBreakFrequency);
            this.jointSpecificMaxPositionError.set(localJointIndex, newMaxPositionError);
            this.jointSpecificMaxVelocityError.set(localJointIndex, newMaxVelocityError);
            this.jointSpecificVelocityReferenceAlpha.set(localJointIndex, newVelocityReferenceAlpha);
            this.jointSpecificVelocityResetMode.set(localJointIndex, newVelocityResetMode);
        }
    }

    public void computeAndUpdateDataHolder(LowLevelOneDoFJointDesiredDataHolder lowLevelJointDataHolderToUpdate) {
        for (int jointIndex = 0; jointIndex < this.jointsToComputeDesiredPositionFor.size(); ++jointIndex) {
            OneDoFJointBasics joint = this.jointsToComputeDesiredPositionFor.get(jointIndex);
            JointDesiredOutputBasics lowLevelJointData = lowLevelJointDataHolderToUpdate.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            if (lowLevelJointData == null || !lowLevelJointData.hasDesiredAcceleration()) continue;
            double alphaPosition = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.jointSpecificPositionBreakFrequency.get(jointIndex), (double)this.controlDT);
            double alphaVelocity = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.jointSpecificVelocityBreakFrequency.get(jointIndex), (double)this.controlDT);
            double maxPositionError = this.jointSpecificMaxPositionError.get(jointIndex);
            double maxVelocityError = this.jointSpecificMaxVelocityError.get(jointIndex);
            double velocityReferenceAlpha = this.jointSpecificVelocityReferenceAlpha.get(jointIndex);
            double velocityReference = velocityReferenceAlpha * joint.getQd();
            double positionReference = joint.getQ();
            boolean resetIntegrators = lowLevelJointData.pollResetIntegratorsRequest();
            if (!lowLevelJointData.hasDesiredVelocity() || resetIntegrators) {
                JointVelocityIntegratorResetMode velocityResetMode = this.jointSpecificVelocityResetMode.get(jointIndex);
                switch (velocityResetMode) {
                    case CURRENT_VELOCITY: {
                        lowLevelJointData.setDesiredVelocity(joint.getQd());
                        break;
                    }
                    case ZERO_VELOCITY: {
                        lowLevelJointData.setDesiredVelocity(0.0);
                        break;
                    }
                    case REFERENCE_VELOCITY: {
                        lowLevelJointData.setDesiredVelocity(velocityReference);
                        break;
                    }
                    default: {
                        LogTools.warn((String)"Unexpected velocity reset mode: {}, resetting velocity to current for joint {}.", (Object)((Object)velocityResetMode), (Object)joint.getName());
                        lowLevelJointData.setDesiredVelocity(joint.getQd());
                    }
                }
            }
            if (!lowLevelJointData.hasDesiredPosition() || resetIntegrators) {
                lowLevelJointData.setDesiredPosition(positionReference);
            }
            double desiredAcceleration = lowLevelJointData.getDesiredAcceleration();
            double desiredVelocity = lowLevelJointData.getDesiredVelocity();
            double desiredPosition = lowLevelJointData.getDesiredPosition();
            desiredVelocity = desiredVelocity * alphaVelocity + (1.0 - alphaVelocity) * velocityReference;
            desiredVelocity += desiredAcceleration * this.controlDT;
            desiredVelocity = MathTools.clamp((double)desiredVelocity, (double)(velocityReference - maxVelocityError), (double)(velocityReference + maxVelocityError));
            desiredPosition = desiredPosition * alphaPosition + (1.0 - alphaPosition) * positionReference;
            desiredPosition += desiredVelocity * this.controlDT;
            desiredPosition = MathTools.clamp((double)desiredPosition, (double)(positionReference - maxPositionError), (double)(positionReference + maxPositionError));
            desiredPosition = MathTools.clamp((double)desiredPosition, (double)joint.getJointLimitLower(), (double)joint.getJointLimitUpper());
            lowLevelJointData.setDesiredVelocity(desiredVelocity);
            lowLevelJointData.setDesiredPosition(desiredPosition);
        }
    }
}

