/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeB;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPVariableSubstitution;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class InverseDynamicsQPSolver {
    private static final boolean SETUP_WRENCHES_CONSTRAINT_AS_OBJECTIVE = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("qpSolverTimer", 0.5, this.registry);
    private final YoFrameVector3D wrenchEquilibriumForceError;
    private final YoFrameVector3D wrenchEquilibriumTorqueError;
    private final YoBoolean addRateRegularization = new YoBoolean("AddRateRegularization", this.registry);
    private final ActiveSetQPSolverWithInactiveVariablesInterface qpSolver;
    private final QPVariableSubstitution accelerationVariablesSubstitution = new QPVariableSubstitution();
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_f;
    private final DMatrixRMaj solverInput_H_previous;
    private final DMatrixRMaj solverInput_f_previous;
    private final DMatrixRMaj solverInput_Aeq;
    private final DMatrixRMaj solverInput_beq;
    private final DMatrixRMaj solverInput_Ain;
    private final DMatrixRMaj solverInput_bin;
    private final DMatrixRMaj solverInput_lb;
    private final DMatrixRMaj solverInput_ub;
    private final DMatrixRMaj solverInput_lb_previous;
    private final DMatrixRMaj solverInput_ub_previous;
    private final DMatrixRMaj solverInput_activeIndices;
    private final DMatrixRMaj solverOutput;
    private final DMatrixRMaj solverOutput_jointAccelerations;
    private final DMatrixRMaj solverOutput_rhos;
    private final YoInteger numberOfActiveVariables = new YoInteger("numberOfActiveVariables", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoInteger numberOfEqualityConstraints = new YoInteger("numberOfEqualityConstraints", this.registry);
    private final YoInteger numberOfInequalityConstraints = new YoInteger("numberOfInequalityConstraints", this.registry);
    private final YoInteger numberOfConstraints = new YoInteger("numberOfConstraints", this.registry);
    private final YoDouble jointAccelerationRegularization = new YoDouble("jointAccelerationRegularization", this.registry);
    private final YoDouble jointJerkRegularization = new YoDouble("jointJerkRegularization", this.registry);
    private final YoDouble jointTorqueWeight = new YoDouble("jointTorqueWeight", this.registry);
    private final DMatrixRMaj regularizationMatrix;
    private final DMatrixRMaj tempJtW;
    private final int numberOfDoFs;
    private final int rhoSize;
    private final int problemSize;
    private final boolean hasFloatingBase;
    private boolean hasWrenchesEquilibriumConstraintBeenSetup = false;
    private boolean resetActiveSet = false;
    private boolean useWarmStart = false;
    private int maxNumberOfIterations = 100;
    private final double dt;
    private final DMatrixRMaj tempWrenchConstraint_J = new DMatrixRMaj(6, 200);
    private final DMatrixRMaj tempWrenchConstraint_LHS = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempWrenchConstraint_RHS = new DMatrixRMaj(6, 1);

    public InverseDynamicsQPSolver(ActiveSetQPSolverWithInactiveVariablesInterface qpSolver, int numberOfDoFs, int rhoSize, boolean hasFloatingBase, double dt, YoRegistry parentRegistry) {
        this.qpSolver = qpSolver;
        this.numberOfDoFs = numberOfDoFs;
        this.rhoSize = rhoSize;
        this.hasFloatingBase = hasFloatingBase;
        this.problemSize = numberOfDoFs + rhoSize;
        this.dt = dt;
        this.addRateRegularization.set(false);
        this.solverInput_H = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.solverInput_f = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_H_previous = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.solverInput_f_previous = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_Aeq = new DMatrixRMaj(0, this.problemSize);
        this.solverInput_beq = new DMatrixRMaj(0, 1);
        this.solverInput_Ain = new DMatrixRMaj(0, this.problemSize);
        this.solverInput_bin = new DMatrixRMaj(0, 1);
        this.solverInput_lb = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_ub = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_lb_previous = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_ub_previous = new DMatrixRMaj(this.problemSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_lb, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_ub, (double)Double.POSITIVE_INFINITY);
        this.solverInput_activeIndices = new DMatrixRMaj(this.problemSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_activeIndices, (double)1.0);
        this.solverOutput = new DMatrixRMaj(this.problemSize, 1);
        this.solverOutput_jointAccelerations = new DMatrixRMaj(numberOfDoFs, 1);
        this.solverOutput_rhos = new DMatrixRMaj(rhoSize, 1);
        this.tempJtW = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.jointAccelerationRegularization.set(0.005);
        this.jointJerkRegularization.set(0.1);
        this.jointTorqueWeight.set(0.001);
        this.regularizationMatrix = new DMatrixRMaj(this.problemSize, this.problemSize);
        for (int i = 0; i < numberOfDoFs; ++i) {
            this.regularizationMatrix.set(i, i, this.jointAccelerationRegularization.getDoubleValue());
        }
        double defaultRhoRegularization = 1.0E-5;
        for (int i = numberOfDoFs; i < this.problemSize; ++i) {
            this.regularizationMatrix.set(i, i, defaultRhoRegularization);
        }
        this.wrenchEquilibriumForceError = new YoFrameVector3D("wrenchEquilibriumForceError", null, this.registry);
        this.wrenchEquilibriumTorqueError = new YoFrameVector3D("wrenchEquilibriumTorqueError", null, this.registry);
        this.accelerationVariablesSubstitution.setIgnoreBias(true);
        parentRegistry.addChild(this.registry);
    }

    public void setAccelerationRegularizationWeight(double weight) {
        this.jointAccelerationRegularization.set(weight);
    }

    public void setJerkRegularizationWeight(double weight) {
        this.jointJerkRegularization.set(weight);
    }

    public void setJointTorqueWeight(double weight) {
        this.jointTorqueWeight.set(weight);
    }

    public void setRhoRegularizationWeight(DMatrixRMaj weight) {
        CommonOps_DDRM.insert((DMatrix)weight, (DMatrix)this.regularizationMatrix, (int)this.numberOfDoFs, (int)this.numberOfDoFs);
    }

    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void notifyResetActiveSet() {
        this.resetActiveSet = true;
    }

    private boolean pollResetActiveSet() {
        boolean ret = this.resetActiveSet;
        this.resetActiveSet = false;
        return ret;
    }

    public void reset() {
        for (int i = 0; i < this.numberOfDoFs; ++i) {
            this.regularizationMatrix.set(i, i, this.jointAccelerationRegularization.getDoubleValue());
        }
        this.accelerationVariablesSubstitution.reset();
        this.solverInput_H.zero();
        this.solverInput_f.zero();
        this.solverInput_Aeq.reshape(0, this.problemSize);
        this.solverInput_beq.reshape(0, 1);
        this.solverInput_Ain.reshape(0, this.problemSize);
        this.solverInput_bin.reshape(0, 1);
    }

    private void addRegularization() {
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.regularizationMatrix);
        if (this.addRateRegularization.getBooleanValue()) {
            this.addJointJerkRegularization();
        }
    }

    public void resetRateRegularization() {
        this.addRateRegularization.set(false);
    }

    private void addJointJerkRegularization() {
        double factor = this.dt * this.dt / this.jointJerkRegularization.getDoubleValue();
        for (int i = 0; i < this.numberOfDoFs; ++i) {
            this.solverInput_H.add(i, i, 1.0 / factor);
            this.solverInput_f.add(i, 0, -this.solverOutput_jointAccelerations.get(i, 0) / factor);
        }
    }

    public void addMotionInput(QPInputTypeA input) {
        switch (input.getConstraintType()) {
            case OBJECTIVE: {
                if (input.useWeightScalar()) {
                    this.addMotionTask(input.taskJacobian, input.taskObjective, input.getWeightScalar());
                    break;
                }
                this.addMotionTask(input.taskJacobian, input.taskObjective, input.taskWeightMatrix);
                break;
            }
            case EQUALITY: {
                this.addMotionEqualityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case LEQ_INEQUALITY: {
                this.addMotionLesserOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case GEQ_INEQUALITY: {
                this.addMotionGreaterOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected constraint type: " + (Object)((Object)input.getConstraintType()));
            }
        }
    }

    public void addMotionInput(QPInputTypeB input) {
        if (input.useWeightScalar()) {
            this.addMotionTask(input.taskJacobian, input.taskConvectiveTerm, input.getWeightScalar(), input.directCostHessian, input.directCostGradient);
        } else {
            this.addMotionTask(input.taskJacobian, input.taskConvectiveTerm, input.taskWeightMatrix, input.directCostHessian, input.directCostGradient);
        }
    }

    public void addRhoInput(QPInputTypeA input) {
        switch (input.getConstraintType()) {
            case OBJECTIVE: {
                if (input.useWeightScalar()) {
                    this.addRhoTask(input.getTaskJacobian(), input.getTaskObjective(), input.getWeightScalar());
                    break;
                }
                this.addRhoTask(input.getTaskJacobian(), input.getTaskObjective(), input.getTaskWeightMatrix());
                break;
            }
            case EQUALITY: {
                this.addRhoEqualityConstraint(input.getTaskJacobian(), input.getTaskObjective());
                break;
            }
            case LEQ_INEQUALITY: {
                this.addRhoLesserOrEqualInequalityConstraint(input.getTaskJacobian(), input.getTaskObjective());
                break;
            }
            case GEQ_INEQUALITY: {
                this.addRhoGreaterOrEqualInequalityConstraint(input.getTaskJacobian(), input.getTaskObjective());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected constraint type: " + (Object)((Object)input.getConstraintType()));
            }
        }
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double taskWeight) {
        if (taskJacobian.getNumCols() != this.numberOfDoFs) {
            throw new RuntimeException("Motion task needs to have size macthing the DoFs of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskObjective, taskWeight, 0);
    }

    public void addRhoTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double taskWeight) {
        if (taskJacobian.getNumCols() != this.rhoSize) {
            throw new RuntimeException("Rho task needs to have size macthing the number of rhos of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskObjective, taskWeight, this.numberOfDoFs);
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        if (taskJacobian.getNumCols() != this.numberOfDoFs) {
            throw new RuntimeException("Motion task needs to have size matching the DoFs of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskObjective, taskWeight, 0);
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskConvectiveTerm, double taskWeight, DMatrixRMaj directCostHessian, DMatrixRMaj directCostGradient) {
        if (taskJacobian.getNumCols() != this.numberOfDoFs) {
            throw new RuntimeException("Motion task needs to have size macthing the DoFs of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskConvectiveTerm, taskWeight, directCostHessian, directCostGradient, 0);
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskConvectiveTerm, DMatrixRMaj taskWeight, DMatrixRMaj directCostHessian, DMatrixRMaj directCostGradient) {
        if (taskJacobian.getNumCols() != this.numberOfDoFs) {
            throw new RuntimeException("Motion task needs to have size macthing the DoFs of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskConvectiveTerm, taskWeight, directCostHessian, directCostGradient, 0);
    }

    public void addRhoTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        if (taskJacobian.getNumCols() != this.rhoSize) {
            throw new RuntimeException("Rho task needs to have size macthing the number of rhos of the robot.");
        }
        this.addTaskInternal(taskJacobian, taskObjective, taskWeight, this.numberOfDoFs);
    }

    public void addRhoTask(DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        this.addTaskInternal(taskObjective, taskWeight, this.numberOfDoFs, this.rhoSize);
    }

    public void addMotionTask(DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        this.addTaskInternal(taskObjective, taskWeight, 0, this.numberOfDoFs);
    }

    public void addTaskInternal(DMatrixRMaj taskObjective, DMatrixRMaj taskWeight, int offset, int variables) {
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)offset, (int)offset, (DMatrix1Row)taskWeight, (int)0, (int)0, (int)variables, (int)variables, (double)1.0);
        MatrixTools.multAddBlock((double)-1.0, (DMatrix1Row)taskWeight, (DMatrix1Row)taskObjective, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
    }

    private void addTaskInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight, int offset) {
        int taskSize = taskJacobian.getNumRows();
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.tempJtW.reshape(variables, taskSize);
        CommonOps_DDRM.multTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.solverInput_H, (int)offset, (int)offset);
        MatrixTools.multAddBlock((double)-1.0, (DMatrix1Row)this.tempJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
    }

    private void addTaskInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double taskWeight, int offset) {
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        MatrixTools.multAddBlockInner((double)taskWeight, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.solverInput_H, (int)offset, (int)offset);
        MatrixTools.multAddBlockTransA((double)(-taskWeight), (DMatrix1Row)taskJacobian, (DMatrix1Row)taskObjective, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
    }

    private void addTaskInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskConvectiveTerm, DMatrixRMaj taskWeight, DMatrixRMaj directCostHessian, DMatrixRMaj directCostGradient, int offset) {
        int taskSize = taskJacobian.getNumRows();
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.tempJtW.reshape(variables, taskSize);
        CommonOps_DDRM.multTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)directCostGradient, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)directCostHessian, (DMatrix1Row)this.tempJtW);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.solverInput_H, (int)offset, (int)offset);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskConvectiveTerm, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
    }

    private void addTaskInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskConvectiveTerm, double taskWeight, DMatrixRMaj directCostHessian, DMatrixRMaj directCostGradient, int offset) {
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        MatrixTools.multAddBlock((double)taskWeight, (DMatrix1Row)taskJacobian, (DMatrix1Row)directCostGradient, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
        CommonOps_DDRM.multTransA((double)taskWeight, (DMatrix1Row)taskJacobian, (DMatrix1Row)directCostHessian, (DMatrix1Row)this.tempJtW);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.solverInput_H, (int)offset, (int)offset);
        MatrixTools.multAddBlock((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskConvectiveTerm, (DMatrix1Row)this.solverInput_f, (int)offset, (int)0);
    }

    public void addMotionEqualityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        if (taskJacobian.getNumCols() != this.numberOfDoFs) {
            throw new RuntimeException("Motion task needs to have size macthing the DoFs of the robot.");
        }
        this.addEqualityConstraintInternal(taskJacobian, taskObjective, 0);
    }

    public void addRhoEqualityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        if (taskJacobian.getNumCols() != this.rhoSize) {
            throw new RuntimeException("Rho task needs to have size macthing the number of rhos of the robot.");
        }
        this.addEqualityConstraintInternal(taskJacobian, taskObjective, this.numberOfDoFs);
    }

    private void addEqualityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, int offset) {
        int taskSize = taskJacobian.getNumRows();
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        int previousSize = this.solverInput_beq.getNumRows();
        this.solverInput_Aeq.reshape(previousSize + taskSize, this.problemSize, true);
        this.solverInput_beq.reshape(previousSize + taskSize, 1, true);
        CommonOps_DDRM.insert((DMatrix)taskJacobian, (DMatrix)this.solverInput_Aeq, (int)previousSize, (int)offset);
        CommonOps_DDRM.insert((DMatrix)taskObjective, (DMatrix)this.solverInput_beq, (int)previousSize, (int)offset);
    }

    public void addMotionLesserOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, 1.0);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, -1.0);
    }

    private void addRhoLesserOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addRhoInequalityConstraintInternal(taskJacobian, taskObjective, 1.0);
    }

    private void addRhoGreaterOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addRhoInequalityConstraintInternal(taskJacobian, taskObjective, -1.0);
    }

    private void addMotionInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, sign, 0);
    }

    private void addRhoInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, sign, this.numberOfDoFs);
    }

    private void addInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign, int offset) {
        int taskSize = taskJacobian.getNumRows();
        int variables = taskJacobian.getNumCols();
        if (offset + variables > this.problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        int previousSize = this.solverInput_bin.getNumRows();
        this.solverInput_Ain.reshape(previousSize + taskSize, this.problemSize, true);
        this.solverInput_bin.reshape(previousSize + taskSize, 1, true);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Ain, (int)previousSize, (int)offset, (DMatrix)taskJacobian, (int)0, (int)0, (int)taskSize, (int)variables, (double)sign);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bin, (int)previousSize, (int)0, (DMatrix)taskObjective, (int)0, (int)0, (int)taskSize, (int)1, (double)sign);
    }

    public void addTorqueMinimizationObjective(DMatrixRMaj torqueJacobian, DMatrixRMaj torqueObjective) {
        MatrixTools.multAddInner((double)this.jointTorqueWeight.getDoubleValue(), (DMatrix1Row)torqueJacobian, (DMatrix1Row)this.solverInput_H);
        CommonOps_DDRM.multAddTransA((double)(-this.jointTorqueWeight.getDoubleValue()), (DMatrix1Row)torqueJacobian, (DMatrix1Row)torqueObjective, (DMatrix1Row)this.solverInput_f);
    }

    public void addTorqueMinimizationObjective(DMatrixRMaj torqueQddotJacobian, DMatrixRMaj torqueRhoJacobian, DMatrixRMaj torqueObjective) {
        int taskSize = torqueObjective.getNumRows();
        this.tempJtW.reshape(taskSize, this.problemSize);
        CommonOps_DDRM.insert((DMatrix)torqueQddotJacobian, (DMatrix)this.tempJtW, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)torqueRhoJacobian, (DMatrix)this.tempJtW, (int)0, (int)this.numberOfDoFs);
        this.addTorqueMinimizationObjective(this.tempJtW, torqueObjective);
    }

    public void setupWrenchesEquilibriumConstraint(DMatrixRMaj centroidalMomentumMatrix, DMatrixRMaj rhoJacobian, DMatrixRMaj convectiveTerm, DMatrixRMaj additionalExternalWrench, DMatrixRMaj gravityWrench) {
        if (!this.hasFloatingBase) {
            this.hasWrenchesEquilibriumConstraintBeenSetup = true;
            return;
        }
        this.tempWrenchConstraint_RHS.set((DMatrixD1)convectiveTerm);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempWrenchConstraint_RHS, (DMatrixD1)additionalExternalWrench);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempWrenchConstraint_RHS, (DMatrixD1)gravityWrench);
        this.tempWrenchConstraint_J.reshape(6, this.problemSize);
        MatrixTools.setMatrixBlock((DMatrix)this.tempWrenchConstraint_J, (int)0, (int)0, (DMatrix)centroidalMomentumMatrix, (int)0, (int)0, (int)6, (int)this.numberOfDoFs, (double)-1.0);
        CommonOps_DDRM.insert((DMatrix)rhoJacobian, (DMatrix)this.tempWrenchConstraint_J, (int)0, (int)this.numberOfDoFs);
        double weight = 150.0;
        MatrixTools.multAddInner((double)weight, (DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.solverInput_H);
        CommonOps_DDRM.multAddTransA((double)(-weight), (DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.tempWrenchConstraint_RHS, (DMatrix1Row)this.solverInput_f);
        this.hasWrenchesEquilibriumConstraintBeenSetup = true;
    }

    public void addAccelerationSubstitution(QPVariableSubstitution substitution) {
        this.accelerationVariablesSubstitution.concatenate(substitution);
    }

    public boolean solve() {
        TIntArrayList inactiveIndices;
        if (!this.hasWrenchesEquilibriumConstraintBeenSetup) {
            throw new RuntimeException("The wrench equilibrium constraint has to be setup before calling solve().");
        }
        this.addRegularization();
        this.numberOfEqualityConstraints.set(this.solverInput_Aeq.getNumRows());
        this.numberOfInequalityConstraints.set(this.solverInput_Ain.getNumRows());
        this.numberOfConstraints.set(this.solverInput_Aeq.getNumRows() + this.solverInput_Ain.getNumRows());
        this.qpSolverTimer.startMeasurement();
        this.qpSolver.clear();
        this.qpSolver.setUseWarmStart(this.useWarmStart);
        this.qpSolver.setMaxNumberOfIterations(this.maxNumberOfIterations);
        if (this.useWarmStart && this.pollResetActiveSet()) {
            this.qpSolver.resetActiveSet();
        }
        if ((inactiveIndices = this.applySubstitution()) != null) {
            for (int i = 0; i < inactiveIndices.size(); ++i) {
                this.solverInput_activeIndices.set(inactiveIndices.get(i), 0, 0.0);
            }
        }
        this.numberOfActiveVariables.set((int)CommonOps_DDRM.elementSum((DMatrixD1)this.solverInput_activeIndices));
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_f);
        this.qpSolver.setVariableBounds((DMatrix)this.solverInput_lb, (DMatrix)this.solverInput_ub);
        this.qpSolver.setActiveVariables(this.solverInput_activeIndices);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.solverInput_Ain, (DMatrix)this.solverInput_bin);
        this.qpSolver.setLinearEqualityConstraints((DMatrix)this.solverInput_Aeq, (DMatrix)this.solverInput_beq);
        this.numberOfIterations.set(this.qpSolver.solve((DMatrix)this.solverOutput));
        this.removeSubstitution();
        this.qpSolverTimer.stopMeasurement();
        this.hasWrenchesEquilibriumConstraintBeenSetup = false;
        if (MatrixTools.containsNaN((DMatrix1Row)this.solverOutput)) {
            return false;
        }
        CommonOps_DDRM.extract((DMatrix)this.solverOutput, (int)0, (int)this.numberOfDoFs, (int)0, (int)1, (DMatrix)this.solverOutput_jointAccelerations, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.solverOutput, (int)this.numberOfDoFs, (int)this.problemSize, (int)0, (int)1, (DMatrix)this.solverOutput_rhos, (int)0, (int)0);
        this.addRateRegularization.set(true);
        if (this.hasFloatingBase) {
            CommonOps_DDRM.mult((DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.solverOutput, (DMatrix1Row)this.tempWrenchConstraint_LHS);
            int index = 0;
            this.wrenchEquilibriumTorqueError.setX(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumTorqueError.setY(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumTorqueError.setZ(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setX(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setY(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setZ(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
        }
        this.solverInput_H_previous.set((DMatrixD1)this.solverInput_H);
        this.solverInput_f_previous.set((DMatrixD1)this.solverInput_f);
        this.solverInput_lb_previous.set((DMatrixD1)this.solverInput_lb);
        this.solverInput_ub_previous.set((DMatrixD1)this.solverInput_ub);
        return true;
    }

    private TIntArrayList applySubstitution() {
        if (this.accelerationVariablesSubstitution.isEmpty()) {
            return null;
        }
        this.accelerationVariablesSubstitution.applySubstitutionToObjectiveFunction(this.solverInput_H, this.solverInput_f);
        this.accelerationVariablesSubstitution.applySubstitutionToLinearConstraint(this.solverInput_Aeq, this.solverInput_beq);
        this.accelerationVariablesSubstitution.applySubstitutionToLinearConstraint(this.solverInput_Ain, this.solverInput_bin);
        this.accelerationVariablesSubstitution.applySubstitutionToBounds(this.solverInput_lb, this.solverInput_ub, this.solverInput_Ain, this.solverInput_bin);
        return this.accelerationVariablesSubstitution.getInactiveIndices();
    }

    private void removeSubstitution() {
        if (this.accelerationVariablesSubstitution.isEmpty()) {
            return;
        }
        this.accelerationVariablesSubstitution.removeSubstitutionToSolution(this.solverOutput);
    }

    private void printForJerry() {
        MatrixTools.printJavaForConstruction((String)"H", (DMatrix1Row)this.solverInput_H);
        MatrixTools.printJavaForConstruction((String)"f", (DMatrix1Row)this.solverInput_f);
        MatrixTools.printJavaForConstruction((String)"lowerBounds", (DMatrix1Row)this.solverInput_lb);
        MatrixTools.printJavaForConstruction((String)"upperBounds", (DMatrix1Row)this.solverInput_ub);
        MatrixTools.printJavaForConstruction((String)"solution", (DMatrix1Row)this.solverOutput);
    }

    public DMatrixRMaj getJointAccelerations() {
        return this.solverOutput_jointAccelerations;
    }

    public DMatrixRMaj getRhos() {
        return this.solverOutput_rhos;
    }

    public void setMinJointAccelerations(double qDDotMin) {
        for (int i = 4; i < this.numberOfDoFs; ++i) {
            this.solverInput_lb.set(i, 0, qDDotMin);
        }
    }

    public void setMinJointAccelerations(DMatrixRMaj qDDotMin) {
        CommonOps_DDRM.insert((DMatrix)qDDotMin, (DMatrix)this.solverInput_lb, (int)0, (int)0);
    }

    public void setMaxJointAccelerations(double qDDotMax) {
        for (int i = 4; i < this.numberOfDoFs; ++i) {
            this.solverInput_ub.set(i, 0, qDDotMax);
        }
    }

    public void setMaxJointAccelerations(DMatrixRMaj qDDotMax) {
        CommonOps_DDRM.insert((DMatrix)qDDotMax, (DMatrix)this.solverInput_ub, (int)0, (int)0);
    }

    public void setMinRho(double rhoMin) {
        for (int i = this.numberOfDoFs; i < this.problemSize; ++i) {
            this.solverInput_lb.set(i, 0, rhoMin);
        }
    }

    public void setMinRho(DMatrixRMaj rhoMin) {
        CommonOps_DDRM.insert((DMatrix)rhoMin, (DMatrix)this.solverInput_lb, (int)this.numberOfDoFs, (int)0);
    }

    public void setMaxRho(double rhoMax) {
        for (int i = this.numberOfDoFs; i < this.problemSize; ++i) {
            this.solverInput_ub.set(i, 0, rhoMax);
        }
    }

    public void setMaxRho(DMatrixRMaj rhoMax) {
        CommonOps_DDRM.insert((DMatrix)rhoMax, (DMatrix)this.solverInput_ub, (int)this.numberOfDoFs, (int)0);
    }

    public void setActiveRhos(DMatrixRMaj activeRhoMatrix) {
        CommonOps_DDRM.insert((DMatrix)activeRhoMatrix, (DMatrix)this.solverInput_activeIndices, (int)this.numberOfDoFs, (int)0);
    }
}

