/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.LinearMomentumRateCostCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumModuleSolution;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.WholeBodyControllerBoundCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.DynamicsMatrixCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ExternalWrenchHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.InverseDynamicsQPSolver;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MotionQPInputCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeB;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPVariableSubstitution;
import us.ihmc.commonWalkingControlModules.visualizer.BasisVectorVisualizer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchMatrixCalculator;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class InverseDynamicsOptimizationControlModule {
    private static final boolean VISUALIZE_RHO_BASIS_VECTORS = false;
    private static final boolean SETUP_JOINT_LIMIT_CONSTRAINTS = true;
    private static final boolean SETUP_RHO_TASKS = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final WrenchMatrixCalculator wrenchMatrixCalculator;
    private final DynamicsMatrixCalculator dynamicsMatrixCalculator;
    private final BasisVectorVisualizer basisVectorVisualizer;
    private final InverseDynamicsQPSolver qpSolver;
    private final QPInputTypeB directMotionQPInput;
    private final QPInputTypeA motionQPInput;
    private final QPInputTypeA rhoQPInput;
    private final QPVariableSubstitution motionQPVariableSubstitution;
    private final MotionQPInputCalculator motionQPInputCalculator;
    private final WholeBodyControllerBoundCalculator boundCalculator;
    private final ExternalWrenchHandler externalWrenchHandler;
    private final JointBasics[] jointsToOptimizeFor;
    private final List<KinematicLoopFunction> kinematicLoopFunctions;
    private final int numberOfDoFs;
    private final int rhoSize;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final DMatrixRMaj qDDotMinMatrix;
    private final DMatrixRMaj qDDotMaxMatrix;
    private final JointIndexHandler jointIndexHandler;
    private final YoDouble absoluteMaximumJointAcceleration = new YoDouble("absoluteMaximumJointAcceleration", this.registry);
    private final Map<OneDoFJointBasics, YoDouble> jointMaximumAccelerations = new HashMap<OneDoFJointBasics, YoDouble>();
    private final Map<OneDoFJointBasics, YoDouble> jointMinimumAccelerations = new HashMap<OneDoFJointBasics, YoDouble>();
    private final YoDouble rhoMin = new YoDouble("ControllerCoreRhoMin", this.registry);
    private final MomentumModuleSolution momentumModuleSolution;
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("hasNotConvergedInPast", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("hasNotConvergedCounts", this.registry);
    private final YoBoolean useWarmStart = new YoBoolean("useWarmStartInSolver", this.registry);
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterationsInSolver", this.registry);
    private final DMatrixRMaj zeroObjective = new DMatrixRMaj(0, 0);

    public InverseDynamicsOptimizationControlModule(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this(toolbox, null, parentRegistry);
    }

    public InverseDynamicsOptimizationControlModule(WholeBodyControlCoreToolbox toolbox, DynamicsMatrixCalculator dynamicsMatrixCalculator, YoRegistry parentRegistry) {
        this.jointIndexHandler = toolbox.getJointIndexHandler();
        this.jointsToOptimizeFor = this.jointIndexHandler.getIndexedJoints();
        this.oneDoFJoints = this.jointIndexHandler.getIndexedOneDoFJoints();
        this.kinematicLoopFunctions = toolbox.getKinematicLoopFunctions();
        this.dynamicsMatrixCalculator = dynamicsMatrixCalculator;
        ReferenceFrame centerOfMassFrame = toolbox.getCenterOfMassFrame();
        this.numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])this.jointsToOptimizeFor);
        this.rhoSize = toolbox.getRhoSize();
        double gravityZ = toolbox.getGravityZ();
        List<? extends ContactablePlaneBody> contactablePlaneBodies = toolbox.getContactablePlaneBodies();
        ControllerCoreOptimizationSettings optimizationSettings = toolbox.getOptimizationSettings();
        this.wrenchMatrixCalculator = toolbox.getWrenchMatrixCalculator();
        YoGraphicsListRegistry yoGraphicsListRegistry = toolbox.getYoGraphicsListRegistry();
        this.basisVectorVisualizer = null;
        this.motionQPInput = new QPInputTypeA(this.numberOfDoFs);
        this.directMotionQPInput = new QPInputTypeB(this.numberOfDoFs);
        this.rhoQPInput = new QPInputTypeA(this.rhoSize);
        this.motionQPVariableSubstitution = new QPVariableSubstitution();
        this.externalWrenchHandler = new ExternalWrenchHandler(gravityZ, centerOfMassFrame, toolbox.getTotalRobotMass(), contactablePlaneBodies);
        this.motionQPInputCalculator = toolbox.getMotionQPInputCalculator();
        this.boundCalculator = toolbox.getQPBoundCalculator();
        this.absoluteMaximumJointAcceleration.set(optimizationSettings.getMaximumJointAcceleration());
        this.qDDotMinMatrix = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.qDDotMaxMatrix = new DMatrixRMaj(this.numberOfDoFs, 1);
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.oneDoFJoints[i];
            this.jointMaximumAccelerations.put(joint, new YoDouble("qdd_max_qp_" + joint.getName(), this.registry));
            this.jointMinimumAccelerations.put(joint, new YoDouble("qdd_min_qp_" + joint.getName(), this.registry));
        }
        this.rhoMin.set(optimizationSettings.getRhoMin());
        this.momentumModuleSolution = new MomentumModuleSolution();
        boolean hasFloatingBase = toolbox.getRootJoint() != null;
        ActiveSetQPSolverWithInactiveVariablesInterface activeSetQPSolver = optimizationSettings.getActiveSetQPSolver();
        double dt = toolbox.getControlDT();
        this.qpSolver = new InverseDynamicsQPSolver(activeSetQPSolver, this.numberOfDoFs, this.rhoSize, hasFloatingBase, dt, this.registry);
        this.qpSolver.setAccelerationRegularizationWeight(optimizationSettings.getJointAccelerationWeight());
        this.qpSolver.setJerkRegularizationWeight(optimizationSettings.getJointJerkWeight());
        this.qpSolver.setJointTorqueWeight(optimizationSettings.getJointTorqueWeight());
        this.qpSolver.setUseWarmStart(optimizationSettings.useWarmStartInSolver());
        this.qpSolver.setMaxNumberOfIterations(optimizationSettings.getMaxNumberOfSolverIterations());
        this.useWarmStart.set(optimizationSettings.useWarmStartInSolver());
        this.maximumNumberOfIterations.set(optimizationSettings.getMaxNumberOfSolverIterations());
        this.zeroObjective.reshape(this.wrenchMatrixCalculator.getCopTaskSize(), 1);
        this.zeroObjective.zero();
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        this.qpSolver.reset();
        this.externalWrenchHandler.reset();
        this.motionQPInputCalculator.initialize();
    }

    public void resetRateRegularization() {
        this.qpSolver.resetRateRegularization();
    }

    public boolean compute() {
        boolean hasConverged;
        this.wrenchMatrixCalculator.computeMatrices();
        this.qpSolver.setRhoRegularizationWeight(this.wrenchMatrixCalculator.getRhoWeightMatrix());
        this.setupRhoTasks();
        this.qpSolver.setMinRho(this.rhoMin.getDoubleValue());
        this.qpSolver.setMaxRho(this.wrenchMatrixCalculator.getRhoMaxMatrix());
        this.qpSolver.setActiveRhos(this.wrenchMatrixCalculator.getActiveRhoMatrix());
        this.setupWrenchesEquilibriumConstraint();
        this.computePrivilegedJointAccelerations();
        this.computeJointAccelerationLimits();
        this.qpSolver.setMinJointAccelerations(this.qDDotMinMatrix);
        this.qpSolver.setMaxJointAccelerations(this.qDDotMaxMatrix);
        for (int i = 0; i < this.kinematicLoopFunctions.size(); ++i) {
            this.motionQPInputCalculator.convertKinematicLoopFunction(this.kinematicLoopFunctions.get(i), this.motionQPVariableSubstitution);
            this.qpSolver.addAccelerationSubstitution(this.motionQPVariableSubstitution);
        }
        this.qpSolver.setMaxNumberOfIterations(this.maximumNumberOfIterations.getIntegerValue());
        if (this.useWarmStart.getBooleanValue() && this.wrenchMatrixCalculator.hasContactStateChanged()) {
            this.qpSolver.setUseWarmStart(this.useWarmStart.getBooleanValue());
            this.qpSolver.notifyResetActiveSet();
        }
        if (!(hasConverged = this.qpSolver.solve())) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                LogTools.warn((String)"The QP has not converged. Only showing this once if it happens repeatedly.");
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
        }
        DMatrixRMaj qDDotSolution = this.qpSolver.getJointAccelerations();
        DMatrixRMaj rhoSolution = this.qpSolver.getRhos();
        Map<RigidBodyBasics, Wrench> groundReactionWrenches = this.wrenchMatrixCalculator.computeWrenchesFromRho(rhoSolution);
        this.externalWrenchHandler.computeExternalWrenches(groundReactionWrenches);
        SpatialForceReadOnly centroidalMomentumRateSolution = this.motionQPInputCalculator.computeCentroidalMomentumRateFromSolution(qDDotSolution);
        Map<RigidBodyBasics, Wrench> externalWrenchSolution = this.externalWrenchHandler.getExternalWrenchMap();
        List<RigidBodyBasics> rigidBodiesWithExternalWrench = this.externalWrenchHandler.getRigidBodiesWithExternalWrench();
        this.momentumModuleSolution.setCentroidalMomentumRateSolution(centroidalMomentumRateSolution);
        this.momentumModuleSolution.setExternalWrenchSolution(externalWrenchSolution);
        this.momentumModuleSolution.setJointAccelerations(qDDotSolution);
        this.momentumModuleSolution.setRhoSolution(rhoSolution);
        this.momentumModuleSolution.setJointsToOptimizeFor(this.jointsToOptimizeFor);
        this.momentumModuleSolution.setRigidBodiesWithExternalWrench(rigidBodiesWithExternalWrench);
        return hasConverged;
    }

    public MomentumModuleSolution getMomentumModuleSolution() {
        return this.momentumModuleSolution;
    }

    private void computeJointAccelerationLimits() {
        this.boundCalculator.computeJointAccelerationLimits(this.absoluteMaximumJointAcceleration.getDoubleValue(), this.qDDotMinMatrix, this.qDDotMaxMatrix);
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.oneDoFJoints[i];
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            double qDDotMin = this.qDDotMinMatrix.get(jointIndex, 0);
            double qDDotMax = this.qDDotMaxMatrix.get(jointIndex, 0);
            this.jointMinimumAccelerations.get(joint).set(qDDotMin);
            this.jointMaximumAccelerations.get(joint).set(qDDotMax);
        }
    }

    private void computePrivilegedJointAccelerations() {
        boolean success = this.motionQPInputCalculator.computePrivilegedJointAccelerations(this.motionQPInput);
        if (success) {
            this.qpSolver.addMotionInput(this.motionQPInput);
        }
    }

    private void setupRhoTasks() {
        DMatrixRMaj rhoPrevious = this.wrenchMatrixCalculator.getRhoPreviousMatrix();
        DMatrixRMaj rhoRateWeight = this.wrenchMatrixCalculator.getRhoRateWeightMatrix();
        this.qpSolver.addRhoTask(rhoPrevious, rhoRateWeight);
        DMatrixRMaj copRegularizationWeight = this.wrenchMatrixCalculator.getCoPRegularizationWeight();
        DMatrixRMaj copRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRegularizationJacobian();
        DMatrixRMaj coPRegularizationObjective = this.wrenchMatrixCalculator.getCoPRegularizationObjective();
        this.qpSolver.addRhoTask(copRegularizationJacobian, coPRegularizationObjective, copRegularizationWeight);
        DMatrixRMaj copRateRegularizationWeight = this.wrenchMatrixCalculator.getCoPRateRegularizationWeight();
        DMatrixRMaj copRateRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRateRegularizationJacobian();
        DMatrixRMaj copRateRegularizationObjective = this.wrenchMatrixCalculator.getCoPRateRegularizationObjective();
        this.qpSolver.addRhoTask(copRateRegularizationJacobian, copRateRegularizationObjective, copRateRegularizationWeight);
        while (this.wrenchMatrixCalculator.getContactWrenchInput(this.rhoQPInput)) {
            this.qpSolver.addRhoInput(this.rhoQPInput);
        }
        while (this.wrenchMatrixCalculator.getCenterOfPressureInput(this.rhoQPInput)) {
            this.qpSolver.addRhoInput(this.rhoQPInput);
        }
    }

    private void setupWrenchesEquilibriumConstraint() {
        DMatrixRMaj centroidalMomentumMatrix = this.motionQPInputCalculator.getCentroidalMomentumMatrix();
        DMatrixRMaj rhoJacobian = this.wrenchMatrixCalculator.getRhoJacobianMatrix();
        DMatrixRMaj convectiveTerm = this.motionQPInputCalculator.getCentroidalMomentumConvectiveTerm();
        DMatrixRMaj additionalExternalWrench = this.externalWrenchHandler.getSumOfExternalWrenches();
        DMatrixRMaj gravityWrench = this.externalWrenchHandler.getGravitationalWrench();
        this.qpSolver.setupWrenchesEquilibriumConstraint(centroidalMomentumMatrix, rhoJacobian, convectiveTerm, additionalExternalWrench, gravityWrench);
    }

    public void setupTorqueMinimizationCommand() {
        this.qpSolver.addTorqueMinimizationObjective(this.dynamicsMatrixCalculator.getTorqueMinimizationAccelerationJacobian(), this.dynamicsMatrixCalculator.getTorqueMinimizationRhoJacobian(), this.dynamicsMatrixCalculator.getTorqueMinimizationObjective());
    }

    public void submitSpatialAccelerationCommand(SpatialAccelerationCommand command) {
        boolean success = this.motionQPInputCalculator.convertSpatialAccelerationCommand(command, this.motionQPInput);
        if (success) {
            this.qpSolver.addMotionInput(this.motionQPInput);
        }
    }

    public void submitJointspaceAccelerationCommand(JointspaceAccelerationCommand command) {
        boolean success = this.motionQPInputCalculator.convertJointspaceAccelerationCommand(command, this.motionQPInput);
        if (success) {
            this.qpSolver.addMotionInput(this.motionQPInput);
        }
    }

    public void submitMomentumRateCommand(MomentumRateCommand command) {
        boolean success = this.motionQPInputCalculator.convertMomentumRateCommand(command, this.motionQPInput);
        if (success) {
            this.qpSolver.addMotionInput(this.motionQPInput);
        }
    }

    public void submitLinearMomentumRateCostCommand(LinearMomentumRateCostCommand command) {
        boolean success = this.motionQPInputCalculator.convertLinearMomentumRateCostCommand(command, this.directMotionQPInput);
        if (success) {
            this.qpSolver.addMotionInput(this.directMotionQPInput);
        }
    }

    public void submitPrivilegedConfigurationCommand(PrivilegedConfigurationCommand command) {
        this.motionQPInputCalculator.updatePrivilegedConfiguration(command);
    }

    public void submitPrivilegedAccelerationCommand(PrivilegedJointSpaceCommand command) {
        this.motionQPInputCalculator.submitPrivilegedAccelerations(command);
    }

    public void submitJointLimitReductionCommand(JointLimitReductionCommand command) {
        this.boundCalculator.submitJointLimitReductionCommand(command);
    }

    public void submitJointLimitEnforcementMethodCommand(JointLimitEnforcementMethodCommand command) {
        this.boundCalculator.submitJointLimitEnforcementMethodCommand(command);
    }

    public void submitPlaneContactStateCommand(PlaneContactStateCommand command) {
        this.wrenchMatrixCalculator.submitPlaneContactStateCommand(command);
    }

    public void submitCenterOfPressureCommand(CenterOfPressureCommand command) {
        this.wrenchMatrixCalculator.submitCenterOfPressureCommand(command);
    }

    public void submitExternalWrenchCommand(ExternalWrenchCommand command) {
        RigidBodyBasics rigidBody = command.getRigidBody();
        WrenchBasics wrench = command.getExternalWrench();
        this.externalWrenchHandler.setExternalWrenchToCompensateFor(rigidBody, (WrenchReadOnly)wrench);
    }

    public void submitContactWrenchCommand(ContactWrenchCommand command) {
        this.wrenchMatrixCalculator.submitContactWrenchCommand(command);
    }

    public void submitOptimizationSettingsCommand(InverseDynamicsOptimizationSettingsCommand command) {
        if (command.hasRhoMin()) {
            this.rhoMin.set(command.getRhoMin());
        }
        if (command.hasJointAccelerationMax()) {
            this.absoluteMaximumJointAcceleration.set(command.getJointAccelerationMax());
        }
        if (command.hasRhoWeight()) {
            this.wrenchMatrixCalculator.setRhoWeight(command.getRhoWeight());
        }
        if (command.hasRhoRateWeight()) {
            this.wrenchMatrixCalculator.setRhoRateWeight(command.getRhoRateWeight());
        }
        if (command.hasCenterOfPressureWeight()) {
            this.wrenchMatrixCalculator.setDesiredCoPWeight((Tuple2DReadOnly)command.getCenterOfPressureWeight());
        }
        if (command.hasCenterOfPressureRateWeight()) {
            this.wrenchMatrixCalculator.setCoPRateWeight((Tuple2DReadOnly)command.getCenterOfPressureRateWeight());
        }
        if (command.hasJointAccelerationWeight()) {
            this.qpSolver.setAccelerationRegularizationWeight(command.getJointAccelerationWeight());
        }
        if (command.hasJointJerkWeight()) {
            this.qpSolver.setJerkRegularizationWeight(command.getJointJerkWeight());
        }
        if (command.hasJointTorqueWeight()) {
            this.qpSolver.setJointTorqueWeight(command.getJointTorqueWeight());
        }
    }
}

