/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ContactWrenchMatrixCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.DynamicsMatrixCalculatorHelper;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.FloatingBaseRigidBodyDynamicsCalculator;
import us.ihmc.robotics.screwTheory.GravityCoriolisExternalWrenchMatrixCalculator;

public class DynamicsMatrixCalculator {
    private final CompositeRigidBodyMassMatrixCalculator massMatrixCalculator;
    private final GravityCoriolisExternalWrenchMatrixCalculator coriolisMatrixCalculator;
    private final ContactWrenchMatrixCalculator contactWrenchMatrixCalculator;
    private final DynamicsMatrixCalculatorHelper helper;
    private final DMatrixRMaj coriolisMatrix;
    private final DMatrixRMaj contactForceJacobian;
    private final DMatrixRMaj floatingBaseMassMatrix;
    private final DMatrixRMaj floatingBaseCoriolisMatrix;
    private final DMatrixRMaj floatingBaseContactForceJacobian;
    private final DMatrixRMaj bodyMassMatrix;
    private final DMatrixRMaj bodyCoriolisMatrix;
    private final DMatrixRMaj bodyContactForceJacobian;
    private final DMatrixRMaj bodyContactForceJacobianTranspose;
    private final DMatrixRMaj jointTorques;
    private final DMatrixRMaj torqueMinimizationObjective;
    private final int bodyDoFs;
    private static final int large = 1000;
    private final DMatrixRMaj localBodyMassMatrix = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localBodyCoriolisMatrix = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localBodyContactJacobian = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localFloatingMassMatrix = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localFloatingCoriolisMatrix = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localFloatingContactJacobian = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj tmpMatrix = new DMatrixRMaj(6);
    private final FloatingBaseRigidBodyDynamicsCalculator rbdCalculator = new FloatingBaseRigidBodyDynamicsCalculator();

    public DynamicsMatrixCalculator(WholeBodyControlCoreToolbox toolbox) {
        FloatingJointBasics rootJoint = toolbox.getRootJoint();
        int rhoSize = toolbox.getRhoSize();
        JointIndexHandler jointIndexHandler = toolbox.getJointIndexHandler();
        this.massMatrixCalculator = toolbox.getMassMatrixCalculator();
        this.coriolisMatrixCalculator = toolbox.getGravityCoriolisExternalWrenchMatrixCalculator();
        this.contactWrenchMatrixCalculator = toolbox.getContactWrenchMatrixCalculator();
        this.helper = new DynamicsMatrixCalculatorHelper(this.coriolisMatrixCalculator, jointIndexHandler);
        this.helper.setRhoSize(rhoSize);
        int numberOfDoFs = jointIndexHandler.getNumberOfDoFs();
        int floatingBaseDoFs = rootJoint != null ? rootJoint.getDegreesOfFreedom() : 0;
        this.bodyDoFs = numberOfDoFs - floatingBaseDoFs;
        this.jointTorques = new DMatrixRMaj(this.bodyDoFs, 1);
        this.coriolisMatrix = new DMatrixRMaj(numberOfDoFs, 1);
        this.contactForceJacobian = new DMatrixRMaj(rhoSize, numberOfDoFs);
        this.floatingBaseMassMatrix = new DMatrixRMaj(floatingBaseDoFs, numberOfDoFs);
        this.floatingBaseCoriolisMatrix = new DMatrixRMaj(floatingBaseDoFs, 1);
        this.floatingBaseContactForceJacobian = new DMatrixRMaj(rhoSize, floatingBaseDoFs);
        this.bodyMassMatrix = new DMatrixRMaj(this.bodyDoFs, numberOfDoFs);
        this.bodyCoriolisMatrix = new DMatrixRMaj(this.bodyDoFs, 1);
        this.bodyContactForceJacobian = new DMatrixRMaj(rhoSize, this.bodyDoFs);
        this.bodyContactForceJacobianTranspose = new DMatrixRMaj(this.bodyDoFs, rhoSize);
        this.torqueMinimizationObjective = new DMatrixRMaj(this.bodyDoFs, 1);
    }

    public void reset() {
        this.coriolisMatrixCalculator.setExternalWrenchesToZero();
    }

    public void compute() {
        this.massMatrixCalculator.reset();
        this.coriolisMatrixCalculator.compute();
        this.computeMatrices();
        this.computeTorqueMinimizationTaskMatrices();
    }

    public void setExternalWrench(RigidBodyBasics rigidBody, WrenchReadOnly externalWrench) {
        this.coriolisMatrixCalculator.setExternalWrench((RigidBodyReadOnly)rigidBody, externalWrench);
    }

    private void computeMatrices() {
        DMatrixRMaj massMatrix = this.massMatrixCalculator.getMassMatrix();
        this.helper.extractFloatingBaseMassMatrix(massMatrix, this.floatingBaseMassMatrix);
        this.helper.extractBodyMassMatrix(massMatrix, this.bodyMassMatrix);
        this.helper.computeCoriolisMatrix(this.coriolisMatrix);
        this.helper.extractFloatingBaseCoriolisMatrix(this.coriolisMatrix, this.floatingBaseCoriolisMatrix);
        this.helper.extractBodyCoriolisMatrix(this.coriolisMatrix, this.bodyCoriolisMatrix);
        this.contactWrenchMatrixCalculator.computeContactForceJacobian(this.contactForceJacobian);
        this.helper.extractFloatingBaseContactForceJacobianMatrix(this.contactForceJacobian, this.floatingBaseContactForceJacobian);
        this.helper.extractBodyContactForceJacobianMatrix(this.contactForceJacobian, this.bodyContactForceJacobian);
    }

    private void computeTorqueMinimizationTaskMatrices() {
        CommonOps_DDRM.transpose((DMatrixRMaj)this.bodyContactForceJacobian, (DMatrixRMaj)this.bodyContactForceJacobianTranspose);
        this.torqueMinimizationObjective.set((DMatrixD1)this.bodyCoriolisMatrix);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.torqueMinimizationObjective);
    }

    public void getFloatingBaseMassMatrix(DMatrixRMaj floatingBaseMassMatrixToPack) {
        floatingBaseMassMatrixToPack.set((DMatrixD1)this.floatingBaseMassMatrix);
    }

    public void getFloatingBaseCoriolisMatrix(DMatrixRMaj floatingBaseCoriolisMatrixToPack) {
        floatingBaseCoriolisMatrixToPack.set((DMatrixD1)this.floatingBaseCoriolisMatrix);
    }

    public void getFloatingBaseContactForceJacobian(DMatrixRMaj floatingBaseContactForceJacobianToPack) {
        floatingBaseContactForceJacobianToPack.set((DMatrixD1)this.floatingBaseContactForceJacobian);
    }

    public void getBodyMassMatrix(DMatrixRMaj bodyMassMatrixToPack) {
        bodyMassMatrixToPack.set((DMatrixD1)this.bodyMassMatrix);
    }

    public void getBodyCoriolisMatrix(DMatrixRMaj bodyCoriolisMatrixToPack) {
        bodyCoriolisMatrixToPack.set((DMatrixD1)this.bodyCoriolisMatrix);
    }

    public void getBodyContactForceJacobian(DMatrixRMaj bodyContactForceJacobianToPack) {
        bodyContactForceJacobianToPack.set((DMatrixD1)this.bodyContactForceJacobian);
    }

    public void getMassMatrix(DMatrixRMaj massMatrixToPack) {
        MatrixTools.setMatrixBlock((DMatrix)massMatrixToPack, (int)0, (int)0, (DMatrix)this.floatingBaseMassMatrix, (int)0, (int)0, (int)this.floatingBaseMassMatrix.getNumRows(), (int)this.floatingBaseMassMatrix.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)massMatrixToPack, (int)this.floatingBaseMassMatrix.getNumRows(), (int)0, (DMatrix)this.bodyMassMatrix, (int)0, (int)0, (int)this.bodyMassMatrix.getNumRows(), (int)this.bodyMassMatrix.getNumCols(), (double)1.0);
    }

    public void getCoriolisMatrix(DMatrixRMaj coriolisMatrixToPack) {
        MatrixTools.setMatrixBlock((DMatrix)coriolisMatrixToPack, (int)0, (int)0, (DMatrix)this.floatingBaseCoriolisMatrix, (int)0, (int)0, (int)this.floatingBaseCoriolisMatrix.getNumRows(), (int)this.floatingBaseCoriolisMatrix.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)coriolisMatrixToPack, (int)this.floatingBaseCoriolisMatrix.getNumRows(), (int)0, (DMatrix)this.bodyCoriolisMatrix, (int)0, (int)0, (int)this.bodyCoriolisMatrix.getNumRows(), (int)this.bodyCoriolisMatrix.getNumCols(), (double)1.0);
    }

    public DMatrixRMaj computeJointTorques(DMatrixRMaj jointAccelerationSolution, DMatrixRMaj contactForceSolution) {
        this.computeJointTorques(this.jointTorques, jointAccelerationSolution, contactForceSolution);
        return this.jointTorques;
    }

    public DMatrixRMaj getTorqueMinimizationAccelerationJacobian() {
        return this.bodyMassMatrix;
    }

    public DMatrixRMaj getTorqueMinimizationRhoJacobian() {
        return this.bodyContactForceJacobianTranspose;
    }

    public DMatrixRMaj getTorqueMinimizationObjective() {
        return this.torqueMinimizationObjective;
    }

    public void computeJointTorques(DMatrixRMaj jointTorquesToPack, DMatrixRMaj jointAccelerationSolution, DMatrixRMaj contactForceSolution) {
        this.rbdCalculator.computeTauGivenRhoAndQddot(this.bodyMassMatrix, this.bodyCoriolisMatrix, this.bodyContactForceJacobian, jointAccelerationSolution, contactForceSolution, jointTorquesToPack);
    }

    public boolean computeQddotGivenRho(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddotToPack, DMatrixRMaj rho) {
        if (this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddotToPack, rho)) {
            return false;
        }
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeQddotGivenRho(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, qddotToPack, rho);
        return true;
    }

    public boolean computeRhoGivenQddot(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj rhoToPack) {
        if (this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddot, rhoToPack)) {
            return false;
        }
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeRhoGivenQddot(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, qddot, rhoToPack);
        return true;
    }

    public void computeTauGivenRhoAndQddot(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj rho, DMatrixRMaj tauToPack) {
        this.getBodyMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeTauGivenRhoAndQddot(this.localBodyMassMatrix, this.localBodyCoriolisMatrix, this.localBodyContactJacobian, qddot, rho, tauToPack);
    }

    public void computeTauGivenRho(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj rho, DMatrixRMaj tauToPack) {
        this.getBodyMatrices(dynamicsMatrixCalculator);
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeTauGivenRho(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, this.localBodyMassMatrix, this.localBodyCoriolisMatrix, this.localBodyContactJacobian, rho, tauToPack);
    }

    public void computeTauGivenQddot(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj tauToPack) {
        this.getBodyMatrices(dynamicsMatrixCalculator);
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeTauGivenQddot(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, this.localBodyMassMatrix, this.localBodyCoriolisMatrix, this.localBodyContactJacobian, qddot, tauToPack);
    }

    public boolean computeRequiredRhoAndAchievableQddotGivenRho(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddotAchievableToPack, DMatrixRMaj rhoToPack) {
        return this.computeRequiredRhoAndAchievableQddotGivenRho(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack, 0);
    }

    private boolean computeRequiredRhoAndAchievableQddotGivenRho(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddotAchievableToPack, DMatrixRMaj rhoToPack, int iter) {
        if (this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack)) {
            return false;
        }
        this.computeQddotGivenRho(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack);
        if (!this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack)) {
            if (iter > 1000) {
                throw new RuntimeException("Overflow in computation - cannot find a satisfactory qddot.");
            }
            this.computeRhoGivenQddot(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack);
            this.computeRequiredRhoAndAchievableQddotGivenRho(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack, iter + 1);
        }
        return true;
    }

    public boolean computeRequiredRhoAndAchievableQddotGivenQddot(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddotAchievableToPack, DMatrixRMaj rhoToPack) {
        return this.computeRequiredRhoAndAchievableQddotGivenQddot(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack, 0);
    }

    private boolean computeRequiredRhoAndAchievableQddotGivenQddot(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddotAchievableToPack, DMatrixRMaj rhoToPack, int iter) {
        if (this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack)) {
            return false;
        }
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        this.rbdCalculator.computeRhoGivenQddot(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, qddotAchievableToPack, rhoToPack);
        if (!this.checkFloatingBaseDynamicsSatisfied(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack)) {
            if (iter > 1000) {
                throw new RuntimeException("Overflow in computation - cannot find a satisfactory qddot.");
            }
            this.computeQddotGivenRho(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack);
            this.computeRequiredRhoAndAchievableQddotGivenQddot(dynamicsMatrixCalculator, qddotAchievableToPack, rhoToPack, iter + 1);
        }
        return true;
    }

    public CompositeRigidBodyMassMatrixCalculator getMassMatrixCalculator() {
        return this.massMatrixCalculator;
    }

    public boolean checkFloatingBaseRigidBodyDynamicsSatisfied(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj tau, DMatrixRMaj rho) {
        this.getBodyMatrices(dynamicsMatrixCalculator);
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        return this.rbdCalculator.areFloatingBaseRigidBodyDynamicsSatisfied(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, this.localBodyMassMatrix, this.localBodyCoriolisMatrix, this.localBodyContactJacobian, qddot, tau, rho);
    }

    public void extractTorqueMatrix(JointBasics[] joints, DMatrixRMaj torqueMatrixToPack) {
        OneDoFJointBasics[] filteredJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])joints, RevoluteJoint.class);
        int bodyDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])filteredJoints);
        int startIndex = 0;
        for (int i = 0; i < bodyDoFs; ++i) {
            OneDoFJointBasics joint = filteredJoints[i];
            int jointDoF = joint.getDegreesOfFreedom();
            this.tmpMatrix.reshape(jointDoF, 1);
            joint.getJointTau(0, (DMatrix)this.tmpMatrix);
            for (int dof = 0; dof < jointDoF; ++dof) {
                torqueMatrixToPack.set(startIndex + dof, 0, this.tmpMatrix.get(dof, 0));
            }
            startIndex += jointDoF;
        }
    }

    public boolean checkFloatingBaseDynamicsSatisfied(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj rho) {
        this.getFloatingBaseMatrices(dynamicsMatrixCalculator);
        return this.rbdCalculator.areFloatingBaseDynamicsSatisfied(this.localFloatingMassMatrix, this.localFloatingCoriolisMatrix, this.localFloatingContactJacobian, qddot, rho);
    }

    public boolean checkRigidBodyDynamicsSatisfied(DynamicsMatrixCalculator dynamicsMatrixCalculator, DMatrixRMaj qddot, DMatrixRMaj tau, DMatrixRMaj rho) {
        this.getBodyMatrices(dynamicsMatrixCalculator);
        return this.rbdCalculator.areRigidBodyDynamicsSatisfied(this.localBodyMassMatrix, this.localBodyCoriolisMatrix, this.localBodyContactJacobian, qddot, tau, rho);
    }

    private void getFloatingBaseMatrices(DynamicsMatrixCalculator dynamicsMatrixCalculator) {
        dynamicsMatrixCalculator.getFloatingBaseMassMatrix(this.localFloatingMassMatrix);
        dynamicsMatrixCalculator.getFloatingBaseCoriolisMatrix(this.localFloatingCoriolisMatrix);
        dynamicsMatrixCalculator.getFloatingBaseContactForceJacobian(this.localFloatingContactJacobian);
    }

    private void getBodyMatrices(DynamicsMatrixCalculator dynamicsMatrixCalculator) {
        dynamicsMatrixCalculator.getBodyMassMatrix(this.localBodyMassMatrix);
        dynamicsMatrixCalculator.getBodyCoriolisMatrix(this.localBodyCoriolisMatrix);
        dynamicsMatrixCalculator.getBodyContactForceJacobian(this.localBodyContactJacobian);
    }
}

