/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace;

import us.ihmc.commonWalkingControlModules.controlModules.YoSE3OffsetFrame;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualForceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBAlphaFilteredVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPoint3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PointFeedbackController
implements FeedbackControllerInterface {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final YoBoolean isEnabled;
    private final FBPoint3D yoDesiredPosition;
    private final FBPoint3D yoCurrentPosition;
    private final FBVector3D yoErrorPosition;
    private final FBVector3D yoErrorPositionIntegrated;
    private final FBVector3D yoDesiredLinearVelocity;
    private final FBVector3D yoCurrentLinearVelocity;
    private final FBVector3D yoErrorLinearVelocity;
    private final FBAlphaFilteredVector3D yoFilteredErrorLinearVelocity;
    private final FBVector3D yoFeedForwardLinearVelocity;
    private final FBVector3D yoFeedbackLinearVelocity;
    private final FBRateLimitedVector3D rateLimitedFeedbackLinearVelocity;
    private final FBVector3D yoDesiredLinearAcceleration;
    private final FBVector3D yoFeedForwardLinearAcceleration;
    private final FBVector3D yoFeedbackLinearAcceleration;
    private final FBRateLimitedVector3D rateLimitedFeedbackLinearAcceleration;
    private final FBVector3D yoAchievedLinearAcceleration;
    private final FBVector3D yoDesiredLinearForce;
    private final FBVector3D yoFeedForwardLinearForce;
    private final FBVector3D yoFeedbackLinearForce;
    private final FBRateLimitedVector3D rateLimitedFeedbackLinearForce;
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredLinearVelocity = new FrameVector3D();
    private final FrameVector3D currentLinearVelocity = new FrameVector3D();
    private final FrameVector3D currentAngularVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardLinearVelocity = new FrameVector3D();
    private final FrameVector3D desiredLinearAcceleration = new FrameVector3D();
    private final FrameVector3D feedForwardLinearForce = new FrameVector3D();
    private final FrameVector3D feedForwardLinearAcceleration = new FrameVector3D();
    private final FrameVector3D biasLinearAcceleration = new FrameVector3D();
    private final FrameVector3D achievedLinearAcceleration = new FrameVector3D();
    private final FrameVector3D desiredLinearForce = new FrameVector3D();
    private final Twist currentTwist = new Twist();
    private final SpatialAccelerationCommand inverseDynamicsOutput = new SpatialAccelerationCommand();
    private final SpatialVelocityCommand inverseKinematicsOutput = new SpatialVelocityCommand();
    private final VirtualForceCommand virtualModelControlOutput = new VirtualForceCommand();
    private final MomentumRateCommand virtualModelControlRootOutput = new MomentumRateCommand();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final YoPID3DGains gains;
    private final Matrix3D tempGainMatrix = new Matrix3D();
    private final YoSE3OffsetFrame controlFrame;
    private final RigidBodyAccelerationProvider rigidBodyAccelerationProvider;
    private RigidBodyBasics base;
    private ReferenceFrame controlBaseFrame;
    private ReferenceFrame linearGainsFrame;
    private final RigidBodyBasics rootBody;
    private final RigidBodyBasics endEffector;
    private final double dt;
    private final boolean isRootBody;
    private final boolean computeIntegralTerm;
    private final int controllerIndex;
    private int currentCommandId;
    private final FrameVector3D proportionalFeedback = new FrameVector3D();
    private final FrameVector3D derivativeFeedback = new FrameVector3D();
    private final FrameVector3D integralFeedback = new FrameVector3D();
    private final SpatialAcceleration achievedSpatialAccelerationVector = new SpatialAcceleration();

    public PointFeedbackController(RigidBodyBasics endEffector, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this(endEffector, 0, ccToolbox, fbToolbox, parentRegistry);
    }

    public PointFeedbackController(RigidBodyBasics endEffector, int controllerIndex, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this.endEffector = endEffector;
        this.controllerIndex = controllerIndex;
        FeedbackControllerSettings settings = ccToolbox.getFeedbackControllerSettings();
        this.computeIntegralTerm = settings != null ? settings.enableIntegralTerm() : true;
        if (ccToolbox.getRootJoint() != null) {
            this.rootBody = ccToolbox.getRootJoint().getSuccessor();
            this.isRootBody = this.endEffector.getName().equals(this.rootBody.getName());
        } else {
            this.isRootBody = false;
            this.rootBody = null;
        }
        this.rigidBodyAccelerationProvider = ccToolbox.getRigidBodyAccelerationProvider();
        String endEffectorName = endEffector.getName();
        this.registry = new YoRegistry(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "PointFBController");
        this.dt = ccToolbox.getControlDT();
        this.gains = fbToolbox.getOrCreatePositionGains(endEffector, controllerIndex, this.computeIntegralTerm);
        YoDouble maximumRate = this.gains.getYoMaximumFeedbackRate();
        this.controlFrame = fbToolbox.getOrCreateControlFrame(endEffector, controllerIndex);
        this.isEnabled = new YoBoolean(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "isPointFBControllerEnabled", this.registry);
        this.isEnabled.set(false);
        this.yoDesiredPosition = fbToolbox.getOrCreatePositionData(endEffector, controllerIndex, Type.DESIRED, (BooleanProvider)this.isEnabled);
        this.yoCurrentPosition = fbToolbox.getOrCreatePositionData(endEffector, controllerIndex, Type.CURRENT, (BooleanProvider)this.isEnabled);
        this.yoErrorPosition = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.POSITION, (BooleanProvider)this.isEnabled);
        this.yoErrorPositionIntegrated = this.computeIntegralTerm ? fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR_INTEGRATED, SpaceData3D.POSITION, (BooleanProvider)this.isEnabled) : null;
        this.yoDesiredLinearVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
        if (ccToolbox.isEnableInverseDynamicsModule() || ccToolbox.isEnableVirtualModelControlModule()) {
            this.yoCurrentLinearVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.CURRENT, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoErrorLinearVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            DoubleProvider breakFrequency = fbToolbox.getErrorVelocityFilterBreakFrequency(endEffectorName);
            this.yoFilteredErrorLinearVelocity = breakFrequency != null ? fbToolbox.getOrCreateAlphaFilteredVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.LINEAR_VELOCITY, this.dt, breakFrequency, (BooleanProvider)this.isEnabled) : null;
            if (ccToolbox.isEnableInverseDynamicsModule()) {
                this.yoDesiredLinearAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardLinearAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedbackLinearAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackLinearAcceleration = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_ACCELERATION, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
                this.yoAchievedLinearAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ACHIEVED, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredLinearAcceleration = null;
                this.yoFeedForwardLinearAcceleration = null;
                this.yoFeedbackLinearAcceleration = null;
                this.rateLimitedFeedbackLinearAcceleration = null;
                this.yoAchievedLinearAcceleration = null;
            }
            if (ccToolbox.isEnableVirtualModelControlModule()) {
                this.yoDesiredLinearForce = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.LINEAR_FORCE, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardLinearForce = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.LINEAR_FORCE, (BooleanProvider)this.isEnabled);
                this.yoFeedbackLinearForce = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_FORCE, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackLinearForce = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_FORCE, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredLinearForce = null;
                this.yoFeedForwardLinearForce = null;
                this.yoFeedbackLinearForce = null;
                this.rateLimitedFeedbackLinearForce = null;
            }
        } else {
            this.yoCurrentLinearVelocity = null;
            this.yoErrorLinearVelocity = null;
            this.yoFilteredErrorLinearVelocity = null;
            this.yoDesiredLinearAcceleration = null;
            this.yoFeedForwardLinearAcceleration = null;
            this.yoFeedbackLinearAcceleration = null;
            this.rateLimitedFeedbackLinearAcceleration = null;
            this.yoAchievedLinearAcceleration = null;
            this.yoDesiredLinearForce = null;
            this.yoFeedForwardLinearForce = null;
            this.yoFeedbackLinearForce = null;
            this.rateLimitedFeedbackLinearForce = null;
        }
        if (ccToolbox.isEnableInverseKinematicsModule()) {
            this.yoFeedbackLinearVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoFeedForwardLinearVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.rateLimitedFeedbackLinearVelocity = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.LINEAR_VELOCITY, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
        } else {
            this.yoFeedbackLinearVelocity = null;
            this.yoFeedForwardLinearVelocity = null;
            this.rateLimitedFeedbackLinearVelocity = null;
        }
        parentRegistry.addChild(this.registry);
    }

    public void submitFeedbackControlCommand(PointFeedbackControlCommand command) {
        if (command.getEndEffector() != this.endEffector) {
            throw new FeedbackControllerException("Wrong end effector - received: " + command.getEndEffector() + ", expected: " + this.endEffector);
        }
        this.currentCommandId = command.getCommandId();
        this.base = command.getBase();
        this.controlBaseFrame = command.getControlBaseFrame();
        this.inverseDynamicsOutput.set(command.getSpatialAccelerationCommand());
        this.gains.set((PID3DGainsReadOnly)command.getGains());
        command.getSpatialAccelerationCommand().getSelectionMatrix(this.selectionMatrix);
        this.linearGainsFrame = command.getLinearGainsFrame();
        command.getBodyFixedPointIncludingFrame(this.desiredPosition);
        this.controlFrame.setOffsetToParentToTranslationOnly((FrameTuple3DReadOnly)this.desiredPosition);
        this.yoDesiredPosition.setIncludingFrame((FrameTuple3DReadOnly)command.getReferencePosition());
        this.yoDesiredPosition.setCommandId(this.currentCommandId);
        this.yoDesiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearVelocity());
        this.yoDesiredLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
        this.yoDesiredLinearVelocity.setCommandId(this.currentCommandId);
        if (this.yoFeedForwardLinearVelocity != null) {
            this.yoFeedForwardLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearVelocity());
            this.yoFeedForwardLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
            this.yoFeedForwardLinearVelocity.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardLinearAcceleration != null) {
            this.yoFeedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearAcceleration());
            this.yoFeedForwardLinearAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
            this.yoFeedForwardLinearAcceleration.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardLinearForce != null) {
            this.yoFeedForwardLinearForce.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceForce());
            this.yoFeedForwardLinearForce.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
            this.yoFeedForwardLinearForce.setCommandId(this.currentCommandId);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    @Override
    public void initialize() {
        if (this.rateLimitedFeedbackLinearAcceleration != null) {
            this.rateLimitedFeedbackLinearAcceleration.reset();
        }
        if (this.rateLimitedFeedbackLinearVelocity != null) {
            this.rateLimitedFeedbackLinearVelocity.reset();
        }
        if (this.yoFilteredErrorLinearVelocity != null) {
            this.yoFilteredErrorLinearVelocity.reset();
        }
        if (this.yoErrorPositionIntegrated != null) {
            this.yoErrorPositionIntegrated.setToZero(worldFrame);
        }
    }

    @Override
    public void computeInverseDynamics() {
        if (!this.isEnabled()) {
            return;
        }
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearAcceleration);
        this.feedForwardLinearAcceleration.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearAcceleration.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.yoFeedbackLinearAcceleration.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearAcceleration.update();
        this.rateLimitedFeedbackLinearAcceleration.setCommandId(this.currentCommandId);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearAcceleration);
        this.desiredLinearAcceleration.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.feedForwardLinearAcceleration);
        this.yoDesiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredLinearAcceleration.changeFrame(trajectoryFrame);
        this.yoDesiredLinearAcceleration.setCommandId(this.currentCommandId);
        this.addCoriolisAcceleration(this.desiredLinearAcceleration);
        this.inverseDynamicsOutput.setLinearAcceleration((ReferenceFrame)this.controlFrame, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
    }

    @Override
    public void computeInverseKinematics() {
        if (!this.isEnabled()) {
            return;
        }
        this.inverseKinematicsOutput.setProperties(this.inverseDynamicsOutput);
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.feedForwardLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearVelocity);
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearVelocity.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoFeedbackLinearVelocity.changeFrame(trajectoryFrame);
        this.yoFeedbackLinearVelocity.setCommandId(this.currentCommandId);
        if (this.rateLimitedFeedbackLinearVelocity.getReferenceFrame() != trajectoryFrame) {
            this.rateLimitedFeedbackLinearVelocity.setReferenceFrame(trajectoryFrame);
            this.rateLimitedFeedbackLinearVelocity.reset();
        }
        this.rateLimitedFeedbackLinearVelocity.update();
        this.rateLimitedFeedbackLinearVelocity.setCommandId(this.currentCommandId);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearVelocity);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.feedForwardLinearVelocity);
        this.yoDesiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredLinearVelocity.changeFrame(trajectoryFrame);
        this.yoDesiredLinearVelocity.setCommandId(this.currentCommandId);
        this.desiredLinearVelocity.changeFrame((ReferenceFrame)this.controlFrame);
        this.inverseKinematicsOutput.setLinearVelocity((ReferenceFrame)this.controlFrame, this.desiredLinearVelocity);
    }

    @Override
    public void computeVirtualModelControl() {
        if (!this.isEnabled()) {
            return;
        }
        this.computeFeedbackForce();
        if (this.isRootBody) {
            this.desiredLinearForce.changeFrame(worldFrame);
            this.virtualModelControlRootOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlRootOutput.setLinearMomentumRate(this.desiredLinearForce);
        } else {
            this.virtualModelControlOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlOutput.setLinearForce((ReferenceFrame)this.controlFrame, this.desiredLinearForce);
        }
    }

    private void computeFeedbackForce() {
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.feedForwardLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearForce);
        this.feedForwardLinearForce.changeFrame((ReferenceFrame)this.controlFrame);
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.desiredLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearForce.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearForce);
        this.yoFeedbackLinearForce.changeFrame(trajectoryFrame);
        this.yoFeedbackLinearForce.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackLinearForce.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearForce.update();
        this.rateLimitedFeedbackLinearForce.setCommandId(this.currentCommandId);
        this.desiredLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearForce);
        this.desiredLinearForce.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.feedForwardLinearForce);
        this.yoDesiredLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearForce);
        this.yoDesiredLinearForce.changeFrame(trajectoryFrame);
        this.yoDesiredLinearForce.setCommandId(this.currentCommandId);
    }

    @Override
    public void computeAchievedAcceleration() {
        this.achievedSpatialAccelerationVector.setIncludingFrame((SpatialMotionReadOnly)this.rigidBodyAccelerationProvider.getRelativeAcceleration((RigidBodyReadOnly)this.base, (RigidBodyReadOnly)this.endEffector));
        this.achievedSpatialAccelerationVector.changeFrame((ReferenceFrame)this.controlFrame);
        this.achievedLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.achievedSpatialAccelerationVector.getLinearPart());
        this.subtractCoriolisAcceleration(this.achievedLinearAcceleration);
        this.yoAchievedLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.achievedLinearAcceleration);
        this.yoAchievedLinearAcceleration.changeFrame(this.yoDesiredPosition.getReferenceFrame());
        this.yoAchievedLinearAcceleration.setCommandId(this.currentCommandId);
    }

    private void computeProportionalTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.yoCurrentPosition.setToZero((ReferenceFrame)this.controlFrame);
        this.yoCurrentPosition.changeFrame(trajectoryFrame);
        this.yoCurrentPosition.setCommandId(this.currentCommandId);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.yoDesiredPosition);
        this.desiredPosition.changeFrame((ReferenceFrame)this.controlFrame);
        feedbackTermToPack.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPosition);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumProportionalError());
        this.yoErrorPosition.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorPosition.changeFrame(trajectoryFrame);
        this.yoErrorPosition.setCommandId(this.currentCommandId);
        if (this.linearGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.linearGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        this.gains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
    }

    private void computeDerivativeTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.yoCurrentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getLinearPart());
        this.yoCurrentLinearVelocity.changeFrame(trajectoryFrame);
        this.yoCurrentLinearVelocity.setCommandId(this.currentCommandId);
        feedbackTermToPack.setToZero(trajectoryFrame);
        feedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredLinearVelocity, (FrameTuple3DReadOnly)this.yoCurrentLinearVelocity);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumDerivativeError());
        if (this.yoFilteredErrorLinearVelocity != null) {
            if (this.yoFilteredErrorLinearVelocity.getReferenceFrame() != trajectoryFrame) {
                this.yoFilteredErrorLinearVelocity.setReferenceFrame(trajectoryFrame);
                this.yoFilteredErrorLinearVelocity.reset();
            }
            feedbackTermToPack.changeFrame(trajectoryFrame);
            this.yoErrorLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
            this.yoFilteredErrorLinearVelocity.update();
            this.yoFilteredErrorLinearVelocity.setCommandId(this.currentCommandId);
            feedbackTermToPack.set((FrameTuple3DReadOnly)this.yoFilteredErrorLinearVelocity);
        } else {
            this.yoErrorLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        }
        this.yoErrorLinearVelocity.changeFrame(trajectoryFrame);
        this.yoErrorLinearVelocity.setCommandId(this.currentCommandId);
        if (this.linearGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.linearGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        this.gains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
    }

    private void computeIntegralTerm(FrameVector3D feedbackTermToPack) {
        if (!this.computeIntegralTerm) {
            feedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            return;
        }
        double maximumIntegralError = this.gains.getMaximumIntegralError();
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        if (maximumIntegralError < 1.0E-5) {
            feedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
            this.yoErrorPositionIntegrated.setCommandId(this.currentCommandId);
            return;
        }
        if (this.yoErrorPositionIntegrated.getReferenceFrame() != trajectoryFrame) {
            this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
        }
        feedbackTermToPack.setIncludingFrame((FrameTuple3DReadOnly)this.yoErrorPosition);
        feedbackTermToPack.scale(this.dt);
        feedbackTermToPack.add((FrameTuple3DReadOnly)this.yoErrorPositionIntegrated);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(maximumIntegralError);
        this.yoErrorPositionIntegrated.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorPositionIntegrated.changeFrame(trajectoryFrame);
        this.yoErrorPositionIntegrated.setCommandId(this.currentCommandId);
        if (this.linearGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.linearGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        this.gains.getIntegralGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
    }

    private void addCoriolisAcceleration(FrameVector3D linearAccelerationToModify) {
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getAngularPart());
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getLinearPart());
        this.biasLinearAcceleration.setToZero((ReferenceFrame)this.controlFrame);
        this.biasLinearAcceleration.cross((FrameVector3DReadOnly)this.currentLinearVelocity, (FrameVector3DReadOnly)this.currentAngularVelocity);
        linearAccelerationToModify.changeFrame((ReferenceFrame)this.controlFrame);
        linearAccelerationToModify.add((FrameTuple3DReadOnly)this.biasLinearAcceleration);
    }

    private void subtractCoriolisAcceleration(FrameVector3D linearAccelerationToModify) {
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getAngularPart());
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getLinearPart());
        this.biasLinearAcceleration.setToZero((ReferenceFrame)this.controlFrame);
        this.biasLinearAcceleration.cross((FrameVector3DReadOnly)this.currentLinearVelocity, (FrameVector3DReadOnly)this.currentAngularVelocity);
        linearAccelerationToModify.changeFrame((ReferenceFrame)this.controlFrame);
        linearAccelerationToModify.sub((FrameTuple3DReadOnly)this.biasLinearAcceleration);
        linearAccelerationToModify.changeFrame(worldFrame);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public SpatialAccelerationCommand getInverseDynamicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseDynamicsOutput;
    }

    public SpatialVelocityCommand getInverseKinematicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseKinematicsOutput;
    }

    @Override
    public VirtualModelControlCommand<?> getVirtualModelControlOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.isRootBody ? this.virtualModelControlRootOutput : this.virtualModelControlOutput;
    }

    public int getControllerIndex() {
        return this.controllerIndex;
    }
}

