/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace;

import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBAlphaFilteredVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBQuaternion3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OrientationFeedbackController
implements FeedbackControllerInterface {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final YoBoolean isEnabled;
    private final FBQuaternion3D yoDesiredOrientation;
    private final FBQuaternion3D yoCurrentOrientation;
    private final FBQuaternion3D yoErrorOrientation;
    private final FBQuaternion3D yoErrorOrientationCumulated;
    private final FBVector3D yoDesiredRotationVector;
    private final FBVector3D yoCurrentRotationVector;
    private final FBVector3D yoErrorRotationVector;
    private final FBVector3D yoErrorRotationVectorIntegrated;
    private final FBVector3D yoDesiredAngularVelocity;
    private final FBVector3D yoCurrentAngularVelocity;
    private final FBVector3D yoErrorAngularVelocity;
    private final FBAlphaFilteredVector3D yoFilteredErrorAngularVelocity;
    private final FBVector3D yoFeedForwardAngularVelocity;
    private final FBVector3D yoFeedbackAngularVelocity;
    private final FBRateLimitedVector3D rateLimitedFeedbackAngularVelocity;
    private final FBVector3D yoDesiredAngularAcceleration;
    private final FBVector3D yoFeedForwardAngularAcceleration;
    private final FBVector3D yoFeedbackAngularAcceleration;
    private final FBRateLimitedVector3D rateLimitedFeedbackAngularAcceleration;
    private final FBVector3D yoAchievedAngularAcceleration;
    private final FBVector3D yoDesiredAngularTorque;
    private final FBVector3D yoFeedForwardAngularTorque;
    private final FBVector3D yoFeedbackAngularTorque;
    private final FBRateLimitedVector3D rateLimitedFeedbackAngularTorque;
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameQuaternion errorOrientationCumulated = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardAngularVelocity = new FrameVector3D();
    private final FrameVector3D desiredAngularAcceleration = new FrameVector3D();
    private final FrameVector3D feedForwardAngularAction = new FrameVector3D();
    private final FrameVector3D feedForwardAngularAcceleration = new FrameVector3D();
    private final FrameVector3D achievedAngularAcceleration = new FrameVector3D();
    private final FrameVector3D desiredAngularTorque = new FrameVector3D();
    private final Twist currentTwist = new Twist();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final SpatialAccelerationCommand inverseDynamicsOutput = new SpatialAccelerationCommand();
    private final SpatialVelocityCommand inverseKinematicsOutput = new SpatialVelocityCommand();
    private final VirtualTorqueCommand virtualModelControlOutput = new VirtualTorqueCommand();
    private final MomentumRateCommand virtualModelControlRootOutput = new MomentumRateCommand();
    private final YoPID3DGains gains;
    private final Matrix3D tempGainMatrix = new Matrix3D();
    private final RigidBodyAccelerationProvider rigidBodyAccelerationProvider;
    private RigidBodyBasics base;
    private ReferenceFrame controlBaseFrame;
    private ReferenceFrame angularGainsFrame;
    private final RigidBodyBasics rootBody;
    private final RigidBodyBasics endEffector;
    private final MovingReferenceFrame endEffectorFrame;
    private final double dt;
    private final boolean isRootBody;
    private final boolean computeIntegralTerm;
    private final int controllerIndex;
    private int currentCommandId;
    private final FrameVector3D proportionalFeedback = new FrameVector3D();
    private final FrameVector3D derivativeFeedback = new FrameVector3D();
    private final FrameVector3D integralFeedback = new FrameVector3D();

    public OrientationFeedbackController(RigidBodyBasics endEffector, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this(endEffector, 0, ccToolbox, fbToolbox, parentRegistry);
    }

    public OrientationFeedbackController(RigidBodyBasics endEffector, int controllerIndex, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this.endEffector = endEffector;
        this.controllerIndex = controllerIndex;
        FeedbackControllerSettings settings = ccToolbox.getFeedbackControllerSettings();
        this.computeIntegralTerm = settings != null ? settings.enableIntegralTerm() : true;
        if (ccToolbox.getRootJoint() != null) {
            this.rootBody = ccToolbox.getRootJoint().getSuccessor();
            this.isRootBody = this.endEffector.getName().equals(this.rootBody.getName());
        } else {
            this.isRootBody = false;
            this.rootBody = null;
        }
        this.rigidBodyAccelerationProvider = ccToolbox.getRigidBodyAccelerationProvider();
        String endEffectorName = endEffector.getName();
        this.registry = new YoRegistry(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "OrientationFBController");
        this.dt = ccToolbox.getControlDT();
        this.gains = fbToolbox.getOrCreateOrientationGains(endEffector, controllerIndex, this.computeIntegralTerm);
        YoDouble maximumRate = this.gains.getYoMaximumFeedbackRate();
        this.endEffectorFrame = endEffector.getBodyFixedFrame();
        this.isEnabled = new YoBoolean(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "IsOrientationFBControllerEnabled", this.registry);
        this.isEnabled.set(false);
        this.yoDesiredOrientation = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.DESIRED, (BooleanProvider)this.isEnabled);
        this.yoCurrentOrientation = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.CURRENT, (BooleanProvider)this.isEnabled);
        this.yoErrorOrientation = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.ERROR, (BooleanProvider)this.isEnabled);
        this.yoDesiredRotationVector = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        this.yoCurrentRotationVector = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.CURRENT, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        this.yoErrorRotationVector = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        if (this.computeIntegralTerm) {
            this.yoErrorOrientationCumulated = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.ERROR_CUMULATED, (BooleanProvider)this.isEnabled);
            this.yoErrorRotationVectorIntegrated = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR_INTEGRATED, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        } else {
            this.yoErrorOrientationCumulated = null;
            this.yoErrorRotationVectorIntegrated = null;
        }
        this.yoDesiredAngularVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.ANGULAR_VELOCITY, (BooleanProvider)this.isEnabled);
        if (ccToolbox.isEnableInverseDynamicsModule() || ccToolbox.isEnableVirtualModelControlModule()) {
            this.yoCurrentAngularVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.CURRENT, SpaceData3D.ANGULAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoErrorAngularVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.ANGULAR_VELOCITY, (BooleanProvider)this.isEnabled);
            DoubleProvider breakFrequency = fbToolbox.getErrorVelocityFilterBreakFrequency(endEffectorName);
            this.yoFilteredErrorAngularVelocity = breakFrequency != null ? fbToolbox.getOrCreateAlphaFilteredVectorData3D(endEffector, controllerIndex, Type.ERROR, SpaceData3D.ANGULAR_VELOCITY, this.dt, breakFrequency, (BooleanProvider)this.isEnabled) : null;
            if (ccToolbox.isEnableInverseDynamicsModule()) {
                this.yoDesiredAngularAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.ANGULAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardAngularAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.ANGULAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedbackAngularAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_ACCELERATION, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackAngularAcceleration = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_ACCELERATION, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
                this.yoAchievedAngularAcceleration = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ACHIEVED, SpaceData3D.ANGULAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredAngularAcceleration = null;
                this.yoFeedForwardAngularAcceleration = null;
                this.yoFeedbackAngularAcceleration = null;
                this.rateLimitedFeedbackAngularAcceleration = null;
                this.yoAchievedAngularAcceleration = null;
            }
            if (ccToolbox.isEnableVirtualModelControlModule()) {
                this.yoDesiredAngularTorque = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.ANGULAR_TORQUE, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardAngularTorque = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.ANGULAR_TORQUE, (BooleanProvider)this.isEnabled);
                this.yoFeedbackAngularTorque = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_TORQUE, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackAngularTorque = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_TORQUE, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredAngularTorque = null;
                this.yoFeedForwardAngularTorque = null;
                this.yoFeedbackAngularTorque = null;
                this.rateLimitedFeedbackAngularTorque = null;
            }
        } else {
            this.yoCurrentAngularVelocity = null;
            this.yoErrorAngularVelocity = null;
            this.yoFilteredErrorAngularVelocity = null;
            this.yoDesiredAngularAcceleration = null;
            this.yoFeedForwardAngularAcceleration = null;
            this.yoFeedbackAngularAcceleration = null;
            this.rateLimitedFeedbackAngularAcceleration = null;
            this.yoAchievedAngularAcceleration = null;
            this.yoDesiredAngularTorque = null;
            this.yoFeedForwardAngularTorque = null;
            this.yoFeedbackAngularTorque = null;
            this.rateLimitedFeedbackAngularTorque = null;
        }
        if (ccToolbox.isEnableInverseKinematicsModule()) {
            this.yoFeedbackAngularVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoFeedForwardAngularVelocity = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData3D.ANGULAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            this.rateLimitedFeedbackAngularVelocity = fbToolbox.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData3D.ANGULAR_VELOCITY, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
        } else {
            this.yoFeedbackAngularVelocity = null;
            this.yoFeedForwardAngularVelocity = null;
            this.rateLimitedFeedbackAngularVelocity = null;
        }
        parentRegistry.addChild(this.registry);
    }

    public void submitFeedbackControlCommand(OrientationFeedbackControlCommand command) {
        if (command.getEndEffector() != this.endEffector) {
            throw new FeedbackControllerException("Wrong end effector - received: " + command.getEndEffector() + ", expected: " + this.endEffector);
        }
        this.currentCommandId = command.getCommandId();
        this.base = command.getBase();
        this.controlBaseFrame = command.getControlBaseFrame();
        this.inverseDynamicsOutput.set(command.getSpatialAccelerationCommand());
        this.inverseKinematicsOutput.setProperties(command.getSpatialAccelerationCommand());
        this.virtualModelControlOutput.setProperties(command.getSpatialAccelerationCommand());
        this.gains.set((PID3DGainsReadOnly)command.getGains());
        command.getSpatialAccelerationCommand().getSelectionMatrix(this.selectionMatrix);
        this.angularGainsFrame = command.getAngularGainsFrame();
        this.yoDesiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)command.getReferenceOrientation());
        this.yoDesiredOrientation.getRotationVector((FrameVector3DBasics)this.yoDesiredRotationVector);
        this.yoDesiredOrientation.setCommandId(this.currentCommandId);
        this.yoDesiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceAngularVelocity());
        this.yoDesiredAngularVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredOrientation);
        this.yoDesiredAngularVelocity.setCommandId(this.currentCommandId);
        if (this.yoFeedForwardAngularVelocity != null) {
            this.yoFeedForwardAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceAngularVelocity());
            this.yoFeedForwardAngularVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredOrientation);
            this.yoFeedForwardAngularVelocity.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardAngularAcceleration != null) {
            this.yoFeedForwardAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceAngularAcceleration());
            this.yoFeedForwardAngularAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredOrientation);
            this.yoFeedForwardAngularAcceleration.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardAngularTorque != null) {
            this.yoFeedForwardAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceTorque());
            this.yoFeedForwardAngularTorque.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredOrientation);
            this.yoFeedForwardAngularTorque.setCommandId(this.currentCommandId);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    @Override
    public void initialize() {
        if (this.rateLimitedFeedbackAngularAcceleration != null) {
            this.rateLimitedFeedbackAngularAcceleration.reset();
        }
        if (this.rateLimitedFeedbackAngularVelocity != null) {
            this.rateLimitedFeedbackAngularVelocity.reset();
        }
        if (this.yoFilteredErrorAngularVelocity != null) {
            this.yoFilteredErrorAngularVelocity.reset();
        }
        if (this.yoErrorOrientationCumulated != null) {
            this.yoErrorOrientationCumulated.setToZero(worldFrame);
        }
        if (this.yoErrorRotationVectorIntegrated != null) {
            this.yoErrorRotationVectorIntegrated.setToZero(worldFrame);
        }
    }

    @Override
    public void computeInverseDynamics() {
        if (!this.isEnabled()) {
            return;
        }
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.feedForwardAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardAngularAcceleration);
        this.feedForwardAngularAcceleration.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredAngularAcceleration.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularAcceleration);
        this.yoFeedbackAngularAcceleration.changeFrame(trajectoryFrame);
        this.yoFeedbackAngularAcceleration.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackAngularAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackAngularAcceleration.update();
        this.rateLimitedFeedbackAngularAcceleration.setCommandId(this.currentCommandId);
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackAngularAcceleration);
        this.desiredAngularAcceleration.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.feedForwardAngularAcceleration);
        this.yoDesiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularAcceleration);
        this.yoDesiredAngularAcceleration.changeFrame(trajectoryFrame);
        this.yoDesiredAngularAcceleration.setCommandId(this.currentCommandId);
        this.inverseDynamicsOutput.setAngularAcceleration((ReferenceFrame)this.endEffectorFrame, (FrameVector3DReadOnly)this.desiredAngularAcceleration);
    }

    @Override
    public void computeInverseKinematics() {
        if (!this.isEnabled()) {
            return;
        }
        this.inverseKinematicsOutput.setProperties(this.inverseDynamicsOutput);
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        this.feedForwardAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardAngularVelocity);
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredAngularVelocity.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredAngularVelocity.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularVelocity);
        this.yoFeedbackAngularVelocity.changeFrame(trajectoryFrame);
        this.yoFeedbackAngularVelocity.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackAngularVelocity.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackAngularVelocity.update();
        this.rateLimitedFeedbackAngularVelocity.setCommandId(this.currentCommandId);
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackAngularVelocity);
        this.desiredAngularVelocity.add((FrameTuple3DReadOnly)this.feedForwardAngularVelocity);
        this.yoDesiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularVelocity);
        this.yoDesiredAngularVelocity.changeFrame(trajectoryFrame);
        this.yoDesiredAngularVelocity.setCommandId(this.currentCommandId);
        this.desiredAngularVelocity.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.inverseKinematicsOutput.setAngularVelocity((ReferenceFrame)this.endEffectorFrame, this.desiredAngularVelocity);
    }

    @Override
    public void computeVirtualModelControl() {
        if (!this.isEnabled()) {
            return;
        }
        this.computeFeedbackTorque();
        if (this.isRootBody) {
            this.desiredAngularTorque.changeFrame(worldFrame);
            this.virtualModelControlRootOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlRootOutput.setAngularMomentumRate(this.desiredAngularTorque);
        } else {
            this.virtualModelControlOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlOutput.setAngularTorque((ReferenceFrame)this.endEffectorFrame, this.desiredAngularTorque);
        }
    }

    private void computeFeedbackTorque() {
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardAngularTorque);
        this.feedForwardAngularAction.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.desiredAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredAngularTorque.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularTorque);
        this.yoFeedbackAngularTorque.changeFrame(trajectoryFrame);
        this.yoFeedbackAngularTorque.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackAngularTorque.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackAngularTorque.update();
        this.rateLimitedFeedbackAngularTorque.setCommandId(this.currentCommandId);
        this.desiredAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackAngularTorque);
        this.desiredAngularTorque.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.feedForwardAngularAction);
        this.yoDesiredAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularTorque);
        this.yoDesiredAngularTorque.changeFrame(trajectoryFrame);
        this.yoDesiredAngularTorque.setCommandId(this.currentCommandId);
    }

    @Override
    public void computeAchievedAcceleration() {
        this.achievedAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rigidBodyAccelerationProvider.getRelativeAcceleration((RigidBodyReadOnly)this.base, (RigidBodyReadOnly)this.endEffector).getAngularPart());
        this.yoAchievedAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.achievedAngularAcceleration);
        this.yoAchievedAngularAcceleration.changeFrame(this.yoDesiredOrientation.getReferenceFrame());
    }

    private void computeProportionalTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        this.yoCurrentOrientation.setToZero((ReferenceFrame)this.endEffectorFrame);
        this.yoCurrentOrientation.changeFrame(trajectoryFrame);
        this.yoCurrentOrientation.setCommandId(this.currentCommandId);
        this.yoCurrentOrientation.getRotationVector((FrameVector3DBasics)this.yoCurrentRotationVector);
        this.yoCurrentRotationVector.setCommandId(this.currentCommandId);
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.yoDesiredOrientation);
        this.desiredOrientation.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.desiredOrientation.normalizeAndLimitToPi();
        this.desiredOrientation.getRotationVector((FrameVector3DBasics)feedbackTermToPack);
        this.selectionMatrix.applyAngularSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumProportionalError());
        this.yoErrorRotationVector.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorRotationVector.changeFrame(trajectoryFrame);
        this.yoErrorRotationVector.setCommandId(this.currentCommandId);
        this.yoErrorOrientation.setRotationVectorIncludingFrame((FrameVector3DReadOnly)this.yoErrorRotationVector);
        this.yoErrorRotationVector.setCommandId(this.currentCommandId);
        if (this.angularGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.angularGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
        }
        this.gains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
    }

    public void computeDerivativeTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        this.endEffectorFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.yoCurrentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getAngularPart());
        this.yoCurrentAngularVelocity.changeFrame(trajectoryFrame);
        this.yoCurrentAngularVelocity.setCommandId(this.currentCommandId);
        feedbackTermToPack.setToZero(trajectoryFrame);
        feedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredAngularVelocity, (FrameTuple3DReadOnly)this.yoCurrentAngularVelocity);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.selectionMatrix.applyAngularSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumDerivativeError());
        if (this.yoFilteredErrorAngularVelocity != null) {
            if (this.yoFilteredErrorAngularVelocity.getReferenceFrame() != trajectoryFrame) {
                this.yoFilteredErrorAngularVelocity.setReferenceFrame(trajectoryFrame);
                this.yoFilteredErrorAngularVelocity.reset();
            }
            feedbackTermToPack.changeFrame(trajectoryFrame);
            this.yoErrorAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
            this.yoFilteredErrorAngularVelocity.update();
            this.yoFilteredErrorAngularVelocity.setCommandId(this.currentCommandId);
            feedbackTermToPack.set((FrameTuple3DReadOnly)this.yoFilteredErrorAngularVelocity);
        } else {
            this.yoErrorAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        }
        this.yoErrorAngularVelocity.changeFrame(trajectoryFrame);
        this.yoErrorAngularVelocity.setCommandId(this.currentCommandId);
        if (this.angularGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.angularGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
        }
        this.gains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
    }

    public void computeIntegralTerm(FrameVector3D feedbackTermToPack) {
        if (!this.computeIntegralTerm) {
            feedbackTermToPack.setToZero((ReferenceFrame)this.endEffectorFrame);
            return;
        }
        double maximumIntegralError = this.gains.getMaximumIntegralError();
        ReferenceFrame trajectoryFrame = this.yoDesiredOrientation.getReferenceFrame();
        if (maximumIntegralError < 1.0E-5) {
            feedbackTermToPack.setToZero((ReferenceFrame)this.endEffectorFrame);
            this.yoErrorOrientationCumulated.setToZero(trajectoryFrame);
            this.yoErrorOrientationCumulated.setCommandId(this.currentCommandId);
            this.yoErrorRotationVectorIntegrated.setToZero(trajectoryFrame);
            this.yoErrorRotationVectorIntegrated.setCommandId(this.currentCommandId);
            return;
        }
        if (this.yoErrorOrientationCumulated.getReferenceFrame() != trajectoryFrame) {
            this.yoErrorOrientationCumulated.setToZero(trajectoryFrame);
            this.yoErrorRotationVectorIntegrated.setToZero(trajectoryFrame);
        }
        this.errorOrientationCumulated.setIncludingFrame((FrameQuaternionReadOnly)this.yoErrorOrientationCumulated);
        this.errorOrientationCumulated.multiply((FrameQuaternionReadOnly)this.yoErrorOrientation);
        this.yoErrorOrientationCumulated.set((FrameQuaternionReadOnly)this.errorOrientationCumulated);
        this.yoErrorOrientationCumulated.setCommandId(this.currentCommandId);
        this.errorOrientationCumulated.normalizeAndLimitToPi();
        this.errorOrientationCumulated.getRotationVector((FrameVector3DBasics)feedbackTermToPack);
        feedbackTermToPack.scale(this.dt);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
        this.selectionMatrix.applyAngularSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(maximumIntegralError);
        this.yoErrorRotationVectorIntegrated.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorRotationVectorIntegrated.changeFrame(trajectoryFrame);
        this.yoErrorRotationVectorIntegrated.setCommandId(this.currentCommandId);
        if (this.angularGainsFrame != null) {
            feedbackTermToPack.changeFrame(this.angularGainsFrame);
        } else {
            feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
        }
        this.gains.getIntegralGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
        feedbackTermToPack.changeFrame((ReferenceFrame)this.endEffectorFrame);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public SpatialAccelerationCommand getInverseDynamicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseDynamicsOutput;
    }

    public SpatialVelocityCommand getInverseKinematicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseKinematicsOutput;
    }

    @Override
    public VirtualModelControlCommand<?> getVirtualModelControlOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.isRootBody ? this.virtualModelControlRootOutput : this.virtualModelControlOutput;
    }

    public int getControllerIndex() {
        return this.controllerIndex;
    }
}

