/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.controlModules.CenterOfPressureResolver;
import us.ihmc.commonWalkingControlModules.controllerCore.command.DesiredExternalWrenchHolder;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class PlaneContactWrenchProcessor {
    private static final boolean VISUALIZE = false;
    private final List<? extends ContactablePlaneBody> contactablePlaneBodies;
    private final CenterOfPressureResolver centerOfPressureResolver = new CenterOfPressureResolver();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Map<ContactablePlaneBody, YoDouble> normalTorques = new LinkedHashMap<ContactablePlaneBody, YoDouble>();
    private final Map<ContactablePlaneBody, YoDouble> groundReactionForceMagnitudes = new LinkedHashMap<ContactablePlaneBody, YoDouble>();
    private final Map<ContactablePlaneBody, YoFramePoint3D> centersOfPressureWorld = new LinkedHashMap<ContactablePlaneBody, YoFramePoint3D>();
    private final Map<ContactablePlaneBody, YoFramePoint2D> centersOfPressure2d = new LinkedHashMap<ContactablePlaneBody, YoFramePoint2D>();
    private final Map<ContactablePlaneBody, YoFramePoint2D> yoCops = new LinkedHashMap<ContactablePlaneBody, YoFramePoint2D>();
    private final Map<ContactablePlaneBody, FramePoint2D> cops = new LinkedHashMap<ContactablePlaneBody, FramePoint2D>();
    private final CenterOfPressureDataHolder desiredCenterOfPressureDataHolder;
    private final DesiredExternalWrenchHolder desiredExternalWrenchHolder;
    private final FramePoint3D tempCoP3d = new FramePoint3D();
    private final FrameVector3D tempForce = new FrameVector3D();

    public PlaneContactWrenchProcessor(List<? extends ContactablePlaneBody> contactablePlaneBodies, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        ArrayList<RigidBodyBasics> feet = new ArrayList<RigidBodyBasics>();
        this.contactablePlaneBodies = contactablePlaneBodies;
        for (ContactablePlaneBody contactablePlaneBody : contactablePlaneBodies) {
            feet.add(contactablePlaneBody.getRigidBody());
            String name = contactablePlaneBody.getSoleFrame().getName();
            YoDouble forceMagnitude = new YoDouble(name + "ForceMagnitude", this.registry);
            this.groundReactionForceMagnitudes.put(contactablePlaneBody, forceMagnitude);
            YoDouble normalTorque = new YoDouble(name + "NormalTorque", this.registry);
            this.normalTorques.put(contactablePlaneBody, normalTorque);
            String copName = name + "CoP";
            String listName = this.getClass().getSimpleName();
            YoFramePoint2D cop2d = new YoFramePoint2D(copName + "2d", "", contactablePlaneBody.getSoleFrame(), this.registry);
            this.centersOfPressure2d.put(contactablePlaneBody, cop2d);
            YoFramePoint3D cop = new YoFramePoint3D(copName, ReferenceFrame.getWorldFrame(), this.registry);
            this.centersOfPressureWorld.put(contactablePlaneBody, cop);
            FramePoint2D footCenter2d = new FramePoint2D(contactablePlaneBody.getSoleFrame());
            footCenter2d.setToNaN();
            this.cops.put(contactablePlaneBody, footCenter2d);
            YoFramePoint2D yoCop = new YoFramePoint2D(contactablePlaneBody.getName() + "CoP", contactablePlaneBody.getSoleFrame(), this.registry);
            yoCop.set((FrameTuple2DReadOnly)footCenter2d);
            this.yoCops.put(contactablePlaneBody, yoCop);
            if (yoGraphicsListRegistry == null) continue;
            YoGraphicPosition copViz = new YoGraphicPosition(copName, cop, 0.005, YoAppearance.Navy(), YoGraphicPosition.GraphicType.BALL);
            copViz.setVisible(false);
            yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)copViz);
            YoArtifactPosition artifact = copViz.createArtifact();
            artifact.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(listName, (Artifact)artifact);
        }
        this.desiredCenterOfPressureDataHolder = new CenterOfPressureDataHolder(feet);
        this.desiredExternalWrenchHolder = new DesiredExternalWrenchHolder(feet);
        parentRegistry.addChild(this.registry);
    }

    public void compute(Map<RigidBodyBasics, Wrench> externalWrenches) {
        for (int i = 0; i < this.contactablePlaneBodies.size(); ++i) {
            ContactablePlaneBody contactablePlaneBody = this.contactablePlaneBodies.get(i);
            FramePoint2D cop = this.cops.get(contactablePlaneBody);
            YoFramePoint2D yoCop = this.yoCops.get(contactablePlaneBody);
            cop.set((FrameTuple2DReadOnly)yoCop);
            Wrench wrench = externalWrenches.get(contactablePlaneBody.getRigidBody());
            if (wrench != null) {
                this.tempForce.setIncludingFrame((FrameTuple3DReadOnly)wrench.getLinearPart());
                double normalTorque = this.centerOfPressureResolver.resolveCenterOfPressureAndNormalTorque((FramePoint2DBasics)cop, (SpatialForceReadOnly)wrench, contactablePlaneBody.getSoleFrame());
                this.centersOfPressure2d.get(contactablePlaneBody).set((FrameTuple2DReadOnly)cop);
                this.tempCoP3d.setIncludingFrame((FrameTuple2DReadOnly)cop, 0.0);
                this.centersOfPressureWorld.get(contactablePlaneBody).setMatchingFrame((FrameTuple3DReadOnly)this.tempCoP3d);
                this.groundReactionForceMagnitudes.get(contactablePlaneBody).set(this.tempForce.length());
                this.normalTorques.get(contactablePlaneBody).set(normalTorque);
            } else {
                this.groundReactionForceMagnitudes.get(contactablePlaneBody).set(0.0);
                this.centersOfPressureWorld.get(contactablePlaneBody).setToNaN();
                cop.setToNaN();
            }
            yoCop.set((FrameTuple2DReadOnly)cop);
            this.desiredCenterOfPressureDataHolder.setCenterOfPressure((FramePoint2DReadOnly)cop, contactablePlaneBody.getRigidBody());
            this.desiredExternalWrenchHolder.setDesiredExternalWrench((WrenchReadOnly)wrench, contactablePlaneBody.getRigidBody());
        }
    }

    public void initialize() {
        for (int i = 0; i < this.contactablePlaneBodies.size(); ++i) {
            ContactablePlaneBody contactablePlaneBody = this.contactablePlaneBodies.get(i);
            this.cops.get(contactablePlaneBody).setToZero(contactablePlaneBody.getSoleFrame());
        }
    }

    public void getDesiredCenterOfPressure(ContactablePlaneBody contactablePlaneBody, FramePoint2D desiredCoPToPack) {
        YoFramePoint2D yoCop = this.yoCops.get(contactablePlaneBody);
        desiredCoPToPack.setIncludingFrame((FrameTuple2DReadOnly)yoCop);
    }

    public CenterOfPressureDataHolder getDesiredCenterOfPressureDataHolder() {
        return this.desiredCenterOfPressureDataHolder;
    }

    public DesiredExternalWrenchHolder getDesiredExternalWrenchHolder() {
        return this.desiredExternalWrenchHolder;
    }
}

