/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointVisualizer;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.CapturePointCalculator;
import us.ihmc.commonWalkingControlModules.referenceFrames.CommonHumanoidReferenceFramesVisualizer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.controllers.ControllerStateChangedListener;
import us.ihmc.robotics.lists.FrameTuple2dArrayList;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.MomentumCalculator;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusChangedListener;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class HighLevelHumanoidControllerToolbox {
    protected static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final ReferenceFrame centerOfMassFrame;
    private final FullHumanoidRobotModel fullRobotModel;
    private final CapturePointCalculator capturePointCalculator;
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final CommonHumanoidReferenceFramesVisualizer referenceFramesVisualizer;
    protected final SideDependentList<ContactableFoot> feet;
    protected final List<ContactablePlaneBody> contactableBodies;
    private final SideDependentList<YoPlaneContactState> footContactStates = new SideDependentList();
    private final SideDependentList<FrameConvexPolygon2D> defaultFootPolygons = new SideDependentList();
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver;
    protected final LinkedHashMap<ContactablePlaneBody, YoFramePoint2D> footDesiredCenterOfPressures = new LinkedHashMap();
    private final YoDouble desiredCoPAlpha;
    private final LinkedHashMap<ContactablePlaneBody, AlphaFilteredYoFramePoint2d> filteredFootDesiredCenterOfPressures = new LinkedHashMap();
    private final ArrayList<Updatable> updatables = new ArrayList();
    private final YoDouble yoTime;
    private final double controlDT;
    private final double gravity;
    private final SideDependentList<CenterOfMassReferenceFrame> handCenterOfMassFrames;
    private final SideDependentList<YoFrameVector3D> wristRawMeasuredForces;
    private final SideDependentList<YoFrameVector3D> wristRawMeasuredTorques;
    private final SideDependentList<YoFrameVector3D> wristForcesHandWeightCancelled;
    private final SideDependentList<YoFrameVector3D> wristTorquesHandWeightCancelled;
    private final SideDependentList<ReferenceFrame> wristForceSensorMeasurementFrames;
    private final Wrench wristWrenchDueToGravity = new Wrench();
    private final Wrench wristTempWrench = new Wrench();
    private final FrameVector3D tempWristForce = new FrameVector3D();
    private final FrameVector3D tempWristTorque = new FrameVector3D();
    private final SideDependentList<YoDouble> handsMass;
    private final SideDependentList<FootSwitchInterface> footSwitches;
    private final SideDependentList<ForceSensorDataReadOnly> wristForceSensors;
    private final YoDouble alphaCoPControl = new YoDouble("alphaCoPControl", this.registry);
    private final YoDouble maxAnkleTorqueCoPControl = new YoDouble("maxAnkleTorqueCoPControl", this.registry);
    private final SideDependentList<Double> xSignsForCoPControl;
    private final SideDependentList<Double> ySignsForCoPControl;
    private final double minZForceForCoPControlScaling;
    private final SideDependentList<YoFrameVector2D> yoCoPError;
    private final SideDependentList<YoDouble> yoCoPErrorMagnitude = new SideDependentList((Object)new YoDouble("leftFootCoPErrorMagnitude", this.registry), (Object)new YoDouble("rightFootCoPErrorMagnitude", this.registry));
    private final SideDependentList<YoDouble> copControlScales;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final JointBasics[] controlledJoints;
    private final OneDoFJointBasics[] controlledOneDoFJoints;
    private final SideDependentList<Wrench> handWrenches = new SideDependentList();
    private final ArrayList<ControllerFailureListener> controllerFailureListeners = new ArrayList();
    private final ArrayList<ControllerStateChangedListener> controllerStateChangedListeners = new ArrayList();
    private final ArrayList<RobotMotionStatusChangedListener> robotMotionStatusChangedListeners = new ArrayList();
    private final BipedSupportPolygons bipedSupportPolygons;
    private final SideDependentList<FrameTuple2dArrayList<FramePoint2D>> previousFootContactPoints = new SideDependentList((Object)FrameTuple2dArrayList.createFramePoint2dArrayList(), (Object)FrameTuple2dArrayList.createFramePoint2dArrayList());
    protected final YoFramePoint3D yoCapturePoint = new YoFramePoint3D("capturePoint", worldFrame, this.registry);
    private final YoDouble omega0 = new YoDouble("omega0", this.registry);
    private final MomentumCalculator momentumCalculator;
    private final YoFrameVector3D yoAngularMomentum;
    private final AlphaFilteredYoFrameVector filteredYoAngularMomentum;
    private final YoDouble totalMass = new YoDouble("TotalMass", this.registry);
    private final FramePoint2D centerOfPressure = new FramePoint2D();
    private final YoFramePoint2D yoCenterOfPressure = new YoFramePoint2D("CenterOfPressure", worldFrame, this.registry);
    private WalkingMessageHandler walkingMessageHandler;
    private final YoBoolean controllerFailed = new YoBoolean("controllerFailed", this.registry);
    private final FramePoint2D tempFootCop2d = new FramePoint2D();
    private final FramePoint3D tempFootCop = new FramePoint3D();
    private final Wrench tempFootWrench = new Wrench();
    private final FramePoint2DBasics capturePoint2d = new FramePoint2D(worldFrame);
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final Momentum robotMomentum = new Momentum();
    private final FramePoint2D localDesiredCapturePoint = new FramePoint2D();
    private final YoDouble momentumGain = new YoDouble("MomentumGain", this.registry);
    private final FramePoint2D copDesired = new FramePoint2D();
    private final FramePoint2D copActual = new FramePoint2D();
    private final FrameVector2D copError = new FrameVector2D();
    private final Wrench footWrench = new Wrench();
    private final FrameVector3D footForceVector = new FrameVector3D();
    private final YoBoolean enableHighCoPDampingForShakies = new YoBoolean("enableHighCoPDampingForShakies", this.registry);
    private final YoBoolean isCoPTrackingBad = new YoBoolean("isCoPTrackingBad", this.registry);
    private final YoDouble highCoPDampingErrorTrigger = new YoDouble("highCoPDampingErrorTrigger", this.registry);
    private final YoDouble highCoPDampingStartTime = new YoDouble("highCoPDampingStartTime", this.registry);
    private final YoDouble highCoPDampingDuration = new YoDouble("highCoPDampingDuration", this.registry);
    private final FramePoint3D tempPosition = new FramePoint3D();

    public HighLevelHumanoidControllerToolbox(FullHumanoidRobotModel fullRobotModel, CommonHumanoidReferenceFrames referenceFrames, SideDependentList<? extends FootSwitchInterface> footSwitches, SideDependentList<ForceSensorDataReadOnly> wristForceSensors, YoDouble yoTime, double gravityZ, double omega0, SideDependentList<ContactableFoot> feet, double controlDT, List<Updatable> updatables, List<ContactablePlaneBody> contactableBodies, YoGraphicsListRegistry yoGraphicsListRegistry, JointBasics ... jointsToIgnore) {
        int n;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.centerOfMassFrame = referenceFrames.getCenterOfMassFrame();
        this.bipedSupportPolygons = new BipedSupportPolygons(referenceFrames, this.registry, yoGraphicsListRegistry);
        this.footSwitches = new SideDependentList(footSwitches);
        this.wristForceSensors = wristForceSensors;
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)fullRobotModel, (ReferenceFrames)referenceFrames);
        this.capturePointCalculator = new CapturePointCalculator(this.centerOfMassFrame, fullRobotModel.getElevator());
        MathTools.checkIntervalContains((double)gravityZ, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.fullRobotModel = fullRobotModel;
        this.referenceFrames = referenceFrames;
        this.controlDT = controlDT;
        this.gravity = gravityZ;
        this.yoTime = yoTime;
        this.omega0.set(omega0);
        this.referenceFramesVisualizer = yoGraphicsListRegistry != null ? new CommonHumanoidReferenceFramesVisualizer(referenceFrames, yoGraphicsListRegistry, this.registry, new ReferenceFrame[0]) : null;
        this.feet = feet;
        this.contactableBodies = contactableBodies;
        RigidBodyBasics elevator = fullRobotModel.getElevator();
        double totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)elevator);
        this.desiredCoPAlpha = new YoDouble("desiredCoPAlpha", this.registry);
        this.desiredCoPAlpha.set(0.9);
        for (RobotSide robotSide3 : RobotSide.values) {
            ContactableFoot contactableFoot = (ContactableFoot)feet.get((Enum)robotSide3);
            ReferenceFrame soleFrame = contactableFoot.getSoleFrame();
            String namePrefix = soleFrame.getName() + "DesiredCoP";
            YoFramePoint2D yoDesiredCenterOfPressure = new YoFramePoint2D(namePrefix, soleFrame, this.registry);
            AlphaFilteredYoFramePoint2d yoFilteredDesiredCenterOfPressure = new AlphaFilteredYoFramePoint2d("filtered" + namePrefix, "", this.registry, (DoubleProvider)this.desiredCoPAlpha, (FrameTuple2DReadOnly)yoDesiredCenterOfPressure);
            this.footDesiredCenterOfPressures.put((ContactablePlaneBody)contactableFoot, yoDesiredCenterOfPressure);
            this.filteredFootDesiredCenterOfPressures.put((ContactablePlaneBody)contactableFoot, yoFilteredDesiredCenterOfPressure);
        }
        if (updatables != null) {
            this.updatables.addAll(updatables);
        }
        double coefficientOfFriction = 1.0;
        RobotSide[] robotSideArray = RobotSide.values;
        int robotSide3 = robotSideArray.length;
        for (n = 0; n < robotSide3; ++n) {
            RobotSide robotSide2 = robotSideArray[n];
            ContactableFoot contactableFoot = (ContactableFoot)feet.get((Enum)robotSide2);
            RigidBodyBasics rigidBody = contactableFoot.getRigidBody();
            YoPlaneContactState contactState = new YoPlaneContactState(contactableFoot.getSoleFrame().getName(), rigidBody, contactableFoot.getSoleFrame(), contactableFoot.getContactPoints2d(), coefficientOfFriction, this.registry);
            this.footContactStates.put((Enum)robotSide2, (Object)contactState);
            ((FrameTuple2dArrayList)this.previousFootContactPoints.get((Enum)robotSide2)).copyFromListAndTrimSize(contactableFoot.getContactPoints2d());
            FrameConvexPolygon2D defaultFootPolygon = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)contactableFoot.getContactPoints2d()));
            this.defaultFootPolygons.put((Enum)robotSide2, (Object)defaultFootPolygon);
        }
        this.controlledJoints = HighLevelHumanoidControllerToolbox.computeJointsToOptimizeFor(fullRobotModel, jointsToIgnore);
        this.controlledOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])this.controlledJoints, OneDoFJointBasics.class);
        if (yoGraphicsListRegistry != null) {
            RobotSide[] planeContactStateList = new ArrayList();
            RobotSide[] robotSide3 = RobotSide.values;
            n = robotSide3.length;
            for (int robotSide2 = 0; robotSide2 < n; ++robotSide2) {
                RobotSide robotSide4 = robotSide3[robotSide2];
                planeContactStateList.add((YoPlaneContactState)this.footContactStates.get((Enum)robotSide4));
            }
            ContactPointVisualizer contactPointVisualizer = new ContactPointVisualizer((List<? extends PlaneContactState>)planeContactStateList, yoGraphicsListRegistry, this.registry);
            this.addUpdatable(contactPointVisualizer);
        }
        this.yoCoPError = new SideDependentList();
        this.xSignsForCoPControl = new SideDependentList();
        this.ySignsForCoPControl = new SideDependentList();
        this.copControlScales = new SideDependentList();
        for (RobotSide robotSide5 : RobotSide.values()) {
            OneDoFJointBasics anklePitchJoint = fullRobotModel.getLegJoint((Enum)robotSide5, LegJointName.ANKLE_PITCH);
            OneDoFJointBasics ankleRollJoint = fullRobotModel.getLegJoint((Enum)robotSide5, LegJointName.ANKLE_ROLL);
            if (anklePitchJoint != null) {
                FrameVector3DReadOnly pitchJointAxis = anklePitchJoint.getJointAxis();
                this.xSignsForCoPControl.put((Enum)robotSide5, (Object)pitchJointAxis.getY());
            } else {
                this.xSignsForCoPControl.put((Enum)robotSide5, (Object)0.0);
            }
            if (ankleRollJoint != null) {
                FrameVector3DReadOnly rollJointAxis = ankleRollJoint.getJointAxis();
                this.ySignsForCoPControl.put((Enum)robotSide5, (Object)rollJointAxis.getY());
            } else {
                this.ySignsForCoPControl.put((Enum)robotSide5, (Object)0.0);
            }
            this.copControlScales.put((Enum)robotSide5, (Object)new YoDouble(robotSide5.getCamelCaseNameForStartOfExpression() + "CoPControlScale", this.registry));
        }
        this.minZForceForCoPControlScaling = 0.2 * totalMass * gravityZ;
        this.alphaCoPControl.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)16.0, (double)controlDT));
        this.maxAnkleTorqueCoPControl.set(10.0);
        for (RobotSide robotSide6 : RobotSide.values) {
            this.yoCoPError.put((Enum)robotSide6, (Object)new YoFrameVector2D(robotSide6.getCamelCaseNameForStartOfExpression() + "FootCoPError", ((ContactableFoot)feet.get((Enum)robotSide6)).getSoleFrame(), this.registry));
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide6);
            if (hand == null) continue;
            this.handWrenches.put((Enum)robotSide6, (Object)new Wrench());
        }
        if (wristForceSensors == null) {
            this.wristForceSensorMeasurementFrames = null;
            this.wristRawMeasuredForces = null;
            this.wristRawMeasuredTorques = null;
            this.wristForcesHandWeightCancelled = null;
            this.wristTorquesHandWeightCancelled = null;
            this.handCenterOfMassFrames = null;
            this.handsMass = null;
        } else {
            this.wristForceSensorMeasurementFrames = new SideDependentList();
            this.wristRawMeasuredForces = new SideDependentList();
            this.wristRawMeasuredTorques = new SideDependentList();
            this.wristForcesHandWeightCancelled = new SideDependentList();
            this.wristTorquesHandWeightCancelled = new SideDependentList();
            this.handCenterOfMassFrames = new SideDependentList();
            this.handsMass = new SideDependentList();
            for (RobotSide robotSide7 : RobotSide.values) {
                ForceSensorDataReadOnly wristForceSensor = (ForceSensorDataReadOnly)wristForceSensors.get((Enum)robotSide7);
                ReferenceFrame measurementFrame = wristForceSensor.getMeasurementFrame();
                RigidBodyBasics measurementLink = wristForceSensor.getMeasurementLink();
                this.wristForceSensorMeasurementFrames.put((Enum)robotSide7, (Object)measurementFrame);
                String sidePrefix = robotSide7.getCamelCaseNameForStartOfExpression();
                String namePrefix = sidePrefix + "WristSensor";
                this.wristRawMeasuredForces.put((Enum)robotSide7, (Object)new YoFrameVector3D(namePrefix + "Force", measurementFrame, this.registry));
                this.wristRawMeasuredTorques.put((Enum)robotSide7, (Object)new YoFrameVector3D(namePrefix + "Torque", measurementFrame, this.registry));
                this.wristForcesHandWeightCancelled.put((Enum)robotSide7, (Object)new YoFrameVector3D(namePrefix + "ForceHandWeightCancelled", measurementFrame, this.registry));
                this.wristTorquesHandWeightCancelled.put((Enum)robotSide7, (Object)new YoFrameVector3D(namePrefix + "TorqueHandWeightCancelled", measurementFrame, this.registry));
                CenterOfMassReferenceFrame handCoMFrame = new CenterOfMassReferenceFrame(sidePrefix + "HandCoMFrame", measurementFrame, (RigidBodyReadOnly)measurementLink);
                this.handCenterOfMassFrames.put((Enum)robotSide7, (Object)handCoMFrame);
                YoDouble handMass = new YoDouble(sidePrefix + "HandTotalMass", this.registry);
                this.handsMass.put((Enum)robotSide7, (Object)handMass);
                handMass.set(TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)measurementLink));
            }
        }
        String graphicListName = this.getClass().getSimpleName();
        if (yoGraphicsListRegistry != null) {
            YoArtifactPosition copViz = new YoArtifactPosition("Controller CoP", this.yoCenterOfPressure.getYoX(), this.yoCenterOfPressure.getYoY(), YoGraphicPosition.GraphicType.DIAMOND, Color.BLACK, 0.005);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)copViz);
        }
        this.yoCenterOfPressure.setToNaN();
        this.totalMass.set(totalMass);
        this.momentumCalculator = new MomentumCalculator(fullRobotModel.getElevator().subtreeArray());
        this.yoAngularMomentum = new YoFrameVector3D("AngularMomentum", this.centerOfMassFrame, this.registry);
        YoDouble alpha = new YoDouble("filteredAngularMomentumAlpha", this.registry);
        alpha.set(0.95);
        this.filteredYoAngularMomentum = new AlphaFilteredYoFrameVector("filteredAngularMomentum", "", this.registry, (DoubleProvider)alpha, (FrameTuple3DReadOnly)this.yoAngularMomentum);
        this.momentumGain.set(0.0);
        this.attachControllerFailureListener(fallingDirection -> this.controllerFailed.set(true));
    }

    public static JointBasics[] computeJointsToOptimizeFor(FullHumanoidRobotModel fullRobotModel, JointBasics ... jointsToRemove) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        JointBasics[] allJoints = MultiBodySystemTools.collectSupportAndSubtreeJoints((RigidBodyBasics)fullRobotModel.getRootJoint().getSuccessor());
        joints.addAll(Arrays.asList(allJoints));
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
            if (hand == null) continue;
            List<JointBasics> fingerJoints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{hand}));
            joints.removeAll(fingerJoints);
        }
        if (jointsToRemove != null) {
            for (RobotSide robotSide : jointsToRemove) {
                joints.remove(robotSide);
            }
        }
        return joints.toArray(new JointBasics[joints.size()]);
    }

    public SideDependentList<YoPlaneContactState> getFootContactStates() {
        return this.footContactStates;
    }

    public void update() {
        this.referenceFrames.updateFrames();
        if (this.referenceFramesVisualizer != null) {
            this.referenceFramesVisualizer.update();
        }
        this.computeCop();
        this.computeCapturePoint();
        this.updateBipedSupportPolygons();
        this.readWristSensorData();
        this.computeAngularMomentum();
        for (int i = 0; i < this.updatables.size(); ++i) {
            this.updatables.get(i).update(this.yoTime.getDoubleValue());
        }
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).updateCoP();
        }
    }

    private void computeCop() {
        double force = 0.0;
        this.centerOfPressure.setToZero(worldFrame);
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).computeAndPackCoP(this.tempFootCop2d);
            if (this.tempFootCop2d.containsNaN()) continue;
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).computeAndPackFootWrench(this.tempFootWrench);
            double footForce = this.tempFootWrench.getLinearPartZ();
            force += footForce;
            this.tempFootCop.setIncludingFrame(this.tempFootCop2d.getReferenceFrame(), this.tempFootCop2d.getX(), this.tempFootCop2d.getY(), 0.0);
            this.tempFootCop.changeFrame(worldFrame);
            this.tempFootCop.scale(footForce);
            this.centerOfPressure.add(this.tempFootCop.getX(), this.tempFootCop.getY());
        }
        this.centerOfPressure.scale(1.0 / force);
        this.yoCenterOfPressure.set((FrameTuple2DReadOnly)this.centerOfPressure);
    }

    public void updateBipedSupportPolygons() {
        this.bipedSupportPolygons.updateUsingContactStates(this.footContactStates);
    }

    private void computeCapturePoint() {
        this.capturePointCalculator.compute(this.capturePoint2d, this.omega0.getValue());
        this.capturePoint2d.changeFrame(this.yoCapturePoint.getReferenceFrame());
        this.yoCapturePoint.set((FrameTuple2DReadOnly)this.capturePoint2d, 0.0);
    }

    public CenterOfMassJacobian getCenterOfMassJacobian() {
        return this.capturePointCalculator.getCenterOfMassJacobian();
    }

    private void computeAngularMomentum() {
        this.robotMomentum.setToZero(this.centerOfMassFrame);
        this.momentumCalculator.computeAndPack(this.robotMomentum);
        this.angularMomentum.setIncludingFrame((FrameTuple3DReadOnly)this.robotMomentum.getAngularPart());
        this.yoAngularMomentum.set((FrameTuple3DReadOnly)this.angularMomentum);
        this.filteredYoAngularMomentum.update();
    }

    public void getAdjustedDesiredCapturePoint(FramePoint2DReadOnly desiredCapturePoint, FramePoint2DBasics adjustedDesiredCapturePointToPack) {
        this.angularMomentum.set((FrameTuple3DReadOnly)this.filteredYoAngularMomentum);
        ReferenceFrame comFrame = this.angularMomentum.getReferenceFrame();
        this.localDesiredCapturePoint.setIncludingFrame((FrameTuple2DReadOnly)desiredCapturePoint);
        this.localDesiredCapturePoint.changeFrameAndProjectToXYPlane(comFrame);
        double scaleFactor = this.momentumGain.getDoubleValue() * this.omega0.getDoubleValue() / (this.totalMass.getDoubleValue() * this.gravity);
        adjustedDesiredCapturePointToPack.setIncludingFrame(comFrame, -this.angularMomentum.getY(), this.angularMomentum.getX());
        adjustedDesiredCapturePointToPack.scale(scaleFactor);
        adjustedDesiredCapturePointToPack.add((FrameTuple2DReadOnly)this.localDesiredCapturePoint);
        adjustedDesiredCapturePointToPack.changeFrameAndProjectToXYPlane(desiredCapturePoint.getReferenceFrame());
    }

    public void getCapturePoint(FixedFramePoint2DBasics capturePointToPack) {
        capturePointToPack.set((FrameTuple3DReadOnly)this.yoCapturePoint);
    }

    public FramePoint3DReadOnly getCapturePoint() {
        return this.yoCapturePoint;
    }

    public void getCapturePoint(FixedFramePoint3DBasics capturePointToPack) {
        capturePointToPack.setMatchingFrame((FrameTuple3DReadOnly)this.yoCapturePoint);
    }

    public boolean estimateIfHighCoPDampingNeeded(SideDependentList<FramePoint2D> desiredCoPs) {
        boolean isCoPDampened;
        if (!this.enableHighCoPDampingForShakies.getBooleanValue()) {
            return false;
        }
        boolean atLeastOneFootWithBadCoPControl = false;
        for (RobotSide robotSide : RobotSide.values) {
            ContactablePlaneBody contactablePlaneBody = (ContactablePlaneBody)this.feet.get((Enum)robotSide);
            ReferenceFrame planeFrame = contactablePlaneBody.getSoleFrame();
            this.copDesired.setIncludingFrame((FrameTuple2DReadOnly)desiredCoPs.get((Enum)robotSide));
            if (this.copDesired.containsNaN()) {
                ((YoFrameVector2D)this.yoCoPError.get((Enum)robotSide)).setToZero();
                ((YoDouble)this.yoCoPErrorMagnitude.get((Enum)robotSide)).set(0.0);
            }
            FootSwitchInterface footSwitch = (FootSwitchInterface)this.footSwitches.get((Enum)robotSide);
            footSwitch.computeAndPackCoP(this.copActual);
            if (this.copActual.containsNaN()) {
                ((YoFrameVector2D)this.yoCoPError.get((Enum)robotSide)).setToZero();
                ((YoDouble)this.yoCoPErrorMagnitude.get((Enum)robotSide)).set(0.0);
            }
            this.copError.setToZero(planeFrame);
            this.copError.sub((FrameTuple2DReadOnly)this.copDesired, (FrameTuple2DReadOnly)this.copActual);
            ((YoFrameVector2D)this.yoCoPError.get((Enum)robotSide)).set((FrameTuple2DReadOnly)this.copError);
            ((YoDouble)this.yoCoPErrorMagnitude.get((Enum)robotSide)).set(this.copError.length());
            footSwitch.computeAndPackFootWrench(this.footWrench);
            this.footForceVector.setIncludingFrame((FrameTuple3DReadOnly)this.footWrench.getLinearPart());
            this.footForceVector.changeFrame(ReferenceFrame.getWorldFrame());
            if (!(this.footForceVector.getZ() > this.minZForceForCoPControlScaling) || !(((YoDouble)this.yoCoPErrorMagnitude.get((Enum)robotSide)).getDoubleValue() > this.highCoPDampingErrorTrigger.getDoubleValue())) continue;
            atLeastOneFootWithBadCoPControl = true;
        }
        this.isCoPTrackingBad.set(atLeastOneFootWithBadCoPControl);
        boolean bl = isCoPDampened = this.yoTime.getDoubleValue() - this.highCoPDampingStartTime.getDoubleValue() <= this.highCoPDampingDuration.getDoubleValue();
        if (atLeastOneFootWithBadCoPControl && !isCoPDampened) {
            this.highCoPDampingStartTime.set(this.yoTime.getDoubleValue());
            isCoPDampened = true;
        }
        return isCoPDampened;
    }

    public void setHighCoPDampingParameters(boolean enable, double duration, double copErrorThreshold) {
        this.enableHighCoPDampingForShakies.set(enable);
        this.highCoPDampingDuration.set(duration);
        this.highCoPDampingErrorTrigger.set(copErrorThreshold);
    }

    public void addUpdatable(Updatable updatable) {
        this.updatables.add(updatable);
    }

    public void addUpdatables(List<Updatable> updatables) {
        for (int i = 0; i < updatables.size(); ++i) {
            this.updatables.add(updatables.get(i));
        }
    }

    public void initialize() {
        this.update();
        for (RobotSide robotSide : RobotSide.values) {
            ((YoPlaneContactState)this.footContactStates.get((Enum)robotSide)).notifyContactStateHasChanged();
        }
    }

    private void readWristSensorData() {
        if (this.wristForceSensors == null) {
            return;
        }
        for (RobotSide robotSide : RobotSide.values) {
            ForceSensorDataReadOnly wristForceSensor = (ForceSensorDataReadOnly)this.wristForceSensors.get((Enum)robotSide);
            ReferenceFrame measurementFrame = wristForceSensor.getMeasurementFrame();
            wristForceSensor.getWrench(this.wristTempWrench);
            this.tempWristForce.setIncludingFrame((FrameTuple3DReadOnly)this.wristTempWrench.getLinearPart());
            this.tempWristTorque.setIncludingFrame((FrameTuple3DReadOnly)this.wristTempWrench.getAngularPart());
            ((YoFrameVector3D)this.wristRawMeasuredForces.get((Enum)robotSide)).setMatchingFrame((FrameTuple3DReadOnly)this.tempWristForce);
            ((YoFrameVector3D)this.wristRawMeasuredTorques.get((Enum)robotSide)).setMatchingFrame((FrameTuple3DReadOnly)this.tempWristTorque);
            this.cancelHandWeight(robotSide, this.wristTempWrench, measurementFrame);
            this.tempWristForce.setIncludingFrame((FrameTuple3DReadOnly)this.wristTempWrench.getLinearPart());
            this.tempWristTorque.setIncludingFrame((FrameTuple3DReadOnly)this.wristTempWrench.getAngularPart());
            ((YoFrameVector3D)this.wristForcesHandWeightCancelled.get((Enum)robotSide)).setMatchingFrame((FrameTuple3DReadOnly)this.tempWristForce);
            ((YoFrameVector3D)this.wristTorquesHandWeightCancelled.get((Enum)robotSide)).setMatchingFrame((FrameTuple3DReadOnly)this.tempWristTorque);
        }
    }

    private void cancelHandWeight(RobotSide robotSide, Wrench wrenchToSubstractHandWeightTo, ReferenceFrame measurementFrame) {
        CenterOfMassReferenceFrame handCoMFrame = (CenterOfMassReferenceFrame)this.handCenterOfMassFrames.get((Enum)robotSide);
        handCoMFrame.update();
        this.tempWristForce.setIncludingFrame(worldFrame, 0.0, 0.0, -((YoDouble)this.handsMass.get((Enum)robotSide)).getDoubleValue() * this.gravity);
        this.tempWristForce.changeFrame((ReferenceFrame)handCoMFrame);
        this.wristWrenchDueToGravity.setToZero(measurementFrame, (ReferenceFrame)handCoMFrame);
        this.wristWrenchDueToGravity.getLinearPart().set((FrameTuple3DReadOnly)this.tempWristForce);
        this.wristWrenchDueToGravity.changeFrame(measurementFrame);
        wrenchToSubstractHandWeightTo.sub((WrenchReadOnly)this.wristWrenchDueToGravity);
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getName();
    }

    public void setDesiredCenterOfPressure(ContactablePlaneBody contactablePlaneBody, FramePoint2DReadOnly desiredCoP) {
        YoFramePoint2D cop = this.footDesiredCenterOfPressures.get(contactablePlaneBody);
        if (cop != null) {
            cop.set((FrameTuple2DReadOnly)desiredCoP);
            if (!cop.containsNaN()) {
                this.filteredFootDesiredCenterOfPressures.get(contactablePlaneBody).update();
            } else {
                this.filteredFootDesiredCenterOfPressures.get(contactablePlaneBody).reset();
            }
        }
    }

    public void getDesiredCenterOfPressure(ContactablePlaneBody contactablePlaneBody, FramePoint2D desiredCoPToPack) {
        desiredCoPToPack.setIncludingFrame((FrameTuple2DReadOnly)this.footDesiredCenterOfPressures.get(contactablePlaneBody));
    }

    public void getFilteredDesiredCenterOfPressure(ContactablePlaneBody contactablePlaneBody, FramePoint2D desiredCoPToPack) {
        desiredCoPToPack.setIncludingFrame((FrameTuple2DReadOnly)this.filteredFootDesiredCenterOfPressures.get(contactablePlaneBody));
    }

    public void updateContactPointsForUpcomingFootstep(Footstep nextFootstep) {
        RobotSide robotSide = nextFootstep.getRobotSide();
        List predictedContactPoints = nextFootstep.getPredictedContactPoints();
        if (predictedContactPoints != null && !predictedContactPoints.isEmpty()) {
            this.setFootPlaneContactPoints(robotSide, predictedContactPoints);
        } else {
            this.resetFootPlaneContactPoint(robotSide);
        }
    }

    public void resetFootPlaneContactPoint(RobotSide robotSide) {
        ContactablePlaneBody foot = (ContactablePlaneBody)this.feet.get((Enum)robotSide);
        YoPlaneContactState footContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        List defaultContactPoints = foot.getContactPoints2d();
        ((FrameTuple2dArrayList)this.previousFootContactPoints.get((Enum)robotSide)).copyFromListAndTrimSize(defaultContactPoints);
        footContactState.setContactFramePoints(defaultContactPoints);
    }

    private void setFootPlaneContactPoints(RobotSide robotSide, List<Point2D> predictedContactPoints) {
        YoPlaneContactState footContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        footContactState.getContactFramePoint2dsInContact((List)this.previousFootContactPoints.get((Enum)robotSide));
        footContactState.setContactPoints(predictedContactPoints);
    }

    public void restorePreviousFootContactPoints(RobotSide robotSide) {
        YoPlaneContactState footContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        footContactState.setContactFramePoints((List)this.previousFootContactPoints.get((Enum)robotSide));
    }

    public void setFootContactCoefficientOfFriction(RobotSide robotSide, double coefficientOfFriction) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setCoefficientOfFriction(coefficientOfFriction);
    }

    public void setFootContactStateNormalContactVector(RobotSide robotSide, FrameVector3D normalContactVector) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setContactNormalVector((FrameVector3DReadOnly)normalContactVector);
    }

    public void setFootContactState(RobotSide robotSide, boolean[] newContactPointStates, FrameVector3D normalContactVector) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setContactPointsInContact(newContactPointStates);
        yoPlaneContactState.setContactNormalVector((FrameVector3DReadOnly)normalContactVector);
    }

    public void setFootContactStateFullyConstrained(RobotSide robotSide) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setFullyConstrained();
    }

    public void setFootContactStateFree(RobotSide robotSide) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        if (yoPlaneContactState != null) {
            yoPlaneContactState.clear();
        }
    }

    public ReferenceFrame getCenterOfMassFrame() {
        return this.centerOfMassFrame;
    }

    public ReferenceFrame getPelvisZUpFrame() {
        return this.referenceFrames.getPelvisZUpFrame();
    }

    public CommonHumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public YoDouble getYoTime() {
        return this.yoTime;
    }

    public double getGravityZ() {
        return this.gravity;
    }

    public double getControlDT() {
        return this.controlDT;
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public SideDependentList<ContactableFoot> getContactableFeet() {
        return this.feet;
    }

    public List<? extends ContactablePlaneBody> getContactablePlaneBodies() {
        return this.contactableBodies;
    }

    public ContactablePlaneBody getContactableBody(RigidBodyBasics body) {
        for (ContactablePlaneBody contactableBody : this.contactableBodies) {
            if (!contactableBody.getRigidBody().getName().equals(body.getName())) continue;
            return contactableBody;
        }
        return null;
    }

    public YoPlaneContactState getFootContactState(RobotSide robotSide) {
        return (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
    }

    public void clearContacts() {
        for (RobotSide robotSide : RobotSide.values) {
            ((YoPlaneContactState)this.footContactStates.get((Enum)robotSide)).clear();
        }
    }

    public SideDependentList<FootSwitchInterface> getFootSwitches() {
        return this.footSwitches;
    }

    public SideDependentList<ForceSensorDataReadOnly> getWristForceSensors() {
        return this.wristForceSensors;
    }

    public ForceSensorDataReadOnly getWristForceSensor(RobotSide robotSide) {
        if (this.wristForceSensors != null) {
            return (ForceSensorDataReadOnly)this.wristForceSensors.get((Enum)robotSide);
        }
        return null;
    }

    public BipedSupportPolygons getBipedSupportPolygons() {
        return this.bipedSupportPolygons;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public JointBasics[] getControlledJoints() {
        return this.controlledJoints;
    }

    public OneDoFJointBasics[] getControlledOneDoFJoints() {
        return this.controlledOneDoFJoints;
    }

    public YoBoolean getControllerFailedBoolean() {
        return this.controllerFailed;
    }

    public void attachControllerFailureListener(ControllerFailureListener listener) {
        this.controllerFailureListeners.add(listener);
    }

    public void reportControllerFailureToListeners(FrameVector2D fallingDirection) {
        for (int i = 0; i < this.controllerFailureListeners.size(); ++i) {
            this.controllerFailureListeners.get(i).controllerFailed(fallingDirection);
        }
    }

    public void attachControllerStateChangedListener(ControllerStateChangedListener listener) {
        this.controllerStateChangedListeners.add(listener);
    }

    public void attachControllerStateChangedListeners(List<ControllerStateChangedListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.attachControllerStateChangedListener(listeners.get(i));
        }
    }

    public void reportControllerStateChangeToListeners(Enum<?> oldState, Enum<?> newState) {
        for (int i = 0; i < this.controllerStateChangedListeners.size(); ++i) {
            this.controllerStateChangedListeners.get(i).controllerStateHasChanged(oldState, newState);
        }
    }

    public void attachRobotMotionStatusChangedListener(RobotMotionStatusChangedListener listener) {
        this.robotMotionStatusChangedListeners.add(listener);
    }

    public void detachRobotMotionStatusChangedListener(RobotMotionStatusChangedListener listener) {
        this.robotMotionStatusChangedListeners.remove(listener);
    }

    public void reportChangeOfRobotMotionStatus(RobotMotionStatus newStatus) {
        for (int i = 0; i < this.robotMotionStatusChangedListeners.size(); ++i) {
            this.robotMotionStatusChangedListeners.get(i).robotMotionStatusHasChanged(newStatus, this.yoTime.getDoubleValue());
        }
    }

    public void getWristRawMeasuredWrench(Wrench wrenchToPack, RobotSide robotSide) {
        if (this.wristRawMeasuredForces == null || this.wristRawMeasuredTorques == null) {
            return;
        }
        this.tempWristForce.setIncludingFrame((FrameTuple3DReadOnly)this.wristRawMeasuredForces.get((Enum)robotSide));
        this.tempWristTorque.setIncludingFrame((FrameTuple3DReadOnly)this.wristRawMeasuredTorques.get((Enum)robotSide));
        ReferenceFrame measurementFrames = (ReferenceFrame)this.wristForceSensorMeasurementFrames.get((Enum)robotSide);
        wrenchToPack.setToZero(measurementFrames, measurementFrames);
        wrenchToPack.getLinearPart().set((FrameTuple3DReadOnly)this.tempWristForce);
        wrenchToPack.getAngularPart().set((FrameTuple3DReadOnly)this.tempWristTorque);
    }

    public void getWristMeasuredWrenchHandWeightCancelled(Wrench wrenchToPack, RobotSide robotSide) {
        if (this.wristForcesHandWeightCancelled == null || this.wristTorquesHandWeightCancelled == null) {
            return;
        }
        this.tempWristForce.setIncludingFrame((FrameTuple3DReadOnly)this.wristForcesHandWeightCancelled.get((Enum)robotSide));
        this.tempWristTorque.setIncludingFrame((FrameTuple3DReadOnly)this.wristTorquesHandWeightCancelled.get((Enum)robotSide));
        ReferenceFrame measurementFrames = (ReferenceFrame)this.wristForceSensorMeasurementFrames.get((Enum)robotSide);
        wrenchToPack.setToZero(measurementFrames, measurementFrames);
        wrenchToPack.getLinearPart().set((FrameTuple3DReadOnly)this.tempWristForce);
        wrenchToPack.getAngularPart().set((FrameTuple3DReadOnly)this.tempWristTorque);
    }

    public void getDefaultFootPolygon(RobotSide robotSide, FrameConvexPolygon2D polygonToPack) {
        polygonToPack.set((FrameConvexPolygon2D)this.defaultFootPolygons.get((Enum)robotSide));
    }

    public SideDependentList<FrameConvexPolygon2D> getDefaultFootPolygons() {
        return this.defaultFootPolygons;
    }

    public void resetFootSupportPolygon(RobotSide robotSide) {
        YoPlaneContactState contactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        List<YoContactPoint> contactPoints = contactState.getContactPoints();
        FrameConvexPolygon2D defaultSupportPolygon = (FrameConvexPolygon2D)this.defaultFootPolygons.get((Enum)robotSide);
        for (int i = 0; i < defaultSupportPolygon.getNumberOfVertices(); ++i) {
            this.tempPosition.setIncludingFrame((FrameTuple2DReadOnly)defaultSupportPolygon.getVertex(i), 0.0);
            contactPoints.get(i).setMatchingFrame((FrameTuple3DReadOnly)this.tempPosition);
        }
        contactState.notifyContactStateHasChanged();
    }

    public double getOmega0() {
        return this.omega0.getDoubleValue();
    }

    public YoDouble getOmega0Provider() {
        return this.omega0;
    }

    public void getCoP(FramePoint3D copToPack) {
        copToPack.setIncludingFrame((FrameTuple2DReadOnly)this.yoCenterOfPressure, 0.0);
    }

    public void getCoP(FramePoint2D copToPack) {
        copToPack.setIncludingFrame((FrameTuple2DReadOnly)this.yoCenterOfPressure);
    }

    public void getAngularMomentum(FrameVector3D upperBodyAngularMomentumToPack) {
        upperBodyAngularMomentumToPack.setIncludingFrame((FrameTuple3DReadOnly)this.angularMomentum);
    }

    public ReferenceFrameHashCodeResolver getReferenceFrameHashCodeResolver() {
        return this.referenceFrameHashCodeResolver;
    }

    public void setWalkingMessageHandler(WalkingMessageHandler walkingMessageHandler) {
        this.walkingMessageHandler = walkingMessageHandler;
    }

    public WalkingMessageHandler getWalkingMessageHandler() {
        return this.walkingMessageHandler;
    }
}

