/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.screwTheory.ScrewTools;

public class GeometricJacobianHolder {
    public static final int NULL_JACOBIAN_ID = 0;
    private final TIntObjectHashMap<GeometricJacobian> hashCodeToJacobianMap = new TIntObjectHashMap();
    private final List<GeometricJacobian> geometricJacobians = new ArrayList<GeometricJacobian>();
    private final JointBasics[] temporaryToStoreJointPath = new JointBasics[30];

    public void compute() {
        for (int i = 0; i < this.geometricJacobians.size(); ++i) {
            this.geometricJacobians.get(i).compute();
        }
    }

    public int getOrCreateGeometricJacobian(RigidBodyBasics ancestor, RigidBodyBasics descendant, ReferenceFrame jacobianFrame) {
        int numberOfJoints = ScrewTools.createJointPath((JointBasics[])this.temporaryToStoreJointPath, (RigidBodyBasics)ancestor, (RigidBodyBasics)descendant);
        return this.getOrCreateGeometricJacobian(this.temporaryToStoreJointPath, numberOfJoints, jacobianFrame);
    }

    public int getOrCreateGeometricJacobian(JointBasics[] joints, ReferenceFrame jacobianFrame) {
        return this.getOrCreateGeometricJacobian(joints, joints.length, jacobianFrame);
    }

    private int getOrCreateGeometricJacobian(JointBasics[] joints, int numberOfJointsToConsider, ReferenceFrame jacobianFrame) {
        if (joints == null || numberOfJointsToConsider == 0) {
            return 0;
        }
        boolean allowChangeFrame = false;
        int jacobianId = ScrewTools.computeGeometricJacobianHashCode((JointBasics[])joints, (int)0, (int)(numberOfJointsToConsider - 1), (ReferenceFrame)jacobianFrame, (boolean)allowChangeFrame);
        GeometricJacobian jacobian = this.getJacobian(jacobianId);
        if (jacobian == null) {
            if (joints.length == numberOfJointsToConsider) {
                jacobian = new GeometricJacobian(joints, jacobianFrame, allowChangeFrame);
            } else {
                JointBasics[] jointsForNewJacobian = new JointBasics[numberOfJointsToConsider];
                System.arraycopy(joints, 0, jointsForNewJacobian, 0, numberOfJointsToConsider);
                jacobian = new GeometricJacobian(jointsForNewJacobian, jacobianFrame, allowChangeFrame);
            }
            jacobian.compute();
            this.geometricJacobians.add(jacobian);
            this.hashCodeToJacobianMap.put(jacobian.hashCode(), (Object)jacobian);
        }
        return jacobian.hashCode();
    }

    public GeometricJacobian getJacobian(int jacobianId) {
        if (jacobianId == 0) {
            return null;
        }
        return (GeometricJacobian)this.hashCodeToJacobianMap.get(jacobianId);
    }
}

