/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactPointForceViewer {
    private final YoFramePoint3D position;
    private final YoFrameVector3D magnitude;
    private final YoFrameVector3D[] basisMagnitudes;

    public ContactPointForceViewer(String prefix, int numberOfBasisVectors, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.position = new YoFramePoint3D(prefix + "ContactPosition", ReferenceFrame.getWorldFrame(), registry);
        this.magnitude = new YoFrameVector3D(prefix + "ContactAcceleration", ReferenceFrame.getWorldFrame(), registry);
        this.basisMagnitudes = new YoFrameVector3D[numberOfBasisVectors];
        for (int i = 0; i < numberOfBasisVectors; ++i) {
            this.basisMagnitudes[i] = new YoFrameVector3D(prefix + "ContactBasisMagnitude" + i, ReferenceFrame.getWorldFrame(), registry);
            YoGraphicVector basisVis = new YoGraphicVector(prefix + "BasisForce" + i, this.position, this.basisMagnitudes[i], 0.05, YoAppearance.Green());
            graphicsListRegistry.registerYoGraphic("ContactForce", (YoGraphic)basisVis);
        }
        YoGraphicVector vis = new YoGraphicVector(prefix + "ContactForce", this.position, this.magnitude, 0.05, YoAppearance.Red());
        graphicsListRegistry.registerYoGraphic("ContactForce", (YoGraphic)vis);
    }

    public void reset() {
        this.position.setToNaN();
        this.magnitude.setToNaN();
    }

    public void update(FramePoint3DReadOnly position, FrameVector3DReadOnly magnitude, FrameVector3DReadOnly[] basisMagnitudes) {
        int i;
        this.position.setMatchingFrame((FrameTuple3DReadOnly)position);
        this.magnitude.setMatchingFrame((FrameTuple3DReadOnly)magnitude);
        for (i = 0; i < basisMagnitudes.length; ++i) {
            this.basisMagnitudes[i].setMatchingFrame((FrameTuple3DReadOnly)basisMagnitudes[i]);
        }
        while (i < this.basisMagnitudes.length) {
            this.basisMagnitudes[i].setToNaN();
            ++i;
        }
    }
}

