/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BagOfVectors {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double DEFAULT_VECTOR_SIZE = 0.01;
    private static final double DEFAULT_BALL_SIZE = 0.01;
    private static final int DEFAULT_NUMBER_OF_VECTORS = 50;
    private static final String DEFAULT_NAME = "BagOfVectors";
    private static final AppearanceDefinition DEFAULT_COLOR = YoAppearance.Black();
    private final ArrayList<YoGraphicVector> yoGraphicVectors = new ArrayList();
    private final ArrayList<YoGraphicPosition> yoGraphicPositions = new ArrayList();
    private int index;
    private boolean outOfVectorsWarning = false;
    private YoGraphicsList yoGraphicsList;
    private ArtifactList artifactList;

    public BagOfVectors(YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(50, 0.01, 0.01, DEFAULT_NAME, DEFAULT_COLOR, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(int numberOfVectors, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfVectors, 0.01, 0.01, DEFAULT_NAME, DEFAULT_COLOR, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(int numberOfVectors, double vectorSizeInMeters, double ballSizeInMeters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfVectors, vectorSizeInMeters, ballSizeInMeters, DEFAULT_NAME, DEFAULT_COLOR, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(int numberOfVectors, double vectorSizeInMeters, double ballSizeInMeters, String name, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfVectors, vectorSizeInMeters, ballSizeInMeters, name, DEFAULT_COLOR, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(int numberOfVectors, double vectorSizeInMeters, double ballSizeInMeters, AppearanceDefinition appearance, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfVectors, vectorSizeInMeters, ballSizeInMeters, DEFAULT_NAME, appearance, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(int numberOfVectors, double vectorSizeInMeters, double ballSizeInMeters, String name, AppearanceDefinition appearance, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(vectorSizeInMeters, ballSizeInMeters, name, BagOfVectors.toList(appearance, numberOfVectors), parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfVectors(double vectorSizeInMeters, double pointSizeInMeters, String name, List<AppearanceDefinition> appearances, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        YoRegistry registry = new YoRegistry(name + "Vectors");
        for (int i = 0; i < appearances.size(); ++i) {
            YoFramePoint3D yoFramePoint = new YoFramePoint3D(name + i, "Point", worldFrame, registry);
            YoFrameVector3D yoFrameVector = new YoFrameVector3D(name + i, "Vector", worldFrame, registry);
            YoGraphicVector newVector = new YoGraphicVector(name + i, yoFramePoint, yoFrameVector, vectorSizeInMeters, appearances.get(i));
            YoGraphicPosition newPoint = new YoGraphicPosition(name + i, yoFramePoint, pointSizeInMeters, appearances.get(i));
            this.yoGraphicVectors.add(newVector);
            this.yoGraphicPositions.add(newPoint);
        }
        this.index = 0;
        this.registerYoGraphics(name, yoGraphicsListRegistry);
        parentRegistry.addChild(registry);
    }

    private static List<AppearanceDefinition> toList(AppearanceDefinition appearanceDefinition, int size) {
        ArrayList<AppearanceDefinition> list = new ArrayList<AppearanceDefinition>(size);
        while (list.size() < size) {
            list.add(appearanceDefinition);
        }
        return list;
    }

    public static BagOfVectors createPatrioticBag(int numberOfVectors, double vectorSizeInMeters, double ballSizeInMeters, String name, YoRegistry parentYoVariableRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        AppearanceDefinition[] redWhiteBlue = new AppearanceDefinition[]{YoAppearance.Red(), YoAppearance.White(), YoAppearance.Blue()};
        ArrayList<AppearanceDefinition> appearances = new ArrayList<AppearanceDefinition>();
        for (int i = 0; i < numberOfVectors; ++i) {
            appearances.add(redWhiteBlue[i % redWhiteBlue.length]);
        }
        return new BagOfVectors(vectorSizeInMeters, ballSizeInMeters, name, appearances, parentYoVariableRegistry, yoGraphicsListRegistry);
    }

    public static BagOfVectors createRainbowBag(int numberOfBalls, double vectorSizeInMeters, double ballSizeInMeters, String name, YoRegistry parentYoVariableRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        AppearanceDefinition[] rainbow = YoAppearance.getStandardRoyGBivRainbow();
        ArrayList<AppearanceDefinition> appearances = new ArrayList<AppearanceDefinition>();
        for (int i = 0; i < numberOfBalls; ++i) {
            appearances.add(rainbow[i % rainbow.length]);
        }
        return new BagOfVectors(vectorSizeInMeters, ballSizeInMeters, name, appearances, parentYoVariableRegistry, yoGraphicsListRegistry);
    }

    private void registerYoGraphics(String name, YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry != null) {
            this.yoGraphicsList = new YoGraphicsList(name + "Balls");
            for (YoGraphicVector yoGraphicVector : this.yoGraphicVectors) {
                this.yoGraphicsList.add((YoGraphic)yoGraphicVector);
            }
            for (YoGraphicPosition yoGraphicPosition : this.yoGraphicPositions) {
                this.yoGraphicsList.add((YoGraphic)yoGraphicPosition);
            }
            yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
        }
    }

    private void registerArtifacts(String name, YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry != null) {
            this.artifactList = new ArtifactList(name + "Balls");
            for (YoGraphicVector yoGraphicVector : this.yoGraphicVectors) {
                this.artifactList.add(yoGraphicVector.createArtifact());
            }
            for (YoGraphicPosition yoGraphicPosition : this.yoGraphicPositions) {
                this.artifactList.add((Artifact)yoGraphicPosition.createArtifact());
            }
            yoGraphicsListRegistry.registerArtifactList(this.artifactList);
        }
    }

    public void setVector(FramePoint3DReadOnly location, FrameVector3DReadOnly velocity) {
        this.setVector(location, velocity, this.index);
        ++this.index;
    }

    public void setVector(FramePoint3DReadOnly location, FrameVector3DReadOnly velocity, int ballIndex) {
        if (!location.getReferenceFrame().isWorldFrame()) {
            throw new RuntimeException(location + " must be in a World Frame!");
        }
        this.setVector(location.getX(), location.getY(), location.getZ(), velocity.getX(), velocity.getY(), velocity.getZ(), ballIndex);
    }

    public void setVector(double pointX, double pointY, double pointZ, double velocityX, double velocityY, double velocityZ) {
        this.setVector(pointX, pointY, pointZ, velocityX, velocityY, velocityZ, this.index);
        ++this.index;
    }

    public void setVector(double pointX, double pointY, double pointZ, double velocityX, double velocityY, double velocityZ, int ballIndex) {
        if (ballIndex < this.yoGraphicVectors.size()) {
            YoGraphicVector yoGraphicVector = this.yoGraphicVectors.get(ballIndex);
            YoGraphicPosition yoGraphicPosition = this.yoGraphicPositions.get(ballIndex);
            yoGraphicVector.set(pointX, pointY, pointZ, velocityX, velocityY, velocityZ);
            yoGraphicPosition.setPosition(pointX, pointY, pointZ);
        } else if (!this.outOfVectorsWarning) {
            this.outOfVectorsWarning = true;
        }
    }

    public void setVectorLoop(FramePoint3DReadOnly location, FrameVector3DReadOnly velocity) {
        location.checkReferenceFrameMatch(worldFrame);
        velocity.checkReferenceFrameMatch(worldFrame);
        if (this.index >= this.yoGraphicVectors.size()) {
            this.index = 0;
        }
        YoGraphicVector yoGraphicVector = this.yoGraphicVectors.get(this.index);
        yoGraphicVector.set(location, velocity);
        this.yoGraphicPositions.get(this.index).setPosition(location);
        ++this.index;
    }

    public void reset() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicVectors.size(); ++i) {
            YoGraphicVector yoGraphicVector = this.yoGraphicVectors.get(i);
            yoGraphicVector.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            this.yoGraphicPositions.get(i).setPosition(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public void hideAll() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicVectors.size(); ++i) {
            this.yoGraphicVectors.get(i).hide();
            this.yoGraphicPositions.get(i).setPositionToNaN();
        }
    }

    public void setVisible(boolean visible) {
        this.index = 0;
        this.yoGraphicsList.setVisible(visible);
    }

    public int getNumberOfVectors() {
        return this.yoGraphicVectors.size();
    }
}

