/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicEllipsoid;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BagOfEllipses {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ArrayList<YoGraphicEllipsoid> yoGraphicEllipsoids = new ArrayList();
    private int index;
    private boolean outOfVectorsWarning = false;
    private YoGraphicsList yoGraphicsList;

    public BagOfEllipses(int numberOfVectors, String name, AppearanceDefinition appearance, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(name, BagOfEllipses.toList(appearance, numberOfVectors), parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfEllipses(String name, List<AppearanceDefinition> appearances, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        YoRegistry registry = new YoRegistry(name + "Vectors");
        for (int i = 0; i < appearances.size(); ++i) {
            YoFramePoint3D yoFramePoint = new YoFramePoint3D(name + i, "Point", worldFrame, registry);
            YoFrameYawPitchRoll yoFrameOrientation = new YoFrameYawPitchRoll(name + i, "Orientation", worldFrame, registry);
            YoGraphicEllipsoid newVector = new YoGraphicEllipsoid(name + i, yoFramePoint, yoFrameOrientation, appearances.get(i), (Vector3DReadOnly)new Vector3D());
            this.yoGraphicEllipsoids.add(newVector);
        }
        this.index = 0;
        this.registerYoGraphics(name, yoGraphicsListRegistry);
        parentRegistry.addChild(registry);
    }

    private static List<AppearanceDefinition> toList(AppearanceDefinition appearanceDefinition, int size) {
        ArrayList<AppearanceDefinition> list = new ArrayList<AppearanceDefinition>(size);
        while (list.size() < size) {
            list.add(appearanceDefinition);
        }
        return list;
    }

    private void registerYoGraphics(String name, YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry != null) {
            this.yoGraphicsList = new YoGraphicsList(name + "Balls");
            for (YoGraphicEllipsoid yoGraphicEllipsoid : this.yoGraphicEllipsoids) {
                this.yoGraphicsList.add((YoGraphic)yoGraphicEllipsoid);
            }
            yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
        }
    }

    public void setEllipse(FramePoint3DReadOnly location, FrameQuaternionReadOnly orientation, Vector3D radii) {
        this.setEllipse(location, orientation, radii, this.index);
        ++this.index;
    }

    public void setEllipse(FramePoint3DReadOnly location, FrameQuaternionReadOnly orientation, Vector3D radii, int ballIndex) {
        if (!location.getReferenceFrame().isWorldFrame()) {
            throw new RuntimeException(location + " must be in a World Frame!");
        }
        if (ballIndex < this.yoGraphicEllipsoids.size()) {
            YoGraphicEllipsoid yoGraphicVector = this.yoGraphicEllipsoids.get(ballIndex);
            yoGraphicVector.setPosition(location);
            yoGraphicVector.setOrientation(orientation);
            yoGraphicVector.setRadii(radii);
        } else if (!this.outOfVectorsWarning) {
            this.outOfVectorsWarning = true;
        }
    }

    public void setEllipseLoop(FramePoint3DReadOnly location, FrameQuaternionReadOnly orientation, Vector3D radii) {
        location.checkReferenceFrameMatch(worldFrame);
        orientation.checkReferenceFrameMatch(worldFrame);
        if (this.index >= this.yoGraphicEllipsoids.size()) {
            this.index = 0;
        }
        YoGraphicEllipsoid yoGraphicEllipsoid = this.yoGraphicEllipsoids.get(this.index);
        yoGraphicEllipsoid.setPosition(location);
        yoGraphicEllipsoid.setOrientation(orientation);
        yoGraphicEllipsoid.setRadii(radii);
        ++this.index;
    }

    public void reset() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicEllipsoids.size(); ++i) {
            YoGraphicEllipsoid yoGraphicVector = this.yoGraphicEllipsoids.get(i);
            yoGraphicVector.setPosition(Double.NaN, Double.NaN, Double.NaN);
            yoGraphicVector.setYawPitchRoll(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public void hideAll() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicEllipsoids.size(); ++i) {
            this.yoGraphicEllipsoids.get(i).hide();
        }
    }

    public void setVisible(boolean visible) {
        this.index = 0;
        this.yoGraphicsList.setVisible(visible);
    }

    public int getNumberOfVectors() {
        return this.yoGraphicEllipsoids.size();
    }
}

