/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProviderTools;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.ContactSegmentHelper;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class PreviewWindowCalculator {
    protected final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoInteger activeSegment = new YoInteger("activeSegmentInWindow", this.registry);
    private final YoBoolean activeSegmentChanged = new YoBoolean("activeSegmentChanged", this.registry);
    private final YoDouble maximumPreviewWindowDuration = new YoDouble("maximumPreviewWindowDuration", this.registry);
    private final YoInteger maximumPreviewWindowSegments = new YoInteger("maximumPreviewWindowSegments", this.registry);
    private final YoInteger segmentsInPreviewWindow = new YoInteger("segmentsInPreviewWindow", this.registry);
    private final YoDouble previewWindowDuration = new YoDouble("previewWindowDuration", this.registry);
    private final RecyclingArrayList<ContactPlaneProvider> previewWindowContacts = new RecyclingArrayList(ContactPlaneProvider::new);
    private final RecyclingArrayList<ContactPlaneProvider> fullContactSet = new RecyclingArrayList(ContactPlaneProvider::new);
    private final ContactSegmentHelper contactSegmentHelper = new ContactSegmentHelper();

    public PreviewWindowCalculator(YoRegistry parentRegistry) {
        this.activeSegment.set(-1);
        this.maximumPreviewWindowDuration.set(0.75);
        this.maximumPreviewWindowSegments.set(3);
        parentRegistry.addChild(this.registry);
    }

    public void compute(List<ContactPlaneProvider> fullContactSequence, double timeAtStartOfWindow) {
        this.previewWindowContacts.clear();
        double previewWindowLength = this.computePlanningHorizon(fullContactSequence, timeAtStartOfWindow);
        this.previewWindowDuration.set(previewWindowLength);
        this.segmentsInPreviewWindow.set(this.previewWindowContacts.size());
    }

    public double getPreviewWindowDuration() {
        return this.previewWindowDuration.getDoubleValue();
    }

    private double computePlanningHorizon(List<ContactPlaneProvider> fullContactSequence, double timeAtStartOfWindow) {
        int i;
        int activeSegment = -1;
        this.activeSegmentChanged.set(false);
        for (int i2 = 0; i2 < fullContactSequence.size(); ++i2) {
            TimeIntervalBasics timeInterval = fullContactSequence.get(i2).getTimeInterval();
            if (!timeInterval.intervalContains(timeAtStartOfWindow)) continue;
            activeSegment = i2;
            break;
        }
        if (this.activeSegment.getIntegerValue() != activeSegment) {
            this.activeSegmentChanged.set(true);
            this.activeSegment.set(activeSegment);
        }
        this.previewWindowContacts.clear();
        double horizonDuration = -timeAtStartOfWindow;
        for (int i3 = activeSegment; i3 < fullContactSequence.size(); ++i3) {
            ContactPlaneProvider contact = fullContactSequence.get(i3);
            ((ContactPlaneProvider)this.previewWindowContacts.add()).set(contact);
            if (contact.getContactState().isLoadBearing() && ((horizonDuration += contact.getTimeInterval().getDuration()) >= this.maximumPreviewWindowDuration.getDoubleValue() || this.previewWindowContacts.size() > this.maximumPreviewWindowSegments.getValue() - 1)) break;
        }
        this.contactSegmentHelper.cropInitialSegmentLength((ContactPlaneProvider)this.previewWindowContacts.get(0), timeAtStartOfWindow);
        double previewWindowLength = 0.0;
        double flightDuration = 0.0;
        for (int i4 = 0; i4 < this.previewWindowContacts.size() - 1; ++i4) {
            double duration = ((ContactPlaneProvider)this.previewWindowContacts.get(i4)).getTimeInterval().getDuration();
            if (((ContactPlaneProvider)this.previewWindowContacts.get(i4)).getContactState().isLoadBearing()) {
                previewWindowLength += duration;
                continue;
            }
            flightDuration += duration;
        }
        ContactPlaneProvider trimmedFinalSegment = this.contactSegmentHelper.trimFinalSegmentLength((ContactPlaneProvider)this.previewWindowContacts.getLast(), previewWindowLength, this.maximumPreviewWindowDuration.getDoubleValue());
        previewWindowLength += ((ContactPlaneProvider)this.previewWindowContacts.getLast()).getTimeInterval().getDuration();
        this.fullContactSet.clear();
        for (i = 0; i < this.previewWindowContacts.size(); ++i) {
            ((ContactPlaneProvider)this.fullContactSet.add()).set((ContactPlaneProvider)this.previewWindowContacts.get(i));
        }
        if (trimmedFinalSegment != null) {
            ((ContactPlaneProvider)this.fullContactSet.add()).set(trimmedFinalSegment);
            for (i = this.previewWindowContacts.size() + activeSegment; i < fullContactSequence.size(); ++i) {
                ((ContactPlaneProvider)this.fullContactSet.add()).set(fullContactSequence.get(i));
            }
        } else {
            for (i = this.previewWindowContacts.size() + activeSegment; i < fullContactSequence.size(); ++i) {
                ((ContactPlaneProvider)this.fullContactSet.add()).set(fullContactSequence.get(i));
            }
        }
        if (!ContactStateProviderTools.checkContactSequenceIsValid(this.previewWindowContacts)) {
            throw new IllegalArgumentException("The preview window is not valid.");
        }
        if (!ContactStateProviderTools.checkContactSequenceIsValid(this.fullContactSet)) {
            throw new IllegalArgumentException("The full contact sequence is not valid.");
        }
        return previewWindowLength + flightDuration;
    }

    public List<ContactPlaneProvider> getPlanningWindow() {
        return this.previewWindowContacts;
    }

    public List<ContactPlaneProvider> getFullPlanningSequence() {
        return this.fullContactSet;
    }

    public boolean activeSegmentChanged() {
        return this.activeSegmentChanged.getBooleanValue();
    }
}

