/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationTrajectoryCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.OrientationTrajectoryConstructor;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.OrientationTrajectoryCalculator;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.math.trajectories.FixedFramePolynomialEstimator3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class OrientationMPCTrajectoryHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final OrientationTrajectoryCalculator referenceOrientationCalculator;
    private final SE3MPCIndexHandler indexHandler;
    private final RecyclingArrayList<FrameOrientation3DBasics> discretizedReferenceOrientation = new RecyclingArrayList(FrameQuaternion::new);
    private final RecyclingArrayList<FrameVector3DBasics> discretizedReferenceAngularVelocity = new RecyclingArrayList(FrameVector3D::new);
    private final RecyclingArrayList<FrameQuaternionBasics> desiredOrientationSolution = new RecyclingArrayList(FrameQuaternion::new);
    private final RecyclingArrayList<FrameVector3DBasics> desiredAngularVelocitySolution = new RecyclingArrayList(FrameVector3D::new);
    private final MultipleWaypointsOrientationTrajectoryGenerator bodyOrientationTrajectory;
    private final MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> internalAngularMomentumTrajectory;
    private final YoDouble previewWindowEndTime;
    private final RecyclingArrayList<AxisAngleBasics> axisAngleErrorSolutions = new RecyclingArrayList(AxisAngle::new);
    private final RecyclingArrayList<FrameVector3DBasics> angularVelocityInBodyErrorSolutions = new RecyclingArrayList(FrameVector3D::new);
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final OrientationTrajectoryConstructor trajectoryConstructor;
    private final YoFrameVector3D optimizedCurrentAngleError = new YoFrameVector3D("optimizedCurrentAngleError", worldFrame, this.registry);
    private final YoFrameVector3D optimizedCurrentAngleVelocityError = new YoFrameVector3D("optimizedCurrentAngleVelocityError", worldFrame, this.registry);
    private final DMatrixRMaj errorAtStartOfState = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj valueAtTick = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj segmentCoefficients = new DMatrixRMaj(10, 1);

    public OrientationMPCTrajectoryHandler(SE3MPCIndexHandler indexHandler, OrientationTrajectoryConstructor trajectoryConstructor) {
        this.indexHandler = indexHandler;
        this.trajectoryConstructor = trajectoryConstructor;
        this.previewWindowEndTime = new YoDouble("orientationPreviewWindowEndTime", this.registry);
        this.internalAngularMomentumTrajectory = new MultipleSegmentPositionTrajectoryGenerator("internalAngularMomentumTrajectory", 50, worldFrame, () -> new FixedFramePolynomialEstimator3D(worldFrame), this.registry);
        this.referenceOrientationCalculator = new OrientationTrajectoryCalculator(this.registry);
        this.bodyOrientationTrajectory = new MultipleWaypointsOrientationTrajectoryGenerator("desiredCoMTrajectory", 100, ReferenceFrame.getWorldFrame(), this.registry);
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public void clearTrajectory() {
        this.previewWindowEndTime.set(Double.NEGATIVE_INFINITY);
        this.bodyOrientationTrajectory.clear();
    }

    public void extractSolutionForPreviewWindow(DMatrixRMaj solutionCoefficients, double currentTimeInState, double previewWindowDuration, FrameQuaternionReadOnly currentDesiredOrientation, FrameVector3DReadOnly currentDesiredAngularVelocity) {
        this.previewWindowEndTime.set(currentTimeInState + previewWindowDuration);
        this.extractSolutionVectors(solutionCoefficients);
        this.clearTrajectory();
        this.desiredOrientationSolution.clear();
        this.desiredAngularVelocitySolution.clear();
        this.bodyOrientationTrajectory.appendWaypoint(currentTimeInState, currentDesiredOrientation, currentDesiredAngularVelocity);
        int globalTick = 0;
        for (int segment = 0; segment < this.indexHandler.getNumberOfSegments(); ++segment) {
            OrientationTrajectoryCommand command = this.trajectoryConstructor.getOrientationTrajectoryCommands().get(segment);
            double tickDuration = this.indexHandler.getTickDuration(segment);
            int end = globalTick + command.getNumberOfTicksInSegment();
            while (globalTick < end) {
                currentTimeInState += tickDuration;
                FrameQuaternionBasics orientation = (FrameQuaternionBasics)this.desiredOrientationSolution.add();
                orientation.set((FrameOrientation3DReadOnly)this.discretizedReferenceOrientation.get(globalTick));
                orientation.append((Orientation3DReadOnly)this.axisAngleErrorSolutions.get(globalTick));
                FrameVector3DBasics angularVelocity = (FrameVector3DBasics)this.desiredAngularVelocitySolution.add();
                angularVelocity.set((FrameTuple3DReadOnly)this.angularVelocityInBodyErrorSolutions.get(globalTick));
                orientation.inverseTransform((FixedFrameTuple3DBasics)angularVelocity);
                angularVelocity.add((FrameTuple3DReadOnly)this.discretizedReferenceAngularVelocity.get(globalTick));
                this.bodyOrientationTrajectory.appendWaypoint(currentTimeInState, (FrameQuaternionReadOnly)orientation, (FrameVector3DReadOnly)angularVelocity);
                ++globalTick;
            }
        }
        this.overwriteTrajectoryOutsidePreviewWindow();
    }

    private void extractSolutionVectors(DMatrixRMaj solutionCoefficients) {
        this.axisAngleErrorSolutions.clear();
        this.angularVelocityInBodyErrorSolutions.clear();
        for (int segment = 0; segment < this.indexHandler.getNumberOfSegments(); ++segment) {
            MatrixTools.setMatrixBlock((DMatrix)this.errorAtStartOfState, (int)0, (int)0, (DMatrix)solutionCoefficients, (int)this.indexHandler.getOrientationStartIndex(segment), (int)0, (int)6, (int)1, (double)1.0);
            if (segment == 0) {
                this.optimizedCurrentAngleError.set((DMatrix)this.errorAtStartOfState);
                this.optimizedCurrentAngleVelocityError.set(3, (DMatrix)this.errorAtStartOfState);
            }
            OrientationTrajectoryCommand command = this.trajectoryConstructor.getOrientationTrajectoryCommands().get(segment);
            int coefficientsInSegment = this.indexHandler.getRhoCoefficientsInSegment(segment) + 6;
            this.segmentCoefficients.reshape(coefficientsInSegment, 1);
            MatrixTools.setMatrixBlock((DMatrix)this.segmentCoefficients, (int)0, (int)0, (DMatrix)solutionCoefficients, (int)this.indexHandler.getComCoefficientStartIndex(segment), (int)0, (int)coefficientsInSegment, (int)1, (double)1.0);
            for (int tick = 0; tick < command.getNumberOfTicksInSegment(); ++tick) {
                this.valueAtTick.set((DMatrixD1)command.getCMatrix(tick));
                CommonOps_DDRM.multAdd((DMatrix1Row)command.getAMatrix(tick), (DMatrix1Row)this.errorAtStartOfState, (DMatrix1Row)this.valueAtTick);
                CommonOps_DDRM.multAdd((DMatrix1Row)command.getBMatrix(tick), (DMatrix1Row)this.segmentCoefficients, (DMatrix1Row)this.valueAtTick);
                AxisAngleBasics axisAngleErrorSolution = (AxisAngleBasics)this.axisAngleErrorSolutions.add();
                FrameVector3DBasics angularVelocityErrorSolution = (FrameVector3DBasics)this.angularVelocityInBodyErrorSolutions.add();
                axisAngleErrorSolution.setRotationVector(this.valueAtTick.get(0, 0), this.valueAtTick.get(1, 0), this.valueAtTick.get(2, 0));
                angularVelocityErrorSolution.set(3, (DMatrix)this.valueAtTick);
            }
        }
    }

    public void setInitialBodyOrientationState(FrameOrientation3DReadOnly bodyOrientation, FrameVector3DReadOnly bodyAngularVelocity) {
        this.referenceOrientationCalculator.setInitialBodyOrientation(bodyOrientation, bodyAngularVelocity);
    }

    public void solveForTrajectoryOutsidePreviewWindow(List<ContactPlaneProvider> fullContactSequence) {
        this.referenceOrientationCalculator.solveForTrajectory(fullContactSequence);
        this.removeInfoOutsidePreviewWindow();
        this.overwriteTrajectoryOutsidePreviewWindow();
    }

    public void computeDiscretizedReferenceTrajectory(double currentTimeInState) {
        this.discretizedReferenceOrientation.clear();
        this.discretizedReferenceAngularVelocity.clear();
        for (int segment = 0; segment < this.indexHandler.getNumberOfSegments(); ++segment) {
            double tickDuration = this.indexHandler.getTickDuration(segment);
            for (int i = 0; i < this.indexHandler.getTicksInSegment(segment); ++i) {
                this.referenceOrientationCalculator.compute(currentTimeInState += tickDuration);
                ((FrameOrientation3DBasics)this.discretizedReferenceOrientation.add()).set(this.referenceOrientationCalculator.getDesiredOrientation());
                ((FrameVector3DBasics)this.discretizedReferenceAngularVelocity.add()).set((FrameTuple3DReadOnly)this.referenceOrientationCalculator.getDesiredAngularVelocity());
            }
        }
    }

    private void removeInfoOutsidePreviewWindow() {
        while (this.bodyOrientationTrajectory.getCurrentNumberOfWaypoints() > 0 && this.bodyOrientationTrajectory.getLastWaypointTime() > this.previewWindowEndTime.getValue()) {
            this.bodyOrientationTrajectory.removeLastWaypoint();
        }
    }

    private void overwriteTrajectoryOutsidePreviewWindow() {
        double existingEndTime;
        MultipleWaypointsOrientationTrajectoryGenerator orientationTrajectoryOutsideWindow = this.referenceOrientationCalculator.getOrientationTrajectory();
        boolean hasTrajectoryAlready = this.bodyOrientationTrajectory.getCurrentNumberOfWaypoints() > 0;
        double d = existingEndTime = hasTrajectoryAlready ? this.bodyOrientationTrajectory.getLastWaypointTime() : 0.0;
        if (existingEndTime >= orientationTrajectoryOutsideWindow.getLastWaypointTime()) {
            return;
        }
        int waypointIndexToAdd = OrientationMPCTrajectoryHandler.getWaypointIndexAfterTime(existingEndTime + 1.0E-5, this.referenceOrientationCalculator.getOrientationTrajectory());
        if (waypointIndexToAdd == -1) {
            return;
        }
        while (waypointIndexToAdd < orientationTrajectoryOutsideWindow.getCurrentNumberOfWaypoints()) {
            this.bodyOrientationTrajectory.appendWaypoint((SO3TrajectoryPointBasics)orientationTrajectoryOutsideWindow.getWaypoint(waypointIndexToAdd));
            ++waypointIndexToAdd;
        }
        this.bodyOrientationTrajectory.initialize();
    }

    private static int getWaypointIndexAfterTime(double time, MultipleWaypointsOrientationTrajectoryGenerator trajectory) {
        for (int i = 0; i < trajectory.getCurrentNumberOfWaypoints(); ++i) {
            if (!(trajectory.getWaypoint(i).getTime() > time)) continue;
            return i;
        }
        return -1;
    }

    public void compute(double timeInPhase) {
        this.bodyOrientationTrajectory.compute(timeInPhase);
        this.referenceOrientationCalculator.compute(timeInPhase);
        if (!this.internalAngularMomentumTrajectory.isEmpty()) {
            this.internalAngularMomentumTrajectory.compute(timeInPhase);
        }
    }

    public void computeReferenceValue(double timeInPhase) {
        this.referenceOrientationCalculator.compute(timeInPhase);
    }

    public void setInternalAngularMomentumTrajectory(MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> trajectory) {
        this.internalAngularMomentumTrajectory.clear();
        for (int i = 0; i < trajectory.getCurrentNumberOfSegments(); ++i) {
            this.internalAngularMomentumTrajectory.appendSegment((FixedFramePositionTrajectoryGenerator)((FixedFramePolynomialEstimator3D)trajectory.getSegment(i)));
        }
        this.internalAngularMomentumTrajectory.initialize();
    }

    public FrameOrientation3DReadOnly getReferenceBodyOrientation() {
        return this.referenceOrientationCalculator.getDesiredOrientation();
    }

    public FrameVector3DReadOnly getReferenceBodyVelocity() {
        return this.referenceOrientationCalculator.getDesiredAngularVelocity();
    }

    public FrameOrientation3DReadOnly getDesiredBodyOrientation() {
        return this.bodyOrientationTrajectory.getOrientation();
    }

    public FrameVector3DReadOnly getDesiredAngularVelocity() {
        return this.bodyOrientationTrajectory.getAngularVelocity();
    }

    public FrameVector3DReadOnly getDesiredAngularAcceleration() {
        return this.bodyOrientationTrajectory.getAngularAcceleration();
    }

    public boolean hasInternalAngularMomentum() {
        return this.internalAngularMomentumTrajectory.isEmpty();
    }

    public FramePoint3DReadOnly getDesiredInternalAngularMomentum() {
        return this.internalAngularMomentumTrajectory.getPosition();
    }

    public FrameVector3DReadOnly getDesiredInternalAngularMomentumRate() {
        return this.internalAngularMomentumTrajectory.getVelocity();
    }
}

