/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.ContactPointForceViewer;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.MatrixMissingTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class MPCContactPoint {
    private final int numberOfBasisVectorsPerContactPoint;
    private final int coefficientsSize;
    private final FixedFrameVector3DBasics[] basisVectorsInWorld;
    private final FixedFrameVector3DBasics[] basisVectorsInPlaneFrame;
    private final FramePoint3D basisVectorOrigin = new FramePoint3D();
    private final double basisVectorAngleIncrement;
    private final PoseReferenceFrame planeFrame;
    private double rhoNormalZ;
    private final RotationMatrix normalContactVectorRotationMatrix = new RotationMatrix();
    private final DMatrixRMaj jerkIntegrationHessian;
    private final DMatrixRMaj contactWrenchCoefficientMatrix;
    private final FrameVector3D contactAcceleration = new FrameVector3D();
    private final FrameVector3D contactJerk = new FrameVector3D();
    private final FrameVector3D[] basisMagnitudes;
    private final FrameVector3D[] basisRates;
    private final DMatrixRMaj[] basisCoefficients;
    private ContactPointForceViewer viewer;
    private final FrameVector3D contactNormalVector = new FrameVector3D();

    public MPCContactPoint(int numberOfBasisVectorsPerContactPoint) {
        this.numberOfBasisVectorsPerContactPoint = numberOfBasisVectorsPerContactPoint;
        this.coefficientsSize = 4 * numberOfBasisVectorsPerContactPoint;
        this.basisVectorAngleIncrement = Math.PI * 2 / (double)numberOfBasisVectorsPerContactPoint;
        this.basisVectorsInWorld = new FrameVector3D[this.numberOfBasisVectorsPerContactPoint];
        this.basisVectorsInPlaneFrame = new FrameVector3D[this.numberOfBasisVectorsPerContactPoint];
        this.basisMagnitudes = new FrameVector3D[this.numberOfBasisVectorsPerContactPoint];
        this.basisRates = new FrameVector3D[this.numberOfBasisVectorsPerContactPoint];
        this.basisCoefficients = new DMatrixRMaj[this.numberOfBasisVectorsPerContactPoint];
        this.planeFrame = new PoseReferenceFrame("ContactFrame", ReferenceFrame.getWorldFrame());
        this.jerkIntegrationHessian = new DMatrixRMaj(this.coefficientsSize, this.coefficientsSize);
        this.contactWrenchCoefficientMatrix = new DMatrixRMaj(3, 4);
        for (int i = 0; i < this.numberOfBasisVectorsPerContactPoint; ++i) {
            this.basisVectorsInWorld[i] = new FrameVector3D(ReferenceFrame.getWorldFrame());
            this.basisVectorsInPlaneFrame[i] = new FrameVector3D((ReferenceFrame)this.planeFrame);
            this.basisMagnitudes[i] = new FrameVector3D(ReferenceFrame.getWorldFrame());
            this.basisRates[i] = new FrameVector3D(ReferenceFrame.getWorldFrame());
            this.basisCoefficients[i] = new DMatrixRMaj(1, 4);
        }
        this.clear();
    }

    public void setContactPointForceViewer(ContactPointForceViewer viewer) {
        this.viewer = viewer;
    }

    public int getRhoSize() {
        return this.numberOfBasisVectorsPerContactPoint;
    }

    public int getCoefficientsSize() {
        return this.coefficientsSize;
    }

    public FrameVector3DReadOnly getBasisVector(int index) {
        return this.basisVectorsInWorld[index];
    }

    public FrameVector3DReadOnly getBasisVectorInPlaneFrame(int index) {
        return this.basisVectorsInPlaneFrame[index];
    }

    public FramePoint3DReadOnly getBasisVectorOrigin() {
        return this.basisVectorOrigin;
    }

    public void computeBasisVectors(Point2DReadOnly contactPointInPlaneFrame, FramePose3DReadOnly framePose, double rotationOffset, double mu) {
        this.planeFrame.setPoseAndUpdate(framePose);
        this.computeNormalContactVectorRotation(this.normalContactVectorRotationMatrix);
        int rhoIndex = 0;
        this.basisVectorOrigin.setIncludingFrame((ReferenceFrame)this.planeFrame, (Tuple2DReadOnly)contactPointInPlaneFrame, 0.0);
        this.basisVectorOrigin.changeFrame(ReferenceFrame.getWorldFrame());
        for (int basisVectorIndex = 0; basisVectorIndex < this.numberOfBasisVectorsPerContactPoint; ++basisVectorIndex) {
            FixedFrameVector3DBasics basisVector = this.basisVectorsInPlaneFrame[rhoIndex];
            this.computeBasisVector(basisVectorIndex, rotationOffset, this.normalContactVectorRotationMatrix, basisVector, mu);
            this.basisVectorsInWorld[rhoIndex].setMatchingFrame((FrameTuple3DReadOnly)basisVector);
            ++rhoIndex;
        }
        this.rhoNormalZ = this.basisVectorsInWorld[0].getZ();
    }

    public void computeJerkIntegrationMatrix(double duration, double omega) {
        duration = Math.min(duration, 5.0);
        double positiveExponential = Math.min(Math.exp(omega * duration), 100000.0);
        double positiveExponential2 = Math.min(positiveExponential * positiveExponential, 100000.0);
        double negativeExponential = 1.0 / positiveExponential;
        double negativeExponential2 = negativeExponential * negativeExponential;
        double omega2 = omega * omega;
        double omega3 = omega * omega2;
        double omega5 = omega2 * omega3;
        double omega6 = omega3 * omega3;
        double c00 = omega5 / 2.0 * (positiveExponential2 - 1.0);
        double c01 = omega6 * duration;
        double c02 = 6.0 * omega2 * (positiveExponential - 1.0);
        double c11 = -omega5 / 2.0 * (negativeExponential2 - 1.0);
        double c12 = 6.0 * omega2 * (negativeExponential - 1.0);
        double c22 = 36.0 * duration;
        for (int basisVectorIndexI = 0; basisVectorIndexI < this.numberOfBasisVectorsPerContactPoint; ++basisVectorIndexI) {
            int startIdxI = basisVectorIndexI * 4;
            FixedFrameVector3DBasics basisVectorI = this.basisVectorsInWorld[basisVectorIndexI];
            this.jerkIntegrationHessian.unsafe_set(startIdxI, startIdxI, c00);
            this.jerkIntegrationHessian.unsafe_set(startIdxI, startIdxI + 1, c01);
            this.jerkIntegrationHessian.unsafe_set(startIdxI, startIdxI + 2, c02);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 1, startIdxI, c01);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 1, startIdxI + 1, c11);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 1, startIdxI + 2, c12);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 2, startIdxI, c02);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 2, startIdxI + 1, c12);
            this.jerkIntegrationHessian.unsafe_set(startIdxI + 2, startIdxI + 2, c22);
            for (int basisVectorIndexJ = basisVectorIndexI + 1; basisVectorIndexJ < this.numberOfBasisVectorsPerContactPoint; ++basisVectorIndexJ) {
                FixedFrameVector3DBasics basisVectorJ = this.basisVectorsInWorld[basisVectorIndexJ];
                double basisDot = basisVectorI.dot((FrameVector3DReadOnly)basisVectorJ);
                int startIdxJ = basisVectorIndexJ * 4;
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxI, (int)startIdxJ, (double)(basisDot * c00));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxI, (int)(startIdxJ + 1), (double)(basisDot * c01));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxI, (int)(startIdxJ + 2), (double)(basisDot * c02));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 1), (int)startIdxJ, (double)(basisDot * c01));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 1), (int)(startIdxJ + 1), (double)(basisDot * c11));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 1), (int)(startIdxJ + 2), (double)(basisDot * c12));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 2), (int)startIdxJ, (double)(basisDot * c02));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 2), (int)(startIdxJ + 1), (double)(basisDot * c12));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxI + 2), (int)(startIdxJ + 2), (double)(basisDot * c22));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxJ, (int)startIdxI, (double)(basisDot * c00));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxJ, (int)(startIdxI + 1), (double)(basisDot * c01));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)startIdxJ, (int)(startIdxI + 2), (double)(basisDot * c02));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 1), (int)startIdxI, (double)(basisDot * c01));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 1), (int)(startIdxI + 1), (double)(basisDot * c11));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 1), (int)(startIdxI + 2), (double)(basisDot * c12));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 2), (int)startIdxI, (double)(basisDot * c02));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 2), (int)(startIdxI + 1), (double)(basisDot * c12));
                MatrixMissingTools.unsafe_add((DMatrixRMaj)this.jerkIntegrationHessian, (int)(startIdxJ + 2), (int)(startIdxI + 2), (double)(basisDot * c22));
            }
        }
    }

    private void computeNormalContactVectorRotation(RotationMatrix normalContactVectorRotationMatrixToPack) {
        this.contactNormalVector.setIncludingFrame((ReferenceFrame)this.planeFrame, 0.0, 0.0, 1.0);
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.contactNormalVector, (Orientation3DBasics)normalContactVectorRotationMatrixToPack);
    }

    public void clear() {
        this.basisVectorOrigin.setToZero(ReferenceFrame.getWorldFrame());
        for (int rhoIndex = 0; rhoIndex < this.basisVectorsInWorld.length; ++rhoIndex) {
            this.basisVectorsInWorld[rhoIndex].setToZero();
            this.basisVectorsInPlaneFrame[rhoIndex].setToZero();
        }
        if (this.viewer != null) {
            this.viewer.reset();
        }
    }

    private void computeBasisVector(int basisVectorIndex, double rotationOffset, RotationMatrix normalContactVectorRotationMatrix, FixedFrameVector3DBasics basisVectorToPack, double mu) {
        double angle = rotationOffset + (double)basisVectorIndex * this.basisVectorAngleIncrement;
        basisVectorToPack.set(Math.cos(angle) * mu, Math.sin(angle) * mu, 1.0);
        normalContactVectorRotationMatrix.transform((Tuple3DBasics)basisVectorToPack);
        basisVectorToPack.normalize();
    }

    public double getRhoNormalZ() {
        return this.rhoNormalZ;
    }

    public DMatrixRMaj getJerkIntegrationHessian() {
        return this.jerkIntegrationHessian;
    }

    public void computeContactForceCoefficientMatrix(DMatrixRMaj solutionVector, int solutionStartIdx) {
        this.contactWrenchCoefficientMatrix.zero();
        int startIdx = solutionStartIdx;
        for (int rhoIndex = 0; rhoIndex < this.numberOfBasisVectorsPerContactPoint; ++rhoIndex) {
            FixedFrameVector3DBasics basisVector = this.basisVectorsInWorld[rhoIndex];
            for (int coeffIdx = 0; coeffIdx < 4; ++coeffIdx) {
                double rhoCoeff = solutionVector.get(startIdx, 0);
                this.contactWrenchCoefficientMatrix.add(0, coeffIdx, basisVector.getX() * rhoCoeff);
                this.contactWrenchCoefficientMatrix.add(1, coeffIdx, basisVector.getY() * rhoCoeff);
                this.contactWrenchCoefficientMatrix.add(2, coeffIdx, basisVector.getZ() * rhoCoeff);
                this.basisCoefficients[rhoIndex].set(0, coeffIdx, rhoCoeff);
                ++startIdx;
            }
        }
    }

    public DMatrixRMaj getContactForceCoefficientMatrix() {
        return this.contactWrenchCoefficientMatrix;
    }

    public DMatrixRMaj getBasisCoefficients(int rhoIdx) {
        return this.basisCoefficients[rhoIdx];
    }

    public void computeContactForce(double omega, double time) {
        double omega2 = omega * omega;
        double omega3 = omega * omega2;
        double exponential = Math.min(Math.exp(omega * time), 100000.0);
        double negativeExponential = 1.0 / exponential;
        double a0 = omega2 * exponential;
        double a1 = omega2 * negativeExponential;
        double a2 = 6.0 * time;
        double a3 = 2.0;
        double aDot0 = omega3 * exponential;
        double aDot1 = -omega3 * negativeExponential;
        double aDot2 = 6.0;
        this.contactAcceleration.setToZero();
        this.contactJerk.setToZero();
        for (int rhoIdx = 0; rhoIdx < this.numberOfBasisVectorsPerContactPoint; ++rhoIdx) {
            double rhoValue = a0 * this.basisCoefficients[rhoIdx].get(0, 0);
            rhoValue += a1 * this.basisCoefficients[rhoIdx].get(0, 1);
            rhoValue += a2 * this.basisCoefficients[rhoIdx].get(0, 2);
            double rhoRate = aDot0 * this.basisCoefficients[rhoIdx].get(0, 0);
            rhoRate += aDot1 * this.basisCoefficients[rhoIdx].get(0, 1);
            this.basisMagnitudes[rhoIdx].setAndScale(rhoValue += a3 * this.basisCoefficients[rhoIdx].get(0, 3), (FrameTuple3DReadOnly)this.basisVectorsInWorld[rhoIdx]);
            this.basisRates[rhoIdx].setAndScale(rhoRate += aDot2 * this.basisCoefficients[rhoIdx].get(0, 2), (FrameTuple3DReadOnly)this.basisVectorsInWorld[rhoIdx]);
            this.contactAcceleration.add((FrameTuple3DReadOnly)this.basisMagnitudes[rhoIdx]);
            this.contactJerk.add((FrameTuple3DReadOnly)this.basisRates[rhoIdx]);
        }
        if (this.viewer != null) {
            this.viewer.update((FramePoint3DReadOnly)this.basisVectorOrigin, (FrameVector3DReadOnly)this.contactAcceleration, (FrameVector3DReadOnly[])this.basisMagnitudes);
        }
    }

    public FrameVector3DReadOnly getBasisMagnitude(int rhoIdx) {
        return this.basisMagnitudes[rhoIdx];
    }

    public void clearViz() {
        if (this.viewer != null) {
            this.viewer.reset();
        }
    }

    public FrameVector3DReadOnly getContactAcceleration() {
        return this.contactAcceleration;
    }

    public FrameVector3DReadOnly getContactJerk() {
        return this.contactJerk;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MPCContactPoint) {
            int i;
            MPCContactPoint other = (MPCContactPoint)object;
            if (this.numberOfBasisVectorsPerContactPoint != other.numberOfBasisVectorsPerContactPoint) {
                return false;
            }
            if (this.coefficientsSize != other.coefficientsSize) {
                return false;
            }
            if (!this.planeFrame.equals((Object)other.planeFrame)) {
                return false;
            }
            if (!this.basisVectorOrigin.equals((FrameTuple3DReadOnly)other.basisVectorOrigin)) {
                return false;
            }
            if (this.basisVectorsInWorld.length != other.basisVectorsInWorld.length) {
                return false;
            }
            if (this.rhoNormalZ != other.rhoNormalZ) {
                return false;
            }
            if (this.basisCoefficients.length != other.basisCoefficients.length) {
                return false;
            }
            for (i = 0; i < this.basisCoefficients.length; ++i) {
                if (this.basisCoefficients[i].equals(other.basisCoefficients[i])) continue;
                return false;
            }
            for (i = 0; i < this.basisVectorsInWorld.length; ++i) {
                if (this.basisVectorsInWorld[i].equals((FrameTuple3DReadOnly)other.basisVectorsInWorld[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

