/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPoint;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.ContactPlaneForceViewer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.FrictionConeRotationCalculator;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class MPCContactPlane {
    private final int maxNumberOfContactPoints;
    private final int numberOfBasisVectorsPerContactPoint;
    private int numberOfContactPoints;
    private int coefficientSize;
    private int rhoSize;
    private final MPCContactPoint[] contactPoints;
    private final PoseReferenceFrame planeFrame;
    private final FrameVector3D contactAcceleration = new FrameVector3D();
    private final FrameVector3D contactJerk = new FrameVector3D();
    private final FrictionConeRotationCalculator coneRotationCalculator;
    private final DMatrixRMaj contactWrenchCoefficientMatrix;
    private final DMatrixRMaj jerkIntegrationHessian;
    private ContactPlaneForceViewer viewer;
    private final Point3D point = new Point3D();

    public MPCContactPlane(int maxNumberOfContactPoints, int numberOfBasisVectorsPerContactPoint, FrictionConeRotationCalculator coneRotationCalculator) {
        this.maxNumberOfContactPoints = maxNumberOfContactPoints;
        this.numberOfBasisVectorsPerContactPoint = numberOfBasisVectorsPerContactPoint;
        this.coneRotationCalculator = coneRotationCalculator;
        this.numberOfContactPoints = maxNumberOfContactPoints;
        this.rhoSize = maxNumberOfContactPoints * numberOfBasisVectorsPerContactPoint;
        this.coefficientSize = 4 * maxNumberOfContactPoints * numberOfBasisVectorsPerContactPoint;
        this.contactPoints = new MPCContactPoint[maxNumberOfContactPoints];
        this.planeFrame = new PoseReferenceFrame("ContactFrame", ReferenceFrame.getWorldFrame());
        for (int i = 0; i < this.numberOfContactPoints; ++i) {
            this.contactPoints[i] = new MPCContactPoint(numberOfBasisVectorsPerContactPoint);
        }
        int coefficientsSize = 4 * this.rhoSize;
        this.jerkIntegrationHessian = new DMatrixRMaj(coefficientsSize, coefficientsSize);
        this.contactWrenchCoefficientMatrix = new DMatrixRMaj(3, 4);
    }

    public void setContactPointForceViewer(ContactPlaneForceViewer viewer) {
        this.viewer = viewer;
        for (MPCContactPoint pointHelper : this.contactPoints) {
            pointHelper.setContactPointForceViewer(viewer.getNextPointForceViewer());
        }
    }

    public int getRhoSize() {
        return this.rhoSize;
    }

    public int getCoefficientSize() {
        return this.coefficientSize;
    }

    public int getNumberOfContactPoints() {
        return this.numberOfContactPoints;
    }

    public MPCContactPoint getContactPointHelper(int index) {
        return this.contactPoints[index];
    }

    public double getRhoNormalZ(int index) {
        return this.contactPoints[index].getRhoNormalZ();
    }

    public ReferenceFrame getContactFrame() {
        return this.planeFrame;
    }

    public void computeBasisVectors(ConvexPolygon2DReadOnly contactPointsInPlaneFrame, FramePose3DReadOnly framePose, double mu) {
        int contactPointIndex;
        this.numberOfContactPoints = contactPointsInPlaneFrame.getNumberOfVertices();
        if (this.numberOfContactPoints > this.maxNumberOfContactPoints) {
            throw new RuntimeException("Unhandled number of contact points: " + this.numberOfContactPoints);
        }
        this.planeFrame.setPoseAndUpdate(framePose);
        this.rhoSize = this.numberOfContactPoints * this.numberOfBasisVectorsPerContactPoint;
        this.coefficientSize = 4 * this.rhoSize;
        for (contactPointIndex = 0; contactPointIndex < this.numberOfContactPoints; ++contactPointIndex) {
            Point2DReadOnly contactPointLocation = contactPointsInPlaneFrame.getVertex(contactPointIndex);
            this.point.set((Tuple2DReadOnly)contactPointsInPlaneFrame.getVertex(contactPointIndex));
            double angleOffset = this.coneRotationCalculator.computeConeRotation(contactPointsInPlaneFrame, (Point3DReadOnly)this.point);
            MPCContactPoint contactPoint = this.contactPoints[contactPointIndex];
            contactPoint.computeBasisVectors(contactPointLocation, framePose, angleOffset, mu);
        }
        while (contactPointIndex < this.maxNumberOfContactPoints) {
            this.clear(contactPointIndex);
            ++contactPointIndex;
        }
    }

    public FrameVector3DReadOnly getBasisVector(int basisIdx) {
        int pastBases = 0;
        for (int pointIdx = 0; pointIdx < this.getNumberOfContactPoints(); ++pointIdx) {
            int localIdx = basisIdx - pastBases;
            MPCContactPoint contactPoint = this.getContactPointHelper(pointIdx);
            if (localIdx < contactPoint.getRhoSize()) {
                return contactPoint.getBasisVector(localIdx);
            }
            pastBases += contactPoint.getRhoSize();
        }
        return null;
    }

    public FrameVector3DReadOnly getBasisVectorInPlaneFrame(int basisIdx) {
        int pastBases = 0;
        for (int pointIdx = 0; pointIdx < this.getNumberOfContactPoints(); ++pointIdx) {
            int localIdx = basisIdx - pastBases;
            MPCContactPoint contactPoint = this.getContactPointHelper(pointIdx);
            if (localIdx < contactPoint.getRhoSize()) {
                return contactPoint.getBasisVectorInPlaneFrame(localIdx);
            }
            pastBases += contactPoint.getRhoSize();
        }
        return null;
    }

    public DMatrixRMaj getBasisCoefficients(int rhoIdx) {
        if (rhoIdx < this.rhoSize) {
            int pointIdx = Math.floorDiv(rhoIdx, this.numberOfBasisVectorsPerContactPoint);
            int localIdx = rhoIdx - this.numberOfBasisVectorsPerContactPoint * pointIdx;
            return this.contactPoints[pointIdx].getBasisCoefficients(localIdx);
        }
        return null;
    }

    public FrameVector3DReadOnly getBasisMagnitude(int rhoIdx) {
        if (rhoIdx < this.rhoSize) {
            int pointIdx = Math.floorDiv(rhoIdx, this.numberOfBasisVectorsPerContactPoint);
            int localIdx = rhoIdx - this.numberOfBasisVectorsPerContactPoint * pointIdx;
            return this.contactPoints[pointIdx].getBasisMagnitude(localIdx);
        }
        return null;
    }

    public void computeJerkIntegrationMatrix(double duration, double omega) {
        int startIdx = 0;
        for (int contactPointIdx = 0; contactPointIdx < this.numberOfContactPoints; ++contactPointIdx) {
            MPCContactPoint contactPoint = this.contactPoints[contactPointIdx];
            contactPoint.computeJerkIntegrationMatrix(duration, omega);
            MatrixTools.setMatrixBlock((DMatrix)this.jerkIntegrationHessian, (int)startIdx, (int)startIdx, (DMatrix)contactPoint.getJerkIntegrationHessian(), (int)0, (int)0, (int)contactPoint.getCoefficientsSize(), (int)contactPoint.getCoefficientsSize(), (double)1.0);
            startIdx += contactPoint.getCoefficientsSize();
        }
    }

    private void clear(int contactPointIndex) {
        this.contactPoints[contactPointIndex].clear();
    }

    public void reset() {
    }

    public void computeContactForceCoefficientMatrix(DMatrixRMaj solutionVector, int solutionStartIdx) {
        int startIdx = solutionStartIdx;
        this.contactWrenchCoefficientMatrix.zero();
        for (int contactPointIdx = 0; contactPointIdx < this.numberOfContactPoints; ++contactPointIdx) {
            MPCContactPoint contactPointHelper = this.contactPoints[contactPointIdx];
            contactPointHelper.computeContactForceCoefficientMatrix(solutionVector, startIdx);
            CommonOps_DDRM.addEquals((DMatrixD1)this.contactWrenchCoefficientMatrix, (DMatrixD1)contactPointHelper.getContactForceCoefficientMatrix());
            startIdx += contactPointHelper.getCoefficientsSize();
        }
    }

    public DMatrixRMaj getContactWrenchCoefficientMatrix() {
        return this.contactWrenchCoefficientMatrix;
    }

    public void computeContactForce(double omega, double time) {
        this.contactAcceleration.setToZero();
        this.contactJerk.setToZero();
        for (int i = 0; i < this.numberOfContactPoints; ++i) {
            this.contactPoints[i].computeContactForce(omega, time);
            this.contactAcceleration.add((FrameTuple3DReadOnly)this.contactPoints[i].getContactAcceleration());
            this.contactJerk.add((FrameTuple3DReadOnly)this.contactPoints[i].getContactJerk());
        }
    }

    public FrameVector3DReadOnly getContactAcceleration() {
        return this.contactAcceleration;
    }

    public FrameVector3DReadOnly getContactJerk() {
        return this.contactJerk;
    }

    public void clearViz() {
        for (MPCContactPoint contactPoint : this.contactPoints) {
            contactPoint.clearViz();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MPCContactPlane) {
            MPCContactPlane other = (MPCContactPlane)object;
            if (this.contactPoints.length != other.contactPoints.length) {
                return false;
            }
            if (this.maxNumberOfContactPoints != other.maxNumberOfContactPoints) {
                return false;
            }
            if (this.numberOfContactPoints != other.numberOfContactPoints) {
                return false;
            }
            if (this.numberOfBasisVectorsPerContactPoint != other.numberOfBasisVectorsPerContactPoint) {
                return false;
            }
            if (this.coefficientSize != other.coefficientSize) {
                return false;
            }
            if (this.rhoSize != other.rhoSize) {
                return false;
            }
            if (!this.planeFrame.equals((Object)other.planeFrame)) {
                return false;
            }
            for (int i = 0; i < this.contactPoints.length; ++i) {
                if (this.contactPoints[i].equals(other.contactPoints[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

