/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import org.ejml.data.DMatrix;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.DirectOrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationContinuityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationTrajectoryCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.BlockInverseCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCQPSolver;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.OrientationTrajectoryInputCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCIndexHandler;
import us.ihmc.convexOptimization.quadraticProgram.InverseMatrixCalculator;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SE3MPCQPSolver
extends LinearMPCQPSolver {
    private final SE3MPCIndexHandler indexHandler;
    private final YoDouble firstOrientationVariableRegularization;
    private final YoDouble secondOrientationVariableRegularization;
    private final YoDouble firstOrientationRateVariableRegularization;
    private final YoDouble secondOrientationRateVariableRegularization;
    private final OrientationTrajectoryInputCalculator orientationInputCalculator;

    public SE3MPCQPSolver(SE3MPCIndexHandler indexHandler, double dt, double gravityZ, YoRegistry parentRegistry) {
        this(indexHandler, dt, gravityZ, (InverseMatrixCalculator<NativeMatrix>)new BlockInverseCalculator(indexHandler, indexHandler::getOrientationStartIndex, indexHandler::getVariablesInSegment), parentRegistry);
    }

    public SE3MPCQPSolver(SE3MPCIndexHandler indexHandler, double dt, double gravityZ, InverseMatrixCalculator<NativeMatrix> inverseCalculator, YoRegistry parentRegistry) {
        super(indexHandler, dt, gravityZ, inverseCalculator, parentRegistry);
        this.firstOrientationVariableRegularization = new YoDouble("firstOrientationVariableRegularization", this.registry);
        this.secondOrientationVariableRegularization = new YoDouble("secondOrientationVariableRegularization", this.registry);
        this.firstOrientationRateVariableRegularization = new YoDouble("firstOrientationRateVariableRegularization", this.registry);
        this.secondOrientationRateVariableRegularization = new YoDouble("secondOrientationRateVariableRegularization", this.registry);
        this.indexHandler = indexHandler;
        this.orientationInputCalculator = new OrientationTrajectoryInputCalculator(indexHandler);
        this.firstOrientationVariableRegularization.set(1.0E-8);
        this.secondOrientationVariableRegularization.set(1.0E-8);
        this.firstOrientationRateVariableRegularization.set(1.0E-6);
        this.secondOrientationRateVariableRegularization.set(1.0E-6);
    }

    public void setFirstOrientationVariableRegularization(double value) {
        this.firstOrientationVariableRegularization.set(value);
    }

    public void setSecondOrientationVariableRegularization(double value) {
        this.secondOrientationVariableRegularization.set(value);
    }

    public void setFirstOrientationRateVariableRegularization(double value) {
        this.firstOrientationRateVariableRegularization.set(value);
    }

    public void setSecondOrientationRateVariableRegularization(double value) {
        this.secondOrientationRateVariableRegularization.set(value);
    }

    @Override
    public void addValueRegularization() {
        super.addValueRegularization();
        double firstOrientationCoefficientFactor = this.firstOrientationVariableRegularization.getDoubleValue();
        double secondOrientationCoefficientFactor = this.secondOrientationVariableRegularization.getDoubleValue();
        for (int segmentId = 0; segmentId < this.indexHandler.getNumberOfSegments(); ++segmentId) {
            int startVar = this.indexHandler.getOrientationStartIndex(segmentId);
            this.qpSolver.addRegularization(startVar, 3, firstOrientationCoefficientFactor);
            this.qpSolver.addRegularization(startVar + 3, 3, secondOrientationCoefficientFactor);
        }
    }

    @Override
    public void addRateRegularization() {
        super.addRateRegularization();
        double firstOrientationCoefficientFactor = this.firstOrientationRateVariableRegularization.getDoubleValue() / this.dt2;
        double secondOrientationCoefficientFactor = this.secondOrientationRateVariableRegularization.getDoubleValue() / this.dt2;
        for (int segmentId = 0; segmentId < this.indexHandler.getNumberOfSegments(); ++segmentId) {
            int startVar = this.indexHandler.getOrientationStartIndex(segmentId);
            this.qpSolver.addRateRegularization(startVar, 3, firstOrientationCoefficientFactor, (DMatrix)this.previousSolution);
            this.qpSolver.addRateRegularization(startVar + 3, 3, secondOrientationCoefficientFactor, (DMatrix)this.previousSolution);
        }
    }

    @Override
    public void submitMPCCommand(MPCCommand<?> command) {
        switch (command.getCommandType()) {
            case ORIENTATION_TRAJECTORY: {
                this.submitOrientationTrajectoryCommand((OrientationTrajectoryCommand)command);
                return;
            }
            case ORIENTATION_CONTINUITY: {
                this.submitOrientationContinuityCommand((OrientationContinuityCommand)command);
                return;
            }
            case ORIENTATION_VALUE: {
                this.submitOrientationValueCommand((OrientationValueCommand)command);
                return;
            }
            case DIRECT_ORIENTATION_VALUE: {
                this.submitDirectOrientationValueCommand((DirectOrientationValueCommand)command);
                return;
            }
        }
        super.submitMPCCommand(command);
    }

    public void submitOrientationValueCommand(OrientationValueCommand command) {
        int offset = this.orientationInputCalculator.computeCompact(this.qpInputTypeA, command);
        if (offset > -1) {
            this.addInput(this.qpInputTypeA, offset);
        }
    }

    public void submitDirectOrientationValueCommand(DirectOrientationValueCommand command) {
        int offset = this.orientationInputCalculator.computeCompact(this.qpInputTypeA, command);
        if (offset > -1) {
            this.addInput(this.qpInputTypeA, offset);
        }
    }

    public void submitOrientationContinuityCommand(OrientationContinuityCommand command) {
        int offset = this.orientationInputCalculator.computeCompact(this.qpInputTypeA, command);
        if (offset > -1) {
            this.addInput(this.qpInputTypeA, offset);
        }
    }

    public void submitOrientationTrajectoryCommand(OrientationTrajectoryCommand command) {
        for (int tick = 0; tick < command.getNumberOfTicksInSegment(); ++tick) {
            int offset = this.orientationInputCalculator.computeAngleErrorMinimizationCompact(tick, this.qpInputTypeA, command);
            if (offset > -1) {
                this.addInput(this.qpInputTypeA, offset);
            }
            if ((offset = this.orientationInputCalculator.computeVelocityErrorMinimizationCompact(tick, this.qpInputTypeA, command)) <= -1) continue;
            this.addInput(this.qpInputTypeA, offset);
        }
    }
}

