/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SE3MPCIndexHandler
extends LinearMPCIndexHandler {
    private static final double intermediateDt = 0.05;
    public static final int variablesPerOrientationTick = 6;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble orientationDt = new YoDouble("orientationDt", this.registry);
    private int totalNumberOfOrientationTicks = 0;
    private final TIntArrayList orientationStartIndices = new TIntArrayList();
    private final TIntArrayList ticksInSegment = new TIntArrayList();
    private final TDoubleArrayList tickDurations = new TDoubleArrayList();

    public SE3MPCIndexHandler(int numberOfBasisVectorsPerContactPoint) {
        super(numberOfBasisVectorsPerContactPoint);
        this.orientationDt.set(0.05);
    }

    @Override
    public void initialize(List<ContactPlaneProvider> previewWindowContactSequence) {
        super.initialize(previewWindowContactSequence);
        this.orientationStartIndices.reset();
        this.tickDurations.reset();
        this.ticksInSegment.reset();
        this.totalNumberOfOrientationTicks = 0;
        for (int segmentNumber = 0; segmentNumber < previewWindowContactSequence.size(); ++segmentNumber) {
            double segmentDuration = previewWindowContactSequence.get(segmentNumber).getTimeInterval().getDuration();
            int ticksInSegment = this.computeTicksInSegment(segmentDuration);
            double tickDuration = segmentDuration / (double)ticksInSegment;
            this.ticksInSegment.add(ticksInSegment);
            this.tickDurations.add(tickDuration);
            this.totalNumberOfOrientationTicks += 6;
            int orientationIndex = this.comStartIndices.get(segmentNumber);
            this.orientationStartIndices.add(orientationIndex);
            this.variablesInSegment.set(segmentNumber, 6 + this.variablesInSegment.get(segmentNumber));
            for (int j = segmentNumber; j < previewWindowContactSequence.size(); ++j) {
                this.comStartIndices.set(j, this.comStartIndices.get(j) + 6);
                this.rhoStartIndices.set(j, this.rhoStartIndices.get(j) + 6);
            }
            this.totalProblemSize += 6;
        }
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public int getTotalNumberOfOrientationTicks() {
        return this.totalNumberOfOrientationTicks;
    }

    public int getOrientationStartIndex(int segment) {
        return this.orientationStartIndices.get(segment);
    }

    public int getTicksInSegment(int segment) {
        return this.ticksInSegment.get(segment);
    }

    public double getTickDuration(int segment) {
        return this.tickDurations.get(segment);
    }

    private int computeTicksInSegment(double segmentDuration) {
        if (segmentDuration > 0.0 && segmentDuration < this.orientationDt.getValue()) {
            return 1;
        }
        return (int)Math.floor(segmentDuration / this.orientationDt.getValue());
    }
}

